/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.runtimes;

import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.runtimes.ComposeApplicationRuntime;
import com.intellij.docker.runtimes.ComposeServiceRuntime;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.docker.runtimes.DockerDeploymentRuntimeBase;
import com.intellij.docker.runtimes.DockerFailedDeploymentRuntime;
import com.intellij.docker.runtimes.DockerGroupRuntime;
import com.intellij.docker.runtimes.DockerImageRuntime;
import com.intellij.docker.runtimes.DockerNetworkRuntime;
import com.intellij.docker.runtimes.DockerPhysicalRuntime;
import com.intellij.docker.runtimes.DockerVolumeRuntime;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerRuntimeComparator
implements Comparator<DockerDeploymentRuntimeBase> {
    @Override
    public int compare(DockerDeploymentRuntimeBase r1, DockerDeploymentRuntimeBase r2) {
        DockerRuntimeCategory category2;
        if (r1 == r2) {
            return 0;
        }
        if (r1 == null || r2 == null) {
            return r1 == null ? -1 : 1;
        }
        DockerRuntimeCategory category1 = DockerRuntimeComparator.getCategory(r1);
        int compareCategories = category1.compareTo(category2 = DockerRuntimeComparator.getCategory(r2));
        if (compareCategories != 0) {
            return compareCategories;
        }
        assert (category1 == category2);
        return category1.compare(r1, r2);
    }

    private static DockerRuntimeCategory getCategory(DockerDeploymentRuntimeBase runtime) {
        if (runtime instanceof DockerFailedDeploymentRuntime) {
            return DockerRuntimeCategory.FAILED_RUNTIME;
        }
        if (runtime instanceof DockerGroupRuntime.ContainersGroup) {
            return DockerRuntimeCategory.GROUP_CONTAINERS;
        }
        if (runtime instanceof DockerGroupRuntime.ImagesGroup) {
            return DockerRuntimeCategory.GROUP_IMAGES;
        }
        if (runtime instanceof DockerGroupRuntime.NetworksGroup) {
            return DockerRuntimeCategory.GROUP_NETWORKS;
        }
        if (runtime instanceof DockerGroupRuntime.VolumesGroup) {
            return DockerRuntimeCategory.GROUP_VOLUMES;
        }
        if (runtime instanceof DockerGroupRuntime) {
            return DockerRuntimeCategory.GROUP_UNKNOWN;
        }
        if (runtime instanceof ComposeApplicationRuntime) {
            return DockerRuntimeCategory.COMPOSE_APPS;
        }
        if (runtime instanceof ComposeServiceRuntime) {
            return DockerRuntimeCategory.COMPOSE_SERVICES;
        }
        if (runtime instanceof DockerImageRuntime) {
            return DockerRuntimeCategory.IMAGES;
        }
        if (runtime instanceof DockerVolumeRuntime) {
            return DockerRuntimeCategory.VOLUMES;
        }
        if (runtime instanceof DockerNetworkRuntime) {
            return DockerRuntimeCategory.NETWORKS;
        }
        if (runtime instanceof DockerApplicationRuntime) {
            return DockerRuntimeCategory.CONTAINERS;
        }
        return DockerRuntimeCategory.UNKNOWNS;
    }

    private static int compareIdentity(@Nullable Object o1, @Nullable Object o2) {
        return Integer.compare(System.identityHashCode(o1), System.identityHashCode(o2));
    }

    private static <APP extends DockerAgentApplication> int comparePresentableName(@NotNull DockerPhysicalRuntime<APP> rt1, @NotNull DockerPhysicalRuntime<APP> rt2) {
        if (rt1 == null) {
            DockerRuntimeComparator.$$$reportNull$$$0(0);
        }
        if (rt2 == null) {
            DockerRuntimeComparator.$$$reportNull$$$0(1);
        }
        return StringUtil.compare((String)rt1.getPresentableName(), (String)rt2.getPresentableName(), (boolean)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "rt1";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "rt2";
                break;
            }
        }
        objectArray[1] = "com/intellij/docker/runtimes/DockerRuntimeComparator";
        objectArray[2] = "comparePresentableName";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum DockerRuntimeCategory {
        FAILED_RUNTIME{

            @Override
            public int compare(@NotNull DockerDeploymentRuntimeBase rt1, @NotNull DockerDeploymentRuntimeBase rt2) {
                if (rt1 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (rt2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                DockerFailedDeploymentRuntime impl1 = (DockerFailedDeploymentRuntime)rt1;
                DockerFailedDeploymentRuntime impl2 = (DockerFailedDeploymentRuntime)rt2;
                return StringUtil.compare((String)impl1.getApplicationName(), (String)impl2.getApplicationName(), (boolean)false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rt1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rt2";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/docker/runtimes/DockerRuntimeComparator$DockerRuntimeCategory$1";
                objectArray[2] = "compare";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        COMPOSE_APPS{

            @Override
            public int compare(@NotNull DockerDeploymentRuntimeBase rt1, @NotNull DockerDeploymentRuntimeBase rt2) {
                if (rt1 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (rt2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                ComposeApplicationRuntime impl1 = (ComposeApplicationRuntime)rt1;
                ComposeApplicationRuntime impl2 = (ComposeApplicationRuntime)rt2;
                return StringUtil.compare((String)impl1.getComposeProjectName(), (String)impl2.getComposeProjectName(), (boolean)false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rt1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rt2";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/docker/runtimes/DockerRuntimeComparator$DockerRuntimeCategory$2";
                objectArray[2] = "compare";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        GROUP_CONTAINERS,
        GROUP_IMAGES,
        GROUP_NETWORKS,
        GROUP_VOLUMES,
        GROUP_UNKNOWN,
        COMPOSE_SERVICES{

            @Override
            public int compare(@NotNull DockerDeploymentRuntimeBase rt1, @NotNull DockerDeploymentRuntimeBase rt2) {
                if (rt1 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (rt2 == null) {
                    3.$$$reportNull$$$0(1);
                }
                ComposeServiceRuntime impl1 = (ComposeServiceRuntime)rt1;
                ComposeServiceRuntime impl2 = (ComposeServiceRuntime)rt2;
                int parentCompare = this.compareParents(impl1.getParent(), impl2.getParent());
                if (parentCompare != 0) {
                    return parentCompare;
                }
                return StringUtil.compare((String)impl1.getServiceName(), (String)impl2.getServiceName(), (boolean)false);
            }

            private int compareParents(@Nullable ComposeApplicationRuntime parent1, @Nullable ComposeApplicationRuntime parent2) {
                if (parent1 == parent2) {
                    return 0;
                }
                if (parent1 == null || parent2 == null) {
                    return parent1 == null ? -1 : 1;
                }
                return COMPOSE_APPS.compare(parent1, parent2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rt1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rt2";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/docker/runtimes/DockerRuntimeComparator$DockerRuntimeCategory$3";
                objectArray[2] = "compare";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        CONTAINERS{

            @Override
            public int compare(@NotNull DockerDeploymentRuntimeBase rt1, @NotNull DockerDeploymentRuntimeBase rt2) {
                if (rt1 == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (rt2 == null) {
                    4.$$$reportNull$$$0(1);
                }
                String id1 = this.containerId(rt1);
                String id2 = this.containerId(rt2);
                return StringUtil.compare((String)id1, (String)id2, (boolean)false);
            }

            private String containerId(@NotNull DockerDeploymentRuntimeBase runtime) {
                if (runtime == null) {
                    4.$$$reportNull$$$0(2);
                }
                return ((DockerApplicationRuntime)runtime).getContainerId();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rt1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rt2";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "runtime";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/docker/runtimes/DockerRuntimeComparator$DockerRuntimeCategory$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "compare";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "containerId";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        IMAGES{

            @Override
            public int compare(@NotNull DockerDeploymentRuntimeBase rt1, @NotNull DockerDeploymentRuntimeBase rt2) {
                boolean noImageTags2;
                if (rt1 == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (rt2 == null) {
                    5.$$$reportNull$$$0(1);
                }
                DockerImageRuntime irt1 = (DockerImageRuntime)rt1;
                DockerImageRuntime irt2 = (DockerImageRuntime)rt2;
                ArrayList imageTags1 = new ArrayList(ContainerUtil.notNullize(irt1.getImageRepoTags()));
                ArrayList imageTags2 = new ArrayList(ContainerUtil.notNullize(irt2.getImageRepoTags()));
                Collections.sort(imageTags1);
                Collections.sort(imageTags2);
                String firstTag1 = (String)ContainerUtil.getFirstItem(imageTags1);
                String firstTag2 = (String)ContainerUtil.getFirstItem(imageTags2);
                boolean noImageTags1 = firstTag1 == null || StringUtil.equals((CharSequence)firstTag1, (CharSequence)"<none>:<none>");
                boolean bl = noImageTags2 = firstTag2 == null || StringUtil.equals((CharSequence)firstTag2, (CharSequence)"<none>:<none>");
                if (noImageTags1 || noImageTags2) {
                    if (noImageTags1 && noImageTags2) {
                        return StringUtil.compare((String)irt1.getImageId(), (String)irt2.getImageId(), (boolean)false);
                    }
                    return noImageTags1 ? 1 : -1;
                }
                return StringUtil.compare((String)firstTag1, (String)firstTag2, (boolean)false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rt1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rt2";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/docker/runtimes/DockerRuntimeComparator$DockerRuntimeCategory$5";
                objectArray[2] = "compare";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        VOLUMES{

            @Override
            public int compare(@NotNull DockerDeploymentRuntimeBase rt1, @NotNull DockerDeploymentRuntimeBase rt2) {
                if (rt1 == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (rt2 == null) {
                    6.$$$reportNull$$$0(1);
                }
                return DockerRuntimeComparator.comparePresentableName((DockerVolumeRuntime)rt1, (DockerVolumeRuntime)rt2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rt1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rt2";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/docker/runtimes/DockerRuntimeComparator$DockerRuntimeCategory$6";
                objectArray[2] = "compare";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        NETWORKS{

            @Override
            public int compare(@NotNull DockerDeploymentRuntimeBase rt1, @NotNull DockerDeploymentRuntimeBase rt2) {
                if (rt1 == null) {
                    7.$$$reportNull$$$0(0);
                }
                if (rt2 == null) {
                    7.$$$reportNull$$$0(1);
                }
                DockerNetworkRuntime net1 = (DockerNetworkRuntime)rt1;
                DockerNetworkRuntime net2 = (DockerNetworkRuntime)rt2;
                if (net1.isPredefined() != net2.isPredefined()) {
                    return net1.isPredefined() ? -1 : 1;
                }
                return DockerRuntimeComparator.comparePresentableName(net1, net2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rt1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rt2";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/docker/runtimes/DockerRuntimeComparator$DockerRuntimeCategory$7";
                objectArray[2] = "compare";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        UNKNOWNS;


        public int compare(@NotNull DockerDeploymentRuntimeBase rt1, @NotNull DockerDeploymentRuntimeBase rt2) {
            if (rt1 == null) {
                DockerRuntimeCategory.$$$reportNull$$$0(0);
            }
            if (rt2 == null) {
                DockerRuntimeCategory.$$$reportNull$$$0(1);
            }
            return DockerRuntimeComparator.compareIdentity((Object)rt1, (Object)rt2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rt1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rt2";
                    break;
                }
            }
            objectArray[1] = "com/intellij/docker/runtimes/DockerRuntimeComparator$DockerRuntimeCategory";
            objectArray[2] = "compare";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

