/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.runtimes;

import com.github.dockerjava.api.model.ContainerNetwork;
import com.github.dockerjava.api.model.Network;
import com.intellij.docker.DockerDeploymentStatus;
import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.agent.DockerAgentNetwork;
import com.intellij.docker.runtimes.DockerNetworkRuntime;
import com.intellij.docker.runtimes.DockerNetworkRuntimeImpl;
import com.intellij.docker.runtimes.DockerParentRuntime;
import com.intellij.docker.runtimes.DockerPhysicalRuntime;
import com.intellij.docker.runtimes.DockerRuntimeBase;
import com.intellij.docker.runtimes.DockerRuntimeContext;
import com.intellij.docker.runtimes.TasksKt;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsSafe;
import java.util.concurrent.CompletableFuture;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 )2\u00020\u0001:\u0001)B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u000b0\t\u00a2\u0006\u0002\u0010\fJ(\u0010\u0019\u001a\u0010\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00140\u00140\u00112\u0006\u0010\u001b\u001a\u00020\n2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0011H\u0016J\u001e\u0010 \u001a\u0010\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00140\u00140\u00112\u0006\u0010\u001b\u001a\u00020\nH\u0016J\u0016\u0010!\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000b2\u0006\u0010\"\u001a\u00020\nH\u0016J\u0006\u0010#\u001a\u00020\u001fJ\u0010\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\u001fH\u0014J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016R\u0014\u0010\r\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/docker/runtimes/DockerNetworkRuntimeImpl;", "Lcom/intellij/docker/runtimes/DockerNetworkRuntime;", "context", "Lcom/intellij/docker/runtimes/DockerRuntimeContext;", "agentNetwork", "Lcom/intellij/docker/agent/DockerAgentNetwork;", "parent", "Lcom/intellij/docker/runtimes/DockerParentRuntime;", "registry", "Lkotlin/Function1;", "", "Lcom/intellij/docker/runtimes/DockerPhysicalRuntime;", "(Lcom/intellij/docker/runtimes/DockerRuntimeContext;Lcom/intellij/docker/agent/DockerAgentNetwork;Lcom/intellij/docker/runtimes/DockerParentRuntime;Lkotlin/jvm/functions/Function1;)V", "agentApplication", "getAgentApplication", "()Lcom/intellij/docker/agent/DockerAgentNetwork;", "inspection", "Ljava/util/concurrent/CompletableFuture;", "Lcom/github/dockerjava/api/model/Network;", "isPredefined", "", "()Z", "network", "getNetwork", "()Lcom/github/dockerjava/api/model/Network;", "connectContainer", "kotlin.jvm.PlatformType", "containerId", "config", "Lcom/github/dockerjava/api/model/ContainerNetwork;", "deleteNetwork", "", "disconnectContainer", "findRuntimeById", "id", "forgetInspection", "internalSetAgentApplication", "application", "Lcom/intellij/docker/agent/DockerAgentApplication;", "onSetAgentApplication", "promiseInspection", "Companion", "intellij.clouds.docker"})
public final class DockerNetworkRuntimeImpl
extends DockerNetworkRuntime {
    private CompletableFuture<Network> inspection;
    private final boolean isPredefined;
    private DockerAgentNetwork agentNetwork;
    private final Function1<String, DockerPhysicalRuntime<?>> registry;
    @NlsSafe
    private static final String HOST = "host";
    @NlsSafe
    private static final String BRIDGE = "bridge";
    @NlsSafe
    private static final String NONE = "none";
    private static final Lazy SHARED_STATUS$delegate;
    @NotNull
    public static final Companion Companion;

    @Override
    public void internalSetAgentApplication(@NotNull DockerAgentApplication application) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        this.agentNetwork = (DockerAgentNetwork)application;
        this.onSetAgentApplication();
    }

    @Override
    protected void onSetAgentApplication() {
        super.onSetAgentApplication();
        this.internalChangeStatus(DockerNetworkRuntimeImpl.Companion.getSHARED_STATUS());
    }

    @Override
    @NotNull
    protected DockerAgentNetwork getAgentApplication() {
        return this.agentNetwork;
    }

    @Override
    @NotNull
    public Network getNetwork() {
        return this.agentNetwork.getNetwork();
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> deleteNetwork() {
        if (this.isPredefined()) {
            CompletableFuture<Unit> completableFuture = CompletableFuture.failedFuture(new IllegalStateException("Pre-defined network cannot be removed"));
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"CompletableFuture.failed\u2026work cannot be removed\"))");
            return completableFuture;
        }
        DockerDeploymentStatus dockerDeploymentStatus = DockerDeploymentStatus.DELETING;
        Intrinsics.checkNotNullExpressionValue((Object)dockerDeploymentStatus, (String)"DockerDeploymentStatus.DELETING");
        DockerDeploymentStatus dockerDeploymentStatus2 = DockerDeploymentStatus.DELETED;
        Intrinsics.checkNotNullExpressionValue((Object)dockerDeploymentStatus2, (String)"DockerDeploymentStatus.DELETED");
        return TasksKt.runStatusTransition((DockerRuntimeBase)this, dockerDeploymentStatus, dockerDeploymentStatus2, (Function0)new Function0<Unit>(this){
            final /* synthetic */ DockerNetworkRuntimeImpl this$0;

            public final void invoke() {
                DockerNetworkRuntimeImpl.access$getAgentNetwork$p(this.this$0).deleteNetwork();
            }
            {
                this.this$0 = dockerNetworkRuntimeImpl;
                super(0);
            }
        });
    }

    @Override
    @NotNull
    public CompletableFuture<Network> promiseInspection() {
        CompletableFuture<Object> completableFuture = this.inspection;
        if (completableFuture == null) {
            CompletableFuture completableFuture2 = TasksKt.makeAgentPromise(this, (Computable)new Computable(this){
                final /* synthetic */ DockerNetworkRuntimeImpl this$0;

                public final Network compute() {
                    return DockerNetworkRuntimeImpl.access$getAgentNetwork$p(this.this$0).reinspect();
                }
                {
                    this.this$0 = dockerNetworkRuntimeImpl;
                }
            });
            boolean bl = false;
            boolean bl2 = false;
            CompletableFuture it = completableFuture2;
            boolean bl3 = false;
            this.inspection = it;
            completableFuture = completableFuture2;
        }
        return completableFuture;
    }

    public final void forgetInspection() {
        this.inspection = null;
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> connectContainer(@NotNull String containerId, @Nullable ContainerNetwork config) {
        Intrinsics.checkNotNullParameter((Object)containerId, (String)"containerId");
        return TasksKt.makeAgentPromise(this, (Computable)new Computable(this, containerId, config){
            final /* synthetic */ DockerNetworkRuntimeImpl this$0;
            final /* synthetic */ String $containerId;
            final /* synthetic */ ContainerNetwork $config;

            public final Boolean compute() {
                return DockerNetworkRuntimeImpl.access$getAgentNetwork$p(this.this$0).connectContainer(this.$containerId, this.$config);
            }
            {
                this.this$0 = dockerNetworkRuntimeImpl;
                this.$containerId = string;
                this.$config = containerNetwork;
            }
        });
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> disconnectContainer(@NotNull String containerId) {
        Intrinsics.checkNotNullParameter((Object)containerId, (String)"containerId");
        return TasksKt.makeAgentPromise(this, (Computable)new Computable(this, containerId){
            final /* synthetic */ DockerNetworkRuntimeImpl this$0;
            final /* synthetic */ String $containerId;

            public final Boolean compute() {
                return DockerNetworkRuntimeImpl.access$getAgentNetwork$p(this.this$0).disconnectContainer(this.$containerId);
            }
            {
                this.this$0 = dockerNetworkRuntimeImpl;
                this.$containerId = string;
            }
        });
    }

    @Override
    public boolean isPredefined() {
        return this.isPredefined;
    }

    @Override
    @Nullable
    public DockerPhysicalRuntime<?> findRuntimeById(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return (DockerPhysicalRuntime)((Object)this.registry.invoke((Object)id));
    }

    public DockerNetworkRuntimeImpl(@NotNull DockerRuntimeContext context, @NotNull DockerAgentNetwork agentNetwork, @Nullable DockerParentRuntime parent, @NotNull Function1<? super String, ? extends DockerPhysicalRuntime<?>> registry) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)agentNetwork, (String)"agentNetwork");
        Intrinsics.checkNotNullParameter(registry, (String)"registry");
        String string = agentNetwork.getUniqueName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"agentNetwork.uniqueName");
        super(context, string, parent);
        this.agentNetwork = agentNetwork;
        this.registry = registry;
        this.isPredefined = CollectionsKt.arrayListOf((Object[])new String[]{HOST, BRIDGE, NONE}).contains(this.agentNetwork.getNetwork().getName());
    }

    static {
        Companion = new Companion(null);
        SHARED_STATUS$delegate = LazyKt.lazy((Function0)Companion.SHARED_STATUS.2.INSTANCE);
    }

    public static final /* synthetic */ DockerAgentNetwork access$getAgentNetwork$p(DockerNetworkRuntimeImpl $this) {
        return $this.agentNetwork;
    }

    public static final /* synthetic */ void access$setAgentNetwork$p(DockerNetworkRuntimeImpl $this, DockerAgentNetwork dockerAgentNetwork) {
        $this.agentNetwork = dockerAgentNetwork;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R#\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/docker/runtimes/DockerNetworkRuntimeImpl$Companion;", "", "()V", "BRIDGE", "", "HOST", "NONE", "SHARED_STATUS", "Lcom/intellij/docker/DockerDeploymentStatus;", "kotlin.jvm.PlatformType", "getSHARED_STATUS", "()Lcom/intellij/docker/DockerDeploymentStatus;", "SHARED_STATUS$delegate", "Lkotlin/Lazy;", "intellij.clouds.docker"})
    public static final class Companion {
        private final DockerDeploymentStatus getSHARED_STATUS() {
            Lazy lazy = SHARED_STATUS$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (DockerDeploymentStatus)lazy.getValue();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

