/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.runtimes;

import com.github.dockerjava.api.model.Image;
import com.intellij.docker.DockerDeploymentStatus;
import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.agent.DockerAgentImage;
import com.intellij.docker.agent.DockerAgentProgressCallback;
import com.intellij.docker.agent.DockerAgentRepositoryConfig;
import com.intellij.docker.agent.DockerUtil;
import com.intellij.docker.agent.OngoingProcess;
import com.intellij.docker.agent.progress.DockerProgressDetailsFormat;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.registry.DockerAgentRepositoryConfigImpl;
import com.intellij.docker.registry.DockerRepositoryModel;
import com.intellij.docker.registry.RegistryRuntimeTask;
import com.intellij.docker.runtimes.DockerImageRuntime;
import com.intellij.docker.runtimes.DockerImageRuntimeImpl;
import com.intellij.docker.runtimes.DockerParentRuntime;
import com.intellij.docker.runtimes.DockerRuntimeBase;
import com.intellij.docker.runtimes.DockerRuntimeContext;
import com.intellij.docker.runtimes.TasksKt;
import com.intellij.openapi.project.Project;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0017H\u0014J\u001a\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\b\u0010!\u001a\u00020\u0012H\u0016R\u0014\u0010\t\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\""}, d2={"Lcom/intellij/docker/runtimes/DockerImageRuntimeImpl;", "Lcom/intellij/docker/runtimes/DockerImageRuntime;", "context", "Lcom/intellij/docker/runtimes/DockerRuntimeContext;", "agentImage", "Lcom/intellij/docker/agent/DockerAgentImage;", "parent", "Lcom/intellij/docker/runtimes/DockerParentRuntime;", "(Lcom/intellij/docker/runtimes/DockerRuntimeContext;Lcom/intellij/docker/agent/DockerAgentImage;Lcom/intellij/docker/runtimes/DockerParentRuntime;)V", "agentApplication", "getAgentApplication", "()Lcom/intellij/docker/agent/DockerAgentImage;", "image", "Lcom/github/dockerjava/api/model/Image;", "getImage", "()Lcom/github/dockerjava/api/model/Image;", "imageRepoTags", "", "", "getImageRepoTags", "()Ljava/util/Set;", "deleteImage", "Ljava/util/concurrent/CompletableFuture;", "", "internalSetAgentApplication", "application", "Lcom/intellij/docker/agent/DockerAgentApplication;", "onSetAgentApplication", "pushImage", "project", "Lcom/intellij/openapi/project/Project;", "repositoryModel", "Lcom/intellij/docker/registry/DockerRepositoryModel;", "toString", "intellij.clouds.docker"})
public final class DockerImageRuntimeImpl
extends DockerImageRuntime {
    private DockerAgentImage agentImage;

    @Override
    public void internalSetAgentApplication(@NotNull DockerAgentApplication application) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        this.agentImage = (DockerAgentImage)application;
        this.onSetAgentApplication();
    }

    @Override
    @NotNull
    protected DockerAgentImage getAgentApplication() {
        return this.agentImage;
    }

    @Override
    @NotNull
    public Image getImage() {
        return this.agentImage.getImage();
    }

    @Override
    @NotNull
    public Set<String> getImageRepoTags() {
        String[] stringArray = this.agentImage.getImageRepoTags();
        return SetsKt.setOf((Object[])Arrays.copyOf(stringArray, stringArray.length));
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> deleteImage() {
        DockerDeploymentStatus dockerDeploymentStatus = DockerDeploymentStatus.DELETING;
        Intrinsics.checkNotNullExpressionValue((Object)dockerDeploymentStatus, (String)"DockerDeploymentStatus.DELETING");
        DockerDeploymentStatus dockerDeploymentStatus2 = DockerDeploymentStatus.DELETED;
        Intrinsics.checkNotNullExpressionValue((Object)dockerDeploymentStatus2, (String)"DockerDeploymentStatus.DELETED");
        return TasksKt.runStatusTransition((DockerRuntimeBase)this, dockerDeploymentStatus, dockerDeploymentStatus2, (Function0)new Function0<Unit>(this){
            final /* synthetic */ DockerImageRuntimeImpl this$0;

            public final void invoke() {
                DockerImageRuntimeImpl.access$getAgentImage$p(this.this$0).deleteImage();
            }
            {
                this.this$0 = dockerImageRuntimeImpl;
                super(0);
            }
        });
    }

    @Override
    protected void onSetAgentApplication() {
        String string;
        String string2;
        boolean bl;
        super.onSetAgentApplication();
        Long l = this.agentImage.getImage().getCreated();
        if (l != null) {
            Long l2 = l;
            boolean bl2 = false;
            bl = false;
            long secondsSinceTimeStart = ((Number)l2).longValue();
            boolean bl3 = false;
            string2 = DockerUtil.formatDuration(System.currentTimeMillis() / (long)1000 - secondsSinceTimeStart);
        } else {
            string2 = null;
        }
        String created = string2;
        Long l3 = this.agentImage.getImage().getVirtualSize();
        if (l3 != null) {
            Long l4 = l3;
            bl = false;
            boolean bl4 = false;
            long bytes = ((Number)l4).longValue();
            boolean bl5 = false;
            string = DockerProgressDetailsFormat.Companion.humanSizeBytes(bytes);
        } else {
            string = null;
        }
        String size = string;
        String statusText2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])new String[]{created, size}), (CharSequence)" / ", null, null, (int)0, null, (Function1)onSetAgentApplication.statusText.1.INSTANCE, (int)30, null);
        this.internalChangeStatus(DockerDeploymentStatus.newImageStatus(statusText2));
    }

    @Override
    public void pushImage(@NotNull Project project, @Nullable DockerRepositoryModel repositoryModel) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DockerAgentRepositoryConfig repositoryConfig = new DockerAgentRepositoryConfigImpl(repositoryModel);
        String string = repositoryConfig.getQualifiedTag();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"repositoryConfig.qualifiedTag");
        String qualifiedReference = string;
        new RegistryRuntimeTask(this, repositoryConfig){
            final /* synthetic */ DockerImageRuntimeImpl this$0;
            final /* synthetic */ DockerAgentRepositoryConfig $repositoryConfig;

            @Nullable
            protected OngoingProcess doPerform(@NotNull DockerAgentProgressCallback progressCallback) {
                Intrinsics.checkNotNullParameter((Object)progressCallback, (String)"progressCallback");
                return DockerImageRuntimeImpl.access$getAgentImage$p(this.this$0).pushImage(this.$repositoryConfig, progressCallback);
            }
            {
                this.this$0 = this$0;
                this.$repositoryConfig = $captured_local_variable$1;
            }
        }.performAsyncWithNotification(project, this.getTaskExecutor(), this.getAgentTaskExecutor(), DockerBundle.message("DockerApplicationRuntime.progress.message.pushing", qualifiedReference), DockerBundle.message("DockerApplicationRuntime.progress.message.pushed.successfully", qualifiedReference));
    }

    @NotNull
    public String toString() {
        String string;
        String string2 = this.getApplicationName();
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            string = DockerUtil.shortedId(it);
        } else {
            string = null;
        }
        String hash = string;
        return "@" + Integer.toHexString(this.hashCode()) + " id: " + hash + ", [IMG]: " + this.getImageRepoTags();
    }

    public DockerImageRuntimeImpl(@NotNull DockerRuntimeContext context, @NotNull DockerAgentImage agentImage, @Nullable DockerParentRuntime parent) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)agentImage, (String)"agentImage");
        super(context, agentImage, parent);
        this.agentImage = agentImage;
        this.onSetAgentApplication();
    }

    public static final /* synthetic */ DockerAgentImage access$getAgentImage$p(DockerImageRuntimeImpl $this) {
        return $this.agentImage;
    }

    public static final /* synthetic */ void access$setAgentImage$p(DockerImageRuntimeImpl $this, DockerAgentImage dockerAgentImage) {
        $this.agentImage = dockerAgentImage;
    }
}

