/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.runtimes;

import com.intellij.docker.DockerDeploymentStatus;
import com.intellij.docker.agent.DockerAgent;
import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.agent.DockerAgentContainer;
import com.intellij.docker.agent.DockerUtil;
import com.intellij.docker.agent.settings.DockerAgentContainerConfig;
import com.intellij.docker.agent.settings.DockerAgentContainerInspection;
import com.intellij.docker.agent.terminal.pipe.DockerConsoleLogPipe;
import com.intellij.docker.agent.terminal.pipe.DockerTerminalPipe;
import com.intellij.docker.runtimes.ComposeServiceRuntime;
import com.intellij.docker.runtimes.DockerContainerRuntime;
import com.intellij.docker.runtimes.DockerParentRuntime;
import com.intellij.docker.runtimes.DockerRuntimeBase;
import com.intellij.docker.runtimes.DockerRuntimeContext;
import com.intellij.docker.runtimes.DockerRuntimeNavigatable;
import com.intellij.docker.runtimes.TasksKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.impl.runtime.deployment.LocalDeploymentImpl;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerApplicationRuntime
extends DockerContainerRuntime {
    private DockerAgentContainer myAgentContainer;
    private List<AgentApplicationChangedListener> myListeners;

    public DockerApplicationRuntime(@NotNull DockerRuntimeContext context, @NotNull DockerAgentContainer agentContainer, @Nullable DockerParentRuntime parent) {
        if (context == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(0);
        }
        if (agentContainer == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(1);
        }
        super(context, agentContainer, parent);
        this.myAgentContainer = agentContainer;
        this.myListeners = new ArrayList<AgentApplicationChangedListener>();
        this.onSetAgentApplication();
    }

    public void addAgentApplicationChangedListener(@NotNull AgentApplicationChangedListener listener) {
        if (listener == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(2);
        }
        this.myListeners.add(listener);
    }

    public void removeAgentApplicationChangedListener(@NotNull AgentApplicationChangedListener listener) {
        if (listener == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(3);
        }
        this.myListeners.remove(listener);
    }

    @Override
    @NotNull
    protected DockerAgentContainer getAgentApplication() {
        DockerAgentContainer dockerAgentContainer = this.myAgentContainer;
        if (dockerAgentContainer == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(4);
        }
        return dockerAgentContainer;
    }

    @Override
    public void internalSetAgentApplication(@NotNull DockerAgentApplication application) {
        if (application == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(5);
        }
        assert (application instanceof DockerAgentContainer);
        if (this.myAgentContainer != application) {
            this.myListeners.forEach(AgentApplicationChangedListener::onAgentChanged);
        }
        this.myAgentContainer = (DockerAgentContainer)application;
        this.onSetAgentApplication();
    }

    @Override
    protected final void onSetAgentApplication() {
        super.onSetAgentApplication();
        @NlsSafe String statusText2 = this.myAgentContainer.getContainer().getStatus();
        this.internalChangeStatus(DockerDeploymentStatus.newContainerStatus(statusText2));
    }

    public DockerAgent getAgent() {
        return this.getContext().getAgent();
    }

    public DockerAgentContainer getAgentContainer() {
        return this.getAgentApplication();
    }

    @Override
    @NotNull
    public String getContainerId() {
        String string = this.getAgentContainer().getContainerId();
        if (string == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(6);
        }
        return string;
    }

    public String @Nullable [] getContainerNames() {
        return this.getAgentContainer().getContainerNames();
    }

    public String getContainerName() {
        return this.getAgentContainer().getContainerName();
    }

    @Override
    @NotNull
    public String getImageId() {
        String string = this.getAgentContainer().getImageId();
        if (string == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @Nullable
    protected DockerRuntimeNavigatable computeRuntimeNavigatable(@NotNull Project project) {
        DockerRuntimeBase parent;
        if (project == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(8);
        }
        if ((parent = this.getParent()) instanceof ComposeServiceRuntime) {
            ComposeServiceRuntime parentImpl = (ComposeServiceRuntime)parent;
            return parentImpl.computeRuntimeNavigatable(project);
        }
        return null;
    }

    @Override
    public void startContainer() {
        TasksKt.runStatusTransition((DockerRuntimeBase)this, DockerDeploymentStatus.STARTING, DockerDeploymentStatus.STARTED, () -> this.getAgentContainer().startContainer());
    }

    @Override
    public void restartContainer() {
        TasksKt.runStatusTransition((DockerRuntimeBase)this, DockerDeploymentStatus.STARTING, DockerDeploymentStatus.STARTED, () -> this.getAgentContainer().restartContainer());
    }

    @Override
    public void pauseContainer() {
        TasksKt.runStatusTransition((DockerRuntimeBase)this, DockerDeploymentStatus.STARTED, DockerDeploymentStatus.wrapStatus(DockerDeploymentStatus.PAUSED), () -> this.getAgentContainer().pauseContainer());
    }

    @Override
    public void unpauseContainer() {
        TasksKt.runStatusTransition((DockerRuntimeBase)this, DockerDeploymentStatus.wrapStatus(DockerDeploymentStatus.PAUSED), DockerDeploymentStatus.STARTED, () -> this.getAgentContainer().unpauseContainer());
    }

    @Override
    public void stopContainer() {
        TasksKt.runStatusTransition((DockerRuntimeBase)this, DockerDeploymentStatus.STOPPING, DockerDeploymentStatus.STOPPED, () -> this.getAgentContainer().stopContainer());
    }

    @Override
    public void deleteContainer() {
        Deployment deployment = this.getDeploymentModel();
        ServerConnection connection = deployment == null ? null : deployment.getConnection();
        TasksKt.runStatusTransition((DockerRuntimeBase)this, DockerDeploymentStatus.DELETING, DockerDeploymentStatus.DELETED, () -> this.getAgentContainer().deleteContainer()).thenRunAsync(() -> {
            Deployment localDeployment;
            if (connection != null && (localDeployment = (Deployment)ContainerUtil.find((Iterable)connection.getDeployments(), e -> e instanceof LocalDeploymentImpl && e.getPresentableName().equals(deployment.getPresentableName()))) != null) {
                connection.undeploy(localDeployment, null);
            }
        }, (Executor)EdtExecutorService.getInstance());
    }

    @Override
    @NotNull
    public CompletableFuture<DockerConsoleLogPipe> showLog(boolean withTimestamps) {
        CompletableFuture<DockerConsoleLogPipe> completableFuture = this.getAgentContainer().showLog(withTimestamps);
        if (completableFuture == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(9);
        }
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<String> processesJson() {
        CompletableFuture<String> completableFuture = TasksKt.makeAgentPromise(this, this.getAgentContainer()::computeProcessesJson);
        if (completableFuture == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(10);
        }
        return completableFuture;
    }

    public CompletableFuture<DockerAgentContainerInspection> promiseInspect() {
        return TasksKt.makeAgentPromise(this, () -> this.getAgentContainer().inspect());
    }

    @Override
    @NotNull
    public CompletableFuture<DockerTerminalPipe> attach() {
        CompletableFuture<DockerTerminalPipe> completableFuture = this.getAgentContainer().attach(true);
        if (completableFuture == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(11);
        }
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<DockerTerminalPipe> exec(@NotNull String command) {
        if (command == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(12);
        }
        CompletableFuture<DockerTerminalPipe> completableFuture = this.getAgentContainer().exec(ParametersListUtil.parseToArray((String)command), true);
        if (completableFuture == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(13);
        }
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<byte[]> captureExecOutput(String @NotNull [] command, boolean includeErr) {
        if (command == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(14);
        }
        CompletableFuture<byte[]> completableFuture = this.getAgentContainer().captureExecOutput(command, includeErr);
        if (completableFuture == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(15);
        }
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<DockerAgentApplication.ContainerUpdateResult> updateContainer(@NotNull DockerAgentContainerConfig config) {
        if (config == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(16);
        }
        CompletableFuture<DockerAgentApplication.ContainerUpdateResult> completableFuture = TasksKt.makeAgentPromise(this, () -> {
            DockerAgentApplication.ContainerUpdateResult updateResult = this.getAgentContainer().updateContainer(config);
            this.handleContainerUpdateResult(updateResult);
            return updateResult;
        });
        if (completableFuture == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(17);
        }
        return completableFuture;
    }

    protected final void handleContainerUpdateResult(@Nullable DockerAgentApplication.ContainerUpdateResult updateResult) {
        if (updateResult == null) {
            return;
        }
        String oldId = updateResult.getRemovedContainerId();
        String newId = updateResult.getCreatedContainerId();
        if (!StringUtil.equals((CharSequence)oldId, (CharSequence)this.getContainerId())) {
            return;
        }
        DockerAgentContainer newAgentApp = updateResult.getCreatedAgentContainer();
        if (newAgentApp != null && oldId != null && newId != null && !newId.equals(oldId)) {
            this.internalSetAgentApplication(newAgentApp);
        }
    }

    public String toString() {
        String hash = Optional.ofNullable(this.getApplicationName()).map(DockerUtil::shortedId).orElse(null);
        return "@" + Integer.toHexString(((Object)((Object)this)).hashCode()) + " id: " + hash + ", [CNT]: " + Arrays.toString(this.getContainerNames());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "agentContainer";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/runtimes/DockerApplicationRuntime";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "application";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/runtimes/DockerApplicationRuntime";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAgentApplication";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainerId";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getImageId";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "showLog";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "processesJson";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "attach";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "exec";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "captureExecOutput";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "updateContainer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addAgentApplicationChangedListener";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeAgentApplicationChangedListener";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "internalSetAgentApplication";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "computeRuntimeNavigatable";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "exec";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "captureExecOutput";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "updateContainer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface AgentApplicationChangedListener {
        public void onAgentChanged();
    }
}

