/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.runtimes;

import com.intellij.docker.DockerDeploymentConfigurationUtilsKt;
import com.intellij.docker.DockerIcons;
import com.intellij.docker.agent.DockerAgentContainer;
import com.intellij.docker.agent.terminal.pipe.DockerTerminalPipe;
import com.intellij.docker.compose.ComposeNavigatableHelper;
import com.intellij.docker.compose.cli.DockerComposeCliUtil;
import com.intellij.docker.compose.cli.DockerComposeStartCliBuilder;
import com.intellij.docker.compose.cli.DockerComposeStopCliBuilder;
import com.intellij.docker.compose.cli.DockerComposeUpCliBuilder;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.runtimes.ComposeApplicationRuntime;
import com.intellij.docker.runtimes.ComposeServiceRuntime;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.docker.runtimes.DockerParentRuntime;
import com.intellij.docker.runtimes.DockerRuntimeBase;
import com.intellij.docker.runtimes.DockerRuntimeNavigatable;
import com.intellij.docker.runtimes.DockerRuntimesManagerService;
import com.intellij.docker.ui.utils.DockerUiUtilsKt;
import com.intellij.docker.utils.ComposeMetadataProvider;
import com.intellij.docker.utils.DockerComposeData;
import com.intellij.docker.utils.DockerComposeUtilsKt;
import com.intellij.docker.utils.DockerUtils;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.remoteServer.util.CloudNotifier;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.ui.JBColor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0016\u0018\u0000 @2\u00020\u00012\u00020\u0002:\u0002@AB2\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000b\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0001J\b\u0010\"\u001a\u00020\u0000H\u0016J\u000e\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020\u001cJ\u0010\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020\u0001H\u0016J\u0010\u0010'\u001a\u00020 2\u0006\u0010&\u001a\u00020\u0001H\u0016J\u0012\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020\fH\u0014J\u0006\u0010+\u001a\u00020 J\b\u0010,\u001a\u00020-H\u0016J\u000e\u0010.\u001a\b\u0012\u0004\u0012\u0002000/H\u0016J\b\u00101\u001a\u00020\u0004H\u0016J\b\u00102\u001a\u0004\u0018\u000103J\b\u00104\u001a\u000205H\u0016J\u0006\u00106\u001a\u000207J\u0006\u00108\u001a\u000207J\u0006\u00109\u001a\u000207J\u0006\u0010:\u001a\u000207J\u000e\u0010;\u001a\u00020 2\u0006\u0010<\u001a\u00020\u0016J\u0006\u0010=\u001a\u00020 J\u0006\u0010>\u001a\u00020 J\b\u0010?\u001a\u00020\u0006H\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00120\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006B"}, d2={"Lcom/intellij/docker/runtimes/ComposeServiceRuntime;", "Lcom/intellij/docker/runtimes/DockerRuntimeBase;", "Lcom/intellij/docker/runtimes/DockerParentRuntime;", "parentRuntime", "Lcom/intellij/docker/runtimes/ComposeApplicationRuntime;", "serviceName", "", "Lorg/jetbrains/annotations/Nls;", "composeVersion", "Lcom/intellij/openapi/util/Version;", "projectSupplier", "Lkotlin/Function0;", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/docker/runtimes/ComposeApplicationRuntime;Ljava/lang/String;Lcom/intellij/openapi/util/Version;Lkotlin/jvm/functions/Function0;)V", "getComposeVersion", "()Lcom/intellij/openapi/util/Version;", "containers", "", "Lcom/intellij/docker/runtimes/DockerApplicationRuntime;", "getContainers", "()[Lcom/intellij/docker/runtimes/DockerApplicationRuntime;", "countOfContainers", "", "getCountOfContainers", "()I", "myContainers", "", "myPipe", "Lcom/intellij/docker/agent/terminal/pipe/DockerTerminalPipe$WithTty;", "getServiceName", "()Ljava/lang/String;", "addContainer", "", "container", "asDockerRuntime", "attachPipe", "pipe", "childAdded", "child", "childRemoved", "computeRuntimeNavigatable", "Lcom/intellij/docker/runtimes/DockerRuntimeNavigatable;", "project", "deleteAllContainers", "getCloudNotifier", "Lcom/intellij/remoteServer/util/CloudNotifier;", "getComposeFiles", "", "Ljava/io/File;", "getParent", "getServiceStatus", "Lcom/intellij/docker/runtimes/DockerRuntimesManagerService$ComposeServiceStatus;", "getStatus", "Lcom/intellij/remoteServer/runtime/deployment/DeploymentStatus;", "isAnyContainerNotRunning", "", "isAnyContainerRunning", "isContainsContainers", "isOrphans", "scaleService", "number", "startService", "stopService", "toString", "Companion", "WithoutContainers", "intellij.clouds.docker"})
public class ComposeServiceRuntime
extends DockerRuntimeBase
implements DockerParentRuntime {
    private final Map<String, DockerApplicationRuntime> myContainers;
    private DockerTerminalPipe.WithTty myPipe;
    @NotNull
    private final String serviceName;
    @NotNull
    private final Version composeVersion;
    private final Function0<Project> projectSupplier;
    private static final Lazy LOG$delegate;
    @NotNull
    public static final Companion Companion;

    public final int getCountOfContainers() {
        return this.myContainers.values().size();
    }

    @NotNull
    public final DockerApplicationRuntime[] getContainers() {
        Collection<DockerApplicationRuntime> $this$toTypedArray$iv = this.myContainers.values();
        boolean $i$f$toTypedArray = false;
        Collection<DockerApplicationRuntime> thisCollection$iv = $this$toTypedArray$iv;
        DockerApplicationRuntime[] dockerApplicationRuntimeArray = thisCollection$iv.toArray(new DockerApplicationRuntime[0]);
        if (dockerApplicationRuntimeArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return dockerApplicationRuntimeArray;
    }

    @Override
    @NotNull
    public ComposeServiceRuntime asDockerRuntime() {
        return this;
    }

    @Override
    @NotNull
    public DeploymentStatus getStatus() {
        boolean bl;
        Icon icon;
        block11: {
            boolean bl2;
            Object object;
            Collection<DockerApplicationRuntime> containers = this.myContainers.values();
            Icon icon2 = containers.size() > 1 ? DockerIcons.DockerCompose : DockerIcons.Docker;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"if (containers.size > 1)\u2026e else DockerIcons.Docker");
            icon = icon2;
            if (!DockerComposeUtilsKt.isComposeFilesLabelSupported(this.composeVersion)) {
                return new DeploymentStatus(DockerUiUtilsKt.setColor$default(icon, "#F4AF3D", false, 2, null), DockerBundle.message("DockerComposeService.unsupported.version.message", new Object[0]), false);
            }
            KProperty kProperty = null;
            Lazy composeFiles2 = LazyKt.lazy((Function0)((Function0)new Function0<Set<? extends File>>(this){
                final /* synthetic */ ComposeServiceRuntime this$0;

                @NotNull
                public final Set<File> invoke() {
                    return this.this$0.getComposeFiles();
                }
                {
                    this.this$0 = composeServiceRuntime;
                    super(0);
                }
            }));
            Object var6_5 = null;
            Lazy notExistentComposeFiles2 = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends File>>(composeFiles2, kProperty){
                final /* synthetic */ Lazy $composeFiles;
                final /* synthetic */ KProperty $composeFiles$metadata;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<File> invoke() {
                    void $this$filterTo$iv$iv;
                    Lazy lazy = this.$composeFiles;
                    Object var2_2 = null;
                    Object object = this.$composeFiles$metadata;
                    boolean bl = false;
                    Iterable $this$filter$iv = (Iterable)lazy.getValue();
                    boolean $i$f$filter = false;
                    object = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        File it = (File)element$iv$iv;
                        boolean bl2 = false;
                        if (!(!it.exists())) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    return (List)destination$iv$iv;
                }
                {
                    this.$composeFiles = lazy;
                    this.$composeFiles$metadata = kProperty;
                    super(0);
                }
            }));
            if (containers.isEmpty()) {
                return new DeploymentStatus(DockerUiUtilsKt.setColor$default(icon, "#9AA7B0", false, 2, null), this.serviceName, false);
            }
            Project project = (Project)this.projectSupplier.invoke();
            if (project == null) {
                object = notExistentComposeFiles2;
                Object var9_9 = null;
                bl2 = false;
                object = (Collection)object.getValue();
                boolean bl3 = false;
                if (!object.isEmpty()) {
                    JBColor jBColor = JBColor.RED;
                    Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"JBColor.RED");
                    object = notExistentComposeFiles2;
                    Object var9_11 = null;
                    bl2 = false;
                    return new DeploymentStatus(DockerUiUtilsKt.setColor$default(icon, jBColor, false, 2, null), ComposeServiceRuntime.Companion.filesNotExistsMessage((List)object.getValue(), project), false);
                }
            } else {
                object = notExistentComposeFiles2;
                Object var9_12 = null;
                bl2 = false;
                object = (Collection)object.getValue();
                boolean bl4 = false;
                if (!object.isEmpty()) {
                    JBColor jBColor = JBColor.RED;
                    Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"JBColor.RED");
                    object = notExistentComposeFiles2;
                    Object var9_14 = null;
                    bl2 = false;
                    return new DeploymentStatus(DockerUiUtilsKt.setColor$default(icon, jBColor, false, 2, null), ComposeServiceRuntime.Companion.filesNotExistsMessage((List)object.getValue(), project), false);
                }
                object = composeFiles2;
                Lazy lazy = null;
                bl2 = false;
                if (!ComposeServiceRuntime.Companion.isServiceExist(project, this.serviceName, (Set)object.getValue())) {
                    lazy = composeFiles2;
                    Lazy lazy2 = null;
                    boolean bl5 = false;
                    String filePaths = ComposeServiceRuntime.Companion.joinToShortenedPathsIfPossible((Collection)lazy.getValue(), project);
                    Object[] objectArray = new Object[3];
                    objectArray[0] = this.serviceName;
                    objectArray[1] = filePaths;
                    lazy2 = composeFiles2;
                    Object var11_21 = null;
                    boolean bl6 = false;
                    objectArray[2] = ((Set)lazy2.getValue()).size();
                    String string = DockerBundle.message("ComposeServiceRuntime.status.service.not.exit", objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"ComposeServiceR\u2026Paths, composeFiles.size)");
                    String message = string;
                    JBColor jBColor = JBColor.RED;
                    Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"JBColor.RED");
                    return new DeploymentStatus(DockerUiUtilsKt.setColor$default(icon, jBColor, false, 2, null), message, false);
                }
            }
            Iterable $this$all$iv = this.myContainers.values();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    DockerApplicationRuntime it = (DockerApplicationRuntime)((Object)element$iv);
                    boolean bl7 = false;
                    if (it.getStatus() != DeploymentStatus.DEPLOYED) continue;
                    bl = false;
                    break block11;
                }
                bl = true;
            }
        }
        if (bl) {
            return new DeploymentStatus(DockerUiUtilsKt.setColor$default(icon, "#F4AF3D", false, 2, null), DockerBundle.message("ComposeServiceRuntime.status.stopped", new Object[0]), false);
        }
        return new DeploymentStatus(icon, this.serviceName, false);
    }

    @Override
    public void childAdded(@NotNull DockerRuntimeBase child) {
        Intrinsics.checkNotNullParameter((Object)((Object)child), (String)"child");
        if (child instanceof DockerApplicationRuntime) {
            String string = ((DockerApplicationRuntime)child).getApplicationName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"child.applicationName");
            this.myContainers.put(string, (DockerApplicationRuntime)child);
        }
    }

    @Override
    public void childRemoved(@NotNull DockerRuntimeBase child) {
        Intrinsics.checkNotNullParameter((Object)((Object)child), (String)"child");
        this.myContainers.remove(child.getApplicationName());
    }

    @Override
    @NotNull
    public ComposeApplicationRuntime getParent() {
        DockerRuntimeBase dockerRuntimeBase = super.getParent();
        if (dockerRuntimeBase == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.docker.runtimes.ComposeApplicationRuntime");
        }
        return (ComposeApplicationRuntime)dockerRuntimeBase;
    }

    @Override
    @Nullable
    protected DockerRuntimeNavigatable computeRuntimeNavigatable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ComposeNavigatableHelper composeNavigatableHelper = ComposeNavigatableHelper.getInstance();
        if (composeNavigatableHelper == null) {
            return this.getParent().computeRuntimeNavigatable(project);
        }
        Intrinsics.checkNotNullExpressionValue((Object)composeNavigatableHelper, (String)"ComposeNavigatableHelper\u2026ntimeNavigatable(project)");
        ComposeNavigatableHelper helper = composeNavigatableHelper;
        PsiElement composeService = ComposeServiceRuntime.Companion.findComposeService(helper, project, this.serviceName, this.getComposeFiles());
        return composeService == null ? null : (DockerRuntimeNavigatable)new DockerRuntimeNavigatable(composeService){
            @NotNull
            private final Navigatable navigatable;
            @Nullable
            private final VirtualFile virtualFile;
            final /* synthetic */ PsiElement $composeService;

            @NotNull
            public Navigatable getNavigatable() {
                return this.navigatable;
            }

            @Nullable
            public VirtualFile getVirtualFile() {
                return this.virtualFile;
            }
            {
                this.$composeService = $captured_local_variable$0;
                this.navigatable = com.intellij.docker.runtimes.ComposeServiceRuntime$Companion.access$toNavigatable(ComposeServiceRuntime.Companion, $captured_local_variable$0);
                this.virtualFile = PsiUtilCore.getVirtualFile((PsiElement)$captured_local_variable$0);
            }
        };
    }

    @NotNull
    public CloudNotifier getCloudNotifier() {
        return ComposeApplicationRuntime.COMPOSE_NOTIFIER;
    }

    @NotNull
    public String toString() {
        return "@" + Integer.toHexString(this.hashCode()) + " id: " + this.getApplicationName() + ", [SRV]";
    }

    public final void attachPipe(@NotNull DockerTerminalPipe.WithTty pipe) {
        Intrinsics.checkNotNullParameter((Object)pipe, (String)"pipe");
        DockerTerminalPipe.WithTty withTty = this.myPipe;
        if (withTty != null) {
            withTty.close();
        }
        this.myPipe = pipe;
    }

    public final boolean isOrphans() {
        boolean bl;
        block10: {
            if (!DockerComposeUtilsKt.isComposeFilesLabelSupported(this.composeVersion)) {
                return true;
            }
            Set set = (Set)DockerUtils.nullize((Collection)this.getComposeFiles());
            if (set == null) {
                return true;
            }
            Set composeFiles2 = set;
            Project project = (Project)this.projectSupplier.invoke();
            if (project == null) {
                Iterable $this$any$iv = composeFiles2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        File it = (File)element$iv;
                        boolean bl2 = false;
                        if (!(!it.exists())) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
            } else {
                boolean bl3;
                block11: {
                    Iterable $this$any$iv = composeFiles2;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            File it = (File)element$iv;
                            boolean bl4 = false;
                            if (!(!it.exists())) continue;
                            bl3 = true;
                            break block11;
                        }
                        bl3 = false;
                    }
                }
                bl = bl3 || !ComposeServiceRuntime.Companion.isServiceExist(project, this.serviceName, composeFiles2);
            }
        }
        return bl;
    }

    public final boolean isAnyContainerNotRunning() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.myContainers.values();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    DockerApplicationRuntime it = (DockerApplicationRuntime)((Object)element$iv);
                    boolean bl2 = false;
                    if (!(it.getStatus() != DeploymentStatus.DEPLOYED)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean isAnyContainerRunning() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.myContainers.values();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    DockerApplicationRuntime it = (DockerApplicationRuntime)((Object)element$iv);
                    boolean bl2 = false;
                    if (!(it.getStatus() == DeploymentStatus.DEPLOYED)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean isContainsContainers() {
        Collection<DockerApplicationRuntime> collection = this.myContainers.values();
        boolean bl = false;
        return !collection.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<File> getComposeFiles() {
        void $this$flatMapTo$iv$iv;
        if (!DockerComposeUtilsKt.isComposeFilesLabelSupported(this.composeVersion)) {
            return SetsKt.emptySet();
        }
        Iterable $this$flatMap$iv = this.myContainers.values();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            DockerApplicationRuntime runtime = (DockerApplicationRuntime)((Object)element$iv$iv);
            boolean bl = false;
            DockerAgentContainer dockerAgentContainer = runtime.getAgentContainer();
            Intrinsics.checkNotNullExpressionValue((Object)dockerAgentContainer, (String)"runtime.agentContainer");
            Object object = ComposeMetadataProvider.INSTANCE.getComposeData(dockerAgentContainer);
            if (object == null || (object = ((DockerComposeData)object).getFiles()) == null) {
                object = SetsKt.emptySet();
            }
            Iterable list$iv$iv = (Iterable)object;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public final void addContainer(@NotNull DockerRuntimeBase container) {
        Intrinsics.checkNotNullParameter((Object)((Object)container), (String)"container");
        container.setParent(this);
    }

    public final void deleteAllContainers() {
        Iterable $this$forEach$iv = this.myContainers.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DockerApplicationRuntime it = (DockerApplicationRuntime)((Object)element$iv);
            boolean bl = false;
            it.deleteContainer();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final DockerRuntimesManagerService.ComposeServiceStatus getServiceStatus() {
        DockerRuntimesManagerService.ComposeServiceStatus composeServiceStatus;
        void $this$mapNotNullTo$iv$iv;
        if (this.myContainers.isEmpty()) {
            return null;
        }
        Iterable $this$mapNotNull$iv = this.myContainers.values();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            DeploymentStatus deploymentStatus;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DockerApplicationRuntime it = (DockerApplicationRuntime)((Object)element$iv$iv);
            boolean bl2 = false;
            if (it.getStatus() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            DeploymentStatus it$iv$iv = deploymentStatus;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List statuses = (List)destination$iv$iv;
        if (statuses.isEmpty()) {
            composeServiceStatus = null;
        } else {
            boolean bl;
            block7: {
                Iterable $this$any$iv = statuses;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        DeploymentStatus it = (DeploymentStatus)element$iv;
                        boolean bl6 = false;
                        if (!DeploymentStatus.DEPLOYED.equals((Object)it)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            composeServiceStatus = bl ? DockerRuntimesManagerService.ComposeServiceStatus.DEPLOYED : DockerRuntimesManagerService.ComposeServiceStatus.STOPPED;
        }
        return composeServiceStatus;
    }

    public final void scaleService(int number) throws ServerRuntimeException {
        DockerComposeUpCliBuilder upCommand = ((DockerComposeUpCliBuilder)((DockerComposeUpCliBuilder)DockerComposeCliUtil.buildUpCommand(this.getParent().getRuntimeHelper()).withFiles(this.getParent().getComposeFilePaths())).withDetached(true).withProjectName(this.getParent().getComposeProjectName())).withServices(this.serviceName).withServiceScaled(this.serviceName, RangesKt.coerceAtLeast((int)number, (int)0));
        ComposeApplicationRuntime.executeCli$default(this.getParent(), upCommand, this.myPipe, null, 4, null);
    }

    public final void startService() throws ServerRuntimeException {
        DockerComposeStartCliBuilder startCommand = ((DockerComposeStartCliBuilder)((DockerComposeStartCliBuilder)DockerComposeCliUtil.buildStartCommand(this.getParent().getRuntimeHelper()).withFiles(this.getParent().getComposeFilePaths())).withProjectName(this.getParent().getComposeProjectName())).withServices(this.serviceName);
        ComposeApplicationRuntime.executeCli$default(this.getParent(), startCommand, this.myPipe, null, 4, null);
    }

    public final void stopService() throws ServerRuntimeException {
        DockerComposeStopCliBuilder stopCommand = ((DockerComposeStopCliBuilder)((DockerComposeStopCliBuilder)DockerComposeCliUtil.buildStopCommand(this.getParent().getRuntimeHelper()).withFiles(this.getParent().getComposeFilePaths())).withProjectName(this.getParent().getComposeProjectName())).withServices(this.serviceName);
        ComposeApplicationRuntime.executeCli$default(this.getParent(), stopCommand, this.myPipe, null, 4, null);
    }

    @NotNull
    public final String getServiceName() {
        return this.serviceName;
    }

    @NotNull
    public final Version getComposeVersion() {
        return this.composeVersion;
    }

    public ComposeServiceRuntime(@NotNull ComposeApplicationRuntime parentRuntime, @NotNull String serviceName, @NotNull Version composeVersion, @NotNull Function0<? extends Project> projectSupplier) {
        Intrinsics.checkNotNullParameter((Object)parentRuntime, (String)"parentRuntime");
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        Intrinsics.checkNotNullParameter((Object)composeVersion, (String)"composeVersion");
        Intrinsics.checkNotNullParameter(projectSupplier, (String)"projectSupplier");
        super(parentRuntime.getContext(), parentRuntime.getApplicationName() + ':' + serviceName, parentRuntime);
        this.serviceName = serviceName;
        this.composeVersion = composeVersion;
        this.projectSupplier = projectSupplier;
        this.myContainers = new ConcurrentSkipListMap();
    }

    static {
        Companion = new Companion(null);
        LOG$delegate = LazyKt.lazy((Function0)Companion.LOG.2.INSTANCE);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\u0018\u00002\u00020\u0001B2\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000eH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/docker/runtimes/ComposeServiceRuntime$WithoutContainers;", "Lcom/intellij/docker/runtimes/ComposeServiceRuntime;", "parentRuntime", "Lcom/intellij/docker/runtimes/ComposeApplicationRuntime;", "serviceName", "", "Lorg/jetbrains/annotations/Nls;", "myFile", "Ljava/io/File;", "projectSupplier", "Lkotlin/Function0;", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/docker/runtimes/ComposeApplicationRuntime;Ljava/lang/String;Ljava/io/File;Lkotlin/jvm/functions/Function0;)V", "getComposeFiles", "", "intellij.clouds.docker"})
    public static final class WithoutContainers
    extends ComposeServiceRuntime {
        private final File myFile;

        @Override
        @NotNull
        public Set<File> getComposeFiles() {
            return SetsKt.setOf((Object)this.myFile);
        }

        public WithoutContainers(@NotNull ComposeApplicationRuntime parentRuntime, @NotNull String serviceName, @NotNull File myFile, @NotNull Function0<? extends Project> projectSupplier) {
            Intrinsics.checkNotNullParameter((Object)parentRuntime, (String)"parentRuntime");
            Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
            Intrinsics.checkNotNullParameter((Object)myFile, (String)"myFile");
            Intrinsics.checkNotNullParameter(projectSupplier, (String)"projectSupplier");
            super(parentRuntime, serviceName, new Version(999, 999, 999), projectSupplier);
            this.myFile = myFile;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J&\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J.\u0010\u0019\u001a\u0004\u0018\u00010\u0018*\u0004\u0018\u00010\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0014H\u0002J\u001c\u0010\u001b\u001a\u00020\n*\b\u0012\u0004\u0012\u00020\u000e0\u001c2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001d"}, d2={"Lcom/intellij/docker/runtimes/ComposeServiceRuntime$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "LOG$delegate", "Lkotlin/Lazy;", "filesNotExistsMessage", "", "Lorg/jetbrains/annotations/Nls;", "files", "", "Ljava/io/File;", "project", "Lcom/intellij/openapi/project/Project;", "isServiceExist", "", "serviceName", "", "toNavigatable", "Lcom/intellij/pom/Navigatable;", "psi", "Lcom/intellij/psi/PsiElement;", "findComposeService", "Lcom/intellij/docker/compose/ComposeNavigatableHelper;", "joinToShortenedPathsIfPossible", "", "intellij.clouds.docker"})
    public static final class Companion {
        private final Logger getLOG() {
            Lazy lazy = LOG$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (Logger)lazy.getValue();
        }

        private final Navigatable toNavigatable(PsiElement psi) {
            Navigatable navigatable;
            PsiElement psiElement = psi;
            if (psiElement instanceof Navigatable) {
                navigatable = (Navigatable)psi;
            } else {
                PsiFile psiFile = psi.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"psi.containingFile");
                VirtualFile virtualFile = psiFile.getVirtualFile();
                boolean bl = false;
                boolean bl2 = false;
                VirtualFile it = virtualFile;
                boolean bl3 = false;
                Navigatable navigatable2 = PsiNavigationSupport.getInstance().createNavigatable(psi.getProject(), it, psi.getTextOffset());
                navigatable = navigatable2;
                Intrinsics.checkNotNullExpressionValue((Object)navigatable2, (String)"PsiNavigationSupport.get\u2026ject, it, psi.textOffset)");
            }
            return navigatable;
        }

        /*
         * WARNING - void declaration
         */
        private final PsiElement findComposeService(ComposeNavigatableHelper $this$findComposeService, Project project, String serviceName, Set<? extends File> files) {
            PsiElement psiElement;
            if (project.isDisposed()) {
                return null;
            }
            ComposeNavigatableHelper composeNavigatableHelper = $this$findComposeService;
            if (composeNavigatableHelper == null) {
                psiElement = null;
            } else {
                Object v1;
                void $this$reduceOrNull$iv;
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = files;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo2 = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    PsiElement psiElement2;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    File it = (File)element$iv$iv;
                    boolean bl2 = false;
                    if ($this$findComposeService.findComposeService(project, it, serviceName) == null) continue;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    PsiElement it$iv$iv = psiElement2;
                    boolean bl5 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv;
                boolean $i$f$reduceOrNull = false;
                Iterator iterator$iv = $this$reduceOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v1 = null;
                } else {
                    Object accumulator$iv = iterator$iv.next();
                    while (iterator$iv.hasNext()) {
                        void next;
                        PsiElement $i$f$mapNotNullTo2 = (PsiElement)iterator$iv.next();
                        PsiElement $noName_0 = (PsiElement)accumulator$iv;
                        boolean bl = false;
                        accumulator$iv = next;
                    }
                    v1 = accumulator$iv;
                }
                psiElement = v1;
            }
            return psiElement;
        }

        private final boolean isServiceExist(Project project, String serviceName, Set<? extends File> files) {
            Object object;
            boolean $i$f$runReedActionIfNeeded = false;
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            boolean reedAccessAllowed$iv = application.isReadAccessAllowed();
            if (reedAccessAllowed$iv) {
                boolean bl = false;
                object = Companion.findComposeService(ComposeNavigatableHelper.getInstance(), project, serviceName, files) != null;
            } else {
                boolean $i$f$runReadAction = false;
                object = ApplicationManager.getApplication().runReadAction(new Computable(project, serviceName, files){
                    final /* synthetic */ Project $project$inlined;
                    final /* synthetic */ String $serviceName$inlined;
                    final /* synthetic */ Set $files$inlined;
                    {
                        this.$project$inlined = project;
                        this.$serviceName$inlined = string;
                        this.$files$inlined = set;
                    }

                    public final T compute() {
                        boolean bl = false;
                        return (T)Boolean.valueOf(com.intellij.docker.runtimes.ComposeServiceRuntime$Companion.access$findComposeService(ComposeServiceRuntime.Companion, ComposeNavigatableHelper.getInstance(), this.$project$inlined, this.$serviceName$inlined, this.$files$inlined) != null);
                    }
                });
            }
            return (Boolean)object;
        }

        private final String joinToShortenedPathsIfPossible(Collection<? extends File> $this$joinToShortenedPathsIfPossible, Project project) {
            return CollectionsKt.joinToString$default((Iterable)$this$joinToShortenedPathsIfPossible, (CharSequence)", ", null, null, (int)0, null, (Function1)((Function1)new Function1<File, CharSequence>(project){
                final /* synthetic */ Project $project;

                @NotNull
                public final CharSequence invoke(@NotNull File it) {
                    CharSequence charSequence;
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Object object = this.$project;
                    if (object != null && (object = DockerDeploymentConfigurationUtilsKt.getPathToStore(object, it)) != null) {
                        charSequence = (CharSequence)object;
                    } else {
                        String string = it.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.path");
                        charSequence = string;
                    }
                    return charSequence;
                }
                {
                    this.$project = project;
                    super(1);
                }
            }), (int)30, null);
        }

        private final String filesNotExistsMessage(List<? extends File> files, Project project) {
            String string = DockerBundle.message("ComposeServiceRuntime.status.files.not.exists", files.size(), this.joinToShortenedPathsIfPossible((Collection<? extends File>)files, project));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"ComposeServiceR\u2026PathsIfPossible(project))");
            return string;
        }

        private Companion() {
        }

        public static final /* synthetic */ Navigatable access$toNavigatable(Companion $this, PsiElement psi) {
            return $this.toNavigatable(psi);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

