/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.runtimes;

import com.google.common.base.Strings;
import com.intellij.docker.DockerComposeDownOptions;
import com.intellij.docker.DockerComposeRemoveImagesOnDown;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerDeploymentConfigurationUtilsKt;
import com.intellij.docker.agent.terminal.pipe.DockerTerminalPipe;
import com.intellij.docker.compose.cli.AbstractDockerComposeCmdCliBuilder;
import com.intellij.docker.compose.cli.DockerComposeCliUtil;
import com.intellij.docker.compose.cli.DockerComposeDownCliBuilder;
import com.intellij.docker.debug.DebugDeploymentTransformer;
import com.intellij.docker.debug.DockerDebugConnector;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.docker.runtimes.ComposeApplicationRuntime;
import com.intellij.docker.runtimes.DeploymentsKt;
import com.intellij.docker.runtimes.DockerDeployingDeploymentRuntime;
import com.intellij.docker.runtimes.DockerFailedDeploymentRuntime;
import com.intellij.docker.runtimes.DockerRuntimeNavigatable;
import com.intellij.docker.runtimes.DockerRuntimeVirtualFileNavigatable;
import com.intellij.docker.runtimes.DockerRuntimesCache;
import com.intellij.docker.runtimes.DockerRuntimesManagerService;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.remoteServer.impl.runtime.deployment.DeploymentTaskImpl;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.runtime.deployment.debug.DebugConnector;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposeDeploymentRuntime
extends ComposeApplicationRuntime {
    private static final Logger LOG = Logger.getInstance(ComposeDeploymentRuntime.class);
    private final Project myProject;
    private final DockerRuntimesCache myRuntimesCache;
    private final File myWorkingDirectory;
    private DockerTerminalPipe.WithTty myPipe;
    private NextDeployInfo myNextDeployInfo;
    private final Map<String, String> myMergedEnvironment;

    public ComposeDeploymentRuntime(@NotNull DockerRuntimesCache runtimesCache, @NotNull DeploymentTask<DockerDeploymentConfiguration> task2) throws ServerRuntimeException {
        if (runtimesCache == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(0);
        }
        if (task2 == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(1);
        }
        this(runtimesCache, task2, ComposeDeploymentRuntime.getComposeFiles(task2));
    }

    private ComposeDeploymentRuntime(@NotNull DockerRuntimesCache runtimesCache, @NotNull DeploymentTask<DockerDeploymentConfiguration> task2, @NotNull List<File> composeFiles2) throws ServerRuntimeException {
        if (runtimesCache == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(2);
        }
        if (task2 == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(3);
        }
        if (composeFiles2 == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(4);
        }
        this(runtimesCache, task2, ComposeDeploymentRuntime.getComposeFiles(task2), ((DockerDeploymentConfiguration)task2.getConfiguration()).getComposeProjectName(), ComposeDeploymentRuntime.computeWorkingDir(composeFiles2));
    }

    private ComposeDeploymentRuntime(@NotNull DockerRuntimesCache runtimesCache, @NotNull DeploymentTask<DockerDeploymentConfiguration> task2, @NotNull List<File> composeFiles2, @Nullable String projectName, @NotNull File workingDirectory) {
        if (runtimesCache == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(5);
        }
        if (task2 == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(6);
        }
        if (composeFiles2 == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(7);
        }
        if (workingDirectory == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(8);
        }
        super(runtimesCache.getRuntimeContext(), Strings.isNullOrEmpty((String)projectName) ? ComposeDeploymentRuntime.computeErasedProjectName(workingDirectory.getName()) : projectName);
        this.myMergedEnvironment = new LinkedHashMap<String, String>();
        this.myProject = task2.getProject();
        this.myRuntimesCache = runtimesCache;
        this.myWorkingDirectory = workingDirectory;
        this.myNextDeployInfo = new NextDeployInfo((DockerDeploymentConfiguration)task2.getConfiguration(), composeFiles2);
        this.myMergedEnvironment.putAll(ComposeDeploymentRuntime.getTaskEnvironment(task2));
    }

    void appendDeploymentTask(@NotNull DeploymentTask<DockerDeploymentConfiguration> newDeploymentTask) throws ServerRuntimeException {
        List<File> newComposeFiles;
        File newWorkingDirectory;
        if (newDeploymentTask == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(9);
        }
        if (!FileUtil.filesEqual((File)(newWorkingDirectory = ComposeDeploymentRuntime.computeWorkingDir(newComposeFiles = ComposeDeploymentRuntime.getComposeFiles(this.myProject, (DockerDeploymentConfiguration)newDeploymentTask.getConfiguration(), ComposeDeploymentRuntime.getDockerDebugTransformer(newDeploymentTask)))), (File)this.myWorkingDirectory)) {
            LOG.debug("Merging compose deployments from different folders: current work-dir: " + this.myWorkingDirectory + ", requested: " + newWorkingDirectory);
        }
        this.myNextDeployInfo = new NextDeployInfo((DockerDeploymentConfiguration)newDeploymentTask.getConfiguration(), newComposeFiles);
        this.myMergedEnvironment.putAll(ComposeDeploymentRuntime.getTaskEnvironment(newDeploymentTask));
    }

    @Nullable
    private static DebugDeploymentTransformer<?> getDockerDebugTransformer(@NotNull DeploymentTask<DockerDeploymentConfiguration> newDeploymentTask) {
        if (newDeploymentTask == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(10);
        }
        if (!(newDeploymentTask instanceof DeploymentTaskImpl)) {
            return null;
        }
        DebugConnector debugConnector = ((DeploymentTaskImpl)newDeploymentTask).getDebugConnector();
        return debugConnector instanceof DockerDebugConnector ? ((DockerDebugConnector)debugConnector).getDeploymentTransformer(newDeploymentTask) : null;
    }

    @NotNull
    public static String computeErasedProjectName(@NotNull String name) {
        if (name == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(11);
        }
        String string = StringUtil.toLowerCase((String)name.replaceAll("[^a-zA-Z0-9-_]+", ""));
        if (string == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Override
    @NotNull
    public RemoteDockerRuntime getRuntimeHelper() throws ServerRuntimeException {
        RemoteDockerRuntime result2 = RemoteDockerRuntime.create(this.getContext().getServerConfiguration(), this.myProject);
        assert (result2 != null);
        RemoteDockerRuntime remoteDockerRuntime = result2;
        if (remoteDockerRuntime == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(13);
        }
        return remoteDockerRuntime;
    }

    @Override
    public void attachPipe(@NotNull DockerTerminalPipe.WithTty pipe) {
        if (pipe == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(14);
        }
        if (this.myPipe != null) {
            this.myPipe.close();
        }
        this.myPipe = pipe;
    }

    @Override
    @Nullable
    public DockerTerminalPipe.WithTty getPipe() {
        return this.myPipe;
    }

    @Override
    @Nullable
    protected String getWorkDirectory() {
        return this.myWorkingDirectory.getPath();
    }

    @Override
    @Nullable
    public DockerRuntimeNavigatable computeRuntimeNavigatable(@NotNull Project project) {
        VirtualFile virtualFile;
        Path mainFile;
        if (project == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(15);
        }
        if ((mainFile = (Path)ContainerUtil.getFirstItem(this.myNextDeployInfo.myComposeFiles)) != null && (virtualFile = LocalFileSystem.getInstance().findFileByIoFile(mainFile.toFile())) != null) {
            return new DockerRuntimeVirtualFileNavigatable(project, virtualFile);
        }
        return null;
    }

    public void deploy(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ServerRuntimeInstance.DeploymentOperationCallback callback, @NotNull Boolean enableBuildKit) {
        CompletableFuture<?> promise;
        if (enableBuildKit == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(16);
        }
        if (callback == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(17);
        }
        final DockerTerminalPipe.WithTty deployPipe = new DockerTerminalPipe.WithTty("ComposeDeploymentRuntime.deployPipe", DeploymentsKt.wrapIdeaLogger(LOG)).setUseBufferedWriter(true).setShowCursor(false);
        callback.started((DeploymentRuntime)new DockerDeployingDeploymentRuntime(this.getApplicationName(), this.getContext()){

            @Override
            @NotNull
            public DockerTerminalPipe getDeployLogPipe() {
                DockerTerminalPipe.WithTty withTty = deployPipe;
                if (withTty == null) {
                    1.$$$reportNull$$$0(0);
                }
                return withTty;
            }

            @Override
            public void stopDeploy() {
                ComposeDeploymentRuntime.this.cancelCurrentProcess();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/runtimes/ComposeDeploymentRuntime$1", "getDeployLogPipe"));
            }
        });
        try {
            promise = this.doDeploy(enableBuildKit, deployPipe);
        }
        catch (ServerRuntimeException e2) {
            callback.errorOccurred(e2.getMessage(), (DeploymentRuntime)this.createFailedRuntime(e2));
            return;
        }
        ((CompletableFuture)promise.thenRun(() -> {
            this.attachPipe(deployPipe);
            callback.succeeded((DeploymentRuntime)this);
        })).exceptionally(e -> {
            callback.errorOccurred(e.getMessage(), (DeploymentRuntime)this.createFailedRuntime((Throwable)e));
            deployPipe.close();
            return null;
        });
    }

    private DockerFailedDeploymentRuntime createFailedRuntime(final @NotNull Throwable ex) {
        if (ex == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(18);
        }
        return new DockerFailedDeploymentRuntime(this.getApplicationName(), this.getContext()){

            @Override
            @NotNull
            public String getErrorMessage() {
                String string = ex.getMessage();
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            @Nullable
            public Navigatable computeNavigatable(@NotNull Project project) {
                if (project == null) {
                    2.$$$reportNull$$$0(1);
                }
                return ComposeDeploymentRuntime.this.computeNavigatable(project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/docker/runtimes/ComposeDeploymentRuntime$2";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getErrorMessage";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/docker/runtimes/ComposeDeploymentRuntime$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "computeNavigatable";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NotNull
    private static List<File> getComposeFiles(@NotNull DeploymentTask<DockerDeploymentConfiguration> deploymentTask) {
        if (deploymentTask == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(19);
        }
        return ComposeDeploymentRuntime.getComposeFiles(deploymentTask.getProject(), (DockerDeploymentConfiguration)deploymentTask.getConfiguration(), ComposeDeploymentRuntime.getDockerDebugTransformer(deploymentTask));
    }

    @NotNull
    private static List<File> getComposeFiles(@NotNull Project project, @NotNull DockerDeploymentConfiguration configuration, DebugDeploymentTransformer<?> debugDeploymentTransformer) {
        if (project == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(20);
        }
        if (configuration == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(21);
        }
        LinkedList<String> paths = new LinkedList<String>();
        paths.add(configuration.getSourceFilePath());
        paths.addAll(configuration.getSecondarySourceFiles());
        List<File> composeFiles2 = paths.stream().filter(Objects::nonNull).map(path -> DockerDeploymentConfigurationUtilsKt.getSourceFile(project, path)).filter(Objects::nonNull).collect(Collectors.toList());
        List<File> list = debugDeploymentTransformer != null ? debugDeploymentTransformer.patchComposeFiles(composeFiles2) : composeFiles2;
        if (list == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(22);
        }
        return list;
    }

    private CompletableFuture<?> doDeploy(@NotNull Boolean enableBuildKit, DockerTerminalPipe.WithTty deployPipe) throws ServerRuntimeException {
        if (enableBuildKit == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(23);
        }
        AbstractDockerComposeCmdCliBuilder cliBuilder = this.shouldRestartOnDeploy() ? DockerComposeCliUtil.buildRestartCommand(this.getRuntimeHelper()).withServices(this.myNextDeployInfo.myServices) : DockerComposeCliUtil.buildUpCommand(this.getRuntimeHelper()).from(this.myNextDeployInfo.myDeployment);
        cliBuilder.withFiles(this.myNextDeployInfo.myComposeFiles);
        cliBuilder.withProjectName(this.myNextDeployInfo.myComposeProject);
        cliBuilder.withEnvFile(this.myNextDeployInfo.myEnvFile);
        if (enableBuildKit.booleanValue()) {
            cliBuilder.withEnvironment("COMPOSE_DOCKER_CLI_BUILD", "1");
            cliBuilder.withEnvironment("DOCKER_BUILDKIT", "1");
        }
        return this.executeCli(cliBuilder, deployPipe, this.myMergedEnvironment);
    }

    @Override
    @NotNull
    public String getComposeProjectName() {
        String string = Strings.isNullOrEmpty((String)this.myNextDeployInfo.myComposeProject) ? super.getComposeProjectName() : this.myNextDeployInfo.myComposeProject;
        if (string == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(24);
        }
        return string;
    }

    private boolean shouldRestartOnDeploy() {
        String[] services = this.myNextDeployInfo.myServices;
        if (services.length != 1) {
            return false;
        }
        DockerRuntimesManagerService.DockerRuntimesManager manager = DockerRuntimesManagerService.getInstance().getActiveManager();
        if (manager == null) {
            return false;
        }
        return manager.findComposeServiceStatus(this.getComposeProjectName(), services[0]) == DockerRuntimesManagerService.ComposeServiceStatus.DEPLOYED;
    }

    @Override
    protected void doAfterUndeploy() {
        this.myRuntimesCache.composeApplicationUndeployed(this);
    }

    @Override
    @NotNull
    protected DockerComposeDownCliBuilder downCommand() throws ServerRuntimeException {
        DockerComposeDownCliBuilder dockerComposeDownCliBuilder = ((DockerComposeDownCliBuilder)super.downCommand().withEnvFile(this.myNextDeployInfo.myEnvFile)).withRemoveVolumes(this.myNextDeployInfo != null && this.myNextDeployInfo.shouldRemoveVolumes()).withRemoveOrphans(this.myNextDeployInfo != null && this.myNextDeployInfo.shouldRemoveOrphans()).withRemoveImages(this.myNextDeployInfo != null ? this.myNextDeployInfo.shouldRemoveImages() : DockerComposeDownCliBuilder.ImageKind.none);
        if (dockerComposeDownCliBuilder == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(25);
        }
        return dockerComposeDownCliBuilder;
    }

    public String toString() {
        return "@" + Integer.toHexString(this.hashCode()) + " id: " + this.getApplicationName() + ", [APP][++]";
    }

    @NotNull
    private static Map<String, String> getTaskEnvironment(@NotNull DeploymentTask<DockerDeploymentConfiguration> task2) {
        if (task2 == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(26);
        }
        Map<String, String> map2 = ((DockerDeploymentConfiguration)task2.getConfiguration()).getEnvVars().stream().filter(var -> !StringUtil.isEmptyOrSpaces((String)var.getName())).collect(Collectors.toMap(var -> StringUtil.trim((String)var.getName()), var -> StringUtil.trim((String)var.getValue()), (oldVal, newVal) -> newVal));
        if (map2 == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(27);
        }
        return map2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: 
            case 22: 
            case 24: 
            case 25: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: 
            case 22: 
            case 24: 
            case 25: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runtimesCache";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "composeFiles";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDeploymentTask";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: 
            case 13: 
            case 22: 
            case 24: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/runtimes/ComposeDeploymentRuntime";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pipe";
                break;
            }
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enableBuildKit";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ex";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deploymentTask";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/runtimes/ComposeDeploymentRuntime";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "computeErasedProjectName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getRuntimeHelper";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getComposeFiles";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getComposeProjectName";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "downCommand";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getTaskEnvironment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "appendDeploymentTask";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDockerDebugTransformer";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "computeErasedProjectName";
                break;
            }
            case 12: 
            case 13: 
            case 22: 
            case 24: 
            case 25: 
            case 27: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "attachPipe";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "computeRuntimeNavigatable";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "deploy";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createFailedRuntime";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getComposeFiles";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "doDeploy";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getTaskEnvironment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: 
            case 22: 
            case 24: 
            case 25: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NextDeployInfo {
        private final DockerComposeDownOptions myDownOptions;
        private final List<Path> myComposeFiles;
        private final String myComposeProject;
        private final String myEnvFile;
        private final DockerDeploymentConfiguration myDeployment;
        private final String[] myServices;

        NextDeployInfo(@NotNull DockerDeploymentConfiguration deployment, @NotNull List<File> composeFiles2) {
            if (deployment == null) {
                NextDeployInfo.$$$reportNull$$$0(0);
            }
            if (composeFiles2 == null) {
                NextDeployInfo.$$$reportNull$$$0(1);
            }
            this.myServices = ArrayUtilRt.toStringArray(deployment.getServices());
            this.myDeployment = deployment;
            this.myDownOptions = deployment.copyComposeDownOptions();
            this.myEnvFile = deployment.getEnvFilePath();
            this.myComposeFiles = ContainerUtil.map(composeFiles2, File::toPath);
            this.myComposeProject = deployment.getComposeProjectName();
        }

        DockerComposeRemoveImagesOnDown getRemoveImagesPolicy() {
            return this.myDownOptions.getRemoveImagesOnComposeDown();
        }

        DockerComposeDownCliBuilder.ImageKind shouldRemoveImages() {
            switch (this.getRemoveImagesPolicy()) {
                case ALL: {
                    return DockerComposeDownCliBuilder.ImageKind.all;
                }
                case LOCAL: {
                    return DockerComposeDownCliBuilder.ImageKind.local;
                }
            }
            return DockerComposeDownCliBuilder.ImageKind.none;
        }

        boolean shouldRemoveOrphans() {
            return this.myDownOptions.getRemoveOrphansOnComposeDown();
        }

        boolean shouldRemoveVolumes() {
            return this.myDownOptions.isRemoveVolumesOnComposeDown();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "deployment";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "composeFiles";
                    break;
                }
            }
            objectArray[1] = "com/intellij/docker/runtimes/ComposeDeploymentRuntime$NextDeployInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

