/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.runtimes;

import com.intellij.docker.DockerIcons;
import com.intellij.docker.agent.cli.communicator.AsyncCliProcess;
import com.intellij.docker.agent.cli.communicator.CliCommunicator;
import com.intellij.docker.agent.terminal.pipe.DockerTerminalPipe;
import com.intellij.docker.cli.executor.CliExecutor;
import com.intellij.docker.compose.cli.AbstractDockerComposeCmdCliBuilder;
import com.intellij.docker.compose.cli.DockerComposeCliUtil;
import com.intellij.docker.compose.cli.DockerComposeDownCliBuilder;
import com.intellij.docker.compose.cli.DockerComposeRestartCliBuilder;
import com.intellij.docker.compose.cli.DockerComposeStartCliBuilder;
import com.intellij.docker.compose.cli.DockerComposeStopCliBuilder;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.docker.runtimes.ComposeApplicationRuntime;
import com.intellij.docker.runtimes.ComposeServiceRuntime;
import com.intellij.docker.runtimes.DockerParentRuntime;
import com.intellij.docker.runtimes.DockerRuntimeBase;
import com.intellij.docker.runtimes.DockerRuntimeContext;
import com.intellij.docker.runtimes.DockerRuntimeNavigatable;
import com.intellij.docker.runtimes.DockerRuntimeVirtualFileNavigatable;
import com.intellij.docker.runtimes.DockerRuntimesManagerService;
import com.intellij.docker.ui.utils.DockerUiUtilsKt;
import com.intellij.docker.utils.DockerComposeUtilsKt;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.remoteServer.util.CloudNotifier;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.ui.JBColor;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 P2\u00020\u00012\u00020\u0002:\u0001PB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u001a\u001a\u00020\u0000H\u0016J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H&J\u0006\u0010\u001c\u001a\u00020\fJ\u0010\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u0001H\u0016J\u0010\u0010\u001f\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u0001H\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\fH\u0014J\b\u0010%\u001a\u00020&H\u0014J<\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\n\u0010*\u001a\u0006\u0012\u0002\b\u00030+2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0014\b\u0002\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0015H\u0007J\u0010\u0010-\u001a\u0004\u0018\u00010\u000f2\u0006\u0010.\u001a\u00020\u0006J\b\u0010/\u001a\u00020\u0006H\u0016J\b\u00100\u001a\u000201H\u0016J\u0014\u00102\u001a\u0010\u0012\f\u0012\n 5*\u0004\u0018\u0001040403J\f\u00106\u001a\b\u0012\u0004\u0012\u00020703J\b\u00108\u001a\u000209H&J\u000e\u0010:\u001a\b\u0012\u0004\u0012\u00020\u000f03H\u0002J\b\u0010;\u001a\u00020<H\u0016J\u0013\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00060>H\u0002\u00a2\u0006\u0002\u0010?J\u0006\u0010@\u001a\u00020AJ\u0006\u0010B\u001a\u00020AJ\u0006\u0010C\u001a\u00020AJ\u0006\u0010D\u001a\u00020AJ\u0006\u0010E\u001a\u00020AJ\b\u0010F\u001a\u00020AH\u0016J\u0006\u0010G\u001a\u00020AJ\u001a\u0010H\u001a\u00020\f2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0\u0015J\u0006\u0010I\u001a\u00020\fJ\f\u0010J\u001a\b\u0012\u0004\u0012\u00020)0(J\f\u0010K\u001a\b\u0012\u0004\u0012\u00020)0(J\n\u0010L\u001a\u0006\u0012\u0002\b\u00030(J\u0010\u0010M\u001a\u00020\f2\u0006\u0010N\u001a\u00020OH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u0006X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\t\u00a8\u0006Q"}, d2={"Lcom/intellij/docker/runtimes/ComposeApplicationRuntime;", "Lcom/intellij/docker/runtimes/DockerRuntimeBase;", "Lcom/intellij/docker/runtimes/DockerParentRuntime;", "context", "Lcom/intellij/docker/runtimes/DockerRuntimeContext;", "composeProjectName", "", "(Lcom/intellij/docker/runtimes/DockerRuntimeContext;Ljava/lang/String;)V", "getComposeProjectName", "()Ljava/lang/String;", "myCurrentProcess", "Lcom/intellij/docker/agent/cli/communicator/AsyncCliProcess;", "", "myServiceRuntimes", "", "Lcom/intellij/docker/runtimes/ComposeServiceRuntime;", "pipe", "Lcom/intellij/docker/agent/terminal/pipe/DockerTerminalPipe$WithTty;", "getPipe", "()Lcom/intellij/docker/agent/terminal/pipe/DockerTerminalPipe$WithTty;", "services", "", "getServices", "()Ljava/util/Map;", "workDirectory", "getWorkDirectory", "asDockerRuntime", "attachPipe", "cancelCurrentProcess", "childAdded", "child", "childRemoved", "computeRuntimeNavigatable", "Lcom/intellij/docker/runtimes/DockerRuntimeNavigatable;", "project", "Lcom/intellij/openapi/project/Project;", "doAfterUndeploy", "downCommand", "Lcom/intellij/docker/compose/cli/DockerComposeDownCliBuilder;", "executeCli", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "cliBuilder", "Lcom/intellij/docker/compose/cli/AbstractDockerComposeCmdCliBuilder;", "additionalEnvs", "findService", "serviceName", "getApplicationName", "getCloudNotifier", "Lcom/intellij/remoteServer/util/CloudNotifier;", "getComposeFilePaths", "", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "getComposeFiles", "Ljava/io/File;", "getRuntimeHelper", "Lcom/intellij/docker/remoteRunRuntime/RemoteDockerRuntime;", "getServicesWithContainers", "getStatus", "Lcom/intellij/remoteServer/runtime/deployment/DeploymentStatus;", "getValidServiceNames", "", "()[Ljava/lang/String;", "isAllServicesRunning", "", "isAllServicesStopped", "isAllServicesWithoutContainers", "isAnyServiceRunning", "isContainsOrphans", "isUndeploySupported", "isValidRuntime", "refreshServices", "removeOrphans", "restartAllRunningServices", "startAllServices", "stopAllServices", "undeploy", "callback", "Lcom/intellij/remoteServer/runtime/deployment/DeploymentRuntime$UndeploymentTaskCallback;", "Companion", "intellij.clouds.docker"})
public abstract class ComposeApplicationRuntime
extends DockerRuntimeBase
implements DockerParentRuntime {
    private final Map<String, ComposeServiceRuntime> myServiceRuntimes;
    private volatile AsyncCliProcess<Unit> myCurrentProcess;
    @NotNull
    private final String composeProjectName;
    @JvmField
    @NotNull
    public static final CloudNotifier COMPOSE_NOTIFIER;
    @NotNull
    public static final Companion Companion;

    @Nullable
    public abstract DockerTerminalPipe.WithTty getPipe();

    @Nullable
    protected abstract String getWorkDirectory();

    @NotNull
    public final Map<String, ComposeServiceRuntime> getServices() {
        return MapsKt.toMap(this.myServiceRuntimes);
    }

    @Override
    @NotNull
    public DeploymentStatus getStatus() {
        DeploymentStatus deploymentStatus;
        if (this.isAllServicesWithoutContainers()) {
            Icon icon = DockerIcons.ContainersList_2;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ContainersList_2");
            deploymentStatus = new DeploymentStatus(DockerUiUtilsKt.setColor$default(icon, "#9AA7B0", false, 2, null), "", false);
        } else {
            boolean bl;
            block11: {
                Iterable $this$none$iv = this.myServiceRuntimes.values();
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        ComposeServiceRuntime it = (ComposeServiceRuntime)element$iv;
                        boolean bl2 = false;
                        if (!DockerComposeUtilsKt.isComposeFilesLabelSupported(it.getComposeVersion())) continue;
                        bl = false;
                        break block11;
                    }
                    bl = true;
                }
            }
            if (bl) {
                Icon icon = DockerIcons.ContainersList_2;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ContainersList_2");
                deploymentStatus = new DeploymentStatus(DockerUiUtilsKt.setColor$default(icon, "#F4AF3D", false, 2, null), DockerBundle.message("DockerComposeApplication.unsupported.version.message", new Object[0]), false);
            } else if (!this.isValidRuntime()) {
                Icon icon = DockerIcons.ContainersList_2;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ContainersList_2");
                JBColor jBColor = JBColor.RED;
                Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"JBColor.RED");
                deploymentStatus = new DeploymentStatus(DockerUiUtilsKt.setColor$default(icon, jBColor, false, 2, null), "", false);
            } else if (this.isAllServicesStopped()) {
                Icon icon = DockerIcons.ContainersList_2;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ContainersList_2");
                deploymentStatus = new DeploymentStatus(DockerUiUtilsKt.setColor$default(icon, "#F4AF3D", false, 2, null), "", false);
            } else {
                deploymentStatus = new DeploymentStatus(DockerIcons.ContainersList_2, "", false);
            }
        }
        return deploymentStatus;
    }

    @NotNull
    public CloudNotifier getCloudNotifier() {
        return COMPOSE_NOTIFIER;
    }

    @NotNull
    public String getApplicationName() {
        return "Docker-compose: " + this.getComposeProjectName();
    }

    @Override
    @Nullable
    public DockerRuntimeNavigatable computeRuntimeNavigatable(@NotNull Project project) {
        DockerRuntimeVirtualFileNavigatable dockerRuntimeVirtualFileNavigatable;
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        File mainFile = (File)ContainerUtil.getFirstItem(this.getComposeFiles());
        VirtualFile virtualFile2 = virtualFile = mainFile == null ? null : LocalFileSystem.getInstance().findFileByIoFile(mainFile);
        if (virtualFile2 != null) {
            VirtualFile virtualFile3 = virtualFile2;
            boolean bl = false;
            boolean bl2 = false;
            VirtualFile it = virtualFile3;
            boolean bl3 = false;
            dockerRuntimeVirtualFileNavigatable = new DockerRuntimeVirtualFileNavigatable(project, it);
        } else {
            dockerRuntimeVirtualFileNavigatable = null;
        }
        return dockerRuntimeVirtualFileNavigatable;
    }

    @Override
    @NotNull
    public ComposeApplicationRuntime asDockerRuntime() {
        return this;
    }

    @Override
    public boolean isUndeploySupported() {
        return true;
    }

    @Override
    public void undeploy(@NotNull DeploymentRuntime.UndeploymentTaskCallback callback) {
        CompletableFuture completableFuture;
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        try {
            completableFuture = ComposeApplicationRuntime.executeCli$default(this, this.downCommand(), this.getPipe(), null, 4, null);
        }
        catch (ServerRuntimeException e) {
            String string = e.getMessage();
            Intrinsics.checkNotNull((Object)string);
            callback.errorOccurred(string);
            return;
        }
        CompletableFuture downPromise = completableFuture;
        ((CompletableFuture)((CompletableFuture)downPromise.thenRun(new Runnable(this){
            final /* synthetic */ ComposeApplicationRuntime this$0;

            public final void run() {
                this.this$0.doAfterUndeploy();
            }
            {
                this.this$0 = composeApplicationRuntime;
            }
        })).thenRun(new Runnable(callback){
            final /* synthetic */ DeploymentRuntime.UndeploymentTaskCallback $callback;

            public final void run() {
                this.$callback.succeeded();
            }
            {
                this.$callback = undeploymentTaskCallback;
            }
        })).exceptionally(new Function(callback){
            final /* synthetic */ DeploymentRuntime.UndeploymentTaskCallback $callback;

            public final Void apply(@NotNull Throwable e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                String string = e.getMessage();
                Intrinsics.checkNotNull((Object)string);
                this.$callback.errorOccurred(string);
                return null;
            }
            {
                this.$callback = undeploymentTaskCallback;
            }
        });
    }

    @Override
    public void childRemoved(@NotNull DockerRuntimeBase child) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)child), (String)"child");
            DockerRuntimeBase dockerRuntimeBase = child;
            if (!(dockerRuntimeBase instanceof ComposeServiceRuntime)) break block0;
            this.myServiceRuntimes.remove(ComposeApplicationRuntime.Companion.getServiceName((ComposeServiceRuntime)child));
        }
    }

    @Override
    public void childAdded(@NotNull DockerRuntimeBase child) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)child), (String)"child");
            DockerRuntimeBase dockerRuntimeBase = child;
            if (!(dockerRuntimeBase instanceof ComposeServiceRuntime)) break block0;
            this.myServiceRuntimes.put(ComposeApplicationRuntime.Companion.getServiceName((ComposeServiceRuntime)child), (ComposeServiceRuntime)child);
        }
    }

    public abstract void attachPipe(@NotNull DockerTerminalPipe.WithTty var1);

    @NotNull
    public abstract RemoteDockerRuntime getRuntimeHelper() throws ServerRuntimeException;

    @JvmOverloads
    @NotNull
    public final CompletableFuture<Void> executeCli(@NotNull AbstractDockerComposeCmdCliBuilder<?> cliBuilder, @Nullable DockerTerminalPipe.WithTty pipe, @NotNull Map<String, String> additionalEnvs) throws ServerRuntimeException {
        Intrinsics.checkNotNullParameter(cliBuilder, (String)"cliBuilder");
        Intrinsics.checkNotNullParameter(additionalEnvs, (String)"additionalEnvs");
        if (this.myCurrentProcess != null) {
            AsyncCliProcess<Unit> asyncCliProcess = this.myCurrentProcess;
            if (asyncCliProcess == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myCurrentProcess");
            }
            asyncCliProcess.cancel();
        }
        ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)executeCli.2.INSTANCE, (int)1, null);
        CompletableFuture<Void> result2 = new CompletableFuture<Void>();
        AppExecutorUtil.getAppExecutorService().execute(new Runnable(this, pipe, cliBuilder, additionalEnvs, result2){
            final /* synthetic */ ComposeApplicationRuntime this$0;
            final /* synthetic */ DockerTerminalPipe.WithTty $pipe;
            final /* synthetic */ AbstractDockerComposeCmdCliBuilder $cliBuilder;
            final /* synthetic */ Map $additionalEnvs;
            final /* synthetic */ CompletableFuture $result;

            /*
             * WARNING - void declaration
             */
            public final void run() {
                block4: {
                    void $this$filterTo$iv$iv;
                    DockerTerminalPipe.WithTty withTty = this.$pipe;
                    if (withTty != null) {
                        withTty.setShowCursor(true);
                    }
                    DockerTerminalPipe.WithTty withTty2 = this.$pipe;
                    if (withTty2 != null) {
                        withTty2.enableTerminalInputTransferring(true);
                    }
                    GeneralCommandLine commandLine = this.$cliBuilder.buildCommandLine();
                    List list = commandLine.getCommandLineList("");
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"commandLine.getCommandLineList(\"\")");
                    Iterable $this$filter$iv = list;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        String it = (String)element$iv$iv;
                        boolean bl = false;
                        String string = it;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it");
                        CharSequence charSequence = string;
                        boolean bl2 = false;
                        if (!(!StringsKt.isBlank((CharSequence)charSequence))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List args = (List)destination$iv$iv;
                    String string = commandLine.getExePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"commandLine.exePath");
                    CliExecutor executor = new CliExecutor(string, null, 2, null);
                    HashMap<K, V> envs = new HashMap<K, V>();
                    envs.putAll(commandLine.getEnvironment());
                    envs.putAll(this.$additionalEnvs);
                    DockerTerminalPipe.WithTty withTty3 = this.$pipe;
                    if (withTty3 != null) {
                        String string2 = commandLine.getCommandLineString();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"commandLine.commandLineString");
                        withTty3.printlnSystem(string2);
                    }
                    boolean bl = true;
                    Path path = null;
                    String string3 = this.this$0.getWorkDirectory();
                    Function1 function1 = (Function1)new Function1<Integer, Unit>(this){
                        final /* synthetic */ executeCli.3 this$0;

                        public final void invoke(int it) {
                            block4: {
                                if (it == 0) {
                                    this.this$0.$result.complete(null);
                                } else {
                                    String string = DockerBundle.message("ComposeDeploymentRuntime.process.finished.error.message", it);
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"ComposeDeployme\u2026ished.error.message\", it)");
                                    String message = string;
                                    this.this$0.$result.completeExceptionally(new CompletionException(message, null));
                                    DockerTerminalPipe.WithTty withTty = this.this$0.$pipe;
                                    if (withTty != null) {
                                        withTty.printError(message);
                                    }
                                }
                                DockerTerminalPipe.WithTty withTty = this.this$0.$pipe;
                                if (withTty != null) {
                                    withTty.enableTerminalInputTransferring(false);
                                }
                                DockerTerminalPipe.WithTty withTty2 = this.this$0.$pipe;
                                if (withTty2 == null) break block4;
                                withTty2.setShowCursor(false);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    };
                    Function1 function12 = (Function1)new Function1<String, Unit>(this){
                        final /* synthetic */ executeCli.3 this$0;

                        public final void invoke(@NotNull String it) {
                            block0: {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                DockerTerminalPipe.WithTty withTty = this.this$0.$pipe;
                                if (withTty == null) break block0;
                                withTty.printError(it);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    };
                    Function1 function13 = (Function1)new Function1<String, Unit>(this){
                        final /* synthetic */ executeCli.3 this$0;

                        public final void invoke(@NotNull String it) {
                            block0: {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                DockerTerminalPipe.WithTty withTty = this.this$0.$pipe;
                                if (withTty == null) break block0;
                                withTty.print(it);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    };
                    AsyncCliProcess asyncProcess2 = CliCommunicator.DefaultImpls.execAsync$default(executor, args, envs, function12, function13, function1, string3, path, bl, 64, null);
                    ComposeApplicationRuntime.access$setMyCurrentProcess$p(this.this$0, asyncProcess2);
                    DockerTerminalPipe.WithTty withTty4 = this.$pipe;
                    if (withTty4 == null) break block4;
                    withTty4.transferTerminalInputTo(asyncProcess2.getProcessInput());
                }
            }
            {
                this.this$0 = composeApplicationRuntime;
                this.$pipe = withTty;
                this.$cliBuilder = abstractDockerComposeCmdCliBuilder;
                this.$additionalEnvs = map2;
                this.$result = completableFuture;
            }
        });
        return result2;
    }

    public static /* synthetic */ CompletableFuture executeCli$default(ComposeApplicationRuntime composeApplicationRuntime, AbstractDockerComposeCmdCliBuilder abstractDockerComposeCmdCliBuilder, DockerTerminalPipe.WithTty withTty, Map map2, int n, Object object) throws ServerRuntimeException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: executeCli");
        }
        if ((n & 2) != 0) {
            withTty = composeApplicationRuntime.getPipe();
        }
        if ((n & 4) != 0) {
            boolean bl = false;
            map2 = MapsKt.emptyMap();
        }
        return composeApplicationRuntime.executeCli(abstractDockerComposeCmdCliBuilder, withTty, map2);
    }

    @JvmOverloads
    @NotNull
    public final CompletableFuture<Void> executeCli(@NotNull AbstractDockerComposeCmdCliBuilder<?> cliBuilder, @Nullable DockerTerminalPipe.WithTty pipe) throws ServerRuntimeException {
        return ComposeApplicationRuntime.executeCli$default(this, cliBuilder, pipe, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final CompletableFuture<Void> executeCli(@NotNull AbstractDockerComposeCmdCliBuilder<?> cliBuilder) throws ServerRuntimeException {
        return ComposeApplicationRuntime.executeCli$default(this, cliBuilder, null, null, 6, null);
    }

    public final void cancelCurrentProcess() {
        if (this.myCurrentProcess != null) {
            AsyncCliProcess<Unit> asyncCliProcess = this.myCurrentProcess;
            if (asyncCliProcess == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myCurrentProcess");
            }
            asyncCliProcess.cancel();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<File> getComposeFiles() {
        void $this$flatMapTo$iv$iv;
        ComposeServiceRuntime it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.myServiceRuntimes.values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ComposeServiceRuntime)element$iv$iv;
            boolean bl = false;
            if (!(!it.isOrphans())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (ComposeServiceRuntime)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getComposeFiles();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Path> getComposeFilePaths() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getComposeFiles();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file2 = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Path path = it.toPath();
            collection.add(path);
        }
        return (List)destination$iv$iv;
    }

    public final boolean isContainsOrphans() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.myServiceRuntimes.values();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ComposeServiceRuntime it = (ComposeServiceRuntime)element$iv;
                    boolean bl2 = false;
                    if (!it.isOrphans()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isValidRuntime() {
        Object object = this.getValidServiceNames();
        boolean bl = false;
        String[] stringArray = object;
        boolean bl2 = false;
        if (stringArray.length == 0) {
            return false;
        }
        boolean bl3 = false;
        if (bl3) return false;
        boolean bl4 = true;
        if (!bl4) return false;
        object = this.myServiceRuntimes;
        bl = false;
        if (object.isEmpty()) return false;
        return true;
    }

    public final boolean isAllServicesWithoutContainers() {
        boolean bl;
        block3: {
            Iterable $this$all$iv = this.myServiceRuntimes.values();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ComposeServiceRuntime it = (ComposeServiceRuntime)element$iv;
                    boolean bl2 = false;
                    if (!it.isContainsContainers()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public final boolean isAllServicesRunning() {
        boolean bl;
        block3: {
            Iterable $this$all$iv = this.getServicesWithContainers();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ComposeServiceRuntime it = (ComposeServiceRuntime)element$iv;
                    boolean bl2 = false;
                    if (it.isAnyContainerRunning()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public final boolean isAllServicesStopped() {
        boolean bl;
        block3: {
            Iterable $this$none$iv = this.getServicesWithContainers();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    ComposeServiceRuntime it = (ComposeServiceRuntime)element$iv;
                    boolean bl2 = false;
                    if (!it.isAnyContainerRunning()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public final boolean isAnyServiceRunning() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.myServiceRuntimes.values();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ComposeServiceRuntime it = (ComposeServiceRuntime)element$iv;
                    boolean bl2 = false;
                    if (!it.isAnyContainerRunning()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CompletableFuture<Void> startAllServices() throws ServerRuntimeException {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        ComposeServiceRuntime it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        DockerComposeStartCliBuilder dockerComposeStartCliBuilder = DockerComposeCliUtil.buildStartCommand(this.getRuntimeHelper());
        boolean bl = false;
        boolean bl2 = false;
        DockerComposeStartCliBuilder $this$with = dockerComposeStartCliBuilder;
        boolean bl3 = false;
        $this$with.withFiles(this.getComposeFilePaths());
        $this$with.withProjectName(this.getComposeProjectName());
        Iterable iterable = this.getServicesWithContainers();
        DockerComposeStartCliBuilder dockerComposeStartCliBuilder2 = $this$with;
        boolean $i$f$filter = false;
        void var9_9 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ComposeServiceRuntime)element$iv$iv;
            boolean bl4 = false;
            if (!it.isAnyContainerNotRunning()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection<String> collection = (List)destination$iv$iv;
        $this$filter$iv = collection;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ComposeServiceRuntime)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl5 = false;
            String string = it.getServiceName();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = collection;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        dockerComposeStartCliBuilder2.withServices(Arrays.copyOf(stringArray, stringArray.length));
        return ComposeApplicationRuntime.executeCli$default(this, $this$with, this.getPipe(), null, 4, null);
    }

    @NotNull
    public final CompletableFuture<?> stopAllServices() throws ServerRuntimeException {
        DockerComposeStopCliBuilder dockerComposeStopCliBuilder = DockerComposeCliUtil.buildStopCommand(this.getRuntimeHelper());
        boolean bl = false;
        boolean bl2 = false;
        DockerComposeStopCliBuilder $this$with = dockerComposeStopCliBuilder;
        boolean bl3 = false;
        $this$with.withProjectName(this.getComposeProjectName());
        $this$with.withFiles(this.getComposeFilePaths());
        String[] stringArray = this.getValidServiceNames();
        $this$with.withServices(Arrays.copyOf(stringArray, stringArray.length));
        return ComposeApplicationRuntime.executeCli$default(this, $this$with, this.getPipe(), null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void removeOrphans() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.myServiceRuntimes.values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ComposeServiceRuntime it = (ComposeServiceRuntime)element$iv$iv;
            boolean bl = false;
            if (!it.isOrphans()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ComposeServiceRuntime it = (ComposeServiceRuntime)element$iv;
            boolean bl = false;
            it.deleteAllContainers();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CompletableFuture<Void> restartAllRunningServices() throws ServerRuntimeException {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        ComposeServiceRuntime it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        DockerComposeRestartCliBuilder dockerComposeRestartCliBuilder = DockerComposeCliUtil.buildRestartCommand(this.getRuntimeHelper());
        boolean bl = false;
        boolean bl2 = false;
        DockerComposeRestartCliBuilder $this$with = dockerComposeRestartCliBuilder;
        boolean bl3 = false;
        Iterable iterable = this.myServiceRuntimes.values();
        DockerComposeRestartCliBuilder dockerComposeRestartCliBuilder2 = $this$with;
        boolean $i$f$filter = false;
        void var9_9 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ComposeServiceRuntime)element$iv$iv;
            boolean bl4 = false;
            if (!(it.getServiceStatus() == DockerRuntimesManagerService.ComposeServiceStatus.DEPLOYED)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection<String> collection = (List)destination$iv$iv;
        $this$filter$iv = collection;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ComposeServiceRuntime)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl5 = false;
            String string = it.getServiceName();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = collection;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        dockerComposeRestartCliBuilder2.withServices(Arrays.copyOf(stringArray, stringArray.length));
        $this$with.withProjectName(this.getComposeProjectName());
        $this$with.withFiles(this.getComposeFilePaths());
        return ComposeApplicationRuntime.executeCli$default(this, $this$with, this.getPipe(), null, 4, null);
    }

    public final void refreshServices(@NotNull Map<String, ? extends ComposeServiceRuntime> services) {
        Intrinsics.checkNotNullParameter(services, (String)"services");
        Map map2 = ContainerUtil.intersection(this.myServiceRuntimes, services);
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"ContainerUtil.intersecti\u2026erviceRuntimes, services)");
        Map intersection = map2;
        this.myServiceRuntimes.clear();
        this.myServiceRuntimes.putAll(intersection);
    }

    @Nullable
    public final ComposeServiceRuntime findService(@NotNull String serviceName) {
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        return this.myServiceRuntimes.get(serviceName);
    }

    @NotNull
    protected DockerComposeDownCliBuilder downCommand() throws ServerRuntimeException {
        return (DockerComposeDownCliBuilder)((DockerComposeDownCliBuilder)DockerComposeCliUtil.buildDownCommand(this.getRuntimeHelper()).withFiles(this.getComposeFilePaths())).withProjectName(this.getComposeProjectName());
    }

    protected void doAfterUndeploy() {
    }

    /*
     * WARNING - void declaration
     */
    private final List<ComposeServiceRuntime> getServicesWithContainers() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.myServiceRuntimes.values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ComposeServiceRuntime it = (ComposeServiceRuntime)element$iv$iv;
            boolean bl = false;
            if (!it.isContainsContainers()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final String[] getValidServiceNames() {
        void $this$mapTo$iv$iv;
        Map.Entry it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.myServiceRuntimes.entrySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            if (!(!((ComposeServiceRuntime)it.getValue()).isOrphans())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = (String)it.getKey();
            collection.add(string);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return stringArray;
    }

    @NotNull
    public String getComposeProjectName() {
        return this.composeProjectName;
    }

    public ComposeApplicationRuntime(@NotNull DockerRuntimeContext context, @NotNull String composeProjectName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)composeProjectName, (String)"composeProjectName");
        super(context, composeProjectName, null);
        this.composeProjectName = composeProjectName;
        this.myServiceRuntimes = new ConcurrentHashMap();
    }

    static {
        Companion = new Companion(null);
        COMPOSE_NOTIFIER = new CloudNotifier("docker-compose");
    }

    public static final /* synthetic */ AsyncCliProcess access$getMyCurrentProcess$p(ComposeApplicationRuntime $this) {
        AsyncCliProcess<Unit> asyncCliProcess = $this.myCurrentProcess;
        if (asyncCliProcess == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myCurrentProcess");
        }
        return asyncCliProcess;
    }

    public static final /* synthetic */ void access$setMyCurrentProcess$p(ComposeApplicationRuntime $this, AsyncCliProcess asyncCliProcess) {
        $this.myCurrentProcess = asyncCliProcess;
    }

    @JvmStatic
    @Nls
    @NotNull
    public static final String NOTIFICATION_GROUP_TITLE() {
        return Companion.NOTIFICATION_GROUP_TITLE();
    }

    @JvmStatic
    @NotNull
    protected static final File computeWorkingDir(@NotNull List<? extends File> composeFiles2) throws ServerRuntimeException {
        return Companion.computeWorkingDir(composeFiles2);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0007J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0005J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/docker/runtimes/ComposeApplicationRuntime$Companion;", "", "()V", "COMPOSE_NOTIFIER", "Lcom/intellij/remoteServer/util/CloudNotifier;", "NOTIFICATION_GROUP_TITLE", "", "computeWorkingDir", "Ljava/io/File;", "composeFiles", "", "getServiceName", "serviceRuntime", "Lcom/intellij/docker/runtimes/ComposeServiceRuntime;", "validateComposeFiles", "", "files", "intellij.clouds.docker"})
    public static final class Companion {
        @JvmStatic
        @Nls
        @NotNull
        public final String NOTIFICATION_GROUP_TITLE() {
            String string = DockerBundle.message("ComposeApplicationRuntime.notification.group", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"ComposeApplicat\u2026time.notification.group\")");
            return string;
        }

        private final String getServiceName(ComposeServiceRuntime serviceRuntime) {
            String string = serviceRuntime.getServiceName();
            if (string == null) {
                String string2 = StringUtil.substringAfterLast((String)serviceRuntime.getApplicationName(), (String)":");
                Intrinsics.checkNotNull((Object)string2);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringUtil.substringAfte\u2026e.applicationName, \":\")!!");
            }
            return string;
        }

        @JvmStatic
        @NotNull
        protected final File computeWorkingDir(@NotNull List<? extends File> composeFiles2) throws ServerRuntimeException {
            Intrinsics.checkNotNullParameter(composeFiles2, (String)"composeFiles");
            this.validateComposeFiles(composeFiles2);
            File file2 = composeFiles2.get(0).getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"composeFiles[0].parentFile");
            return file2;
        }

        private final void validateComposeFiles(List<? extends File> files) throws ServerRuntimeException {
            Object v0;
            block3: {
                if (files.isEmpty()) {
                    throw (Throwable)new ServerRuntimeException("Compose file is not specified");
                }
                Iterable $this$firstOrNull$iv = files;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    File it = (File)element$iv;
                    boolean bl = false;
                    if (!(!it.exists() || !it.isFile())) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            File firstMissing = v0;
            if (firstMissing != null) {
                throw (Throwable)new ServerRuntimeException("Can't read compose file at " + firstMissing);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

