/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remoteRunRuntime;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerConnector;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerPluginDisposable;
import com.intellij.docker.DockerServerRuntimeInstance;
import com.intellij.docker.RemoteDockerRuntimeUtil;
import com.intellij.docker.agent.DockerAgent;
import com.intellij.docker.agent.DockerAgentContainer;
import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.DockerAgentImage;
import com.intellij.docker.agent.DockerAgentProgressCallback;
import com.intellij.docker.agent.DockerAgentRepositoryConfig;
import com.intellij.docker.agent.DockerRepoTag;
import com.intellij.docker.agent.OngoingProcess;
import com.intellij.docker.agent.cli.communicator.CliCommunicator;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.registry.RegistryRuntimeTask;
import com.intellij.docker.remoteRunRuntime.RemoteDockerApplicationRuntime;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.impl.runtime.ServerTaskExecutorImpl;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.remoteServer.util.AgentTaskExecutor;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.Function;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RemoteDockerRuntime {
    private static final Logger LOG = Logger.getInstance(RemoteDockerRuntime.class);
    private static final Map<Pair<DockerCloudConfiguration, Project>, RemoteDockerRuntime> myDockerRuntimeMap = new LinkedHashMap<Pair<DockerCloudConfiguration, Project>, RemoteDockerRuntime>();
    private static final Lock myDockerRuntimeMapLock = new ReentrantLock();
    private final DockerCloudConfiguration myAccount;
    @Nullable
    private final Project myProject;
    private AgentTaskExecutor myAgentTaskExecutor;
    private DockerAgent myDockerAgent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RemoteDockerRuntime create(@NotNull DockerCloudConfiguration config, @Nullable Project project) throws ServerRuntimeException {
        RemoteDockerRuntime dockerRuntime2;
        if (config == null) {
            RemoteDockerRuntime.$$$reportNull$$$0(0);
        }
        myDockerRuntimeMapLock.lock();
        try {
            Pair key = Pair.create((Object)((Object)config), (Object)project);
            dockerRuntime2 = myDockerRuntimeMap.get(key);
            if (dockerRuntime2 == null) {
                dockerRuntime2 = new RemoteDockerRuntime(config, project);
                myDockerRuntimeMap.put((Pair<DockerCloudConfiguration, Project>)key, dockerRuntime2);
                Disposer.register((Disposable)DockerPluginDisposable.getInstance(project), () -> RemoteDockerRuntime.forgetRuntime((Pair<DockerCloudConfiguration, Project>)key));
            }
        }
        finally {
            myDockerRuntimeMapLock.unlock();
        }
        return dockerRuntime2;
    }

    private static void forgetRuntime(Pair<DockerCloudConfiguration, Project> key) {
        myDockerRuntimeMapLock.lock();
        try {
            myDockerRuntimeMap.remove(key);
        }
        finally {
            myDockerRuntimeMapLock.unlock();
        }
    }

    private RemoteDockerRuntime(DockerCloudConfiguration account, @Nullable Project project) throws ServerRuntimeException {
        this.myAccount = account;
        this.myProject = project;
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        final Ref errorRef = Ref.create();
        new DockerConnector(account, (ServerTaskExecutor)new ServerTaskExecutorImpl()).connect(new ServerConnector.ConnectionCallback<DockerDeploymentConfiguration>(){

            public void connected(@NotNull ServerRuntimeInstance<DockerDeploymentConfiguration> serverRuntimeInstance) {
                if (serverRuntimeInstance == null) {
                    1.$$$reportNull$$$0(0);
                }
                DockerServerRuntimeInstance dockerServerRuntimeInstance = (DockerServerRuntimeInstance)serverRuntimeInstance;
                RemoteDockerRuntime.this.myDockerAgent = dockerServerRuntimeInstance.getAgent();
                RemoteDockerRuntime.this.myAgentTaskExecutor = dockerServerRuntimeInstance.getAgentTaskExecutor();
                semaphore.up();
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    1.$$$reportNull$$$0(1);
                }
                errorRef.set((Object)new ServerRuntimeException(errorMessage));
                semaphore.up();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "serverRuntimeInstance";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/docker/remoteRunRuntime/RemoteDockerRuntime$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "connected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "errorOccurred";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        semaphore.waitFor();
        if (!errorRef.isNull()) {
            throw (ServerRuntimeException)((Object)errorRef.get());
        }
    }

    public <T> T executeAgentTask(Computable<T> computable) throws ServerRuntimeException {
        return RemoteDockerRuntimeUtil.executeAgentTask(this.myAgentTaskExecutor, computable);
    }

    public CliCommunicator getDockerCommunicator() {
        return this.getAgent().getCliFacade().createDockerCommunicator();
    }

    public DockerAgent getAgent() {
        return this.myDockerAgent;
    }

    public AgentTaskExecutor getAgentExecutor() {
        return this.myAgentTaskExecutor;
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @Nullable
    public RemoteDockerApplicationRuntime findContainerByNameOrId(String containerNameOrId) throws ServerRuntimeException {
        return (RemoteDockerApplicationRuntime)this.createNameOrId2ContainerMapping().fun((Object)containerNameOrId);
    }

    @NotNull
    public Function<String, RemoteDockerApplicationRuntime> createNameOrId2ContainerMapping() throws ServerRuntimeException {
        DockerAgentContainer[] containers = this.getContainers();
        Function function = containerNameOrId -> {
            for (DockerAgentContainer next : containers) {
                if (!StringUtil.equals((CharSequence)containerNameOrId, (CharSequence)next.getContainerId()) && !ContainerUtil.exists((Object[])next.getContainerNames(), n -> n != null && n.startsWith("/" + containerNameOrId))) continue;
                return RemoteDockerApplicationRuntime.create(this, next);
            }
            return null;
        };
        if (function == null) {
            RemoteDockerRuntime.$$$reportNull$$$0(1);
        }
        return function;
    }

    public DockerAgentContainer[] getContainers() throws ServerRuntimeException {
        return (DockerAgentContainer[])this.executeAgentTask(() -> this.getAgent().getContainers());
    }

    public DockerAgentImage[] getImages() throws ServerRuntimeException {
        return this.getImages(null);
    }

    public DockerAgentImage[] getImages(String label) throws ServerRuntimeException {
        return (DockerAgentImage[])this.executeAgentTask(() -> this.getAgent().getImages(label));
    }

    @Nullable
    public DockerAgentImage findImageByNameOrId(@NotNull String nameOrId) throws ServerRuntimeException {
        if (nameOrId == null) {
            RemoteDockerRuntime.$$$reportNull$$$0(2);
        }
        return nameOrId.startsWith("sha256:") ? this.findImageByIdPrefix(nameOrId) : this.findImageByName(nameOrId);
    }

    @Nullable
    public DockerAgentImage findImageByIdPrefix(@NotNull String sha256id) throws ServerRuntimeException {
        if (sha256id == null) {
            RemoteDockerRuntime.$$$reportNull$$$0(3);
        }
        int MINIMAL_LOOKUP_LENGTH = 6;
        String lookup = StringUtil.trimStart((String)sha256id, (String)"sha256:");
        if (lookup.length() < 6) {
            return null;
        }
        for (DockerAgentImage next : this.getImages()) {
            String actualId;
            String nextId = next.getImageId();
            if (nextId == null || !(actualId = StringUtil.trimStart((String)nextId, (String)"sha256:")).startsWith(lookup)) continue;
            return next;
        }
        return null;
    }

    @Nullable
    public DockerAgentImage findImageByName(@NotNull String imageName) throws ServerRuntimeException {
        DockerAgentImage[] images;
        if (imageName == null) {
            RemoteDockerRuntime.$$$reportNull$$$0(4);
        }
        for (DockerAgentImage next : images = this.getImages()) {
            for (String imageTag2 : next.getImageRepoTags()) {
                if (!StringUtil.equals((CharSequence)imageTag2, (CharSequence)imageName)) continue;
                return next;
            }
        }
        return null;
    }

    public void pullImage(@NotNull String imageName) throws ServerRuntimeException {
        if (imageName == null) {
            RemoteDockerRuntime.$$$reportNull$$$0(5);
        }
        LOG.debug("Pull image {" + imageName + "}");
        try {
            this.doPullImage(imageName);
            LOG.debug("Docker image {" + imageName + "} pulled successfully");
        }
        catch (ServerRuntimeException e) {
            LOG.debug("Failed to pull docker image {" + imageName + "}", (Throwable)e);
            throw e;
        }
    }

    public CompletableFuture<BlockingQueue<byte[]>> asyncPullImage(@NotNull String imageName) {
        if (imageName == null) {
            RemoteDockerRuntime.$$$reportNull$$$0(6);
        }
        if (this.myProject == null) {
            throw new NullPointerException();
        }
        DockerAgentRepositoryConfig repositoryConfig = RemoteDockerRuntime.forImageName(imageName);
        return this.getAgent().asyncPullImage(repositoryConfig);
    }

    public CompletableFuture<BlockingQueue<byte[]>> asyncBuildImage(@NotNull DockerAgentDeploymentConfig config) {
        if (config == null) {
            RemoteDockerRuntime.$$$reportNull$$$0(7);
        }
        if (this.myProject == null) {
            throw new NullPointerException();
        }
        return this.getAgent().createImageBuilder().asyncBuildImage(config);
    }

    private void doPullImage(@NotNull String imageName) throws ServerRuntimeException {
        if (imageName == null) {
            RemoteDockerRuntime.$$$reportNull$$$0(8);
        }
        final DockerAgentRepositoryConfig repositoryConfig = RemoteDockerRuntime.forImageName(imageName);
        new RegistryRuntimeTask(){

            @Override
            protected OngoingProcess doPerform(DockerAgentProgressCallback progressCallback) {
                return RemoteDockerRuntime.this.getAgent().pullImage(repositoryConfig, progressCallback);
            }
        }.performSync((ServerTaskExecutor)new ServerTaskExecutorImpl(), this.myAgentTaskExecutor, DockerBundle.message("RemoteDockerRuntime.progress.title.pulling.image", imageName));
    }

    public DockerCloudConfiguration getAccount() {
        return this.myAccount;
    }

    private static DockerAgentRepositoryConfig forImageName(String imageName) {
        DockerRepoTag repoTag = DockerRepoTag.fromString(imageName);
        return repoTag.toAgentRepositoryConfig();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remoteRunRuntime/RemoteDockerRuntime";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameOrId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sha256id";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remoteRunRuntime/RemoteDockerRuntime";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createNameOrId2ContainerMapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findImageByNameOrId";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findImageByIdPrefix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findImageByName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "pullImage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "asyncPullImage";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "asyncBuildImage";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doPullImage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

