/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run.target;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.agent.DockerAgentImage;
import com.intellij.docker.agent.progress.TtySink;
import com.intellij.docker.agent.settings.DockerPortBinding;
import com.intellij.docker.agent.settings.DockerPortBindingImpl;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.engine.DockerNetworkUtil;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.remote.run.runtime.UnixPathUtil;
import com.intellij.docker.remote.run.target.DockerEnvironment;
import com.intellij.docker.remote.run.target.configuration.DockerTargetEnvironmentConfiguration;
import com.intellij.docker.remote.run.target.prepare.BuildImageOperation;
import com.intellij.docker.remote.run.target.prepare.PrepareImageOperation;
import com.intellij.docker.remote.run.target.prepare.PullImageOperation;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.execution.Platform;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.target.BaseTargetEnvironmentRequest;
import com.intellij.execution.target.HostPort;
import com.intellij.execution.target.LanguageRuntimeConfiguration;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetPlatform;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.value.DeferredLocalTargetValue;
import com.intellij.execution.target.value.DeferredTargetValue;
import com.intellij.execution.target.value.TargetValue;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public final class DockerRemoteRequest
extends BaseTargetEnvironmentRequest {
    private final RemoteDockerRuntime myDocker;
    private final DockerTargetEnvironmentConfiguration myTargetConfiguration;
    private final Map<Integer, BoundPortValue> myPortsMap;
    private final Map<Integer, LocalPortTargetValue> myLocalPortsMap;
    private final Map<String, DockerTargetVolume> myVolumes;
    private String myVolumesRoot;
    private TargetEnvironmentRequest.Volume myDefaultVolume;
    private boolean mySaveFilesBeforeStartingProcess;

    public DockerRemoteRequest(RemoteDockerRuntime docker, DockerTargetEnvironmentConfiguration config) {
        this.myPortsMap = new TreeMap<Integer, BoundPortValue>();
        this.myLocalPortsMap = new HashMap<Integer, LocalPortTargetValue>();
        this.myVolumes = new HashMap<String, DockerTargetVolume>();
        this.mySaveFilesBeforeStartingProcess = true;
        this.myDocker = docker;
        this.myTargetConfiguration = config;
    }

    private DockerRemoteRequest(RemoteDockerRuntime docker, DockerTargetEnvironmentConfiguration config, @NotNull Set<TargetEnvironment.UploadRoot> uploadVolumes, @NotNull Set<TargetEnvironment.DownloadRoot> downloadVolumes, @NotNull Set<TargetEnvironment.TargetPortBinding> targetPortBindings, @NotNull Set<TargetEnvironment.LocalPortBinding> localPortBindings) {
        if (uploadVolumes == null) {
            DockerRemoteRequest.$$$reportNull$$$0(0);
        }
        if (downloadVolumes == null) {
            DockerRemoteRequest.$$$reportNull$$$0(1);
        }
        if (targetPortBindings == null) {
            DockerRemoteRequest.$$$reportNull$$$0(2);
        }
        if (localPortBindings == null) {
            DockerRemoteRequest.$$$reportNull$$$0(3);
        }
        super(uploadVolumes, downloadVolumes, targetPortBindings, localPortBindings);
        this.myPortsMap = new TreeMap<Integer, BoundPortValue>();
        this.myLocalPortsMap = new HashMap<Integer, LocalPortTargetValue>();
        this.myVolumes = new HashMap<String, DockerTargetVolume>();
        this.mySaveFilesBeforeStartingProcess = true;
        this.myDocker = docker;
        this.myTargetConfiguration = config;
    }

    @NotNull
    public TargetEnvironmentRequest duplicate() {
        return new DockerRemoteRequest(this.myDocker, this.myTargetConfiguration, new HashSet<TargetEnvironment.UploadRoot>(this.getUploadVolumes()), new HashSet<TargetEnvironment.DownloadRoot>(this.getDownloadVolumes()), new HashSet<TargetEnvironment.TargetPortBinding>(this.getTargetPortBindings()), new HashSet<TargetEnvironment.LocalPortBinding>(this.getLocalPortBindings()));
    }

    List<DockerVolumeBinding> prepareAgentVolumes(TargetProgressIndicator indicator) throws IOException {
        indicator.addSystemLine(DockerBundle.message("progress.text.preparing.volumes", new Object[0]));
        LinkedList<DockerVolumeBinding> result2 = new LinkedList<DockerVolumeBinding>();
        for (DockerTargetVolume next : this.myVolumes.values()) {
            result2.addAll(next.setupVolumes(indicator));
        }
        return result2;
    }

    @NotNull
    public TargetPlatform getTargetPlatform() {
        TargetPlatform targetPlatform = this.myTargetConfiguration.getValues().getTargetPlatform();
        if (targetPlatform == null) {
            DockerRemoteRequest.$$$reportNull$$$0(4);
        }
        return targetPlatform;
    }

    public DockerTargetEnvironmentConfiguration getConfiguration() {
        return this.myTargetConfiguration;
    }

    public RemoteDockerRuntime getDocker() {
        return this.myDocker;
    }

    @NotNull
    public TargetEnvironmentRequest.Volume createUploadRoot(@Nullable String remoteRootPath, boolean temporary) {
        String safeRemoteRootPath = this.safeRemotePath(remoteRootPath);
        DockerTargetVolume dockerTargetVolume = this.doCreateVolumeImpl(safeRemoteRootPath, temporary);
        if (dockerTargetVolume == null) {
            DockerRemoteRequest.$$$reportNull$$$0(5);
        }
        return dockerTargetVolume;
    }

    @NotNull
    public TargetEnvironmentRequest.DownloadableVolume createDownloadRoot(@Nullable String remoteRootPath) {
        DockerTargetVolume dockerTargetVolume = this.doCreateVolumeImpl(this.safeRemotePath(remoteRootPath), false);
        if (dockerTargetVolume == null) {
            DockerRemoteRequest.$$$reportNull$$$0(6);
        }
        return dockerTargetVolume;
    }

    @NotNull
    public TargetEnvironmentRequest.Volume getDefaultVolume() {
        if (this.myDefaultVolume == null) {
            this.myDefaultVolume = this.createTempVolume();
        }
        TargetEnvironmentRequest.Volume volume = this.myDefaultVolume;
        if (volume == null) {
            DockerRemoteRequest.$$$reportNull$$$0(7);
        }
        return volume;
    }

    private DockerTargetVolume doCreateVolumeImpl(@NotNull String safeRootPath, boolean temporary) {
        if (safeRootPath == null) {
            DockerRemoteRequest.$$$reportNull$$$0(8);
        }
        return this.myVolumes.computeIfAbsent(safeRootPath, root -> new DockerTargetVolume(this, (String)root, temporary));
    }

    @NotNull
    private String safeRemotePath(@Nullable String remotePath) {
        Object object = remotePath != null ? remotePath : this.getRemoteAllVolumesRoot() + "/" + (this.myVolumes.size() + 1) + "/";
        if (object == null) {
            DockerRemoteRequest.$$$reportNull$$$0(9);
        }
        return object;
    }

    @NotNull
    public TargetValue<Integer> bindTargetPort(int targetPort) {
        TargetValue targetValue = (TargetValue)this.myPortsMap.computeIfAbsent(targetPort, BoundPortValue::new);
        if (targetValue == null) {
            DockerRemoteRequest.$$$reportNull$$$0(10);
        }
        return targetValue;
    }

    @NotNull
    public TargetValue<HostPort> bindLocalPort(int localPort) {
        TargetValue targetValue = this.myLocalPortsMap.computeIfAbsent(localPort, port -> new LocalPortTargetValue((int)port));
        if (targetValue == null) {
            DockerRemoteRequest.$$$reportNull$$$0(11);
        }
        return targetValue;
    }

    @NotNull
    public TargetEnvironment prepareEnvironment(@NotNull TargetProgressIndicator progressIndicator) {
        DockerEnvironment dockerEnvironment;
        DockerAgentImage agentImage;
        if (progressIndicator == null) {
            DockerRemoteRequest.$$$reportNull$$$0(12);
        }
        progressIndicator.addSystemLine(DockerBundle.message("DockerEnvironmentFactory.progress.text.preparing.docker.target", new Object[0]));
        if (this.mySaveFilesBeforeStartingProcess) {
            WriteAction.runAndWait(() -> {
                Project project = this.myDocker.getProject();
                if (project != null) {
                    PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                }
                FileDocumentManager.getInstance().saveAllDocuments();
            });
        }
        try {
            agentImage = this.prepareImageRuntime(progressIndicator);
        }
        catch (ServerRuntimeException e) {
            throw new RuntimeException(e);
        }
        List<LocalPortTargetValue> localPorts = this.getLocalPortsToAccess();
        if (!localPorts.isEmpty()) {
            DockerCloudConfiguration dockerCloudConfiguration = this.myDocker.getAccount();
            String hostAddress = DockerNetworkUtil.getHostAddress(dockerCloudConfiguration);
            localPorts.forEach(targetValue -> targetValue.resolve(hostAddress));
        }
        try {
            String runCliOptions = this.getConfiguration().getValues().getContainerConfig().getRunCliOptions();
            List<DockerVolumeBinding> bindings = this.prepareAgentVolumes(progressIndicator);
            List<BoundPortValue> ports = this.getRemotePortsToBind();
            DockerEnvironment environment = DockerEnvironment.create(this.myDocker, agentImage, this, runCliOptions, bindings, ports);
            this.environmentPrepared(environment, progressIndicator);
            dockerEnvironment = environment;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (dockerEnvironment == null) {
            DockerRemoteRequest.$$$reportNull$$$0(13);
        }
        return dockerEnvironment;
    }

    @NotNull
    private DockerAgentImage prepareImageRuntime(@NotNull TargetProgressIndicator indicator) throws ServerRuntimeException {
        String imageTagOrId;
        DockerAgentImage agentImage;
        if (indicator == null) {
            DockerRemoteRequest.$$$reportNull$$$0(14);
        }
        if ((agentImage = this.myDocker.findImageByNameOrId(imageTagOrId = this.isBuildNotPull() ? this.getBuildImageConfig().getBuiltImageTag() : this.getPullImageConfig().getTagToPull())) == null || this.shouldRebuildEveryTime()) {
            agentImage = this.forceRecreateImage(indicator);
        }
        if (agentImage == null) {
            throw new RuntimeException(DockerBundle.message("DockerEnvironmentFactory.error.cant.find.image", imageTagOrId));
        }
        DockerAgentImage dockerAgentImage = agentImage;
        if (dockerAgentImage == null) {
            DockerRemoteRequest.$$$reportNull$$$0(15);
        }
        return dockerAgentImage;
    }

    private DockerTargetEnvironmentConfiguration.PullImageConfig getPullImageConfig() {
        return this.myTargetConfiguration.getValues().getPullImageConfig();
    }

    private boolean shouldRebuildEveryTime() {
        return this.isBuildNotPull() && this.getBuildImageConfig().getRebuildEveryTime();
    }

    private DockerTargetEnvironmentConfiguration.BuildImageConfig getBuildImageConfig() {
        return this.myTargetConfiguration.getValues().getBuildImageConfig();
    }

    private boolean isBuildNotPull() {
        return this.myTargetConfiguration.getValues().getBuildNotPull();
    }

    @Nullable
    private DockerAgentImage forceRecreateImage(final @NotNull TargetProgressIndicator indicator) throws ServerRuntimeException {
        if (indicator == null) {
            DockerRemoteRequest.$$$reportNull$$$0(16);
        }
        class PrintToIndicator
        implements Consumer<String> {
            private volatile boolean myHadRecentOutput = true;

            PrintToIndicator() {
            }

            @Override
            public void accept(@NlsSafe String text2) {
                text2 = StringUtil.trimEnd((String)text2, (char)'\n');
                indicator.addText(text2, (Key)ProcessOutputType.STDOUT);
                this.myHadRecentOutput = true;
            }

            public void reset() {
                this.myHadRecentOutput = false;
            }

            public boolean hasRecentOutput() {
                return this.myHadRecentOutput;
            }
        }
        PrintToIndicator printToIndicator = new PrintToIndicator();
        TtySink ttySink2 = TtySink.wrapNonTty(printToIndicator);
        PrepareImageOperation preparation = this.isBuildNotPull() ? new BuildImageOperation(this.myDocker.getProject(), this.myTargetConfiguration, this.myDocker, ttySink2) : new PullImageOperation(this.myDocker, this.getPullImageConfig().getTagToPull(), ttySink2);
        LanguageRuntimeConfiguration firstLanguage = (LanguageRuntimeConfiguration)ContainerUtil.getFirstItem((List)this.myTargetConfiguration.getRuntimes().resolvedConfigs());
        CompletableFuture<DockerAgentImage> imagePromise = preparation.perform(firstLanguage);
        DockerAgentImage image = null;
        while (true) {
            try {
                image = imagePromise.get(5000L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | TimeoutException ignored) {
                if (!printToIndicator.hasRecentOutput()) break;
                printToIndicator.reset();
                continue;
            }
            catch (ExecutionException e) {
                throw new ServerRuntimeException((Throwable)e);
            }
            break;
        }
        return image;
    }

    public List<BoundPortValue> getRemotePortsToBind() {
        return new ArrayList<BoundPortValue>(this.myPortsMap.values());
    }

    @NotNull
    public List<LocalPortTargetValue> getLocalPortsToAccess() {
        return new ArrayList<LocalPortTargetValue>(this.myLocalPortsMap.values());
    }

    private String getRemoteAllVolumesRoot() {
        if (this.myVolumesRoot == null) {
            this.myVolumesRoot = "/tmp/" + UUID.randomUUID();
        }
        return this.myVolumesRoot;
    }

    public void setSaveFilesBeforeStartingProcess(boolean saveFilesBeforeStartingProcess) {
        this.mySaveFilesBeforeStartingProcess = saveFilesBeforeStartingProcess;
    }

    private static String resolveRemotePath(@NotNull TargetEnvironmentRequest.Volume volume, @NotNull String absolutePathToRoot, @NotNull String pathFromRoot) {
        if (volume == null) {
            DockerRemoteRequest.$$$reportNull$$$0(17);
        }
        if (absolutePathToRoot == null) {
            DockerRemoteRequest.$$$reportNull$$$0(18);
        }
        if (pathFromRoot == null) {
            DockerRemoteRequest.$$$reportNull$$$0(19);
        }
        char separator = volume.getPlatform().fileSeparator;
        return StringUtil.trimTrailing((String)absolutePathToRoot, (char)separator) + separator + pathFromRoot;
    }

    static DockerVolumeBinding safeVolumeBinding(String containerPath, String localPath) {
        return new DockerVolumeBindingImpl(containerPath, UnixPathUtil.toUnixPath(localPath), false);
    }

    private static Logger getLogger() {
        return Logger.getInstance(DockerRemoteRequest.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uploadVolumes";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloadVolumes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPortBindings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPortBindings";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/run/target/DockerRemoteRequest";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "safeRootPath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "volume";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "absolutePathToRoot";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathFromRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/run/target/DockerRemoteRequest";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetPlatform";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createUploadRoot";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createDownloadRoot";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultVolume";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "safeRemotePath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "bindTargetPort";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "bindLocalPort";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareEnvironment";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareImageRuntime";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doCreateVolumeImpl";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "prepareEnvironment";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "prepareImageRuntime";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "forceRecreateImage";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "resolveRemotePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DockerTargetVolume
    implements TargetEnvironmentRequest.DownloadableVolume {
        private final DockerRemoteRequest myMainRequest;
        private final String myRemoteRoot;
        private final String myVolumeId;
        private final boolean myIsTemporary;
        private final Map<String, UploadToTargetValue> myUploads;
        private final Map<String, DownloadFromTargetValue> myDownloads;

        DockerTargetVolume(@NotNull DockerRemoteRequest request, @NotNull String remoteRoot, boolean temporary) {
            if (request == null) {
                DockerTargetVolume.$$$reportNull$$$0(0);
            }
            if (remoteRoot == null) {
                DockerTargetVolume.$$$reportNull$$$0(1);
            }
            this.myUploads = new LinkedHashMap<String, UploadToTargetValue>();
            this.myDownloads = new LinkedHashMap<String, DownloadFromTargetValue>();
            this.myMainRequest = request;
            this.myRemoteRoot = remoteRoot;
            this.myVolumeId = remoteRoot + "@" + Integer.toHexString(System.identityHashCode(this));
            this.myIsTemporary = temporary;
        }

        boolean isTemporary() {
            return this.myIsTemporary;
        }

        @NotNull
        public String getRemoteRoot() {
            String string = this.myRemoteRoot;
            if (string == null) {
                DockerTargetVolume.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getVolumeId() {
            String string = this.myVolumeId;
            if (string == null) {
                DockerTargetVolume.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public Platform getPlatform() {
            Platform platform = this.myMainRequest.getTargetPlatform().getPlatform();
            if (platform == null) {
                DockerTargetVolume.$$$reportNull$$$0(4);
            }
            return platform;
        }

        @NotNull
        public TargetValue<String> createUpload(@NotNull String localPath) {
            if (localPath == null) {
                DockerTargetVolume.$$$reportNull$$$0(5);
            }
            TargetValue targetValue = (TargetValue)this.myUploads.computeIfAbsent(localPath, p -> UploadToTargetValue.forLocalPath((TargetEnvironmentRequest.Volume)this, p));
            if (targetValue == null) {
                DockerTargetVolume.$$$reportNull$$$0(6);
            }
            return targetValue;
        }

        @NotNull
        public TargetValue<String> createDownload(@NotNull String rootRelativePath) {
            if (rootRelativePath == null) {
                DockerTargetVolume.$$$reportNull$$$0(7);
            }
            TargetValue targetValue = (TargetValue)this.myDownloads.computeIfAbsent(rootRelativePath, p -> new DownloadFromTargetValue(this, rootRelativePath));
            if (targetValue == null) {
                DockerTargetVolume.$$$reportNull$$$0(8);
            }
            return targetValue;
        }

        public List<DockerVolumeBinding> setupVolumes(TargetProgressIndicator indicator) throws IOException {
            LinkedList<DockerVolumeBinding> result2 = new LinkedList<DockerVolumeBinding>();
            result2.addAll(this.setupUploadVolumes(indicator));
            result2.addAll(this.setupDownloadVolume(indicator));
            return result2;
        }

        private List<DockerVolumeBinding> setupUploadVolumes(TargetProgressIndicator indicator) {
            LinkedList<DockerVolumeBinding> result2 = new LinkedList<DockerVolumeBinding>();
            Map<File, List<UploadToTargetValue>> groupedByContainerPoint = this.myUploads.values().stream().collect(Collectors.groupingBy(UploadToTargetValue::getContainerFolder));
            int idx = 0;
            for (Map.Entry<File, List<UploadToTargetValue>> nextEntry : groupedByContainerPoint.entrySet()) {
                String nextContainerPath;
                if (groupedByContainerPoint.size() == 1) {
                    nextContainerPath = this.myRemoteRoot;
                } else {
                    String groupRoot = DockerRemoteRequest.resolveRemotePath((TargetEnvironmentRequest.Volume)this, this.myRemoteRoot, String.valueOf(idx));
                    nextContainerPath = DockerRemoteRequest.resolveRemotePath((TargetEnvironmentRequest.Volume)this, groupRoot, nextEntry.getKey().getName());
                }
                DockerVolumeBinding agentVolume = DockerRemoteRequest.safeVolumeBinding(nextContainerPath, nextEntry.getKey().getPath());
                indicator.addSystemLine(DockerBundle.message("progress.text.docker.upload.volume.progress.message", agentVolume.getHostPath(), agentVolume.getContainerPath()));
                result2.add(agentVolume);
                for (UploadToTargetValue nextUpload : nextEntry.getValue()) {
                    nextUpload.agentVolumeAttached(agentVolume);
                }
                ++idx;
            }
            return result2;
        }

        private List<DockerVolumeBinding> setupDownloadVolume(TargetProgressIndicator indicator) throws IOException {
            Path tempLocalFolder;
            if (this.myDownloads.isEmpty()) {
                return Collections.emptyList();
            }
            try {
                tempLocalFolder = Files.createTempDirectory("dockerTargetDownload", new FileAttribute[0]);
                tempLocalFolder = tempLocalFolder.toRealPath(new LinkOption[0]);
            }
            catch (IOException e) {
                throw new IOException("Can't create temp local folder for download volume", e);
            }
            DockerVolumeBindingImpl agentVolume = new DockerVolumeBindingImpl(this.myRemoteRoot, tempLocalFolder.toString(), false);
            indicator.addSystemLine(DockerBundle.message("progress.text.docker.download.volume.progress.message", agentVolume.getHostPath(), agentVolume.getContainerPath()));
            for (DownloadFromTargetValue nextDownload : this.myDownloads.values()) {
                nextDownload.agentVolumeAttached(agentVolume);
            }
            return Collections.singletonList(agentVolume);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "remoteRoot";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/remote/run/target/DockerRemoteRequest$DockerTargetVolume";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localPath";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootRelativePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/remote/run/target/DockerRemoteRequest$DockerTargetVolume";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRemoteRoot";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVolumeId";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPlatform";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createUpload";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createDownload";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 8: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createUpload";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createDownload";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class LocalPortTargetValue
    implements TargetValue<HostPort> {
        private final AsyncPromise<HostPort> myPromise = new AsyncPromise();
        private final int myLocalPort;

        LocalPortTargetValue(int localPort) {
            this.myLocalPort = localPort;
        }

        int getLocalPort() {
            return this.myLocalPort;
        }

        public Promise<HostPort> getLocalValue() {
            return this.myPromise;
        }

        public Promise<HostPort> getTargetValue() {
            return this.myPromise;
        }

        void resolve(@NotNull String host) {
            if (host == null) {
                LocalPortTargetValue.$$$reportNull$$$0(0);
            }
            this.myPromise.setResult((Object)new HostPort(host, this.myLocalPort));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/docker/remote/run/target/DockerRemoteRequest$LocalPortTargetValue", "resolve"));
        }
    }

    static class BoundPortValue
    extends DeferredLocalTargetValue<Integer> {
        private static final int NOT_BOUND = -1;

        BoundPortValue(int containerPort) {
            super((Object)containerPort);
        }

        int getContainerPort() {
            try {
                Integer port = (Integer)this.getTargetValue().blockingGet(0);
                return port != null ? port : -1;
            }
            catch (ExecutionException | TimeoutException e) {
                throw new IllegalStateException("Port has not been resolved yet", e);
            }
        }

        void localPortBound(@Nullable DockerPortBinding portBinding) {
            Integer resolvedValue;
            Integer n = resolvedValue = portBinding == null ? null : portBinding.getHostPort();
            if (resolvedValue != null) {
                super.resolve((Object)resolvedValue);
                return;
            }
            try {
                int remotePort = this.getContainerPort();
                DockerRemoteRequest.getLogger().error("Requested port " + remotePort + " is not bound by container: " + portBinding);
            }
            catch (RuntimeException e) {
                DockerRemoteRequest.getLogger().error("Remote port was not set, port binding can't be found", (Throwable)e);
            }
        }

        DockerPortBindingImpl asDockerPortBinding() {
            DockerPortBindingImpl result2 = new DockerPortBindingImpl();
            result2.setContainerPort(this.getContainerPort());
            return result2;
        }
    }

    private static class DownloadFromTargetValue
    extends DeferredLocalTargetValue<String> {
        private final String myPathFromVolume;

        DownloadFromTargetValue(@NotNull TargetEnvironmentRequest.DownloadableVolume volume, @NotNull String pathFromVolume) {
            if (volume == null) {
                DownloadFromTargetValue.$$$reportNull$$$0(0);
            }
            if (pathFromVolume == null) {
                DownloadFromTargetValue.$$$reportNull$$$0(1);
            }
            super((Object)DockerRemoteRequest.resolveRemotePath((TargetEnvironmentRequest.Volume)volume, volume.getRemoteRoot(), pathFromVolume));
            this.myPathFromVolume = pathFromVolume;
        }

        void agentVolumeAttached(@NotNull DockerVolumeBinding agentVolume) {
            if (agentVolume == null) {
                DownloadFromTargetValue.$$$reportNull$$$0(2);
            }
            String localPath = agentVolume.getHostPath() + Platform.current().fileSeparator + this.myPathFromVolume;
            super.resolve((Object)localPath);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "volume";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathFromVolume";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "agentVolume";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/docker/remote/run/target/DockerRemoteRequest$DownloadFromTargetValue";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "agentVolumeAttached";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class UploadToTargetValue
    extends DeferredTargetValue<String> {
        private final TargetEnvironmentRequest.Volume myVolume;
        private final File myLocalFile;

        static UploadToTargetValue forLocalPath(@NotNull TargetEnvironmentRequest.Volume volume, @NotNull String localPath) {
            if (volume == null) {
                UploadToTargetValue.$$$reportNull$$$0(0);
            }
            if (localPath == null) {
                UploadToTargetValue.$$$reportNull$$$0(1);
            }
            try {
                File canonicalFile = new File(FileUtil.toSystemDependentName((String)localPath)).getCanonicalFile();
                return new UploadToTargetValue(volume, canonicalFile);
            }
            catch (IOException e) {
                throw new RuntimeException("Can't resolve path: " + localPath, e);
            }
        }

        private UploadToTargetValue(@NotNull TargetEnvironmentRequest.Volume volume, @NotNull File localFile) {
            if (volume == null) {
                UploadToTargetValue.$$$reportNull$$$0(2);
            }
            if (localFile == null) {
                UploadToTargetValue.$$$reportNull$$$0(3);
            }
            super((Object)localFile.getAbsolutePath());
            this.myVolume = volume;
            this.myLocalFile = localFile;
        }

        void agentVolumeAttached(@NotNull DockerVolumeBinding agentVolume) {
            if (agentVolume == null) {
                UploadToTargetValue.$$$reportNull$$$0(4);
            }
            String pathInVolume = this.myLocalFile.isDirectory() ? "" : this.myLocalFile.getName();
            String remotePath = DockerRemoteRequest.resolveRemotePath(this.myVolume, agentVolume.getContainerPath(), pathInVolume);
            super.resolve((Object)remotePath);
        }

        @NotNull
        File getContainerFolder() {
            File file2 = this.myLocalFile.isDirectory() ? this.myLocalFile : this.myLocalFile.getParentFile();
            if (file2 == null) {
                UploadToTargetValue.$$$reportNull$$$0(5);
            }
            return file2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "volume";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localPath";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localFile";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "agentVolume";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/remote/run/target/DockerRemoteRequest$UploadToTargetValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/remote/run/target/DockerRemoteRequest$UploadToTargetValue";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContainerFolder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "forLocalPath";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "agentVolumeAttached";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

