/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run.target;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.DockerAgentImage;
import com.intellij.docker.agent.DockerAgentSourceType;
import com.intellij.docker.agent.settings.DockerEnvVar;
import com.intellij.docker.agent.settings.DockerEnvVarImpl;
import com.intellij.docker.agent.settings.DockerPortBinding;
import com.intellij.docker.agent.settings.DockerPortBindingImpl;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.engine.DockerNetworkUtil;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.remote.run.runtime.DockerExecProcess;
import com.intellij.docker.remote.run.target.DockerDownloadVolume;
import com.intellij.docker.remote.run.target.DockerMountedVolume;
import com.intellij.docker.remote.run.target.DockerRemoteRequest;
import com.intellij.docker.remoteRunRuntime.RemoteDockerApplicationRuntime;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.target.HostPort;
import com.intellij.execution.target.ResolvedPortBinding;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetPlatform;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.DeferredRemoteProcess;
import com.intellij.remote.RemoteProcess;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.net.NetUtils;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class DockerEnvironment
extends TargetEnvironment {
    private static final Logger LOG = Logger.getInstance(DockerEnvironment.class);
    private final DockerAgentImage myAgentImage;
    @NotNull
    private final Collection<DockerVolumeBinding> myVolumeBindings;
    @NotNull
    private final List<DockerRemoteRequest.BoundPortValue> myPortBindings;
    @NotNull
    private final String myRunCliOptions;
    private final Map<TargetEnvironment.UploadRoot, TargetEnvironment.UploadableVolume> myUploadVolumes;
    private final Map<TargetEnvironment.DownloadRoot, TargetEnvironment.DownloadableVolume> myDownloadVolumes;
    private final Map<TargetEnvironment.TargetPortBinding, Integer> myTargetPortBindings;
    private final Map<TargetEnvironment.LocalPortBinding, ResolvedPortBinding> myLocalPortBindings;
    private boolean myDeferContainerRemovalUntilShutdown;
    private RemoteDockerApplicationRuntime myContainer;

    DockerEnvironment(@NotNull DockerAgentImage image, @NotNull DockerRemoteRequest request, @NotNull String options, @NotNull Collection<DockerVolumeBinding> volumeBindings, @NotNull List<DockerRemoteRequest.BoundPortValue> ports) {
        if (image == null) {
            DockerEnvironment.$$$reportNull$$$0(0);
        }
        if (request == null) {
            DockerEnvironment.$$$reportNull$$$0(1);
        }
        if (options == null) {
            DockerEnvironment.$$$reportNull$$$0(2);
        }
        if (volumeBindings == null) {
            DockerEnvironment.$$$reportNull$$$0(3);
        }
        if (ports == null) {
            DockerEnvironment.$$$reportNull$$$0(4);
        }
        super((TargetEnvironmentRequest)request);
        this.myUploadVolumes = new HashMap<TargetEnvironment.UploadRoot, TargetEnvironment.UploadableVolume>();
        this.myDownloadVolumes = new HashMap<TargetEnvironment.DownloadRoot, TargetEnvironment.DownloadableVolume>();
        this.myTargetPortBindings = new HashMap<TargetEnvironment.TargetPortBinding, Integer>();
        this.myLocalPortBindings = new HashMap<TargetEnvironment.LocalPortBinding, ResolvedPortBinding>();
        this.myAgentImage = image;
        this.myRunCliOptions = options;
        this.myVolumeBindings = volumeBindings;
        this.myPortBindings = ports;
    }

    @NotNull
    public Map<TargetEnvironment.UploadRoot, TargetEnvironment.UploadableVolume> getUploadVolumes() {
        Map<TargetEnvironment.UploadRoot, TargetEnvironment.UploadableVolume> map2 = Collections.unmodifiableMap(this.myUploadVolumes);
        if (map2 == null) {
            DockerEnvironment.$$$reportNull$$$0(5);
        }
        return map2;
    }

    @NotNull
    public Map<TargetEnvironment.DownloadRoot, TargetEnvironment.DownloadableVolume> getDownloadVolumes() {
        Map<TargetEnvironment.DownloadRoot, TargetEnvironment.DownloadableVolume> map2 = Collections.unmodifiableMap(this.myDownloadVolumes);
        if (map2 == null) {
            DockerEnvironment.$$$reportNull$$$0(6);
        }
        return map2;
    }

    @NotNull
    public Map<TargetEnvironment.TargetPortBinding, Integer> getTargetPortBindings() {
        Map<TargetEnvironment.TargetPortBinding, Integer> map2 = Collections.unmodifiableMap(this.myTargetPortBindings);
        if (map2 == null) {
            DockerEnvironment.$$$reportNull$$$0(7);
        }
        return map2;
    }

    @NotNull
    public Map<TargetEnvironment.LocalPortBinding, ResolvedPortBinding> getLocalPortBindings() {
        Map<TargetEnvironment.LocalPortBinding, ResolvedPortBinding> map2 = Collections.unmodifiableMap(this.myLocalPortBindings);
        if (map2 == null) {
            DockerEnvironment.$$$reportNull$$$0(8);
        }
        return map2;
    }

    @NotNull
    public TargetPlatform getTargetPlatform() {
        TargetPlatform targetPlatform = this.getRequest().getTargetPlatform();
        if (targetPlatform == null) {
            DockerEnvironment.$$$reportNull$$$0(9);
        }
        return targetPlatform;
    }

    public void shutdown() {
        if (this.myDeferContainerRemovalUntilShutdown && this.myContainer != null) {
            RemoteDockerApplicationRuntime container = this.myContainer;
            ApplicationManager.getApplication().executeOnPooledThread(() -> container.removeContainer());
        }
        this.myContainer = null;
    }

    @Nullable
    public RemoteDockerApplicationRuntime getContainerRuntime() {
        return this.myContainer;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public Process createProcess(@NotNull TargetedCommandLine commandLine, @NotNull ProgressIndicator indicator) throws ExecutionException {
        if (commandLine == null) {
            DockerEnvironment.$$$reportNull$$$0(10);
        }
        if (indicator == null) {
            DockerEnvironment.$$$reportNull$$$0(11);
        }
        try {
            resolvedCommand = ArrayUtil.toStringArray((Collection)commandLine.collectCommandsSynchronously());
            inputFilePath = commandLine.getInputFilePath();
            if (inputFilePath != null) {
                // empty if block
            }
            workingDirectory = StringUtil.nullize((String)commandLine.getWorkingDirectory());
            portBindings = this.getPortBindings();
            actualPortMappings = portBindings.stream().collect(Collectors.toMap((Function<DockerPortBinding, Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getContainerPort(), (Lcom/intellij/docker/agent/settings/DockerPortBinding;)Ljava/lang/Integer;)(), (Function<DockerPortBinding, DockerPortBinding>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$createProcess$1(com.intellij.docker.agent.settings.DockerPortBinding ), (Lcom/intellij/docker/agent/settings/DockerPortBinding;)Lcom/intellij/docker/agent/settings/DockerPortBinding;)(), (BinaryOperator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$createProcess$2(com.intellij.docker.agent.settings.DockerPortBinding com.intellij.docker.agent.settings.DockerPortBinding ), (Lcom/intellij/docker/agent/settings/DockerPortBinding;Lcom/intellij/docker/agent/settings/DockerPortBinding;)Lcom/intellij/docker/agent/settings/DockerPortBinding;)(), (Supplier<HashMap>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$createProcess$3(), ()Ljava/util/HashMap;)()));
            environmentVariables = commandLine.getEnvironmentVariables();
            v0 /* !! */  = runCliOptionsList /* !! */  = StringUtil.isEmptyOrSpaces((String)this.myRunCliOptions) != false ? new ArrayList<E>() : ParametersListUtil.parse((String)this.myRunCliOptions);
            if (this.getRequest().getDownloadVolumes().isEmpty()) ** GOTO lbl-1000
            if (ContainerUtil.exists((Object[])DockerEnvironment.RM_OPTION_ALTERNATIVES(), (Condition)(Condition)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, contains(java.lang.Object ), (Ljava/lang/String;)Z)(runCliOptionsList /* !! */ ))) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            this.myDeferContainerRemovalUntilShutdown = v1;
            deployConfig = new DockerAgentDeploymentConfig.Adapter(){

                @Override
                public String[] getImageTags() {
                    return new String[]{DockerEnvironment.this.myAgentImage.getImageId()};
                }

                @Override
                public DockerPortBinding[] getPortBindings() {
                    DockerPortBinding[] result2 = (DockerPortBinding[])portBindings.toArray(DockerPortBinding[]::new);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("ports: " + Stream.of(result2).map(next -> (DockerPortBindingImpl)ObjectUtils.tryCast((Object)next, DockerPortBindingImpl.class)).filter(Objects::nonNull).map(DockerPortBindingImpl::toCommandLineString).map(x$0 -> DockerEnvironment.quote(x$0)).collect(Collectors.joining(",\n\t")));
                    }
                    return result2;
                }

                @Override
                public DockerEnvVar[] getEnvVars() {
                    return (DockerEnvVar[])environmentVariables.entrySet().stream().map(e -> new DockerEnvVarImpl((String)e.getKey(), (String)e.getValue())).toArray(DockerEnvVar[]::new);
                }

                @Override
                public String getWorkingDir() {
                    return workingDirectory;
                }

                @Override
                public DockerVolumeBinding[] getVolumeBindings() {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("volumes: " + DockerEnvironment.this.myVolumeBindings.stream().map(next -> ((DockerVolumeBindingImpl)next).toCommandLineString()).map(x$0 -> DockerEnvironment.quote(x$0)).collect(Collectors.joining(",\n\t")));
                    }
                    return DockerEnvironment.this.myVolumeBindings.toArray(new DockerVolumeBinding[0]);
                }

                @Override
                public String[] getCommand() {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("command: " + Stream.of(resolvedCommand).map(x$0 -> DockerEnvironment.quote(x$0)).collect(Collectors.joining()));
                    }
                    return resolvedCommand;
                }

                @Override
                public String sourceType() {
                    return DockerAgentSourceType.IMAGE.name();
                }

                @Override
                public String[] getCustomRunOptions() {
                    ArrayList<String> result2 = new ArrayList<String>();
                    result2.add("--security-opt=seccomp:unconfined");
                    if (DockerEnvironment.this.myDeferContainerRemovalUntilShutdown) {
                        for (String nextRm : DockerEnvironment.RM_OPTION_ALTERNATIVES()) {
                            runCliOptionsList.remove(nextRm);
                        }
                    }
                    result2.addAll(runCliOptionsList);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("effective cli options: " + result2.stream().map(x$0 -> DockerEnvironment.quote(x$0)).collect(Collectors.joining(",\n\t")));
                        LOG.debug("deferred --rm: " + DockerEnvironment.this.myDeferContainerRemovalUntilShutdown);
                    }
                    return ArrayUtil.toStringArray(result2);
                }

                @Override
                public boolean isCreateContainerOnly() {
                    return true;
                }
            };
            if (ApplicationManager.getApplication().isDispatchThread()) {
                return new DeferredRemoteProcess(DockerEnvironment.runAsync((Callable<RemoteProcess>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$createProcess$4(java.util.Map com.intellij.docker.agent.DockerAgentDeploymentConfig ), ()Lcom/intellij/remote/RemoteProcess;)((DockerEnvironment)this, (Map)actualPortMappings, (DockerAgentDeploymentConfig)deployConfig)));
            }
            return this.doCreateDockerProcess(actualPortMappings, deployConfig);
        }
        catch (RemoteSdkException | ServerRuntimeException | IOException e) {
            throw new ExecutionException(DockerBundle.message("DockerEnvironment.cant.run.process", new Object[]{e.getMessage()}), e);
        }
    }

    @NotNull
    private RemoteProcess doCreateDockerProcess(@NotNull Map<Integer, DockerPortBinding> actualPortMappings, @NotNull DockerAgentDeploymentConfig deployConfig2) throws ExecutionException, IOException, ServerRuntimeException {
        if (actualPortMappings == null) {
            DockerEnvironment.$$$reportNull$$$0(12);
        }
        if (deployConfig2 == null) {
            DockerEnvironment.$$$reportNull$$$0(13);
        }
        this.myContainer = RemoteDockerApplicationRuntime.createWithPullImage(((DockerRemoteRequest)this.getRequest()).getDocker(), deployConfig2);
        this.myContainer.startAndAttach();
        DockerExecProcess result2 = DockerExecProcess.Factory.newProcess(this.myContainer, false);
        this.myPortBindings.forEach(portValue -> portValue.localPortBound((DockerPortBinding)actualPortMappings.get(portValue.getContainerPort())));
        DockerExecProcess dockerExecProcess = result2;
        if (dockerExecProcess == null) {
            DockerEnvironment.$$$reportNull$$$0(14);
        }
        return dockerExecProcess;
    }

    @NotNull
    private static <T> AsyncPromise<T> runAsync(@NotNull Callable<T> callable) {
        if (callable == null) {
            DockerEnvironment.$$$reportNull$$$0(15);
        }
        AsyncPromise promise = new AsyncPromise();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                Object result2 = callable.call();
                promise.setResult(result2);
            }
            catch (Throwable t) {
                promise.setError(t);
            }
        });
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            DockerEnvironment.$$$reportNull$$$0(16);
        }
        return asyncPromise;
    }

    private static String[] RM_OPTION_ALTERNATIVES() {
        return new String[]{"--rm", "-rm"};
    }

    private static String quote(String text2) {
        return "`" + text2 + "`";
    }

    private List<DockerPortBinding> getPortBindings() throws IOException {
        if (this.myPortBindings.isEmpty()) {
            return Collections.emptyList();
        }
        int[] localPorts = NetUtils.findAvailableSocketPorts((int)this.myPortBindings.size());
        int idx = 0;
        ArrayList<DockerPortBinding> result2 = new ArrayList<DockerPortBinding>(localPorts.length);
        for (DockerRemoteRequest.BoundPortValue nextPortRequest : this.myPortBindings) {
            DockerPortBindingImpl nextBinding = nextPortRequest.asDockerPortBinding();
            if (nextBinding.getHostPort() == null) {
                nextBinding.setHostPort(localPorts[idx]);
            }
            result2.add(nextBinding);
            ++idx;
        }
        return result2;
    }

    static DockerEnvironment create(@NotNull RemoteDockerRuntime docker, @NotNull DockerAgentImage image, @NotNull DockerRemoteRequest request, @NotNull String options, @NotNull Collection<DockerVolumeBinding> volumeBindings, @NotNull List<DockerRemoteRequest.BoundPortValue> ports) throws IOException {
        if (docker == null) {
            DockerEnvironment.$$$reportNull$$$0(17);
        }
        if (image == null) {
            DockerEnvironment.$$$reportNull$$$0(18);
        }
        if (request == null) {
            DockerEnvironment.$$$reportNull$$$0(19);
        }
        if (options == null) {
            DockerEnvironment.$$$reportNull$$$0(20);
        }
        if (volumeBindings == null) {
            DockerEnvironment.$$$reportNull$$$0(21);
        }
        if (ports == null) {
            DockerEnvironment.$$$reportNull$$$0(22);
        }
        DockerEnvironment dockerEnvironment = new DockerEnvironment(image, request, options, volumeBindings, ports);
        for (TargetEnvironment.UploadRoot uploadRoot : request.getUploadVolumes()) {
            Object targetRootPath;
            if (uploadRoot.getTargetRootPath() instanceof TargetEnvironment.TargetPath.Persistent) {
                targetRootPath = ((TargetEnvironment.TargetPath.Persistent)uploadRoot.getTargetRootPath()).getAbsolutePath();
            } else {
                TargetEnvironment.TargetPath.Temporary targetPath = (TargetEnvironment.TargetPath.Temporary)uploadRoot.getTargetRootPath();
                String parentPath = StringUtil.isEmptyOrSpaces((String)targetPath.getParentDirectory()) ? "/tmp" : targetPath.getParentDirectory();
                targetRootPath = parentPath + "/" + UUID.randomUUID();
            }
            volumeBindings.add(DockerRemoteRequest.safeVolumeBinding((String)targetRootPath, uploadRoot.getLocalRootPath().toAbsolutePath().toString()));
            dockerEnvironment.myUploadVolumes.put(uploadRoot, new DockerMountedVolume(uploadRoot.getLocalRootPath(), (String)targetRootPath));
        }
        for (TargetEnvironment.DownloadRoot downloadRoot : request.getDownloadVolumes()) {
            DockerVolumeBinding dockerJavaBinding;
            Object targetRootPath;
            Path localRootPath = downloadRoot.getLocalRootPath() != null ? downloadRoot.getLocalRootPath().toAbsolutePath() : FileUtil.createTempDirectory((String)"intellij-target.", (String)"", (boolean)true).toPath();
            if (downloadRoot.getTargetRootPath() instanceof TargetEnvironment.TargetPath.Persistent) {
                targetRootPath = ((TargetEnvironment.TargetPath.Persistent)downloadRoot.getTargetRootPath()).getAbsolutePath();
            } else {
                assert (downloadRoot.getTargetRootPath() instanceof TargetEnvironment.TargetPath.Temporary);
                targetRootPath = "/tmp/" + UUID.randomUUID();
            }
            if (downloadRoot.getPersistentId() != null) {
                String volumeName = downloadRoot.getPersistentId().replace('/', '_');
                dockerJavaBinding = new DockerVolumeBindingImpl((String)targetRootPath, volumeName, false);
            } else {
                dockerJavaBinding = DockerRemoteRequest.safeVolumeBinding((String)targetRootPath, localRootPath.toString());
            }
            volumeBindings.add(dockerJavaBinding);
            dockerEnvironment.myDownloadVolumes.put(downloadRoot, new DockerDownloadVolume(dockerEnvironment, localRootPath, (String)targetRootPath));
        }
        for (final TargetEnvironment.TargetPortBinding targetPortBinding : request.getTargetPortBindings()) {
            final int localPort = targetPortBinding.getLocal() == null ? NetUtils.findAvailableSocketPort() : targetPortBinding.getLocal();
            ports.add(new DockerRemoteRequest.BoundPortValue(targetPortBinding.getTarget()){

                @Override
                int getContainerPort() {
                    return targetPortBinding.getTarget();
                }

                @Override
                DockerPortBindingImpl asDockerPortBinding() {
                    DockerPortBindingImpl result2 = super.asDockerPortBinding();
                    result2.setHostPort(localPort);
                    return result2;
                }

                public Promise<Integer> getLocalValue() {
                    return Promises.resolvedPromise((Object)localPort);
                }
            });
            dockerEnvironment.myTargetPortBindings.put(targetPortBinding, localPort);
        }
        if (!request.getLocalPortBindings().isEmpty()) {
            DockerCloudConfiguration dockerCloudConfiguration = docker.getAccount();
            String hostAddress = DockerNetworkUtil.getHostAddress(dockerCloudConfiguration);
            for (TargetEnvironment.LocalPortBinding localPortBinding : request.getLocalPortBindings()) {
                if (localPortBinding.getTarget() != null && localPortBinding.getTarget().intValue() != localPortBinding.getLocal()) {
                    throw new UnsupportedOperationException("TCP proxy is not implemented.");
                }
                int localPort = localPortBinding.getLocal();
                HostPort localHostPort = new HostPort(DockerNetworkUtil.getDockerNetworkInterface(dockerCloudConfiguration), localPort);
                HostPort targetHostPort = new HostPort(hostAddress, localPort);
                dockerEnvironment.myLocalPortBindings.put(localPortBinding, new ResolvedPortBinding(localHostPort, targetHostPort));
            }
        }
        return dockerEnvironment;
    }

    private /* synthetic */ RemoteProcess lambda$createProcess$4(Map actualPortMappings, DockerAgentDeploymentConfig deployConfig2) throws Exception {
        return this.doCreateDockerProcess(actualPortMappings, deployConfig2);
    }

    private static /* synthetic */ HashMap lambda$createProcess$3() {
        return new HashMap();
    }

    private static /* synthetic */ DockerPortBinding lambda$createProcess$2(DockerPortBinding oldValue, DockerPortBinding newValue) {
        return newValue;
    }

    private static /* synthetic */ DockerPortBinding lambda$createProcess$1(DockerPortBinding binding) {
        return binding;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 1: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 3: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "volumeBindings";
                break;
            }
            case 4: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ports";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/run/target/DockerEnvironment";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualPortMappings";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deployConfig";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/run/target/DockerEnvironment";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUploadVolumes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDownloadVolumes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetPortBindings";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalPortBindings";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetPlatform";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateDockerProcess";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "runAsync";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 16: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createProcess";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doCreateDockerProcess";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "runAsync";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

