/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote;

import com.google.common.net.HostAndPort;
import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.DockerCredentialsCase;
import com.intellij.docker.remote.DockerCredentialsHolder;
import com.intellij.docker.remote.run.common.PortsBuilder;
import com.intellij.docker.remote.run.common.VolumesBuilder;
import com.intellij.docker.remote.run.runtime.DockerUtil;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.util.PathMappingSettings;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DockerProcessUtil {
    private static final Logger LOG = Logger.getInstance(DockerProcessUtil.class);

    @NotNull
    public static File buildDockerImageArchive(@NotNull File dockerfile, File ... srcHelpersDirs) throws IOException {
        if (dockerfile == null) {
            DockerProcessUtil.$$$reportNull$$$0(0);
        }
        if (srcHelpersDirs == null) {
            DockerProcessUtil.$$$reportNull$$$0(1);
        }
        File tarFile = FileUtil.createTempFile((String)"helpers-docker-image", (String)".tar");
        DockerProcessUtil.debug("Temp file ''{0}'' for building Docker image with helpers created", tarFile.getPath());
        try (TarArchiveOutputStream tarStream = new TarArchiveOutputStream((OutputStream)new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(tarFile))));){
            tarStream.setLongFileMode(2);
            for (File srcHelpersDir : srcHelpersDirs) {
                DockerProcessUtil.debug("Traversing ''{0}'' source helpers directory", srcHelpersDir.getPath());
                for (File file2 : FileUtils.listFiles((File)srcHelpersDir, (IOFileFilter)FileFilterUtils.fileFileFilter(), (IOFileFilter)FileFilterUtils.directoryFileFilter())) {
                    String tarEntryName = FileUtil.getRelativePath((File)srcHelpersDir, (File)file2);
                    if (tarEntryName == null) {
                        DockerProcessUtil.warn("Failed to determine relative path for file ''{0}'' with base directory ''{1}''", srcHelpersDir.getAbsolutePath(), file2.getAbsolutePath());
                        continue;
                    }
                    DockerProcessUtil.addArchiveEntry(tarStream, file2, tarEntryName);
                }
            }
            DockerProcessUtil.addArchiveEntry(tarStream, dockerfile, "Dockerfile");
        }
        File file3 = tarFile;
        if (file3 == null) {
            DockerProcessUtil.$$$reportNull$$$0(2);
        }
        return file3;
    }

    private static void addArchiveEntry(@NotNull TarArchiveOutputStream tarStream, @NotNull File file2, @NotNull String tarEntryName) throws IOException {
        block14: {
            if (tarStream == null) {
                DockerProcessUtil.$$$reportNull$$$0(3);
            }
            if (file2 == null) {
                DockerProcessUtil.$$$reportNull$$$0(4);
            }
            if (tarEntryName == null) {
                DockerProcessUtil.$$$reportNull$$$0(5);
            }
            DockerProcessUtil.debug("Adding ''{0}'' {1} to the archive as ''{2}''", file2.getPath(), file2.isDirectory() ? "directory" : "file", tarEntryName);
            TarArchiveEntry tarEntry = new TarArchiveEntry(file2);
            tarEntry.setName(tarEntryName);
            try (Closeable ignored = DockerProcessUtil.putArchiveEntry(tarStream, (ArchiveEntry)tarEntry);){
                if (tarEntry.isDirectory()) break block14;
                try (FileInputStream is = new FileInputStream(file2);){
                    IOUtils.copyLarge((InputStream)is, (OutputStream)tarStream);
                }
            }
        }
    }

    private static void debug(@NotNull String pattern, Object ... arguments) {
        if (pattern == null) {
            DockerProcessUtil.$$$reportNull$$$0(6);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(MessageFormat.format(pattern, arguments));
        }
    }

    private static void warn(@NotNull String pattern, Object ... arguments) {
        if (pattern == null) {
            DockerProcessUtil.$$$reportNull$$$0(7);
        }
        LOG.warn(MessageFormat.format(pattern, arguments));
    }

    public static String @NotNull [] getShContainerCommand() {
        String[] stringArray = new String[]{"/bin/sh"};
        if (stringArray == null) {
            DockerProcessUtil.$$$reportNull$$$0(8);
        }
        return stringArray;
    }

    @NotNull
    public static VolumesBuilder setupVolumesBinds(@Nullable PathMappingSettings mappings) {
        return DockerProcessUtil.setupVolumesBinds(mappings, null);
    }

    @NotNull
    public static VolumesBuilder setupVolumesBinds(@Nullable PathMappingSettings mappings, @Nullable DockerContainerSettings containerSettings) {
        VolumesBuilder bindingBuilder = VolumesBuilder.builder();
        if (mappings != null) {
            for (PathMappingSettings.PathMapping mapping : mappings.getPathMappings()) {
                bindingBuilder.addBoundVolume(mapping.getRemoteRoot(), DockerUtil.toUnixPath(mapping.getLocalRoot()));
            }
        }
        if (containerSettings != null) {
            bindingBuilder.addBoundVolumes(containerSettings.getVolumeBindings());
        }
        VolumesBuilder volumesBuilder = bindingBuilder;
        if (volumesBuilder == null) {
            DockerProcessUtil.$$$reportNull$$$0(9);
        }
        return volumesBuilder;
    }

    @NotNull
    public static String getBuildVersion() {
        String string = ApplicationInfo.getInstance().getBuild().asString();
        if (string == null) {
            DockerProcessUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public static DockerCredentialsHolder getDockerCredentialsHolder(@NotNull RemoteSdkAdditionalData commonCredentials) {
        if (commonCredentials == null) {
            DockerProcessUtil.$$$reportNull$$$0(11);
        }
        final Ref result2 = Ref.create();
        commonCredentials.switchOnConnectionType(new CredentialsCase[]{new DockerCredentialsCase(){

            public void process(DockerCredentialsHolder credentials) {
                result2.set((Object)credentials);
            }
        }});
        if (result2.isNull()) {
            throw new IllegalArgumentException();
        }
        DockerCredentialsHolder dockerCredentialsHolder = (DockerCredentialsHolder)result2.get();
        if (dockerCredentialsHolder == null) {
            DockerProcessUtil.$$$reportNull$$$0(12);
        }
        return dockerCredentialsHolder;
    }

    @NotNull
    public static PortsBuilder getWebServerBindPorts(@Nullable HostAndPort data) {
        PortsBuilder portsBuilder = PortsBuilder.builder();
        if (data != null && data.hasPort()) {
            portsBuilder.addPortBinding(data.getPort(), data.getPort());
        }
        PortsBuilder portsBuilder2 = portsBuilder;
        if (portsBuilder2 == null) {
            DockerProcessUtil.$$$reportNull$$$0(13);
        }
        return portsBuilder2;
    }

    @NotNull
    private static Closeable putArchiveEntry(final @NotNull TarArchiveOutputStream stream, @NotNull ArchiveEntry archiveEntry) throws IOException {
        if (stream == null) {
            DockerProcessUtil.$$$reportNull$$$0(14);
        }
        if (archiveEntry == null) {
            DockerProcessUtil.$$$reportNull$$$0(15);
        }
        stream.putArchiveEntry(archiveEntry);
        return new Closeable(){

            @Override
            public void close() throws IOException {
                stream.closeArchiveEntry();
            }
        };
    }

    public static boolean isInvalidLinuxEnvName(@Nullable String string) {
        return StringUtil.isEmptyOrSpaces((String)string) || string.contains("=");
    }

    public static void removeIncorrectVariables(Map<String, String> envs) {
        envs.entrySet().removeIf(e -> DockerProcessUtil.isInvalidLinuxEnvName((String)e.getKey()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerfile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcHelpersDirs";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/DockerProcessUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tarStream";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tarEntryName";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonCredentials";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archiveEntry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/DockerProcessUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDockerImageArchive";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getShContainerCommand";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "setupVolumesBinds";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildVersion";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDockerCredentialsHolder";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getWebServerBindPorts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildDockerImageArchive";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addArchiveEntry";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "debug";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "warn";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDockerCredentialsHolder";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "putArchiveEntry";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

