/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote;

import com.intellij.docker.compose.cli.DockerComposeCliUtil;
import com.intellij.docker.compose.cli.DockerComposeUpCliBuilder;
import com.intellij.docker.compose.configuration.util.DockerComposeConfigurationUtil;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.remote.DockerComposeContainerUtil;
import com.intellij.docker.remote.DockerComposeCredentialsHolder;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import java.io.FileNotFoundException;
import org.jetbrains.annotations.NotNull;

public final class DockerComposeServiceStarter {
    private static final Logger LOG = Logger.getInstance(DockerComposeServiceStarter.class);

    public static void startServices(@NotNull Project project, @NotNull RemoteDockerRuntime dockerRuntime2, @NotNull DockerComposeCredentialsHolder docker) throws ExecutionException, FileNotFoundException {
        if (project == null) {
            DockerComposeServiceStarter.$$$reportNull$$$0(0);
        }
        if (dockerRuntime2 == null) {
            DockerComposeServiceStarter.$$$reportNull$$$0(1);
        }
        if (docker == null) {
            DockerComposeServiceStarter.$$$reportNull$$$0(2);
        }
        DockerComposeUpCliBuilder cmd = ((DockerComposeUpCliBuilder)((DockerComposeUpCliBuilder)DockerComposeCliUtil.buildUpCommand(dockerRuntime2).withEnvironment(DockerComposeContainerUtil.getEnvs(docker))).withFiles(DockerComposeConfigurationUtil.findConfigurationFiles(docker.getComposeFilePaths()))).withDetached(true).withServices(docker.getComposeServiceName());
        Ref exception = new Ref(null);
        Ref outputRef = new Ref(null);
        String title = DockerBundle.message("DockerComposeServiceStarter.starting.docker.compose", new Object[0]);
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> DockerComposeServiceStarter.startDockerCompose(cmd, (Ref<ExecutionException>)exception, (Ref<ProcessOutput>)outputRef, ProgressManager.getInstance().getProgressIndicator()), title, true, project, null);
        } else {
            DockerComposeServiceStarter.startDockerCompose(cmd, (Ref<ExecutionException>)exception, (Ref<ProcessOutput>)outputRef, ProgressManager.getInstance().getProgressIndicator());
        }
        if (!exception.isNull()) {
            throw (ExecutionException)exception.get();
        }
    }

    private static void startDockerCompose(DockerComposeUpCliBuilder cmd, Ref<ExecutionException> exception, Ref<ProcessOutput> outputRef, ProgressIndicator indicator) {
        try {
            KillableColoredProcessHandler processHandler = cmd.run();
            CapturingProcessRunner runner = new CapturingProcessRunner((BaseProcessHandler)processHandler);
            if (indicator != null) {
                String commandLine = processHandler.getCommandLine();
                indicator.setText(commandLine);
                LOG.info("Starting docker-compose: " + commandLine);
                outputRef.set((Object)runner.runProcess(indicator));
            } else {
                outputRef.set((Object)runner.runProcess());
            }
        }
        catch (ExecutionException e) {
            outputRef.set(null);
            exception.set((Object)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "dockerRuntime";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "docker";
                break;
            }
        }
        objectArray[1] = "com/intellij/docker/remote/DockerComposeServiceStarter";
        objectArray[2] = "startServices";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

