/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote;

import com.intellij.docker.agent.DockerAgentContainer;
import com.intellij.docker.compose.configuration.util.DockerComposeConfigurationUtil;
import com.intellij.docker.remote.DockerComposeCredentialsHolder;
import com.intellij.docker.remote.DockerComposeServiceStarter;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DockerComposeContainerUtil {
    private static final Logger LOG = Logger.getInstance(DockerComposeContainerUtil.class);
    private static final String SERVICE_LABEL = "com.docker.compose.service";
    private static final String PROJECT_LABEL = "com.docker.compose.project";
    private static final String ONEOFF_LABEL = "com.docker.compose.oneoff";
    private static final String NUMBER_LABEL = "com.docker.compose.container-number";
    private static final String COMPOSE_PROJECT_NAME = "COMPOSE_PROJECT_NAME";
    private static final Pattern OLD_STYLE_SANITIZATION = Pattern.compile("[^a-z0-9]");
    private static final Pattern NEW_STYLE_SANITIZATION = Pattern.compile("[^-_a-z0-9]");

    @Nullable
    public static DockerAgentContainer findContainerByServiceName(@NotNull Project project, @NotNull RemoteDockerRuntime dockerRuntime2, @NotNull DockerComposeCredentialsHolder docker, boolean startIfNotRunning) throws FileNotFoundException, ExecutionException {
        if (project == null) {
            DockerComposeContainerUtil.$$$reportNull$$$0(0);
        }
        if (dockerRuntime2 == null) {
            DockerComposeContainerUtil.$$$reportNull$$$0(1);
        }
        if (docker == null) {
            DockerComposeContainerUtil.$$$reportNull$$$0(2);
        }
        DockerAgentContainer container = DockerComposeContainerUtil.findContainerByServiceName(dockerRuntime2, docker);
        if (startIfNotRunning && container == null) {
            DockerComposeServiceStarter.startServices(project, dockerRuntime2, docker);
            container = DockerComposeContainerUtil.findContainerByServiceName(dockerRuntime2, docker);
        }
        return container;
    }

    @Nullable
    public static DockerAgentContainer findContainerByServiceName(@NotNull RemoteDockerRuntime dockerRuntime2, @NotNull DockerComposeCredentialsHolder docker) {
        if (dockerRuntime2 == null) {
            DockerComposeContainerUtil.$$$reportNull$$$0(3);
        }
        if (docker == null) {
            DockerComposeContainerUtil.$$$reportNull$$$0(4);
        }
        Pair<String, String> projectName = DockerComposeContainerUtil.toProjectName(docker);
        DockerAgentContainer selected = null;
        ProjectNameType priority = ProjectNameType.NOT_MATCHING;
        int index = Integer.MAX_VALUE;
        for (DockerAgentContainer c : dockerRuntime2.getAgent().getContainers()) {
            ProjectNameType newPriority;
            Map<String, String> labels = c.getContainerLabels();
            if (!DockerComposeContainerUtil.isRunning(c) || !DockerComposeContainerUtil.isFromService(labels, docker.getComposeServiceName()) || (newPriority = DockerComposeContainerUtil.getProjectNamePriority(labels, projectName)) == ProjectNameType.NOT_MATCHING) continue;
            int newIndex = DockerComposeContainerUtil.getContainerIndex(labels, Integer.MAX_VALUE);
            if (!newPriority.isBetterThan(priority) && (newPriority != priority || newIndex >= index)) continue;
            selected = c;
            priority = newPriority;
            index = newIndex;
        }
        if (LOG.isTraceEnabled()) {
            if (selected == null) {
                LOG.trace("Failed to find container with " + (String)(projectName == null ? "empty" : "'" + (String)projectName.first + "' or '" + (String)projectName.second + "'") + " project name");
            } else {
                LOG.trace("Container with name '" + selected.getContainerName() + "' was successfully found");
            }
        }
        return selected;
    }

    private static boolean isRunning(@NotNull DockerAgentContainer container) {
        String status;
        if (container == null) {
            DockerComposeContainerUtil.$$$reportNull$$$0(5);
        }
        return (status = container.getContainer().getStatus()) == null || status.startsWith("Up");
    }

    @Nullable
    public static Pair<String, String> toProjectName(@NotNull DockerComposeCredentialsHolder docker) {
        if (docker == null) {
            DockerComposeContainerUtil.$$$reportNull$$$0(6);
        }
        try {
            String name;
            Map envs = docker.getEnvs().getEnvs();
            if (envs.containsKey(COMPOSE_PROJECT_NAME)) {
                return new Pair((Object)((String)envs.get(COMPOSE_PROJECT_NAME)), null);
            }
            List<Path> files = DockerComposeConfigurationUtil.findConfigurationFiles(docker.getComposeFilePaths());
            String string = name = !files.isEmpty() ? StringUtil.toLowerCase((String)DockerComposeConfigurationUtil.getDockerComposeProjectName(files.get(0))) : null;
            if (StringUtil.isEmpty(name)) {
                return null;
            }
            String oldStyle = OLD_STYLE_SANITIZATION.matcher(name).replaceAll("");
            String newStyle = NEW_STYLE_SANITIZATION.matcher(name).replaceAll("");
            return new Pair((Object)newStyle, (Object)oldStyle);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    private static boolean isFromService(@Nullable Map<String, String> labels, @NotNull String service2) {
        if (service2 == null) {
            DockerComposeContainerUtil.$$$reportNull$$$0(7);
        }
        return labels != null && !DockerComposeContainerUtil.isOneOffContainer(labels) && DockerComposeContainerUtil.equalsService(labels, service2);
    }

    public static int getContainerIndex(@Nullable Map<String, String> labels, int defaultValue) {
        try {
            if (labels != null && labels.containsKey(NUMBER_LABEL)) {
                return Integer.parseInt(labels.get(NUMBER_LABEL));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defaultValue;
    }

    private static boolean equalsService(@NotNull Map<String, String> labels, @NotNull String service2) {
        if (labels == null) {
            DockerComposeContainerUtil.$$$reportNull$$$0(8);
        }
        if (service2 == null) {
            DockerComposeContainerUtil.$$$reportNull$$$0(9);
        }
        return StringUtil.equals((CharSequence)labels.get(SERVICE_LABEL), (CharSequence)service2);
    }

    private static boolean isOneOffContainer(Map<String, String> labels) {
        return Boolean.parseBoolean(labels.get(ONEOFF_LABEL));
    }

    @NotNull
    private static ProjectNameType getProjectNamePriority(@NotNull Map<String, String> labels, @Nullable Pair<String, String> project) {
        if (labels == null) {
            DockerComposeContainerUtil.$$$reportNull$$$0(10);
        }
        String actualProjectName = labels.get(PROJECT_LABEL);
        if (project == null) {
            ProjectNameType projectNameType = actualProjectName == null ? ProjectNameType.OLD_PROJECT_NAME : ProjectNameType.NOT_MATCHING;
            if (projectNameType == null) {
                DockerComposeContainerUtil.$$$reportNull$$$0(11);
            }
            return projectNameType;
        }
        if (StringUtil.equals((CharSequence)actualProjectName, (CharSequence)((CharSequence)project.first))) {
            ProjectNameType projectNameType = ProjectNameType.NEW_PROJECT_NAME;
            if (projectNameType == null) {
                DockerComposeContainerUtil.$$$reportNull$$$0(12);
            }
            return projectNameType;
        }
        if (StringUtil.equals((CharSequence)actualProjectName, (CharSequence)((CharSequence)project.second))) {
            ProjectNameType projectNameType = ProjectNameType.OLD_PROJECT_NAME;
            if (projectNameType == null) {
                DockerComposeContainerUtil.$$$reportNull$$$0(13);
            }
            return projectNameType;
        }
        ProjectNameType projectNameType = ProjectNameType.NOT_MATCHING;
        if (projectNameType == null) {
            DockerComposeContainerUtil.$$$reportNull$$$0(14);
        }
        return projectNameType;
    }

    @NotNull
    public static TreeMap<String, String> getEnvs(@NotNull DockerComposeCredentialsHolder docker) {
        if (docker == null) {
            DockerComposeContainerUtil.$$$reportNull$$$0(15);
        }
        TreeMap<String, String> envs = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        if (docker.getEnvs().isPassParentEnvs()) {
            envs.putAll(EnvironmentUtil.getEnvironmentMap());
        }
        envs.putAll(docker.getEnvs().getEnvs());
        TreeMap<String, String> treeMap = envs;
        if (treeMap == null) {
            DockerComposeContainerUtil.$$$reportNull$$$0(16);
        }
        return treeMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerRuntime";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docker";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labels";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/DockerComposeContainerUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/DockerComposeContainerUtil";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectNamePriority";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findContainerByServiceName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isRunning";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "toProjectName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isFromService";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "equalsService";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getProjectNamePriority";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getEnvs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static enum ProjectNameType {
        NOT_MATCHING,
        OLD_PROJECT_NAME,
        NEW_PROJECT_NAME;


        public boolean isBetterThan(@NotNull ProjectNameType type2) {
            if (type2 == null) {
                ProjectNameType.$$$reportNull$$$0(0);
            }
            if (type2 == NOT_MATCHING) {
                return this != NOT_MATCHING;
            }
            if (type2 == OLD_PROJECT_NAME) {
                return this == NEW_PROJECT_NAME;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/docker/remote/DockerComposeContainerUtil$ProjectNameType", "isBetterThan"));
        }
    }
}

