/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.registry;

import com.intellij.DynamicBundle;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.registry.DockerRegistry;
import com.intellij.docker.registry.DockerRegistryConfigurable;
import com.intellij.docker.registry.DockerRegistryManager;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.text.UniqueNameGenerator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegistrySelectionEditor {
    private JButton myNewButton;
    private ComboBox myAccountComboBox;
    private JPanel myMainPanel;
    private Runnable myServerSelectionListener;

    public RegistrySelectionEditor(List<? extends DockerRegistry> registries, DockerRegistry defaultRegistry) {
        AccountItem defaultItem = null;
        this.$$$setupUI$$$();
        for (DockerRegistry dockerRegistry : registries) {
            AccountItem item = new AccountItem(dockerRegistry);
            this.getAccountComboBox().addItem(item);
            if (dockerRegistry != defaultRegistry) continue;
            defaultItem = item;
        }
        this.myNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegistrySelectionEditor.this.createAccount();
            }
        });
        this.myAccountComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RegistrySelectionEditor.this.myServerSelectionListener != null) {
                    RegistrySelectionEditor.this.myServerSelectionListener.run();
                }
            }
        });
        if (defaultItem != null) {
            this.myAccountComboBox.setSelectedItem((Object)defaultItem);
        }
    }

    public void setAccountSelectionListener(Runnable listener) {
        this.myServerSelectionListener = listener;
    }

    @NotNull
    private JComboBox<AccountItem> getAccountComboBox() {
        ComboBox comboBox2 = this.myAccountComboBox;
        if (comboBox2 == null) {
            RegistrySelectionEditor.$$$reportNull$$$0(0);
        }
        return comboBox2;
    }

    private void createAccount() {
        DockerRegistry newAccount = new DockerRegistry().withName(RegistrySelectionEditor.generateServerName());
        DockerRegistryConfigurable configurable = new DockerRegistryConfigurable(newAccount, null, true);
        if (!new SingleConfigurableEditor((Component)this.myMainPanel, (Configurable)configurable, ShowSettingsUtilImpl.createDimensionKey((Configurable)configurable), false).showAndGet()) {
            return;
        }
        newAccount.setName(configurable.getDisplayName());
        DockerRegistryManager.getInstance().addRegistry(newAccount);
        AccountItem newAccountItem = new AccountItem(newAccount);
        this.getAccountComboBox().addItem(newAccountItem);
        this.getAccountComboBox().setSelectedItem(newAccountItem);
    }

    public JComponent getMainPanel() {
        return this.myMainPanel;
    }

    @Nullable
    public DockerRegistry getSelectedAccount() {
        AccountItem selectedItem = (AccountItem)this.myAccountComboBox.getSelectedItem();
        return selectedItem == null ? null : selectedItem.getAccount();
    }

    @Nls
    private static String generateServerName() {
        @Nls String defaultName = DockerBundle.message("RegistrySelectionEditor.default.name.docker.registry", new Object[0]);
        return UniqueNameGenerator.generateUniqueName((String)defaultName, s -> {
            for (DockerRegistry server : DockerRegistryManager.getInstance().getRegistries()) {
                if (!server.getName().equals(s)) continue;
                return false;
            }
            return true;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/registry/RegistrySelectionEditor", "getAccountComboBox"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboBox comboBox2;
        JButton jButton;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 5, 6, null, null, null));
        this.myNewButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle((String)"messages/DockerBundle", RegistrySelectionEditor.class).getString("RegistrySelectionEditor.new.text"));
        jPanel.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 0, null, null, null));
        this.myAccountComboBox = comboBox2 = new ComboBox();
        jPanel.add((Component)comboBox2, new GridConstraints(0, 0, 1, 1, 0, 1, 2, 0, null, new Dimension(200, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class AccountItem {
        private final DockerRegistry myAccount;

        AccountItem(DockerRegistry account) {
            this.myAccount = account;
        }

        public DockerRegistry getAccount() {
            return this.myAccount;
        }

        public String toString() {
            return this.myAccount.getName();
        }
    }
}

