/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.registry;

import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.registry.DockerRegistry;
import com.intellij.docker.registry.DockerRegistryConfigurable;
import com.intellij.docker.registry.DockerRegistryManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.IconUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class DockerRegistryListConfigurable
extends MasterDetailsComponent
implements SearchableConfigurable {
    @NonNls
    public static final String ID = "DockerRegistry";

    public DockerRegistryListConfigurable() {
        this.initTree();
    }

    @NotNull
    protected String getEmptySelectionString() {
        String string = DockerBundle.message("configurable.DockerRegistryListConfigurable.empty.selection.string", new Object[0]);
        if (string == null) {
            DockerRegistryListConfigurable.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    public String getDisplayName() {
        return DockerBundle.message("configurable.DockerRegistryListConfigurable.display.name", new Object[0]);
    }

    public void reset() {
        this.myRoot.removeAllChildren();
        for (DockerRegistry registry : DockerRegistryManager.getInstance().getRegistries()) {
            this.addRegistryNode(registry, false);
        }
        super.reset();
    }

    private MasterDetailsComponent.MyNode addRegistryNode(DockerRegistry registry, boolean isNew) {
        MasterDetailsComponent.MyNode node = new MasterDetailsComponent.MyNode((NamedConfigurable)new DockerRegistryConfigurable(registry, this.TREE_UPDATER, isNew));
        this.addNode(node, this.myRoot);
        return node;
    }

    @NotNull
    public String getId() {
        return ID;
    }

    @NotNull
    public Runnable enableSearch(String option) {
        Runnable runnable = () -> Objects.requireNonNull(SpeedSearchSupply.getSupply((JComponent)this.myTree, (boolean)true)).findAndSelectElement(option);
        if (runnable == null) {
            DockerRegistryListConfigurable.$$$reportNull$$$0(1);
        }
        return runnable;
    }

    protected void initTree() {
        super.initTree();
        new TreeSpeedSearch(this.myTree, treePath -> ((MasterDetailsComponent.MyNode)treePath.getLastPathComponent()).getDisplayName(), true);
    }

    protected void processRemovedItems() {
        HashSet<DockerRegistry> registries = new HashSet<DockerRegistry>();
        for (NamedConfigurable<DockerRegistry> configurable : this.getConfiguredRegistries()) {
            registries.add((DockerRegistry)((Object)configurable.getEditableObject()));
        }
        ArrayList<DockerRegistry> toDelete = new ArrayList<DockerRegistry>();
        DockerRegistryManager registryManager = DockerRegistryManager.getInstance();
        for (DockerRegistry registry : registryManager.getRegistries()) {
            if (registries.contains((Object)registry)) continue;
            toDelete.add(registry);
        }
        for (DockerRegistry registry : toDelete) {
            registryManager.removeRegistry(registry);
        }
    }

    public void apply() throws ConfigurationException {
        super.apply();
        DockerRegistryManager registryManager = DockerRegistryManager.getInstance();
        HashSet<DockerRegistry> registries = new HashSet<DockerRegistry>(registryManager.getRegistries());
        for (NamedConfigurable<DockerRegistry> configurable : this.getConfiguredRegistries()) {
            DockerRegistry registry = (DockerRegistry)((Object)configurable.getEditableObject());
            registry.setName(configurable.getDisplayName());
            if (registries.contains((Object)registry)) continue;
            registryManager.addRegistry(registry);
        }
    }

    public String getHelpTopic() {
        return "docker.registry";
    }

    @NotNull
    protected ArrayList<AnAction> createActions(boolean fromPopup) {
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        actions.add((AnAction)new AddRegistryAction());
        actions.add((AnAction)new MasterDetailsComponent.MyDeleteAction((MasterDetailsComponent)this));
        ArrayList<AnAction> arrayList = actions;
        if (arrayList == null) {
            DockerRegistryListConfigurable.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    protected boolean wasObjectStored(Object editableObject) {
        return true;
    }

    private List<NamedConfigurable<DockerRegistry>> getConfiguredRegistries() {
        ArrayList<NamedConfigurable<DockerRegistry>> configurables = new ArrayList<NamedConfigurable<DockerRegistry>>();
        for (int i2 = 0; i2 < this.myRoot.getChildCount(); ++i2) {
            MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i2);
            configurables.add((NamedConfigurable<DockerRegistry>)node.getConfigurable());
        }
        return configurables;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/docker/registry/DockerRegistryListConfigurable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptySelectionString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "enableSearch";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private final class AddRegistryAction
    extends DumbAwareAction {
        private AddRegistryAction() {
            super(DockerBundle.messagePointer("configurable.DockerRegistryListConfigurable.AddRegistryAction.text", new Object[0]), Presentation.NULL_STRING, IconUtil.getAddIcon());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddRegistryAction.$$$reportNull$$$0(0);
            }
            String name = UniqueNameGenerator.generateUniqueName((String)"Docker Registry", s -> {
                for (NamedConfigurable<DockerRegistry> configurable : DockerRegistryListConfigurable.this.getConfiguredRegistries()) {
                    if (!configurable.getDisplayName().equals(s)) continue;
                    return false;
                }
                return true;
            });
            MasterDetailsComponent.MyNode node = DockerRegistryListConfigurable.this.addRegistryNode(new DockerRegistry().withName(name), true);
            DockerRegistryListConfigurable.this.selectNodeInTree((DefaultMutableTreeNode)node);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/docker/registry/DockerRegistryListConfigurable$AddRegistryAction", "actionPerformed"));
        }
    }
}

