/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.machine;

import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.machine.DockerMachine;
import com.intellij.docker.machine.DockerMachineConfigurableKt;
import com.intellij.docker.machine.DockerMachineException;
import com.intellij.docker.machine.JBTextFieldWithHint;
import com.intellij.docker.utils.Failure;
import com.intellij.docker.utils.Result;
import com.intellij.docker.utils.Success;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.layout.CellBuilder;
import com.intellij.util.ConcurrencyUtil;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\u001a\"\u0010\u0000\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u001c\u0010\u0006\u001a\u00020\u0007*\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\"\u0010\n\u001a\u00020\u0007*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000fH\u0002\u001a2\u0010\u0010\u001a\u0012\u0012\u0002\b\u0003 \u0012*\b\u0012\u0002\b\u0003\u0018\u00010\u00110\u0011*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000fH\u0002\u001a,\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\b*\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0001\u0010\u0017\u001a\u00020\u00022\b\b\u0002\u0010\u0018\u001a\u00020\u0002H\u0002\u00a8\u0006\u0019"}, d2={"getExecVersion", "Lcom/intellij/docker/utils/Result;", "", "execPath", "isDockerMachine", "", "installExecValidator", "", "Lcom/intellij/ui/layout/CellBuilder;", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "invokeLater", "Lcom/intellij/openapi/application/Application;", "modalityState", "Lcom/intellij/openapi/application/ModalityState;", "func", "Lkotlin/Function0;", "schedule", "Ljava/util/concurrent/ScheduledFuture;", "kotlin.jvm.PlatformType", "Ljava/util/concurrent/ScheduledExecutorService;", "delay", "", "withFileDescriptor", "title", "filePrefix", "intellij.clouds.docker"})
public final class DockerMachineConfigurableKt {
    private static final Result<String> getExecVersion(String execPath, boolean isDockerMachine) {
        Function1 getVersionFunc2 = getExecVersion.getVersionFunc.1.INSTANCE;
        if (isDockerMachine) {
            Result result2;
            try {
                String string = DockerMachine.getDockerMachine(execPath).version();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DockerMachine.getDockerMachine(execPath).version()");
                result2 = new Success<Object>(getVersionFunc2.invoke((Object)string));
            }
            catch (DockerMachineException e) {
                String string = e.getMessage();
                if (string == null) {
                    String string2 = DockerBundle.message("DockerMachineConfigurable.message.can't.find.executable", new Object[0]);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DockerBundle.message(\"Do\u2026e.can't.find.executable\")");
                }
                result2 = new Failure(string);
            }
            return result2;
        }
        try {
            ProcessOutput output;
            GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{execPath, "-v"});
            CapturingProcessHandler handler2 = new CapturingProcessHandler(commandLine);
            ProcessOutput processOutput = output = handler2.runProcess(3000);
            Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"output");
            if (processOutput.isTimeout()) {
                String string = DockerBundle.message("DockerMachine.timeout.exceeded", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DockerBundle.message(\"Do\u2026achine.timeout.exceeded\")");
                return new Failure(string);
            }
            if (output.getExitCode() != 0) {
                String string = output.getStderr();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"output.stderr");
                return new Failure(string);
            }
            String string = output.getStdout();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"output.stdout");
            return new Success<Object>(getVersionFunc2.invoke((Object)string));
        }
        catch (ExecutionException e) {
            String string = e.getMessage();
            if (string == null) {
                String string3 = DockerBundle.message("DockerMachineConfigurable.message.can't.find.executable", new Object[0]);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"DockerBundle.message(\"Do\u2026e.can't.find.executable\")");
            }
            Result result3 = new Failure(string);
            return result3;
        }
    }

    static /* synthetic */ Result getExecVersion$default(String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return DockerMachineConfigurableKt.getExecVersion(string, bl);
    }

    /*
     * WARNING - void declaration
     */
    private static final void installExecValidator(CellBuilder<? extends TextFieldWithBrowseButton> $this$installExecValidator, boolean isDockerMachine) {
        void scheduledFuture;
        AtomicReference<String> scheduledExecutable = new AtomicReference<String>("");
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = ConcurrencyUtil.newSingleScheduledThreadExecutor((String)"Docker Executable Version");
        Intrinsics.checkNotNullExpressionValue((Object)scheduledThreadPoolExecutor, (String)"ConcurrencyUtil.newSingl\u2026cker Executable Version\")");
        ScheduledExecutorService executorService = scheduledThreadPoolExecutor;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        JTextField jTextField = ((TextFieldWithBrowseButton)$this$installExecValidator.getComponent()).getTextField();
        if (jTextField == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.docker.machine.JBTextFieldWithHint");
        }
        JBTextFieldWithHint textField = (JBTextFieldWithHint)((Object)jTextField);
        textField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter($this$installExecValidator, textField, scheduledExecutable, (Ref.ObjectRef)scheduledFuture, executorService, isDockerMachine){
            final /* synthetic */ CellBuilder $this_installExecValidator;
            final /* synthetic */ JBTextFieldWithHint $textField;
            final /* synthetic */ AtomicReference $scheduledExecutable;
            final /* synthetic */ Ref.ObjectRef $scheduledFuture;
            final /* synthetic */ ScheduledExecutorService $executorService;
            final /* synthetic */ boolean $isDockerMachine;

            protected void textChanged(@NotNull DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                if (application.isHeadlessEnvironment()) {
                    return;
                }
                ModalityState modalityState = ModalityState.current();
                Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.current()");
                ModalityState modalityState2 = modalityState;
                String string = this.$textField.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"textField.text");
                String currentDockerExecutable = string;
                this.$scheduledExecutable.set(currentDockerExecutable);
                ScheduledFuture scheduledFuture = (ScheduledFuture)this.$scheduledFuture.element;
                if (scheduledFuture != null) {
                    scheduledFuture.cancel(false);
                }
                this.$scheduledFuture.element = DockerMachineConfigurableKt.access$schedule(this.$executorService, 1500L, (Function0)new Function0<Unit>(this, modalityState2, currentDockerExecutable){
                    final /* synthetic */ installExecValidator.1 this$0;
                    final /* synthetic */ ModalityState $modalityState;
                    final /* synthetic */ String $currentDockerExecutable;

                    public final void invoke() {
                        block3: {
                            Result result2;
                            block2: {
                                V v = this.this$0.$scheduledExecutable.get();
                                Intrinsics.checkNotNullExpressionValue(v, (String)"scheduledExecutable.get()");
                                String dockerExecutable = (String)v;
                                if (Intrinsics.areEqual((Object)((String)this.this$0.$scheduledExecutable.get()), (Object)dockerExecutable) ^ true) {
                                    return;
                                }
                                ComponentValidator componentValidator2 = (ComponentValidator)ComponentValidator.getInstance((JComponent)this.this$0.$this_installExecValidator.getComponent()).orElseGet(installExecValidator.textChanged.1.INSTANCE);
                                if ((componentValidator2 != null ? componentValidator2.getValidationInfo() : null) != null) {
                                    this.this$0.$textField.setHint(null);
                                    return;
                                }
                                result2 = DockerMachineConfigurableKt.access$getExecVersion(dockerExecutable, this.this$0.$isDockerMachine);
                                if (!(result2 instanceof Success)) break block2;
                                Application application = ApplicationManager.getApplication();
                                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                                DockerMachineConfigurableKt.access$invokeLater(application, this.$modalityState, (Function0)new Function0<Unit>(this, result2){
                                    final /* synthetic */ installExecValidator.textChanged.1 this$0;
                                    final /* synthetic */ Result $result;

                                    public final void invoke() {
                                        if (Intrinsics.areEqual((Object)this.this$0.$currentDockerExecutable, (Object)this.this$0.this$0.$textField.getText())) {
                                            this.this$0.this$0.$textField.setHint((String)((Success)this.$result).getValue());
                                            ComponentValidator.getInstance((JComponent)this.this$0.this$0.$this_installExecValidator.getComponent()).ifPresent(installExecValidator.textChanged.1.INSTANCE);
                                        }
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        this.$result = result2;
                                        super(0);
                                    }
                                });
                                break block3;
                            }
                            if (!(result2 instanceof Failure)) break block3;
                            Application application = ApplicationManager.getApplication();
                            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                            DockerMachineConfigurableKt.access$invokeLater(application, this.$modalityState, (Function0)new Function0<Unit>(this, result2){
                                final /* synthetic */ installExecValidator.textChanged.1 this$0;
                                final /* synthetic */ Result $result;

                                public final void invoke() {
                                    if (Intrinsics.areEqual((Object)this.this$0.$currentDockerExecutable, (Object)this.this$0.this$0.$textField.getText())) {
                                        this.this$0.this$0.$textField.setHint(null);
                                        ComponentValidator.getInstance((JComponent)this.this$0.this$0.$this_installExecValidator.getComponent()).ifPresent(new Consumer(this){
                                            final /* synthetic */ installExecValidator.textChanged.3 this$0;

                                            public final void accept(@NotNull ComponentValidator it) {
                                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                                it.updateInfo(new ValidationInfo(((Failure)this.this$0.$result).getErrorMessage(), this.this$0.this$0.this$0.$this_installExecValidator.getComponent()));
                                            }
                                            {
                                                this.this$0 = var1_1;
                                            }
                                        });
                                    }
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$result = result2;
                                    super(0);
                                }
                            });
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$modalityState = modalityState;
                        this.$currentDockerExecutable = string;
                        super(0);
                    }
                });
            }
            {
                this.$this_installExecValidator = $receiver;
                this.$textField = $captured_local_variable$1;
                this.$scheduledExecutable = $captured_local_variable$2;
                this.$scheduledFuture = $captured_local_variable$3;
                this.$executorService = $captured_local_variable$4;
                this.$isDockerMachine = $captured_local_variable$5;
            }
        });
    }

    static /* synthetic */ void installExecValidator$default(CellBuilder cellBuilder, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        DockerMachineConfigurableKt.installExecValidator((CellBuilder<? extends TextFieldWithBrowseButton>)cellBuilder, bl);
    }

    private static final void invokeLater(Application $this$invokeLater, ModalityState modalityState, Function0<Unit> func) {
        Object object = func;
        if (object != null) {
            Function0<Unit> function0 = object;
            object = new Runnable(function0){
                private final /* synthetic */ Function0 function;
                {
                    this.function = function0;
                }

                public final /* synthetic */ void run() {
                    Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(), (String)"invoke(...)");
                }
            };
        }
        $this$invokeLater.invokeLater((Runnable)object, modalityState);
    }

    private static final ScheduledFuture<?> schedule(ScheduledExecutorService $this$schedule, long delay, Function0<Unit> func) {
        Object object = func;
        if (object != null) {
            Function0<Unit> function0 = object;
            object = new /* invalid duplicate definition of identical inner class */;
        }
        return $this$schedule.schedule((Runnable)object, delay, TimeUnit.MILLISECONDS);
    }

    private static final CellBuilder<TextFieldWithBrowseButton> withFileDescriptor(CellBuilder<? extends TextFieldWithBrowseButton> $this$withFileDescriptor, @Nls String title, String filePrefix) {
        FileChooserDescriptor fileDescriptor2 = Intrinsics.areEqual((Object)filePrefix, (Object)"") ? FileChooserDescriptorFactory.createSingleFileOrExecutableAppDescriptor() : new FileChooserDescriptor(true, false, false, false, false, false).withFileFilter(new Condition(filePrefix){
            final /* synthetic */ String $filePrefix;

            public final boolean value(VirtualFile it) {
                VirtualFile virtualFile = it;
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"it");
                return StringUtil.startsWith((CharSequence)virtualFile.getName(), (CharSequence)this.$filePrefix);
            }
            {
                this.$filePrefix = string;
            }
        });
        ((TextFieldWithBrowseButton)$this$withFileDescriptor.getComponent()).addBrowseFolderListener(title, null, null, fileDescriptor2);
        return $this$withFileDescriptor;
    }

    static /* synthetic */ CellBuilder withFileDescriptor$default(CellBuilder cellBuilder, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        return DockerMachineConfigurableKt.withFileDescriptor((CellBuilder<? extends TextFieldWithBrowseButton>)cellBuilder, string, string2);
    }

    public static final /* synthetic */ CellBuilder access$withFileDescriptor(CellBuilder $this$access_u24withFileDescriptor, String title, String filePrefix) {
        return DockerMachineConfigurableKt.withFileDescriptor((CellBuilder<? extends TextFieldWithBrowseButton>)$this$access_u24withFileDescriptor, title, filePrefix);
    }

    public static final /* synthetic */ void access$installExecValidator(CellBuilder $this$access_u24installExecValidator, boolean isDockerMachine) {
        DockerMachineConfigurableKt.installExecValidator((CellBuilder<? extends TextFieldWithBrowseButton>)$this$access_u24installExecValidator, isDockerMachine);
    }

    public static final /* synthetic */ ScheduledFuture access$schedule(ScheduledExecutorService $this$access_u24schedule, long delay, Function0 func) {
        return DockerMachineConfigurableKt.schedule($this$access_u24schedule, delay, (Function0<Unit>)func);
    }

    public static final /* synthetic */ Result access$getExecVersion(String execPath, boolean isDockerMachine) {
        return DockerMachineConfigurableKt.getExecVersion(execPath, isDockerMachine);
    }

    public static final /* synthetic */ void access$invokeLater(Application $this$access_u24invokeLater, ModalityState modalityState, Function0 func) {
        DockerMachineConfigurableKt.invokeLater($this$access_u24invokeLater, modalityState, (Function0<Unit>)func);
    }
}

