/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.java;

import com.intellij.docker.DockerCloudType;
import com.intellij.docker.deploymentSource.DockerFileDeploymentSourceType;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.java.DockerRemoteDebugExtensionEditor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.configuration.deployment.DeploymentSourceType;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfigurationExtension;
import java.util.Arrays;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DockerRemoteDebugRunConfigurationExtension
extends DeployToServerRunConfigurationExtension {
    private static final Boolean IS_IDEA_173089_FIXED = Boolean.FALSE;

    DockerRemoteDebugRunConfigurationExtension() {
    }

    @NotNull
    protected String getEditorTitle() {
        String string = DockerBundle.message("DockerRemoteDebugRunConfigurationExtension.editorTitle", new Object[0]);
        if (string == null) {
            DockerRemoteDebugRunConfigurationExtension.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isApplicableFor(@NotNull DeployToServerRunConfiguration configuration) {
        if (configuration == null) {
            DockerRemoteDebugRunConfigurationExtension.$$$reportNull$$$0(1);
        }
        return IS_IDEA_173089_FIXED != false && DockerCloudType.getInstance().isDebugSupported() && configuration.getServerType() == DockerCloudType.getInstance() && DockerRemoteDebugRunConfigurationExtension.isSupportedDeploymentSource(configuration) && DockerRemoteDebugRunConfigurationExtension.hasJavaModule(configuration.getProject());
    }

    private static boolean isSupportedDeploymentSource(@NotNull DeployToServerRunConfiguration configuration) {
        DeploymentSourceType type2;
        if (configuration == null) {
            DockerRemoteDebugRunConfigurationExtension.$$$reportNull$$$0(2);
        }
        return (type2 = (DeploymentSourceType)Optional.ofNullable(configuration.getDeploymentSource()).map(DeploymentSource::getType).orElse(null)) == DockerFileDeploymentSourceType.getInstance();
    }

    private static boolean hasJavaModule(@NotNull Project project) {
        if (project == null) {
            DockerRemoteDebugRunConfigurationExtension.$$$reportNull$$$0(3);
        }
        return Arrays.stream(ModuleManager.getInstance((Project)project).getModules()).anyMatch(m -> ModuleType.is((Module)m, (ModuleType)JavaModuleType.getModuleType()));
    }

    public boolean isEnabledFor(@NotNull DeployToServerRunConfiguration applicableConfiguration, @Nullable RunnerSettings runnerSettings) {
        if (applicableConfiguration == null) {
            DockerRemoteDebugRunConfigurationExtension.$$$reportNull$$$0(4);
        }
        return true;
    }

    @NotNull
    protected SettingsEditor<DeployToServerRunConfiguration> createEditor(@NotNull DeployToServerRunConfiguration configuration) {
        if (configuration == null) {
            DockerRemoteDebugRunConfigurationExtension.$$$reportNull$$$0(5);
        }
        return new DockerRemoteDebugExtensionEditor();
    }

    protected void patchCommandLine(@NotNull DeployToServerRunConfiguration configuration, @Nullable RunnerSettings runnerSettings, @NotNull GeneralCommandLine cmdLine, @NotNull String runnerId) {
        if (configuration == null) {
            DockerRemoteDebugRunConfigurationExtension.$$$reportNull$$$0(6);
        }
        if (cmdLine == null) {
            DockerRemoteDebugRunConfigurationExtension.$$$reportNull$$$0(7);
        }
        if (runnerId == null) {
            DockerRemoteDebugRunConfigurationExtension.$$$reportNull$$$0(8);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/java/DockerRemoteDebugRunConfigurationExtension";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicableConfiguration";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdLine";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorTitle";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/java/DockerRemoteDebugRunConfigurationExtension";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableFor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedDeploymentSource";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasJavaModule";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledFor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "patchCommandLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

