/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.dockerFile.utils;

import com.intellij.docker.dockerFile.DockerFileType;
import com.intellij.docker.dockerFile.DockerPsiFile;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0013\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006*\u00020\u0007H\u0000\u001a\u0015\u0010\b\u001a\t\u0018\u00010\t\u00a2\u0006\u0002\b\u0006*\u0004\u0018\u00010\u0007H\u0000\u001a\f\u0010\n\u001a\u00020\u0001*\u00020\u0007H\u0000\u001a\f\u0010\u000b\u001a\u00020\u0001*\u00020\u0007H\u0000\u00a8\u0006\f"}, d2={"isDockerFileName", "", "name", "", "findInjectionHost", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "Lorg/jetbrains/annotations/Nullable;", "Lcom/intellij/psi/PsiElement;", "findRoot", "Lcom/intellij/docker/dockerFile/DockerPsiFile;", "isInjectedToDockerFile", "isShellElement", "intellij.clouds.docker.file"})
public final class DockerFileUtilsKt {
    public static final boolean isDockerFileName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return Intrinsics.areEqual((Object)((Object)DockerFileType.DOCKER_FILE_TYPE), (Object)FileTypeManager.getInstance().getFileTypeByFileName(name));
    }

    @Nullable
    public static final DockerPsiFile findRoot(@Nullable PsiElement $this$findRoot) {
        return (DockerPsiFile)PsiTreeUtil.getParentOfType((PsiElement)$this$findRoot, DockerPsiFile.class);
    }

    public static final boolean isShellElement(@NotNull PsiElement $this$isShellElement) {
        Intrinsics.checkNotNullParameter((Object)$this$isShellElement, (String)"$this$isShellElement");
        Language language = $this$isShellElement.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"language");
        return Intrinsics.areEqual((Object)language.getID(), (Object)"Shell Script");
    }

    public static final boolean isInjectedToDockerFile(@NotNull PsiElement $this$isInjectedToDockerFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isInjectedToDockerFile, (String)"$this$isInjectedToDockerFile");
        return DockerFileUtilsKt.findRoot((PsiElement)DockerFileUtilsKt.findInjectionHost($this$isInjectedToDockerFile)) != null;
    }

    @Nullable
    public static final PsiLanguageInjectionHost findInjectionHost(@NotNull PsiElement $this$findInjectionHost) {
        Intrinsics.checkNotNullParameter((Object)$this$findInjectionHost, (String)"$this$findInjectionHost");
        return InjectedLanguageManager.getInstance((Project)$this$findInjectionHost.getProject()).getInjectionHost($this$findInjectionHost);
    }
}

