/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.dockerFile.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.docker.dockerFile.parser.psi.DockerFileVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class DockerFileInspectorBase
extends DockerFileVisitor {
    protected final ProblemsHolder myHolder;
    protected final boolean myOnTheFly;

    DockerFileInspectorBase(@NotNull ProblemsHolder problemsHolder, boolean isOnTheFly) {
        if (problemsHolder == null) {
            DockerFileInspectorBase.$$$reportNull$$$0(0);
        }
        this.myHolder = problemsHolder;
        this.myOnTheFly = isOnTheFly;
    }

    protected void registerProblem(@NotNull List<? extends PsiElement> badWord, @NotNull @Nls String text2, ProblemHighlightType type2, LocalQuickFix ... fixes) {
        if (badWord == null) {
            DockerFileInspectorBase.$$$reportNull$$$0(1);
        }
        if (text2 == null) {
            DockerFileInspectorBase.$$$reportNull$$$0(2);
        }
        if (fixes == null) {
            DockerFileInspectorBase.$$$reportNull$$$0(3);
        }
        if (badWord.isEmpty()) {
            return;
        }
        PsiElement first = badWord.get(0);
        PsiElement last = badWord.get(badWord.size() - 1);
        ProblemDescriptor error = this.myHolder.getManager().createProblemDescriptor(first, last, text2, type2, this.myOnTheFly, fixes);
        this.myHolder.registerProblem(error);
    }

    protected static List<List<PsiElement>> separateWordsBetween(PsiElement start, PsiElement end) {
        LinkedList<List<PsiElement>> result2 = new LinkedList<List<PsiElement>>();
        ArrayList<PsiElement> word = null;
        for (PsiElement cur = start; cur != null; cur = cur.getNextSibling()) {
            if (cur instanceof PsiWhiteSpace) {
                word = null;
            } else {
                if (word == null) {
                    word = new ArrayList<PsiElement>();
                    result2.add(word);
                }
                word.add(cur);
            }
            if (cur == end) break;
        }
        return result2;
    }

    protected static List<List<PsiElement>> separateWords(List<? extends PsiElement> children) {
        if (children.isEmpty()) {
            return Collections.emptyList();
        }
        if (children.size() == 1) {
            return Collections.singletonList(new ArrayList<PsiElement>(children));
        }
        return DockerFileInspectorBase.separateWordsBetween(children.get(0), children.get(children.size() - 1));
    }

    @Nullable
    protected static PsiWhiteSpace firstSpaceAfter(PsiElement psi) {
        PsiElement cur = psi;
        while (cur != null) {
            if (cur instanceof PsiWhiteSpace) {
                return (PsiWhiteSpace)cur;
            }
            cur = PsiTreeUtil.nextLeaf((PsiElement)cur);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "badWord";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/dockerFile/inspections/DockerFileInspectorBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "registerProblem";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

