/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.dockerFile;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.docker.ConfigureNewRunConfig;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerIcons;
import com.intellij.docker.DockerRunConfigurationCreator;
import com.intellij.docker.DockerRunLineMarkerProviderBase;
import com.intellij.docker.EditExistingRunConfig;
import com.intellij.docker.FireAsTemporaryRunConfigAction;
import com.intellij.docker.RunConfigActionBase;
import com.intellij.docker.RunExistingRunConfig;
import com.intellij.docker.deployment.DockerRunConfig;
import com.intellij.docker.deploymentSource.DockerFileDeploymentSourceType;
import com.intellij.docker.dockerFile.DockerFileContextFolderDetector;
import com.intellij.docker.dockerFile.DockerPsiFile;
import com.intellij.docker.dockerFile.lexer.DockerTokenTypes;
import com.intellij.docker.dockerFile.parser.psi.DockerFileFromCommand;
import com.intellij.docker.dockerFile.parser.psi.DockerPsiCommand;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.utils.DockerUtils;
import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DockerFileRunLineMarkerProvider
extends DockerRunLineMarkerProviderBase {
    DockerFileRunLineMarkerProvider() {
    }

    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement psi) {
        ASTNode node;
        if (psi == null) {
            DockerFileRunLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if ((node = psi.getNode()) == null) {
            return null;
        }
        if (node.getElementType() != DockerTokenTypes.FROM) {
            return null;
        }
        if (!(psi.getContainingFile() instanceof DockerPsiFile)) {
            return null;
        }
        DockerPsiCommand command = (DockerPsiCommand)PsiTreeUtil.getParentOfType((PsiElement)psi, DockerPsiCommand.class);
        if (command == null || DockerFileRunLineMarkerProvider.findPreviousFromCommand(command) != null) {
            return null;
        }
        return new DockerRunLineMarkerProviderBase.RunConfigLineMarkerInfo(psi, AllIcons.RunConfigurations.TestState.Run_run){

            @Override
            protected ActionGroup computeGutterPopup(@NotNull DockerRunConfigurationCreator helper, @NotNull VirtualFile sourceFile) {
                if (helper == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (sourceFile == null) {
                    1.$$$reportNull$$$0(1);
                }
                return DockerFileRunLineMarkerProvider.doComputeGutterPopup(helper, sourceFile);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "helper";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "sourceFile";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/docker/dockerFile/DockerFileRunLineMarkerProvider$1";
                objectArray[2] = "computeGutterPopup";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    private static DockerFileFromCommand findPreviousFromCommand(@NotNull DockerPsiCommand command) {
        if (command == null) {
            DockerFileRunLineMarkerProvider.$$$reportNull$$$0(1);
        }
        for (PsiElement cur = command.getPrevSibling(); cur != null; cur = cur.getPrevSibling()) {
            if (!(cur instanceof DockerFileFromCommand)) continue;
            return (DockerFileFromCommand)cur;
        }
        return null;
    }

    private static ActionGroup doComputeGutterPopup(@NotNull DockerRunConfigurationCreator helper, @NotNull VirtualFile sourceFile) {
        if (helper == null) {
            DockerFileRunLineMarkerProvider.$$$reportNull$$$0(2);
        }
        if (sourceFile == null) {
            DockerFileRunLineMarkerProvider.$$$reportNull$$$0(3);
        }
        DockerFileDeploymentSourceType dockerType = DockerFileDeploymentSourceType.getInstance();
        List foundConfigs = ContainerUtil.filter(DockerRunConfig.Wrapper.dockerConfigs(helper.getProject(), sourceFile, dockerType), e -> (Boolean)e.fromConfig(c -> c.getBuildCliOptions().contains("--target ") && c.isBuildKitEnabled()) == false);
        LinkedList<RunConfigActionBase> knownsGroup = new LinkedList<RunConfigActionBase>();
        for (DockerRunConfig.Wrapper nextFound : foundConfigs) {
            knownsGroup.add(new RunExistingRunConfig(helper, nextFound));
            knownsGroup.add(new BuildExistingRunConfig(helper, nextFound));
            knownsGroup.add(new EditExistingRunConfig(helper, nextFound));
            knownsGroup.add((RunConfigActionBase)new Separator());
        }
        List<RemoteServer<DockerCloudConfiguration>> allServers = DockerFileRunLineMarkerProvider.listAllDockerAccounts();
        LinkedList<RunConfigActionBase> unknownsGroup = new LinkedList<RunConfigActionBase>();
        if (allServers.isEmpty()) {
            ConfigureNewRunConfig theOnlyAction = new ConfigureNewRunConfig(helper, sourceFile, DockerFileDeploymentSourceType.getInstance(), null);
            theOnlyAction.getTemplatePresentation().setIcon(DockerIcons.Docker);
            unknownsGroup.add(theOnlyAction);
        } else {
            List<RemoteServer<DockerCloudConfiguration>> remainingServers = DockerUtils.allServersExceptKnowns(foundConfigs);
            RemoteServer theOnlyServer = (RemoteServer)ContainerUtil.getOnlyItem(remainingServers);
            if (theOnlyServer != null) {
                unknownsGroup.add(new RunTemporaryRunConfigAction(helper, sourceFile, (RemoteServer<DockerCloudConfiguration>)theOnlyServer));
                unknownsGroup.add(new BuildTemporaryRunConfigAction(helper, sourceFile, (RemoteServer<DockerCloudConfiguration>)theOnlyServer));
            } else {
                DefaultActionGroup runGroup = DefaultActionGroup.createPopupGroup(DockerBundle.messagePointer("DockerFileRunLineMarkerProvider.action.group.run", new Object[0]));
                runGroup.getTemplatePresentation().setIcon(DockerIcons.Docker);
                DefaultActionGroup buildGroup = DefaultActionGroup.createPopupGroup(DockerBundle.messagePointer("DockerFileRunLineMarkerProvider.action.group.build", new Object[0]));
                for (RemoteServer<DockerCloudConfiguration> nextDocker : remainingServers) {
                    runGroup.add((AnAction)new RunTemporaryRunConfigAction(helper, sourceFile, nextDocker));
                    buildGroup.add((AnAction)new BuildTemporaryRunConfigAction(helper, sourceFile, nextDocker));
                }
                unknownsGroup.add((RunConfigActionBase)runGroup);
                unknownsGroup.add((RunConfigActionBase)buildGroup);
            }
            if (!remainingServers.isEmpty()) {
                RemoteServer<DockerCloudConfiguration> firstServer = remainingServers.get(0);
                unknownsGroup.add(new ConfigureNewRunConfig(helper, sourceFile, DockerFileDeploymentSourceType.getInstance(), firstServer));
            }
        }
        return DockerFileRunLineMarkerProvider.combineActions(knownsGroup, unknownsGroup);
    }

    private static void customizeFileBasedConfiguration(@NotNull Project project, @NotNull VirtualFile dockerFile, @NotNull DockerDeploymentConfiguration configuration) {
        String autoDetectedContextPath;
        PsiFile file2;
        if (project == null) {
            DockerFileRunLineMarkerProvider.$$$reportNull$$$0(4);
        }
        if (dockerFile == null) {
            DockerFileRunLineMarkerProvider.$$$reportNull$$$0(5);
        }
        if (configuration == null) {
            DockerFileRunLineMarkerProvider.$$$reportNull$$$0(6);
        }
        if ((file2 = PsiManager.getInstance((Project)project).findFile(dockerFile)) instanceof DockerPsiFile && (autoDetectedContextPath = DockerFileContextFolderDetector.detectContextFolderForDockerfile((DockerPsiFile)file2)) != null) {
            configuration.setContextFolderPath(autoDetectedContextPath);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/dockerFile/DockerFileRunLineMarkerProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineMarkerInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findPreviousFromCommand";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doComputeGutterPopup";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "customizeFileBasedConfiguration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class BuildTemporaryRunConfigAction
    extends FireAsTemporaryRunConfigAction {
        BuildTemporaryRunConfigAction(@NotNull DockerRunConfigurationCreator helper, @NotNull VirtualFile sourceFile, @NotNull RemoteServer<DockerCloudConfiguration> docker) {
            if (helper == null) {
                BuildTemporaryRunConfigAction.$$$reportNull$$$0(0);
            }
            if (sourceFile == null) {
                BuildTemporaryRunConfigAction.$$$reportNull$$$0(1);
            }
            if (docker == null) {
                BuildTemporaryRunConfigAction.$$$reportNull$$$0(2);
            }
            super(helper, sourceFile, DockerFileDeploymentSourceType.getInstance(), docker);
            this.getTemplatePresentation().setText(DockerBundle.messagePointer("DockerFileRunLineMarkerProvider.BuildAsTemporaryRunConfig.text", docker.getName()));
        }

        @Override
        protected void customize(DockerRunConfig.Wrapper wrapper) {
            if (wrapper != null) {
                wrapper.applyToConfig(e -> {
                    e.setBuildOnly(true);
                    DockerFileRunLineMarkerProvider.customizeFileBasedConfiguration(this.getProject(), this.getMySourceFile(), e);
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "helper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "sourceFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "docker";
                    break;
                }
            }
            objectArray[1] = "com/intellij/docker/dockerFile/DockerFileRunLineMarkerProvider$BuildTemporaryRunConfigAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class RunTemporaryRunConfigAction
    extends FireAsTemporaryRunConfigAction {
        RunTemporaryRunConfigAction(@NotNull DockerRunConfigurationCreator helper, @NotNull VirtualFile sourceFile, @NotNull RemoteServer<DockerCloudConfiguration> docker) {
            if (helper == null) {
                RunTemporaryRunConfigAction.$$$reportNull$$$0(0);
            }
            if (sourceFile == null) {
                RunTemporaryRunConfigAction.$$$reportNull$$$0(1);
            }
            if (docker == null) {
                RunTemporaryRunConfigAction.$$$reportNull$$$0(2);
            }
            super(helper, sourceFile, DockerFileDeploymentSourceType.getInstance(), docker);
        }

        @Override
        protected void customize(DockerRunConfig.Wrapper wrapper) {
            super.customize(wrapper);
            if (wrapper != null) {
                wrapper.applyToConfig(e -> DockerFileRunLineMarkerProvider.customizeFileBasedConfiguration(this.getProject(), this.getMySourceFile(), e));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "helper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "sourceFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "docker";
                    break;
                }
            }
            objectArray[1] = "com/intellij/docker/dockerFile/DockerFileRunLineMarkerProvider$RunTemporaryRunConfigAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class BuildExistingRunConfig
    extends RunConfigActionBase {
        @NotNull
        private final DockerRunConfig.Wrapper myWrapper;

        BuildExistingRunConfig(@NotNull DockerRunConfigurationCreator helper, @NotNull DockerRunConfig.Wrapper wrapper) {
            if (helper == null) {
                BuildExistingRunConfig.$$$reportNull$$$0(0);
            }
            if (wrapper == null) {
                BuildExistingRunConfig.$$$reportNull$$$0(1);
            }
            super(helper);
            this.myWrapper = wrapper;
            this.getTemplatePresentation().setText(DockerBundle.messagePointer("DockerFileRunLineMarkerProvider.BuildExistingRunConfig.text", this.myWrapper.getRunConfigName()));
        }

        @Override
        public void execute() {
            this.myWrapper.applyToConfig(e -> e.setBuildOnly(true));
            this.getHelper().executeConfiguration(this.myWrapper.getSettings());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "helper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "wrapper";
                    break;
                }
            }
            objectArray[1] = "com/intellij/docker/dockerFile/DockerFileRunLineMarkerProvider$BuildExistingRunConfig";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

