/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.dockerFile;

import com.intellij.docker.dockerFile.DockerFileCopyCommandUtilsKt;
import com.intellij.docker.dockerFile.DockerFileRunConfigurationProducer;
import com.intellij.docker.dockerFile.DockerPsiFile;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J*\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/docker/dockerFile/DockerFileContextFolderDetector;", "", "()V", "detectContextFolderForDockerfile", "", "dockerFile", "Lcom/intellij/docker/dockerFile/DockerPsiFile;", "fs", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "contentRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "virtualFile", "intellij.clouds.docker.file"})
public final class DockerFileContextFolderDetector {
    @NotNull
    public static final DockerFileContextFolderDetector INSTANCE;

    @JvmStatic
    @Nullable
    public static final String detectContextFolderForDockerfile(@NotNull DockerPsiFile dockerFile) {
        Intrinsics.checkNotNullParameter((Object)((Object)dockerFile), (String)"dockerFile");
        VirtualFile virtualFile = dockerFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        VirtualFile virtualFile3 = ProjectFileIndex.getInstance((Project)dockerFile.getProject()).getContentRootForFile(virtualFile2);
        if (virtualFile3 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"ProjectFileIndex.getInst\u2026rtualFile) ?: return null");
        VirtualFile contentRoot = virtualFile3;
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"LocalFileSystem.getInstance()");
        return INSTANCE.detectContextFolderForDockerfile((VirtualFileSystem)localFileSystem, contentRoot, virtualFile2, dockerFile);
    }

    @TestOnly
    @Nullable
    public final String detectContextFolderForDockerfile(@NotNull VirtualFileSystem fs, @NotNull VirtualFile contentRoot, @NotNull VirtualFile virtualFile, @NotNull DockerPsiFile dockerFile) {
        Intrinsics.checkNotNullParameter((Object)fs, (String)"fs");
        Intrinsics.checkNotNullParameter((Object)contentRoot, (String)"contentRoot");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)((Object)dockerFile), (String)"dockerFile");
        Logger logger2 = Logger.getInstance(DockerFileRunConfigurationProducer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(Docke\u2026tionProducer::class.java)");
        Logger logger3 = logger2;
        int maxFilesToTraverse = 50;
        List<String> pathsToTraverse = DockerFileCopyCommandUtilsKt.localCopySourcePaths(dockerFile);
        if (pathsToTraverse.isEmpty()) {
            return null;
        }
        boolean isDefaultContextPath = true;
        int filesTraversed = 0;
        for (VirtualFile contextPath = virtualFile.getParent(); contextPath != null && FileUtil.isAncestor((String)contentRoot.getPath(), (String)contextPath.getPath(), (boolean)false); contextPath = contextPath.getParent()) {
            for (String path : pathsToTraverse) {
                ProgressManager.checkCanceled();
                if (FileUtil.isAbsolute((String)path)) continue;
                if (maxFilesToTraverse <= filesTraversed++) {
                    logger3.info("Traversed " + filesTraversed + " files while checking Dockerfile " + virtualFile.getPath() + ", exiting");
                    return null;
                }
                VirtualFile localFile = fs.findFileByPath(FileUtil.join((String[])new String[]{contextPath.getPath(), path}));
                if (localFile == null || !localFile.exists() || localFile.isDirectory()) continue;
                logger3.info("Detected context path " + contextPath.getPath() + " for Dockerfile " + virtualFile.getPath());
                return isDefaultContextPath ? null : contextPath.getPath();
            }
            isDefaultContextPath = false;
        }
        return null;
    }

    private DockerFileContextFolderDetector() {
    }

    static {
        DockerFileContextFolderDetector dockerFileContextFolderDetector;
        INSTANCE = dockerFileContextFolderDetector = new DockerFileContextFolderDetector();
    }
}

