/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.deploymentSource;

import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerDeploymentConfigurationUtilsKt;
import com.intellij.docker.DockerIcons;
import com.intellij.docker.agent.DockerUtil;
import com.intellij.docker.deploymentSource.DockerSingletonDeploymentSourceType;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.runtimes.DockerImageRuntime;
import com.intellij.docker.runtimes.DockerRuntimeBase;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DockerFileDeploymentSourceType
extends DockerSingletonDeploymentSourceType {
    static final String ID = "dockerfile";

    public static DockerFileDeploymentSourceType getInstance() {
        return (DockerFileDeploymentSourceType)DockerFileDeploymentSourceType.findExtension(DockerFileDeploymentSourceType.class);
    }

    public DockerFileDeploymentSourceType() {
        super(ID, DockerBundle.message("DockerFileDeploymentSourceType.name", new Object[0]), DockerIcons.DockerFile_1);
    }

    @Override
    @Nullable
    public String suggestConfigurationName(@NotNull DockerDeploymentConfiguration configuration) {
        String sourceFilePath;
        if (configuration == null) {
            DockerFileDeploymentSourceType.$$$reportNull$$$0(0);
        }
        if (StringUtil.isEmptyOrSpaces((String)(sourceFilePath = configuration.getSourceFilePath()))) {
            return null;
        }
        String lastTwo = DockerFileDeploymentSourceType.lastTwoSegments(sourceFilePath);
        return DockerBundle.message("DockerFileDeploymentSourceType.suggestRunConfigurationName", lastTwo);
    }

    @Override
    @NotNull
    public String getPresentableDeploymentName(@NotNull DockerDeploymentConfiguration configuration, @Nullable DockerRuntimeBase runtime) {
        if (configuration == null) {
            DockerFileDeploymentSourceType.$$$reportNull$$$0(1);
        }
        String namePiece = configuration.isBuildOnly() ? DockerFileDeploymentSourceType.getPresentableImageNamePiece(configuration, runtime) : DockerFileDeploymentSourceType.getPresentableContainerNamePiece(configuration, runtime);
        String path = configuration.getSourceFilePath();
        String string = DockerBundle.message("DockerFileDeploymentSourceType.deploymentName", namePiece, path);
        if (string == null) {
            DockerFileDeploymentSourceType.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    @Nls
    private static String getPresentableImageNamePiece(@NotNull DockerDeploymentConfiguration configuration, @Nullable DockerRuntimeBase runtime) {
        DockerImageRuntime imageRuntime;
        List tags2;
        if (configuration == null) {
            DockerFileDeploymentSourceType.$$$reportNull$$$0(3);
        }
        @NlsSafe String result2 = runtime instanceof DockerImageRuntime ? ((tags2 = (imageRuntime = (DockerImageRuntime)runtime).getImageRepoTags().stream().map(DockerUtil::shortedId).sorted(String.CASE_INSENSITIVE_ORDER).collect(Collectors.toList())).size() > 1 ? tags2.toString() : tags2.stream().findAny().orElse(DockerUtil.shortedId(imageRuntime.getImageId()))) : configuration.getAllImageTagsJoined();
        String string = StringUtil.isEmptyOrSpaces((String)result2) ? (String)NAME_PIECE_UNKNOWN.get() : result2;
        if (string == null) {
            DockerFileDeploymentSourceType.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public void checkDeploymentConfiguration(@NotNull Project project, @NotNull DockerDeploymentConfiguration configuration) throws RuntimeConfigurationException {
        if (project == null) {
            DockerFileDeploymentSourceType.$$$reportNull$$$0(5);
        }
        if (configuration == null) {
            DockerFileDeploymentSourceType.$$$reportNull$$$0(6);
        }
        super.checkDeploymentConfiguration(project, configuration);
        File dockerFile = DockerDeploymentConfigurationUtilsKt.getSourceFile(project, configuration);
        if (dockerFile == null) {
            throw new RuntimeConfigurationError(DockerBundle.message("DockerFileDeploymentSourceType.error.path.required", new Object[0]));
        }
        if (!dockerFile.exists() || !dockerFile.isFile()) {
            throw new RuntimeConfigurationError(DockerBundle.message("DockerFileDeploymentSourceType.error.dockerfile.does.not.exist", dockerFile));
        }
        DockerFileDeploymentSourceType.checkImageTagFormat(configuration, false, false);
        DockerFileDeploymentSourceType.checkContainerNameFormat(configuration);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/deploymentSource/DockerFileDeploymentSourceType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/deploymentSource/DockerFileDeploymentSourceType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableDeploymentName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableImageNamePiece";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "suggestConfigurationName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableDeploymentName";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableImageNamePiece";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkDeploymentConfiguration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

