/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.deploymentSource;

import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerDeploymentConfigurationUtilsKt;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.util.text.StringKt;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\b\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\t\u001a\u0004\u0018\u00010\n*\u0004\u0018\u00010\u000b\u00a8\u0006\f"}, d2={"checkComposeFile", "", "project", "Lcom/intellij/openapi/project/Project;", "config", "Lcom/intellij/docker/DockerDeploymentConfiguration;", "checkEnvFile", "checkProjectName", "checkTimeout", "toValidationInfo", "Lcom/intellij/openapi/ui/ValidationInfo;", "", "intellij.clouds.docker"})
public final class DockerComposeDeploymentValidationKt {
    @Nullable
    public static final ValidationInfo toValidationInfo(@Nullable Throwable $this$toValidationInfo) {
        ValidationInfo validationInfo;
        Object object = $this$toValidationInfo;
        if (object != null && (object = ((Throwable)object).getMessage()) != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            validationInfo = new ValidationInfo((String)it);
        } else {
            validationInfo = null;
        }
        return validationInfo;
    }

    public static final void checkEnvFile(@NotNull DockerDeploymentConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        String string = config.getEnvFilePath();
        if (string == null || (string = StringKt.nullize((String)string, (boolean)true)) == null) {
            return;
        }
        String path = string;
        File file2 = new File(path);
        if (!file2.exists()) {
            throw (Throwable)new RuntimeConfigurationException(DockerBundle.message("DockerComposeDeploymentEditor.env.file.does.not.exist", file2.getAbsolutePath()));
        }
        if (file2.isDirectory()) {
            throw (Throwable)new RuntimeConfigurationException(DockerBundle.message("DockerComposeDeploymentEditor.env.file.not.valid", file2.getAbsolutePath()));
        }
    }

    public static final void checkTimeout(@NotNull DockerDeploymentConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        String timeout = config.getUpTimeout();
        if (StringsKt.isBlank((CharSequence)timeout)) {
            return;
        }
        if (StringsKt.toIntOrNull((String)timeout) == null) {
            throw (Throwable)new RuntimeConfigurationException(DockerBundle.message("DockerComposeDeploymentEditor.up.timeout.dialog.message.not.valid.integer", timeout));
        }
        String string = timeout;
        boolean bl = false;
        if (Integer.parseInt(string) < 0) {
            throw (Throwable)new RuntimeConfigurationException(DockerBundle.message("DockerComposeDeploymentEditor.up.timeout.dialog.message.timeout.cannot.be.less", new Object[0]));
        }
        string = timeout;
        bl = false;
        if (Integer.parseInt(string) > 1000) {
            throw (Throwable)new RuntimeConfigurationException(DockerBundle.message("DockerComposeDeploymentEditor.up.timeout.dialog.message.timeout.cannot.be.greater", new Object[0]));
        }
    }

    public static final void checkProjectName(@NotNull DockerDeploymentConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        String projectName = config.getComposeProjectName();
        if (StringsKt.isBlank((CharSequence)projectName)) {
            return;
        }
        String string = "([a-zA-Z_\\-0-9])+";
        boolean bl = false;
        if (!new Regex(string).matches((CharSequence)projectName)) {
            throw (Throwable)new RuntimeConfigurationException(DockerBundle.message("DockerComposeDeploymentEditor.dialog.message.not.valid.project.name", projectName));
        }
    }

    public static final void checkComposeFile(@NotNull Project project, @NotNull DockerDeploymentConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        File composeFile = DockerDeploymentConfigurationUtilsKt.getSourceFile(project, config);
        if (composeFile == null) {
            throw (Throwable)new RuntimeConfigurationException(DockerBundle.message("DockerComposeDeploymentSourceType.error.path.required", new Object[0]));
        }
        if (!composeFile.exists() || !composeFile.isFile()) {
            throw (Throwable)new RuntimeConfigurationException(DockerBundle.message("DockerComposeDeploymentSourceType.error.file.does.not.exist", composeFile));
        }
    }
}

