/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.deployment.ui;

import com.intellij.DynamicBundle;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.agent.cli.CliParserBase;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.cli.DockerRunCliBuilder;
import com.intellij.docker.cli.DockerRunCliValidator;
import com.intellij.docker.cli.NormalizedCommandLine;
import com.intellij.docker.cli.model.DockerCliOption;
import com.intellij.docker.cli.model.DockerCliOptionsModel;
import com.intellij.docker.deployment.ui.DockerCliOptionsField;
import com.intellij.docker.deployment.ui.DockerEnvVarFieldWithBrowseButton;
import com.intellij.docker.deployment.ui.DockerPortBindingsField;
import com.intellij.docker.deployment.ui.DockerVolumeBindingsField;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.apache.commons.cli.ParseException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerContainerSettingsUI {
    private final Project myProject;
    private JPanel myMainPanel;
    private JBRadioButton myAllPortsRadio;
    private JBRadioButton mySpecifyPortsRadio;
    private HyperlinkLabel myExposedPortsHyperlink;
    private TextFieldWithBrowseButton myPortsField;
    private TextFieldWithBrowseButton myVolumesField;
    private TextFieldWithBrowseButton myEnvVarsField;
    private TextFieldWithCompletion myCliOptionsField;
    private JBLabel myPortsLabel;
    private ExpandableTextField myEntrypointField;
    private ExpandableTextField myCommandField;
    private JBLabel myCommandFieldLabel;

    public DockerContainerSettingsUI(@NotNull Project project) {
        if (project == null) {
            DockerContainerSettingsUI.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.$$$setupUI$$$();
        this.mySpecifyPortsRadio.addActionListener(e -> this.updatePortsEnablement());
        this.myAllPortsRadio.addActionListener(e -> this.updatePortsEnablement());
        this.updatePortsEnablement();
    }

    public void setCommandFieldVisibility(boolean value) {
        this.myCommandFieldLabel.setVisible(value);
        this.myCommandField.setVisible(value);
    }

    public void resetEditorFrom(@NotNull DockerDeploymentConfiguration configuration) {
        if (configuration == null) {
            DockerContainerSettingsUI.$$$reportNull$$$0(1);
        }
        this.myEntrypointField.setText(configuration.getEntrypoint());
        this.myCommandField.setText(configuration.getCommand());
        (configuration.isPublishAllPorts() ? this.myAllPortsRadio : this.mySpecifyPortsRadio).setSelected(true);
        this.getEnvVarsField().setEnvVars(configuration.getEnvVars());
        this.getPortBindingsField().setBindings(configuration.getPortBindings(), false);
        this.getVolumeBindingsField().setBindings(configuration.getVolumeBindings(), false);
        this.getCliOptionsField().resetEditorFrom(configuration);
        this.updatePortsEnablement();
    }

    public void applyEditorTo(@NotNull DockerDeploymentConfiguration configuration) throws ConfigurationException {
        if (configuration == null) {
            DockerContainerSettingsUI.$$$reportNull$$$0(2);
        }
        configuration.setEntrypoint(this.myEntrypointField.getText());
        configuration.setCommand(this.myCommandField.getText());
        configuration.setPublishAllPorts(this.myAllPortsRadio.isSelected());
        configuration.setEnvVars(this.getEnvVarsField().getEnvVars());
        configuration.setPortBindings(this.getPortBindingsField().getBindings());
        configuration.setVolumeBindings(this.getVolumeBindingsField().getBindings());
        this.getCliOptionsField().applyValueTo(configuration);
    }

    @Nullable
    public ValidationInfo doValidate() {
        try {
            this.getCliOptionsField().getParsedOptions();
        }
        catch (CliParserBase.IllegalOptionException | ParseException e) {
            return new ValidationInfo(e.getLocalizedMessage(), (JComponent)((Object)this.getCliOptionsField()));
        }
        return null;
    }

    private void updatePortsEnablement() {
        boolean enabled = this.mySpecifyPortsRadio.isSelected();
        this.myPortsField.setEnabled(enabled);
        this.myPortsLabel.setEnabled(enabled);
        this.myPortsField.getTextField().setEnabled(enabled);
    }

    private EnvVarsField getEnvVarsField() {
        return (EnvVarsField)this.myEnvVarsField;
    }

    private DockerPortBindingsField getPortBindingsField() {
        return (DockerPortBindingsField)this.myPortsField;
    }

    private DockerVolumeBindingsField getVolumeBindingsField() {
        return (DockerVolumeBindingsField)this.myVolumesField;
    }

    private DockerRunOptionsField getCliOptionsField() {
        return (DockerRunOptionsField)this.myCliOptionsField;
    }

    private void createUIComponents() {
        this.myEnvVarsField = new EnvVarsField();
        this.myExposedPortsHyperlink = new HyperlinkLabel();
        this.myExposedPortsHyperlink.setHtmlText(DockerBundle.message("DockerContainerSettingsUI.exposedPortsHyperlink", new Object[0]));
        this.myExposedPortsHyperlink.addHyperlinkListener(e -> this.onExposedPortHyperlink());
        this.myPortsField = new DockerPortBindingsField();
        this.myVolumesField = new DockerVolumeBindingsField(this.myProject).withSampleHostPath(this.myProject.getBasePath());
        this.myCliOptionsField = new DockerRunOptionsField(this.myProject);
    }

    private void onExposedPortHyperlink() {
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    public DockerRunCliBuilder prepareRunCliBuilder(@NotNull String imageTag2) {
        if (imageTag2 == null) {
            DockerContainerSettingsUI.$$$reportNull$$$0(3);
        }
        DockerRunCliBuilder runBuilder = new DockerRunCliBuilder(imageTag2);
        runBuilder.setEntryPoint(this.myEntrypointField.getText());
        runBuilder.setCommand(this.myCommandField.getText());
        if (this.myAllPortsRadio.isSelected()) {
            runBuilder.setPublishAllPorts();
        } else if (this.mySpecifyPortsRadio.isSelected()) {
            runBuilder.addPublishedPorts(this.getPortBindingsField().getBindings());
        }
        for (DockerVolumeBindingImpl dockerVolumeBindingImpl : this.getVolumeBindingsField().getBindings()) {
            runBuilder.addVolume(dockerVolumeBindingImpl);
        }
        for (Map.Entry entry : this.getEnvVarsField().getPairs().entrySet()) {
            if (entry.getKey() == null) continue;
            runBuilder.addEnvVar((String)entry.getKey(), (String)entry.getValue());
        }
        try {
            NormalizedCommandLine userOptions2 = this.getCliOptionsField().getParsedOptions();
            if (userOptions2 != null) {
                runBuilder.setCustomRunOptions(userOptions2);
            }
        }
        catch (CliParserBase.IllegalOptionException | ParseException throwable) {
            // empty catch block
        }
        return runBuilder;
    }

    public void setContextFolder(File contextFolder) {
        this.getCliOptionsField().setContextFolder(contextFolder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageTag";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/deployment/ui/DockerContainerSettingsUI";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "applyEditorTo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareRunCliBuilder";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        ExpandableTextField expandableTextField;
        ExpandableTextField expandableTextField2;
        JBLabel jBLabel2;
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/DockerBundle", DockerContainerSettingsUI.class).getString("DockerContainerSettingsUI.run.options.text"));
        jPanel.add((Component)jBLabel3, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myAllPortsRadio = jBRadioButton2 = new JBRadioButton();
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton2, DynamicBundle.getBundle((String)"messages/DockerBundle", DockerContainerSettingsUI.class).getString("DockerContainerSettingsUI.all.text"));
        jPanel2.add((Component)jBRadioButton2, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 0, null, null, null));
        this.mySpecifyPortsRadio = jBRadioButton = new JBRadioButton();
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton, DynamicBundle.getBundle((String)"messages/DockerBundle", DockerContainerSettingsUI.class).getString("DockerContainerSettingsUI.specify.text"));
        jPanel2.add((Component)jBRadioButton, new GridConstraints(0, 2, 1, 1, 0, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        HyperlinkLabel hyperlinkLabel = this.myExposedPortsHyperlink;
        jPanel2.add((Component)hyperlinkLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        this.myPortsLabel = jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/DockerBundle", DockerContainerSettingsUI.class).getString("DockerContainerSettingsUI.bind.ports.text"));
        jPanel.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        JBLabel jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, DynamicBundle.getBundle((String)"messages/DockerBundle", DockerContainerSettingsUI.class).getString("DockerContainerSettingsUI.bind.mounts.text"));
        jPanel.add((Component)jBLabel4, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel5, DynamicBundle.getBundle((String)"messages/DockerBundle", DockerContainerSettingsUI.class).getString("DockerContainerSettingsUI.environment.variables.text"));
        jPanel.add((Component)jBLabel5, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.myPortsField;
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = this.myVolumesField;
        jPanel.add((Component)textFieldWithBrowseButton2, new GridConstraints(3, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton3 = this.myEnvVarsField;
        jPanel.add((Component)textFieldWithBrowseButton3, new GridConstraints(4, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        TextFieldWithCompletion textFieldWithCompletion = this.myCliOptionsField;
        textFieldWithCompletion.setText("");
        jPanel.add((Component)textFieldWithCompletion, new GridConstraints(5, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel3, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/DockerBundle", DockerContainerSettingsUI.class).getString("DockerContainerSettingsUI.executable.panel.title"), (int)0, (int)0, null, null));
        this.myEntrypointField = expandableTextField2 = new ExpandableTextField();
        jPanel3.add((Component)expandableTextField2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myCommandField = expandableTextField = new ExpandableTextField();
        jPanel3.add((Component)expandableTextField, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myCommandFieldLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/DockerBundle", DockerContainerSettingsUI.class).getString("DockerContainerSettingsUI.command.text"));
        jPanel3.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel6 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel6, DynamicBundle.getBundle((String)"messages/DockerBundle", DockerContainerSettingsUI.class).getString("DockerContainerSettingsUI.entrypoint.text"));
        jPanel3.add((Component)jBLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        jBLabel3.setLabelFor((Component)textFieldWithCompletion);
        jBLabel2.setLabelFor((Component)textFieldWithBrowseButton);
        jBLabel4.setLabelFor((Component)textFieldWithBrowseButton2);
        jBLabel5.setLabelFor((Component)textFieldWithBrowseButton3);
        jBLabel.setLabelFor((Component)expandableTextField);
        jBLabel6.setLabelFor((Component)expandableTextField2);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton);
        buttonGroup.add((AbstractButton)jBRadioButton2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public static class DockerRunOptionsField
    extends DockerCliOptionsField {
        private static final Map<String, DockerCliOption> MODEL = DockerCliOptionsModel.INSTANCE.getDockerRunOptions();

        public DockerRunOptionsField(Project project) {
            super(project, new DockerRunCliValidator(), MODEL);
        }

        @Override
        protected void storeRawText(@NotNull DockerDeploymentConfiguration configuration) {
            if (configuration == null) {
                DockerRunOptionsField.$$$reportNull$$$0(0);
            }
            configuration.setRunCliOptions(this.getText());
        }

        @Override
        public void resetEditorFrom(@NotNull DockerDeploymentConfiguration configuration) {
            if (configuration == null) {
                DockerRunOptionsField.$$$reportNull$$$0(1);
            }
            String optionsLine = configuration.getRunCliOptions();
            this.setText(optionsLine);
        }

        @Override
        public void clearValue(@NotNull DockerDeploymentConfiguration configuration) {
            if (configuration == null) {
                DockerRunOptionsField.$$$reportNull$$$0(2);
            }
            configuration.setRunCliOptions(null);
        }

        @Override
        protected void handleParseException(ParseException e) throws ConfigurationException {
            throw new RuntimeConfigurationWarning(DockerBundle.message("DockerContainerSettingsUI.DockerRunOptionsField.onParseError", e.getMessage()));
        }

        @Override
        @NotNull
        protected DockerRunCliValidator getValidator() {
            DockerRunCliValidator dockerRunCliValidator = (DockerRunCliValidator)super.getValidator();
            if (dockerRunCliValidator == null) {
                DockerRunOptionsField.$$$reportNull$$$0(3);
            }
            return dockerRunCliValidator;
        }

        public void setContextFolder(@Nullable File contextFolder) {
            this.getValidator().setContextFolder(contextFolder);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/deployment/ui/DockerContainerSettingsUI$DockerRunOptionsField";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/deployment/ui/DockerContainerSettingsUI$DockerRunOptionsField";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValidator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "storeRawText";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "resetEditorFrom";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "clearValue";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class EnvVarsField
    extends DockerEnvVarFieldWithBrowseButton {
        EnvVarsField() {
            super(DockerBundle.message("DockerContainerSettingsUI.EnvVarsField.dialogTitle", new Object[0]), DockerBundle.message("DockerContainerSettingsUI.EnvVarsField.dialogEmptyText", new Object[0]));
        }
    }
}

