/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.deployment;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerDeploymentConfigurationUtilsKt;
import com.intellij.docker.deploymentSource.DockerDeploymentConfigurator;
import com.intellij.docker.deploymentSource.DockerSingletonDeploymentSourceType;
import com.intellij.execution.Location;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.impl.EditConfigurationsDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfiguration;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.configuration.deployment.DeploymentSourceType;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DockerRunConfigurationProducerBase
extends LazyRunConfigurationProducer<DeployToServerRunConfiguration<?, DockerDeploymentConfiguration>> {
    @Nullable
    protected abstract DockerSingletonDeploymentSourceType getDeploymentSourceType(@NotNull PsiFile var1);

    protected abstract void customizeConfiguration(@NotNull DockerDeploymentConfiguration var1, @NotNull PsiElement var2, @NotNull PsiFile var3);

    protected boolean setupConfigurationFromContext(@NotNull DeployToServerRunConfiguration<?, DockerDeploymentConfiguration> configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        RemoteServer<DockerCloudConfiguration> docker;
        PsiElement contextPsi;
        if (configuration == null) {
            DockerRunConfigurationProducerBase.$$$reportNull$$$0(0);
        }
        if (context == null) {
            DockerRunConfigurationProducerBase.$$$reportNull$$$0(1);
        }
        if (sourceElement == null) {
            DockerRunConfigurationProducerBase.$$$reportNull$$$0(2);
        }
        if ((contextPsi = DockerRunConfigurationProducerBase.findPsiElement(context)) == null) {
            return false;
        }
        PsiFile contextPsiFile = DockerRunConfigurationProducerBase.getPsiFile(contextPsi);
        if (contextPsiFile == null) {
            return false;
        }
        DockerSingletonDeploymentSourceType sourceType = this.getDeploymentSourceType(contextPsiFile);
        if (sourceType == null) {
            return false;
        }
        Project project = context.getProject();
        DockerDeploymentConfigurator configurator = DockerCloudType.getInstance().createDeploymentConfigurator(project);
        DeploymentSource deploymentSource = sourceType.getSingletonSource();
        DockerDeploymentConfiguration deploymentConfig = configurator.createDefaultConfiguration(deploymentSource);
        DockerDeploymentConfigurationUtilsKt.setSourceFile(project, deploymentConfig, contextPsiFile.getVirtualFile());
        this.customizeConfiguration(deploymentConfig, contextPsi, contextPsiFile);
        configuration.setDeploymentSource(deploymentSource);
        configuration.setDeploymentConfiguration((DeploymentConfiguration)deploymentConfig);
        String suggestedName = configurator.suggestConfigurationName(deploymentSource, deploymentConfig);
        if (suggestedName != null) {
            configuration.setName(suggestedName);
        }
        configuration.setServerName((docker = DockerRunConfigurationProducerBase.findFirstDockerAccount()) == null ? null : docker.getName());
        return true;
    }

    public void onFirstRun(@NotNull ConfigurationFromContext configuration, @NotNull ConfigurationContext context, @NotNull Runnable startRunnable) {
        if (configuration == null) {
            DockerRunConfigurationProducerBase.$$$reportNull$$$0(3);
        }
        if (context == null) {
            DockerRunConfigurationProducerBase.$$$reportNull$$$0(4);
        }
        if (startRunnable == null) {
            DockerRunConfigurationProducerBase.$$$reportNull$$$0(5);
        }
        DeployToServerRunConfiguration runConfiguration = (DeployToServerRunConfiguration)configuration.getConfiguration();
        Project project = context.getProject();
        boolean cancelled = false;
        if (runConfiguration.getServerName() == null) {
            RunManager runManager = RunManager.getInstance((Project)project);
            RunnerAndConfigurationSettings settings = configuration.getConfigurationSettings();
            if (!runManager.getAllSettings().contains(settings)) {
                runManager.addConfiguration(settings);
            }
            runManager.setSelectedConfiguration(settings);
            EditConfigurationsDialog dialog2 = new EditConfigurationsDialog(project);
            if (!dialog2.showAndGet()) {
                cancelled = true;
            }
        }
        if (!cancelled) {
            super.onFirstRun(configuration, context, startRunnable);
        }
    }

    public boolean isConfigurationFromContext(@NotNull DeployToServerRunConfiguration<?, DockerDeploymentConfiguration> configuration, @NotNull ConfigurationContext context) {
        if (configuration == null) {
            DockerRunConfigurationProducerBase.$$$reportNull$$$0(6);
        }
        if (context == null) {
            DockerRunConfigurationProducerBase.$$$reportNull$$$0(7);
        }
        if (configuration.getServerType() != DockerCloudType.getInstance()) {
            return false;
        }
        DeploymentSourceType sourceType = Optional.ofNullable(configuration.getDeploymentSource()).map(DeploymentSource::getType).orElse(null);
        if (!(sourceType instanceof DockerSingletonDeploymentSourceType)) {
            return false;
        }
        PsiElement contextPsi = DockerRunConfigurationProducerBase.findPsiElement(context);
        if (contextPsi == null) {
            return false;
        }
        PsiFile contextPsiFile = DockerRunConfigurationProducerBase.getPsiFile(contextPsi);
        return contextPsiFile != null && contextPsiFile.getVirtualFile() != null && sourceType == this.getDeploymentSourceType(contextPsiFile) && this.isConfigurationFromContext((DockerDeploymentConfiguration)configuration.getDeploymentConfiguration(), contextPsi, contextPsiFile);
    }

    protected boolean isConfigurationFromContext(@NotNull DockerDeploymentConfiguration configuration, @NotNull PsiElement contextPsi, @NotNull PsiFile contextFile) {
        if (configuration == null) {
            DockerRunConfigurationProducerBase.$$$reportNull$$$0(8);
        }
        if (contextPsi == null) {
            DockerRunConfigurationProducerBase.$$$reportNull$$$0(9);
        }
        if (contextFile == null) {
            DockerRunConfigurationProducerBase.$$$reportNull$$$0(10);
        }
        return DockerDeploymentConfigurationUtilsKt.isForSameFile(contextPsi.getProject(), configuration, contextFile.getVirtualFile());
    }

    @Nullable
    private static PsiElement findPsiElement(ConfigurationContext context) {
        return Optional.ofNullable(context).map(ConfigurationContext::getLocation).map(Location::getPsiElement).map(o -> (PsiElement)ObjectUtils.tryCast((Object)o, PsiElement.class)).orElse(null);
    }

    @Nullable
    private static PsiFile getPsiFile(@NotNull PsiElement psi) {
        if (psi == null) {
            DockerRunConfigurationProducerBase.$$$reportNull$$$0(11);
        }
        return psi instanceof PsiFile ? (PsiFile)psi : psi.getOriginalElement().getContainingFile();
    }

    @Nullable
    private static RemoteServer<DockerCloudConfiguration> findFirstDockerAccount() {
        return (RemoteServer)ContainerUtil.getFirstItem((List)RemoteServersManager.getInstance().getServers((ServerType)DockerCloudType.getInstance()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startRunnable";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextPsi";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/deployment/DockerRunConfigurationProducerBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setupConfigurationFromContext";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "onFirstRun";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isConfigurationFromContext";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getPsiFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

