/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.deployment;

import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerDeploymentConfigurationUtilsKt;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.deployment.DockerRunConfig;
import com.intellij.docker.deploymentSource.DockerComposeDeploymentSourceType;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.execution.ParametersListUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b&\u0018\u0000 \u000f2\u00020\u0001:\u0004\u000e\u000f\u0010\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H&\u00a8\u0006\u0012"}, d2={"Lcom/intellij/docker/deployment/DockerRunConfigurationPathHandler;", "", "()V", "getPaths", "", "", "project", "Lcom/intellij/openapi/project/Project;", "dockerRunConfig", "Lcom/intellij/docker/deployment/DockerRunConfig;", "replacePath", "", "oldPath", "newPath", "BindMounts", "Companion", "MainSourceFile", "SecondaryComposeFiles", "intellij.clouds.docker"})
public abstract class DockerRunConfigurationPathHandler {
    @NotNull
    private static final ExtensionPointName<DockerRunConfigurationPathHandler> EP_NAME;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public abstract List<String> getPaths(@NotNull Project var1, @NotNull DockerRunConfig var2);

    public abstract void replacePath(@NotNull Project var1, @NotNull DockerRunConfig var2, @NotNull String var3, @NotNull String var4);

    static {
        Companion = new Companion(null);
        ExtensionPointName extensionPointName = ExtensionPointName.create((String)"com.intellij.docker.runConfiguration.pathHandler");
        Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"ExtensionPointName.creat\u2026nfiguration.pathHandler\")");
        EP_NAME = extensionPointName;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/docker/deployment/DockerRunConfigurationPathHandler$MainSourceFile;", "Lcom/intellij/docker/deployment/DockerRunConfigurationPathHandler;", "()V", "getPaths", "", "", "project", "Lcom/intellij/openapi/project/Project;", "dockerRunConfig", "Lcom/intellij/docker/deployment/DockerRunConfig;", "replacePath", "", "oldPath", "newPath", "intellij.clouds.docker"})
    public static final class MainSourceFile
    extends DockerRunConfigurationPathHandler {
        @NotNull
        public static final MainSourceFile INSTANCE;

        @Override
        @NotNull
        public List<String> getPaths(@NotNull Project project, @NotNull DockerRunConfig dockerRunConfig) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dockerRunConfig, (String)"dockerRunConfig");
            File file2 = Companion.findDockerFile(project, dockerRunConfig.getDeployment().getSourceFilePath());
            return CollectionsKt.listOfNotNull((Object)(file2 != null ? file2.getAbsolutePath() : null));
        }

        @Override
        public void replacePath(@NotNull Project project, @NotNull DockerRunConfig dockerRunConfig, @NotNull String oldPath, @NotNull String newPath) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)dockerRunConfig, (String)"dockerRunConfig");
                Intrinsics.checkNotNullParameter((Object)oldPath, (String)"oldPath");
                Intrinsics.checkNotNullParameter((Object)newPath, (String)"newPath");
                CharSequence charSequence = newPath;
                boolean bl = false;
                if (!(!StringsKt.isBlank((CharSequence)charSequence))) break block1;
                DockerDeploymentConfigurationUtilsKt.setSourceFile(project, dockerRunConfig.getDeployment(), new File(newPath));
                String string = DockerComposeDeploymentSourceType.getInstance().suggestConfigurationName(dockerRunConfig.getDeployment());
                if (string != null) {
                    charSequence = string;
                    bl = false;
                    boolean bl2 = false;
                    CharSequence it = charSequence;
                    boolean bl3 = false;
                    dockerRunConfig.getRunConfiguration().setName((String)it);
                }
            }
        }

        private MainSourceFile() {
        }

        static {
            MainSourceFile mainSourceFile;
            INSTANCE = mainSourceFile = new MainSourceFile();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/docker/deployment/DockerRunConfigurationPathHandler$SecondaryComposeFiles;", "Lcom/intellij/docker/deployment/DockerRunConfigurationPathHandler;", "()V", "getPaths", "", "", "project", "Lcom/intellij/openapi/project/Project;", "dockerRunConfig", "Lcom/intellij/docker/deployment/DockerRunConfig;", "replacePath", "", "oldPath", "newPath", "intellij.clouds.docker"})
    public static final class SecondaryComposeFiles
    extends DockerRunConfigurationPathHandler {
        @NotNull
        public static final SecondaryComposeFiles INSTANCE;

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<String> getPaths(@NotNull Project project, @NotNull DockerRunConfig dockerRunConfig) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dockerRunConfig, (String)"dockerRunConfig");
            Iterable $this$mapNotNull$iv = dockerRunConfig.getDeployment().getSecondarySourceFiles();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String string;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                File file2 = Companion.findDockerFile(project, it);
                if ((file2 != null ? file2.getAbsolutePath() : null) == null) continue;
                string = string;
                boolean bl3 = false;
                boolean bl4 = false;
                String it$iv$iv = string;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void replacePath(@NotNull Project project, @NotNull DockerRunConfig dockerRunConfig, @NotNull String oldPath, @NotNull String newPath) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dockerRunConfig, (String)"dockerRunConfig");
            Intrinsics.checkNotNullParameter((Object)oldPath, (String)"oldPath");
            Intrinsics.checkNotNullParameter((Object)newPath, (String)"newPath");
            if (StringsKt.isBlank((CharSequence)newPath)) {
                return;
            }
            DockerDeploymentConfiguration deployment = dockerRunConfig.getDeployment();
            boolean bl = false;
            List newFilesList = new ArrayList();
            UtilKt.addIfNotNull((List)newFilesList, (Object)DockerDeploymentConfigurationUtilsKt.getSourceFile(project, deployment));
            Iterable iterable = deployment.getSecondarySourceFiles();
            List list = newFilesList;
            boolean $i$f$mapNotNull = false;
            void var9_11 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                File file2;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                String it = (String)element$iv$iv;
                boolean bl3 = false;
                if ((Intrinsics.areEqual((Object)it, (Object)oldPath) ? new File(newPath) : DockerDeploymentConfigurationUtilsKt.getSourceFile(project, it)) == null) continue;
                file2 = file2;
                boolean bl4 = false;
                boolean bl5 = false;
                File it$iv$iv = file2;
                boolean bl6 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list2 = (List)destination$iv$iv;
            list.addAll(list2);
            DockerDeploymentConfigurationUtilsKt.setManySourceFiles(project, deployment, newFilesList);
        }

        private SecondaryComposeFiles() {
        }

        static {
            SecondaryComposeFiles secondaryComposeFiles;
            INSTANCE = secondaryComposeFiles = new SecondaryComposeFiles();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/docker/deployment/DockerRunConfigurationPathHandler$BindMounts;", "Lcom/intellij/docker/deployment/DockerRunConfigurationPathHandler;", "()V", "getPaths", "", "", "project", "Lcom/intellij/openapi/project/Project;", "dockerRunConfig", "Lcom/intellij/docker/deployment/DockerRunConfig;", "replacePath", "", "oldPath", "newPath", "intellij.clouds.docker"})
    public static final class BindMounts
    extends DockerRunConfigurationPathHandler {
        @NotNull
        public static final BindMounts INSTANCE;

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<String> getPaths(@NotNull Project project, @NotNull DockerRunConfig dockerRunConfig) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dockerRunConfig, (String)"dockerRunConfig");
            boolean bl = false;
            List list = new ArrayList();
            boolean bl2 = false;
            boolean bl3 = false;
            List $this$apply = list;
            boolean bl4 = false;
            Iterable iterable = dockerRunConfig.getDeployment().getVolumeBindings();
            List list2 = $this$apply;
            boolean $i$f$mapNotNull = false;
            void var11_12 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String string;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl5 = false;
                DockerVolumeBindingImpl it = (DockerVolumeBindingImpl)element$iv$iv;
                boolean bl6 = false;
                if (it.getHostPath() == null) continue;
                boolean bl7 = false;
                boolean bl8 = false;
                String it$iv$iv = string;
                boolean bl9 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list3 = (List)destination$iv$iv;
            list2.addAll(list3);
            Companion.iterateCliVolumes(dockerRunConfig.getDeployment(), (Function2<? super String, ? super Boolean, Unit>)((Function2)new Function2<String, Boolean, Unit>($this$apply){
                final /* synthetic */ List $this_apply;

                public final void invoke(@NotNull String param, boolean isVolume) {
                    Intrinsics.checkNotNullParameter((Object)param, (String)"param");
                    if (isVolume && StringsKt.contains$default((CharSequence)param, (CharSequence)":", (boolean)false, (int)2, null)) {
                        UtilKt.addIfNotNull((List)this.$this_apply, (Object)StringsKt.substringBefore$default((String)param, (String)":", null, (int)2, null));
                    }
                }
                {
                    this.$this_apply = list;
                    super(2);
                }
            }));
            return list;
        }

        @Override
        public void replacePath(@NotNull Project project, @NotNull DockerRunConfig dockerRunConfig, @NotNull String oldPath, @NotNull String newPath) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dockerRunConfig, (String)"dockerRunConfig");
            Intrinsics.checkNotNullParameter((Object)oldPath, (String)"oldPath");
            Intrinsics.checkNotNullParameter((Object)newPath, (String)"newPath");
            CharSequence charSequence = newPath;
            boolean bl = false;
            if (charSequence.length() > 0) {
                Companion.replaceMountedPath(dockerRunConfig.getDeployment(), oldPath, newPath);
            }
        }

        private BindMounts() {
        }

        static {
            BindMounts bindMounts;
            INSTANCE = bindMounts = new BindMounts();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J$\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000e0\u0011J\u001a\u0010\u0013\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\fR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcom/intellij/docker/deployment/DockerRunConfigurationPathHandler$Companion;", "", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/docker/deployment/DockerRunConfigurationPathHandler;", "getEP_NAME", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "findDockerFile", "Ljava/io/File;", "Lcom/intellij/openapi/project/Project;", "path", "", "iterateCliVolumes", "", "Lcom/intellij/docker/DockerDeploymentConfiguration;", "handler", "Lkotlin/Function2;", "", "replaceMountedPath", "oldPath", "newPath", "intellij.clouds.docker"})
    public static final class Companion {
        @NotNull
        public final ExtensionPointName<DockerRunConfigurationPathHandler> getEP_NAME() {
            return EP_NAME;
        }

        /*
         * WARNING - void declaration
         */
        public final void replaceMountedPath(@NotNull DockerDeploymentConfiguration $this$replaceMountedPath, @NotNull String oldPath, @NotNull String newPath) {
            void changed;
            Intrinsics.checkNotNullParameter((Object)$this$replaceMountedPath, (String)"$this$replaceMountedPath");
            Intrinsics.checkNotNullParameter((Object)oldPath, (String)"oldPath");
            Intrinsics.checkNotNullParameter((Object)newPath, (String)"newPath");
            Iterable $this$forEach$iv = $this$replaceMountedPath.getVolumeBindings();
            boolean $i$f$forEach22 = false;
            for (Object element$iv : $this$forEach$iv) {
                DockerVolumeBindingImpl it = (DockerVolumeBindingImpl)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getHostPath(), (Object)oldPath)) continue;
                it.setHostPath(newPath);
            }
            $i$f$forEach22 = false;
            List newCli = new ArrayList();
            Ref.BooleanRef $i$f$forEach22 = new Ref.BooleanRef();
            $i$f$forEach22.element = false;
            this.iterateCliVolumes($this$replaceMountedPath, (Function2<? super String, ? super Boolean, Unit>)((Function2)new Function2<String, Boolean, Unit>(oldPath, newCli, newPath, (Ref.BooleanRef)changed){
                final /* synthetic */ String $oldPath;
                final /* synthetic */ List $newCli;
                final /* synthetic */ String $newPath;
                final /* synthetic */ Ref.BooleanRef $changed;

                public final void invoke(@NotNull String param, boolean isVolume) {
                    Intrinsics.checkNotNullParameter((Object)param, (String)"param");
                    if (isVolume && StringsKt.startsWith$default((String)param, (String)this.$oldPath, (boolean)false, (int)2, null)) {
                        this.$newCli.add(StringsKt.replace$default((String)param, (String)this.$oldPath, (String)this.$newPath, (boolean)false, (int)4, null));
                        this.$changed.element = true;
                    } else {
                        this.$newCli.add(param);
                    }
                }
                {
                    this.$oldPath = string;
                    this.$newCli = list;
                    this.$newPath = string2;
                    this.$changed = booleanRef;
                    super(2);
                }
            }));
            if (changed.element) {
                $this$replaceMountedPath.setRunCliOptions(CollectionsKt.joinToString$default((Iterable)newCli, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
            }
        }

        public final void iterateCliVolumes(@NotNull DockerDeploymentConfiguration $this$iterateCliVolumes, @NotNull Function2<? super String, ? super Boolean, Unit> handler2) {
            Intrinsics.checkNotNullParameter((Object)$this$iterateCliVolumes, (String)"$this$iterateCliVolumes");
            Intrinsics.checkNotNullParameter(handler2, (String)"handler");
            String string = $this$iterateCliVolumes.getRunCliOptions();
            if (string == null) {
                return;
            }
            String cliOptions = string;
            boolean nextIsVolume = false;
            Iterator iterator = ParametersListUtil.parse((String)cliOptions).iterator();
            boolean bl = false;
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                String next = (String)iterator2.next();
                handler2.invoke((Object)next, (Object)nextIsVolume);
                nextIsVolume = Intrinsics.areEqual((Object)next, (Object)"-v") || Intrinsics.areEqual((Object)next, (Object)"--volume");
            }
        }

        private final File findDockerFile(Project $this$findDockerFile, String path) {
            return DockerDeploymentConfigurationUtilsKt.getSourceFile($this$findDockerFile, path);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

