/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.debug;

import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.agent.settings.DockerAgentContainerInspection;
import com.intellij.docker.debug.DockerContainerWaiter;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.openapi.util.Condition;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.util.ObjectUtils;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class HealthyStatusWaiter
extends DockerContainerWaiter {
    private CompletableFuture<Boolean> myPromise;
    private boolean mySeenRuntime;

    HealthyStatusWaiter(@NotNull ServerConnection<DockerDeploymentConfiguration> connection, @NotNull Condition<? super Deployment> deploymentSearch) {
        if (connection == null) {
            HealthyStatusWaiter.$$$reportNull$$$0(0);
        }
        if (deploymentSearch == null) {
            HealthyStatusWaiter.$$$reportNull$$$0(1);
        }
        super(connection, deploymentSearch);
    }

    @Override
    public Boolean waitForContainer(long timeout, TimeUnit unit) {
        try {
            return this.waitForNotNull(timeout, unit, this::computeDeploymentHealthy);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @Nullable
    private Boolean computeDeploymentHealthy(@NotNull Deployment deployment) {
        DockerApplicationRuntime runtime;
        if (deployment == null) {
            HealthyStatusWaiter.$$$reportNull$$$0(2);
        }
        if ((runtime = (DockerApplicationRuntime)Optional.ofNullable(deployment.getRuntime()).map(o -> (DockerApplicationRuntime)((Object)((Object)ObjectUtils.tryCast((Object)o, DockerApplicationRuntime.class)))).orElse(null)) == null) {
            return this.mySeenRuntime ? Boolean.valueOf(false) : null;
        }
        this.mySeenRuntime = true;
        return this.isHealthyRuntime(runtime);
    }

    @Nullable
    private Boolean isHealthyRuntime(@NotNull DockerApplicationRuntime runtime) {
        if (runtime == null) {
            HealthyStatusWaiter.$$$reportNull$$$0(3);
        }
        if (this.myPromise == null) {
            this.myPromise = runtime.promiseInspect().thenApply(inspect2 -> {
                Boolean result2 = null;
                if (inspect2 != null && (result2 = HealthyStatusWaiter.processInspection(inspect2)) != Boolean.TRUE) {
                    this.myPromise = null;
                }
                return result2;
            });
        }
        return this.myPromise.isDone() ? HealthyStatusWaiter.valueOrNull(this.myPromise) : null;
    }

    @Nullable
    private static Boolean valueOrNull(@Nullable CompletableFuture<Boolean> promise) {
        try {
            return promise != null && promise.isDone() ? (Boolean)promise.getNow(null) : null;
        }
        catch (CancellationException | CompletionException e) {
            return null;
        }
    }

    @Nullable
    private static Boolean processInspection(@Nullable DockerAgentContainerInspection inspection) {
        String status = Optional.ofNullable(inspection).map(DockerAgentContainerInspection::getHealthStatus).orElse(null);
        if (status == null) {
            return null;
        }
        if ("healthy".equals(status)) {
            return true;
        }
        if ("unhealthy".equals(status)) {
            return false;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deploymentSearch";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deployment";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runtime";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/debug/HealthyStatusWaiter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "computeDeploymentHealthy";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isHealthyRuntime";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

