/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.debug;

import com.intellij.DynamicBundle;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.debug.DockerBeforeRunTask;
import com.intellij.docker.debug.DockerRunConfigurationUtils;
import com.intellij.docker.deploymentSource.DockerComposeDeploymentSourceType;
import com.intellij.docker.deploymentSource.DockerFileDeploymentSourceType;
import com.intellij.docker.deploymentSource.DockerImageDeploymentSourceType;
import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.configuration.deployment.SingletonDeploymentSourceType;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DockerRunConfigurationPanel {
    private static final String CHOOSE_SERVICE = "";
    private final Project myProject;
    private ComboBox myRunConfigCombo;
    private ComboBox myServiceCombo;
    private JPanel myPanel;
    private JBLabel myServiceLabel;

    DockerRunConfigurationPanel(@NotNull Project project) {
        if (project == null) {
            DockerRunConfigurationPanel.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.$$$setupUI$$$();
        this.getServiceCombo().attachLabel((JLabel)this.myServiceLabel);
    }

    JPanel getPanel() {
        return this.myPanel;
    }

    private DockerRunConfigCombo getRunConfigCombo() {
        return (DockerRunConfigCombo)this.myRunConfigCombo;
    }

    private ComposeServiceCombo getServiceCombo() {
        return (ComposeServiceCombo)this.myServiceCombo;
    }

    void addActionListener(@NotNull ActionListener listener) {
        if (listener == null) {
            DockerRunConfigurationPanel.$$$reportNull$$$0(1);
        }
        this.getServiceCombo().addActionListener(listener);
        this.getRunConfigCombo().getComboBox().addActionListener(listener);
    }

    @Nullable
    DockerBeforeRunTask.TargetRunConfig getTargetRunConfig() {
        DockerBeforeRunTask.TargetRunConfig selectedRunConfig = this.getRunConfigCombo().getSelection();
        if (selectedRunConfig == null) {
            return null;
        }
        if (selectedRunConfig instanceof DockerBeforeRunTask.TargetContainerRunConfig) {
            return selectedRunConfig;
        }
        assert (selectedRunConfig instanceof DockerBeforeRunTask.TargetComposeRunConfig);
        DockerBeforeRunTask.TargetComposeRunConfig template = (DockerBeforeRunTask.TargetComposeRunConfig)selectedRunConfig;
        String serviceName = this.getServiceCombo().getSelectedService();
        return serviceName == null ? null : template.createWithServiceName(serviceName);
    }

    void resetFrom(@NotNull DockerBeforeRunTask task2) {
        if (task2 == null) {
            DockerRunConfigurationPanel.$$$reportNull$$$0(2);
        }
        DockerBeforeRunTask.TargetRunConfig targetRunConfig = task2.getTargetRunConfig();
        this.getRunConfigCombo().selectRunConfig(targetRunConfig);
        this.getServiceCombo().resetFrom(targetRunConfig);
    }

    private void createUIComponents() {
        this.myRunConfigCombo = new DockerRunConfigCombo(this.myProject);
        this.myServiceCombo = new ComposeServiceCombo();
        this.getRunConfigCombo().getComboBox().addActionListener(e -> this.getServiceCombo().resetFrom(this.getRunConfigCombo().getSelection()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/debug/DockerRunConfigurationPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addActionListener";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "resetFrom";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/DockerBundle", DockerRunConfigurationPanel.class).getString("DockerRunConfigurationPanel.configuration.text"));
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        ComboBox comboBox2 = this.myRunConfigCombo;
        jPanel.add((Component)comboBox2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myServiceLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/DockerBundle", DockerRunConfigurationPanel.class).getString("DockerRunConfigurationPanel.service.text"));
        jPanel.add((Component)jBLabel, new GridConstraints(0, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        ComboBox comboBox3 = this.myServiceCombo;
        jPanel.add((Component)comboBox3, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 0, null, null, null));
        jBLabel2.setLabelFor((Component)comboBox2);
        jBLabel.setLabelFor((Component)comboBox3);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    static class ComposeServiceCombo
    extends ComboBox<String> {
        private JLabel myAttachedLabel;

        ComposeServiceCombo() {
            super((ComboBoxModel)new CollectionComboBoxModel(), 200);
            this.setEditable(false);
        }

        void attachLabel(JLabel label) {
            this.myAttachedLabel = label;
        }

        public CollectionComboBoxModel<String> getModel() {
            return (CollectionComboBoxModel)super.getModel();
        }

        public void resetFrom(@Nullable DockerBeforeRunTask.TargetRunConfig targetRunConfig) {
            this.getModel().removeAll();
            if (targetRunConfig instanceof DockerBeforeRunTask.TargetComposeRunConfig) {
                this.setEnabled(true);
                DockerBeforeRunTask.TargetComposeRunConfig targetImpl = (DockerBeforeRunTask.TargetComposeRunConfig)targetRunConfig;
                List<String> serviceNames = targetImpl.getAllServices();
                this.getModel().add(serviceNames);
                @NlsSafe String selectedService = targetImpl.getServiceName();
                this.setSelectedItem(StringUtil.isEmpty((String)selectedService) ? ContainerUtil.getFirstItem(serviceNames) : selectedService);
            } else {
                this.setSelectedItem(null);
                this.setEnabled(false);
            }
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            if (this.myAttachedLabel != null) {
                this.myAttachedLabel.setEnabled(enabled);
            }
        }

        public String getSelectedService() {
            return (String)this.getSelectedItem();
        }
    }

    static class DockerRunConfigCombo
    extends ComboBox<DockerBeforeRunTask.TargetRunConfig> {
        private final CollectionComboBoxModel<DockerBeforeRunTask.TargetRunConfig> myListModel;

        DockerRunConfigCombo(@NotNull Project project) {
            if (project == null) {
                DockerRunConfigCombo.$$$reportNull$$$0(0);
            }
            this.myListModel = new CollectionComboBoxModel();
            RunManager runManager = RunManager.getInstance((Project)project);
            for (RunConfiguration next : runManager.getConfigurationsList((ConfigurationType)DockerCloudType.getRunConfigurationType())) {
                assert (next instanceof DeployToServerRunConfiguration) : "unexpected docker run config: " + next;
                this.myListModel.add((Object)DockerRunConfigCombo.wrapDockerRunConfig((DeployToServerRunConfiguration)next));
            }
            this.myListModel.add((Object)null);
            this.getComboBox().setModel((ComboBoxModel<DockerBeforeRunTask.TargetRunConfig>)this.myListModel);
            this.getComboBox().setRenderer((ListCellRenderer<DockerBeforeRunTask.TargetRunConfig>)SimpleListCellRenderer.create((label, value, index) -> {
                if (value == null) {
                    return;
                }
                DeployToServerRunConfiguration<?, ?> runConfig = value.getDockerRunConfig();
                label.setIcon(DockerRunConfigurationUtils.getRunConfigurationIcon(runConfig));
                label.setText(runConfig.getName());
            }));
        }

        private JComboBox<DockerBeforeRunTask.TargetRunConfig> getComboBox() {
            return this;
        }

        void selectRunConfig(@Nullable DockerBeforeRunTask.TargetRunConfig target) {
            DockerBeforeRunTask.TargetRunConfig toSelect = target == null ? (DockerBeforeRunTask.TargetRunConfig)ContainerUtil.getFirstItem((List)this.myListModel.getItems()) : (DockerBeforeRunTask.TargetRunConfig)this.myListModel.getItems().stream().filter(that -> that.getDockerRunConfig() == target.getDockerRunConfig()).findFirst().orElse(null);
            this.getComboBox().setSelectedItem(toSelect);
        }

        @Nullable
        DockerBeforeRunTask.TargetRunConfig getSelection() {
            return (DockerBeforeRunTask.TargetRunConfig)this.myListModel.getSelectedItem();
        }

        @Nullable
        private static DockerBeforeRunTask.TargetRunConfig wrapDockerRunConfig(@Nullable DeployToServerRunConfiguration<?, ?> runConfig) {
            if (runConfig == null) {
                return null;
            }
            SingletonDeploymentSourceType sourceType = DockerRunConfigurationUtils.getDeploymentSourceType(runConfig);
            if (DockerComposeDeploymentSourceType.getInstance() == sourceType) {
                return new DockerBeforeRunTask.TargetComposeRunConfig(runConfig, DockerRunConfigurationPanel.CHOOSE_SERVICE);
            }
            if (DockerImageDeploymentSourceType.getInstance() == sourceType || DockerFileDeploymentSourceType.getInstance() == sourceType) {
                return new DockerBeforeRunTask.TargetContainerRunConfig(runConfig);
            }
            throw new IllegalStateException("Unexpected run config: " + runConfig);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/docker/debug/DockerRunConfigurationPanel$DockerRunConfigCombo", "<init>"));
        }
    }
}

