/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.debug;

import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.openapi.util.Condition;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class DockerContainerWaiter {
    private final ServerConnection<DockerDeploymentConfiguration> myConnection;
    private final Condition<? super Deployment> myDeploymentSearch;

    DockerContainerWaiter(@NotNull ServerConnection<DockerDeploymentConfiguration> connection, @NotNull Condition<? super Deployment> deploymentSearch) {
        if (connection == null) {
            DockerContainerWaiter.$$$reportNull$$$0(0);
        }
        if (deploymentSearch == null) {
            DockerContainerWaiter.$$$reportNull$$$0(1);
        }
        this.myConnection = connection;
        this.myDeploymentSearch = deploymentSearch;
    }

    @NotNull
    protected ServerConnection<DockerDeploymentConfiguration> getConnection() {
        ServerConnection<DockerDeploymentConfiguration> serverConnection = this.myConnection;
        if (serverConnection == null) {
            DockerContainerWaiter.$$$reportNull$$$0(2);
        }
        return serverConnection;
    }

    public abstract Boolean waitForContainer(long var1, TimeUnit var3);

    @Nullable
    protected Deployment findDeployment() {
        Collection deployments2 = this.myConnection.getDeployments();
        return (Deployment)ContainerUtil.find((Iterable)deployments2, this.myDeploymentSearch);
    }

    @Nullable
    protected final <R> R waitForNotNull(long timeout, TimeUnit unit, Function<Deployment, R> computation) throws InterruptedException {
        long start = System.currentTimeMillis();
        long end = start + unit.toMillis(timeout);
        boolean seenDeployment = false;
        do {
            Deployment deployment = this.findDeployment();
            if (seenDeployment && deployment == null) {
                return null;
            }
            if (deployment != null) {
                seenDeployment = true;
                R result2 = computation.apply(deployment);
                if (result2 != null) {
                    return result2;
                }
            }
            if (System.currentTimeMillis() >= end) continue;
            TimeUnit.MILLISECONDS.sleep(1000L);
        } while (System.currentTimeMillis() < end);
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deploymentSearch";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/debug/DockerContainerWaiter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/debug/DockerContainerWaiter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

