/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.debug;

import com.intellij.docker.debug.DockerBeforeRunTask;
import com.intellij.docker.debug.DockerRunConfigurationPanel;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.remoteDebug.RemotePortRequest;
import com.intellij.docker.remoteDebug.RemoteServerRequestAdapterFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.util.Column;
import com.intellij.remoteServer.util.JTableWrapper;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.FormBuilder;
import java.awt.Dimension;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerBeforeRunTaskUI {
    static final Logger LOG = Logger.getInstance(DockerBeforeRunTaskUI.class);
    private final DockerBeforeRunTask myInputTask;
    private final DockerRunConfigurationPanel myTopRow;
    private final ExpandableTextField myCommandTextField;
    private final JTextField myOptionsTextField;
    private final JCheckBox myWaitForHealthCheck;
    private final RemoteServerRequestAdapterFactory myRunConfigurationAdapter;
    private final JPanel myPortsTablePanel;
    private final JTableWrapper<RemotePortRequest, ColumnBase> myTableWrapper;

    public DockerBeforeRunTaskUI(@NotNull Project project, @NotNull RemoteServerRequestAdapterFactory runConfigurationAdapter, @NotNull DockerBeforeRunTask task2) {
        if (project == null) {
            DockerBeforeRunTaskUI.$$$reportNull$$$0(0);
        }
        if (runConfigurationAdapter == null) {
            DockerBeforeRunTaskUI.$$$reportNull$$$0(1);
        }
        if (task2 == null) {
            DockerBeforeRunTaskUI.$$$reportNull$$$0(2);
        }
        this.myInputTask = task2;
        this.myRunConfigurationAdapter = runConfigurationAdapter;
        this.myTopRow = new DockerRunConfigurationPanel(project);
        this.myTopRow.addActionListener(e -> this.onTopRowChanged(this.myTopRow.getTargetRunConfig()));
        this.myCommandTextField = new ExpandableTextField();
        this.myCommandTextField.setColumns(0);
        this.myOptionsTextField = new JBTextField();
        this.myOptionsTextField.setEditable(false);
        this.myWaitForHealthCheck = new JBCheckBox(DockerBundle.message("checkbox.wait.for.healthcheck", new Object[0]));
        JBTable portsTable = new JBTable();
        portsTable.setShowColumns(true);
        this.myTableWrapper = new JTableWrapper(portsTable, (Column[])new ColumnBase[]{new DescriptionColumn(), new LocalPortColumn(), new ContainerPortColumn()});
        this.myPortsTablePanel = ToolbarDecorator.createDecorator((JTable)portsTable).createPanel();
        this.myPortsTablePanel.setPreferredSize(new Dimension(-1, 300));
    }

    @Nullable
    private String computeOptions() {
        String result2 = this.myInputTask.getPortMappings().stream().map(mapping -> "-p " + mapping.getLocalPort() + ":" + mapping.getEffectiveRemotePort()).collect(Collectors.joining(" "));
        return StringUtil.nullize((String)result2, (boolean)true);
    }

    public void applyTo(@NotNull DockerBeforeRunTask task2) {
        if (task2 == null) {
            DockerBeforeRunTaskUI.$$$reportNull$$$0(3);
        }
        DockerBeforeRunTask.TargetRunConfig targetRunConfig = this.myTopRow.getTargetRunConfig();
        task2.setTargetRunConfig(targetRunConfig);
        task2.setWaitForHealthCheck(this.myWaitForHealthCheck.isSelected());
        task2.setCustomCommand(this.getStorableCommand(targetRunConfig));
    }

    public void resetFrom() {
        this.myTopRow.resetFrom(this.myInputTask);
        this.myWaitForHealthCheck.setSelected(this.myInputTask.isWaitForHealthCheck());
        this.myTableWrapper.setInputRows(this.myInputTask.getPortMappings());
        this.refreshOptionsAndCommand(this.myInputTask.getTargetRunConfig(), this.myInputTask.getCustomCommand());
    }

    public JPanel createUI() {
        FormBuilder builder = FormBuilder.createFormBuilder();
        builder.addComponent((JComponent)this.myTopRow.getPanel());
        builder.addLabeledComponentFillVertically(DockerBundle.message("DockerBeforeRunTaskUI.ports.table.title", new Object[0]), (JComponent)this.myPortsTablePanel);
        builder.addLabeledComponent(DockerBundle.message("DockerBeforeRunTaskUI.command.field.title", new Object[0]), (JComponent)this.myCommandTextField);
        builder.addLabeledComponent(DockerBundle.message("DockerBeforeRunTaskUI.options.field.title", new Object[0]), (JComponent)this.myOptionsTextField);
        builder.addComponent((JComponent)this.myWaitForHealthCheck);
        return builder.getPanel();
    }

    private void onTopRowChanged(@Nullable DockerBeforeRunTask.TargetRunConfig targetRunConfig) {
        String customCommand = Objects.equals(targetRunConfig, this.myInputTask.getTargetRunConfig()) ? this.myInputTask.getCustomCommand() : null;
        this.refreshOptionsAndCommand(targetRunConfig, customCommand);
    }

    private void refreshOptionsAndCommand(@Nullable DockerBeforeRunTask.TargetRunConfig targetRunConfig, @Nullable String customCommand) {
        String autoCommand;
        String computedOptions = this.computeOptions();
        this.myOptionsTextField.setText(computedOptions);
        String command = !StringUtil.isEmptyOrSpaces((String)customCommand) ? customCommand : (StringUtil.isEmptyOrSpaces((String)(autoCommand = this.computeAutoAdjustedCommand(targetRunConfig))) ? null : autoCommand);
        this.myCommandTextField.setText(command);
    }

    private String computeAutoAdjustedCommand(@Nullable DockerBeforeRunTask.TargetRunConfig targetRunConfig) {
        return targetRunConfig == null ? null : targetRunConfig.getAutoAdjustedCommand(this.myRunConfigurationAdapter, this.myInputTask.getRequest());
    }

    private String getStorableCommand(@Nullable DockerBeforeRunTask.TargetRunConfig targetRunConfig) {
        String autoCommand;
        String actualCommand = this.myCommandTextField.getText();
        return DockerBeforeRunTaskUI.isTheSameCommand(actualCommand, autoCommand = this.computeAutoAdjustedCommand(targetRunConfig)) ? null : actualCommand;
    }

    private static boolean isTheSameCommand(@Nullable String commandA, @Nullable String commandB) {
        if (StringUtil.isEmptyOrSpaces((String)commandA) || StringUtil.isEmptyOrSpaces((String)commandB)) {
            return StringUtil.isEmptyOrSpaces((String)commandA) && StringUtil.isEmptyOrSpaces((String)commandB);
        }
        return commandA.trim().equals(commandB.trim());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfigurationAdapter";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/debug/DockerBeforeRunTaskUI";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "applyTo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class ContainerPortColumn
    extends ColumnBase {
        ContainerPortColumn() {
            super(DockerBundle.message("DockerBeforeRunTaskUI.ContainerPortColumn.title", new Object[0]));
        }

        public Object getColumnValue(RemotePortRequest row) {
            int value = row.getRemotePort();
            if (value == -1) {
                value = row.getLocalPort();
            }
            return String.valueOf(value);
        }

        public boolean isEditable() {
            return true;
        }

        public void setColumnValue(RemotePortRequest row, Object object) {
            int intValue;
            String text2 = (String)object;
            if (StringUtil.isEmptyOrSpaces((String)text2)) {
                intValue = -1;
            } else {
                intValue = Integer.parseInt(text2);
                if (intValue == row.getLocalPort()) {
                    intValue = -1;
                }
            }
            row.setRemotePort(intValue);
            DockerBeforeRunTaskUI.this.refreshOptionsAndCommand(DockerBeforeRunTaskUI.this.myTopRow.getTargetRunConfig(), DockerBeforeRunTaskUI.this.myCommandTextField.getText());
        }
    }

    private static class LocalPortColumn
    extends ColumnBase {
        LocalPortColumn() {
            super(DockerBundle.message("DockerBeforeRunTaskUI.LocalPortColumn.title", new Object[0]));
        }

        public Object getColumnValue(RemotePortRequest row) {
            return String.valueOf(row.getLocalPort());
        }

        public boolean isEditable() {
            return false;
        }
    }

    private static class DescriptionColumn
    extends ColumnBase {
        DescriptionColumn() {
            super(DockerBundle.message("DockerBeforeRunTaskUI.DescriptionColumn.title", new Object[0]));
        }

        public Object getColumnValue(RemotePortRequest row) {
            return row.getPresentableDescription();
        }
    }

    private static abstract class ColumnBase
    extends Column<RemotePortRequest> {
        ColumnBase(@Nls String name) {
            super(name);
        }
    }
}

