/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.conversion;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ConversionProcessor;
import com.intellij.conversion.ProjectConverter;
import com.intellij.conversion.RunManagerSettings;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

final class DockerRunConfigurationConverter
extends ProjectConverter {
    private static final String TAG_DEPLOYMENT = "deployment";
    private static final String ATTR_FACTORYNAME = "factoryName";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_PATH = "path";

    DockerRunConfigurationConverter() {
    }

    @NotNull
    public ConversionProcessor<RunManagerSettings> createRunConfigurationsConverter() {
        return new ConversionProcessor<RunManagerSettings>(){

            public boolean isConversionNeeded(RunManagerSettings settings) {
                return settings.getRunConfigurations().stream().anyMatch(x$0 -> DockerRunConfigurationConverter.isDocker172RunConfigurationElement(x$0));
            }

            public void process(RunManagerSettings settings) throws CannotConvertException {
                settings.getRunConfigurations().stream().filter(x$0 -> DockerRunConfigurationConverter.isDocker172RunConfigurationElement(x$0)).forEach(x$0 -> DockerRunConfigurationConverter.convertDocker172RunConfigurationElement(x$0));
            }
        };
    }

    private static boolean isDocker172RunConfigurationElement(Element element) {
        return "docker-deploy".equals(element.getAttributeValue(ATTR_TYPE)) && "Docker Deployment".equals(element.getAttributeValue(ATTR_FACTORYNAME)) && element.getChild(TAG_DEPLOYMENT) != null;
    }

    private static void convertDocker172RunConfigurationElement(Element runConfig) {
        String path;
        Element deployment = runConfig.getChild(TAG_DEPLOYMENT);
        assert (deployment != null);
        String deploymentType = deployment.getAttributeValue(ATTR_TYPE);
        if (deploymentType != null) {
            runConfig.setAttribute(ATTR_FACTORYNAME, deploymentType);
        }
        if ((path = deployment.getAttributeValue(ATTR_PATH)) != null) {
            deployment.removeAttribute(ATTR_PATH);
            Element settings = DockerRunConfigurationConverter.findOrCreateChild(deployment, "settings");
            settings.addContent(new Element("option").setAttribute("name", "sourceFilePath").setAttribute("value", path));
        }
    }

    @NotNull
    private static Element findOrCreateChild(@NotNull Element parent, @NotNull String tag2) {
        Element result2;
        if (parent == null) {
            DockerRunConfigurationConverter.$$$reportNull$$$0(0);
        }
        if (tag2 == null) {
            DockerRunConfigurationConverter.$$$reportNull$$$0(1);
        }
        if ((result2 = parent.getChild(tag2)) == null) {
            result2 = new Element(tag2);
        }
        Element element = result2;
        if (element == null) {
            DockerRunConfigurationConverter.$$$reportNull$$$0(2);
        }
        return element;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/conversion/DockerRunConfigurationConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/conversion/DockerRunConfigurationConverter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateChild";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateChild";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

