/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.composeFile.model;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.docker.agent.settings.DockerPortSpec;
import com.intellij.docker.composeFile.i18n.DockerComposeBundle;
import com.intellij.docker.composeFile.model.ComposeScalarType;
import com.intellij.docker.composeFile.model.PortScalarType;
import com.intellij.docker.ui.validation.UiValidationUtilsKt;
import com.intellij.psi.PsiElement;
import com.intellij.util.text.StringKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLScalar;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000b\u001a\u0004\u0018\u00010\n*\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/docker/composeFile/model/PortScalarType;", "Lcom/intellij/docker/composeFile/model/ComposeScalarType;", "()V", "doValidateScalarValue", "", "scalarValue", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "toDockerPortSpec", "Lcom/intellij/docker/agent/settings/DockerPortSpec;", "asDockerPortSpec", "", "intellij.clouds.docker.compose"})
public final class PortScalarType
extends ComposeScalarType {
    @Override
    protected void doValidateScalarValue(@NotNull YAMLScalar scalarValue, @NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)scalarValue, (String)"scalarValue");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        String string = scalarValue.getTextValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"scalarValue.textValue");
        String text2 = string;
        if (StringsKt.contains$default((CharSequence)text2, (CharSequence)" ", (boolean)false, (int)2, null)) {
            holder.registerProblem((PsiElement)scalarValue, DockerComposeBundle.message("PortScalarType.spaces.not.allowed", new Object[0]), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
            return;
        }
        DockerPortSpec spec = this.asDockerPortSpec(text2);
        if (spec == null) {
            holder.registerProblem((PsiElement)scalarValue, DockerComposeBundle.message("PortScalarType.ports.mapping.expected", new Object[0]), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
        } else {
            doValidateScalarValue.1 $fun$isValidPortRange$1;
            String hostIP;
            String protocol = spec.getContainerSpec().getProtocol();
            if (!CollectionsKt.listOf((Object[])new String[]{"tcp", "udp", "sctp"}).contains(protocol)) {
                holder.registerProblem((PsiElement)scalarValue, DockerComposeBundle.message("PortScalarType.not.valid.internet.protocol", protocol), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
            }
            if ((hostIP = StringKt.nullize((String)spec.getLocalSpec().getHostIP(), (boolean)true)) != null && !UiValidationUtilsKt.isIP(hostIP)) {
                holder.registerProblem((PsiElement)scalarValue, DockerComposeBundle.message("PortScalarType.not.valid.host.ip", hostIP), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
            }
            if (!($fun$isValidPortRange$1 = doValidateScalarValue.1.INSTANCE).invoke(spec.getLocalSpec().getPortRange()) || !$fun$isValidPortRange$1.invoke(spec.getContainerSpec().getPortsRange())) {
                holder.registerProblem((PsiElement)scalarValue, DockerComposeBundle.message("PortScalarType.not.valid.port.range", new Object[0]), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
            }
        }
    }

    @Nullable
    public final DockerPortSpec toDockerPortSpec(@NotNull YAMLScalar scalarValue) {
        Intrinsics.checkNotNullParameter((Object)scalarValue, (String)"scalarValue");
        String string = scalarValue.getTextValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"scalarValue.textValue");
        return this.asDockerPortSpec(string);
    }

    private final DockerPortSpec asDockerPortSpec(String $this$asDockerPortSpec) {
        Object object;
        boolean bl = false;
        try {
            object = Result.Companion;
            boolean bl2 = false;
            DockerPortSpec dockerPortSpec = DockerPortSpec.Companion.fromRawString($this$asDockerPortSpec);
            boolean bl3 = false;
            object = Result.constructor-impl((Object)dockerPortSpec);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl4 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Result.Companion companion = object;
        boolean bl5 = false;
        return (DockerPortSpec)(Result.isFailure-impl((Object)companion) ? null : companion);
    }

    public PortScalarType() {
        super("docker-compose:port");
    }
}

