/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.composeFile.model;

import com.google.common.net.InetAddresses;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.docker.composeFile.i18n.DockerComposeBundle;
import com.intellij.docker.composeFile.model.ComposeScalarType;
import com.intellij.docker.ui.validation.UiValidationUtilsKt;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLScalar;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0010\u0018\u00002\u00020\u0001:\u0002\t\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\u000b"}, d2={"Lcom/intellij/docker/composeFile/model/IPType;", "Lcom/intellij/docker/composeFile/model/ComposeScalarType;", "()V", "doValidateScalarValue", "", "scalarValue", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "V4", "V6", "intellij.clouds.docker.compose"})
public class IPType
extends ComposeScalarType {
    @Override
    protected void doValidateScalarValue(@NotNull YAMLScalar scalarValue, @NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)scalarValue, (String)"scalarValue");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (!InetAddresses.isInetAddress((String)scalarValue.getTextValue())) {
            holder.registerProblem((PsiElement)scalarValue, DockerComposeBundle.message("IPType.ip.value.expected", new Object[0]), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
        }
    }

    public IPType() {
        super("docker-compose:IP");
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lcom/intellij/docker/composeFile/model/IPType$V4;", "Lcom/intellij/docker/composeFile/model/IPType;", "()V", "doValidateScalarValue", "", "scalarValue", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "intellij.clouds.docker.compose"})
    public static final class V4
    extends IPType {
        @Override
        protected void doValidateScalarValue(@NotNull YAMLScalar scalarValue, @NotNull ProblemsHolder holder) {
            Intrinsics.checkNotNullParameter((Object)scalarValue, (String)"scalarValue");
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            String string = scalarValue.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"scalarValue.text");
            if (!UiValidationUtilsKt.isIPv4(string)) {
                holder.registerProblem((PsiElement)scalarValue, DockerComposeBundle.message("IPType.ipv4.value.expected", new Object[0]), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lcom/intellij/docker/composeFile/model/IPType$V6;", "Lcom/intellij/docker/composeFile/model/IPType;", "()V", "doValidateScalarValue", "", "scalarValue", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "intellij.clouds.docker.compose"})
    public static final class V6
    extends IPType {
        @Override
        protected void doValidateScalarValue(@NotNull YAMLScalar scalarValue, @NotNull ProblemsHolder holder) {
            Intrinsics.checkNotNullParameter((Object)scalarValue, (String)"scalarValue");
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            String string = scalarValue.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"scalarValue.text");
            if (!UiValidationUtilsKt.isIPv6(string)) {
                holder.registerProblem((PsiElement)scalarValue, DockerComposeBundle.message("IPType.ipv6.value.expected", new Object[0]), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
            }
        }
    }
}

