/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.composeFile.model;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.docker.composeFile.i18n.DockerComposeBundle;
import com.intellij.docker.composeFile.model.ComposeScalarType;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLScalar;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lcom/intellij/docker/composeFile/model/DurationType;", "Lcom/intellij/docker/composeFile/model/ComposeScalarType;", "()V", "doValidateScalarValue", "", "scalarValue", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "Companion", "intellij.clouds.docker.compose"})
public final class DurationType
extends ComposeScalarType {
    private static final Regex DURATION_PATTERN;
    @NotNull
    public static final Companion Companion;

    @Override
    protected void doValidateScalarValue(@NotNull YAMLScalar scalarValue, @NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)scalarValue, (String)"scalarValue");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        String string = scalarValue.getTextValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"scalarValue.textValue");
        if (!DURATION_PATTERN.matches((CharSequence)string)) {
            holder.registerProblem((PsiElement)scalarValue, DockerComposeBundle.message("DurationType.duration.value.expected", scalarValue.getTextValue()), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
        }
    }

    public DurationType() {
        super("docker-compose:duration");
    }

    static {
        Companion = new Companion(null);
        String string = "^((\\d+(\\.\\d)?h)?(\\d+(\\.\\d)?m)?(\\d+(\\.\\d)?s)?(\\d+(\\.\\d)?ms)?(\\d+(\\.\\d)?us)?)$";
        boolean bl = false;
        DURATION_PATTERN = new Regex(string);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/docker/composeFile/model/DurationType$Companion;", "", "()V", "DURATION_PATTERN", "Lkotlin/text/Regex;", "intellij.clouds.docker.compose"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

