/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.composeFile.model;

import com.intellij.docker.composeFile.ComposeFilePathReferenceProvider;
import com.intellij.openapi.paths.PathReferenceManager;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.meta.model.YamlReferenceType;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLScalar;

class DockerfileReferenceType
extends YamlReferenceType {
    DockerfileReferenceType(String typeName) {
        super(typeName);
    }

    public PsiReference @NotNull [] getReferencesFromValue(@NotNull YAMLScalar valueScalar) {
        Optional<YAMLKeyValue> buildKeyValue;
        YAMLMapping buildMapping;
        if (valueScalar == null) {
            DockerfileReferenceType.$$$reportNull$$$0(0);
        }
        if ((buildMapping = (YAMLMapping)(buildKeyValue = Optional.of(valueScalar).map(DockerfileReferenceType::getParentKeyValue).map(DockerfileReferenceType::getParentKeyValue).filter(kv -> "build".equals(kv.getKeyText().trim()))).map(YAMLKeyValue::getValue).map(val -> (YAMLMapping)ObjectUtils.tryCast((Object)val, YAMLMapping.class)).orElse(null)) == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                DockerfileReferenceType.$$$reportNull$$$0(1);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PathReferenceManager manager = PathReferenceManager.getInstance();
        PsiReference[] psiReferenceArray = manager.createCustomReferences((PsiElement)valueScalar, true, new PathReferenceProvider[]{new ComposeFilePathReferenceProvider().withDefaultPathEvaluator(file2 -> DockerfileReferenceType.evaluateDefaultPath(file2, buildMapping))});
        if (psiReferenceArray == null) {
            DockerfileReferenceType.$$$reportNull$$$0(2);
        }
        return psiReferenceArray;
    }

    private static Collection<PsiFileSystemItem> evaluateDefaultPath(PsiFile file2, YAMLMapping buildMapping) {
        PsiManager psiManager = file2.getManager();
        PsiDirectory currentFolder = file2.getOriginalFile().getParent();
        if (currentFolder == null) {
            return Collections.emptyList();
        }
        String buildContext = Optional.ofNullable(buildMapping.getKeyValueByKey("context")).map(YAMLKeyValue::getValue).map(psi -> (YAMLScalar)ObjectUtils.tryCast((Object)psi, YAMLScalar.class)).map(YAMLScalar::getTextValue).map(String::trim).orElse(null);
        if (buildContext == null || ".".equals(buildContext)) {
            return Collections.singletonList(currentFolder);
        }
        return Optional.ofNullable(DockerfileReferenceType.resolveIfExists(currentFolder.getVirtualFile(), buildContext)).filter(VirtualFile::isDirectory).map(arg_0 -> ((PsiManager)psiManager).findDirectory(arg_0)).map(Collections::singletonList).orElse(Collections.singletonList(currentFolder));
    }

    @Nullable
    private static VirtualFile resolveIfExists(@NotNull VirtualFile base, @NotNull String path) {
        File mayBeAbsolute;
        if (base == null) {
            DockerfileReferenceType.$$$reportNull$$$0(3);
        }
        if (path == null) {
            DockerfileReferenceType.$$$reportNull$$$0(4);
        }
        if ((mayBeAbsolute = new File(path)).isAbsolute() && mayBeAbsolute.exists()) {
            return VfsUtil.findFileByIoFile((File)mayBeAbsolute, (boolean)false);
        }
        return VfsUtilCore.findRelativeFile((String)path, (VirtualFile)base);
    }

    @Nullable
    private static YAMLKeyValue getParentKeyValue(@NotNull PsiElement psi) {
        if (psi == null) {
            DockerfileReferenceType.$$$reportNull$$$0(5);
        }
        return (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)psi, YAMLKeyValue.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueScalar";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/composeFile/model/DockerfileReferenceType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/composeFile/model/DockerfileReferenceType";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesFromValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesFromValue";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveIfExists";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getParentKeyValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

