/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.composeFile;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.docker.agent.settings.DockerPortSpec;
import com.intellij.docker.composeFile.ComposeInspectionHelper;
import com.intellij.docker.composeFile.i18n.DockerComposeBundle;
import com.intellij.docker.composeFile.model.PortScalarType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeInspectionBase;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.meta.model.YamlComposedTypeBase;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLQuotedText;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;
import org.jetbrains.yaml.psi.impl.YAMLQuotedTextImpl;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0017\u0010\u000b\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b\f2\u0006\u0010\u0007\u001a\u00020\bH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/docker/composeFile/ComposeUnquotedPortsInspection;", "Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeInspectionBase;", "()V", "helper", "Lcom/intellij/docker/composeFile/ComposeInspectionHelper;", "doBuildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "metaTypeProvider", "Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeProvider;", "getMetaTypeProvider", "Lorg/jetbrains/annotations/Nullable;", "PortsChecker", "intellij.clouds.docker.compose"})
public final class ComposeUnquotedPortsInspection
extends YamlMetaTypeInspectionBase {
    private final ComposeInspectionHelper helper = new ComposeInspectionHelper();

    @Nullable
    protected YamlMetaTypeProvider getMetaTypeProvider(@NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return this.helper.getMetaTypeProvider(holder);
    }

    @NotNull
    protected PsiElementVisitor doBuildVisitor(@NotNull ProblemsHolder holder, @NotNull YamlMetaTypeProvider metaTypeProvider) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)metaTypeProvider, (String)"metaTypeProvider");
        return (PsiElementVisitor)new PortsChecker(holder, metaTypeProvider);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000e\u000fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u000e\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/composeFile/ComposeUnquotedPortsInspection$PortsChecker;", "Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeInspectionBase$SimpleYamlPsiVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "metaTypeProvider", "Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeProvider;", "(Lcom/intellij/codeInspection/ProblemsHolder;Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeProvider;)V", "visitYAMLSequenceItem", "", "item", "Lorg/jetbrains/yaml/psi/YAMLSequenceItem;", "fieldAndType", "Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeProvider$MetaTypeProxy;", "Lorg/jetbrains/yaml/psi/YAMLValue;", "AddQuoteQuickFix", "Companion", "intellij.clouds.docker.compose"})
    private static final class PortsChecker
    extends YamlMetaTypeInspectionBase.SimpleYamlPsiVisitor {
        private final ProblemsHolder holder;
        private final YamlMetaTypeProvider metaTypeProvider;
        @NotNull
        public static final Companion Companion = new Companion(null);

        protected void visitYAMLSequenceItem(@NotNull YAMLSequenceItem item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            YAMLValue yAMLValue = item.getValue();
            if (!(yAMLValue instanceof YAMLScalar)) {
                yAMLValue = null;
            }
            YAMLScalar yAMLScalar = (YAMLScalar)yAMLValue;
            if (yAMLScalar == null) {
                return;
            }
            YAMLScalar value = yAMLScalar;
            if (value instanceof YAMLQuotedText) {
                return;
            }
            Object object = this.fieldAndType((YAMLValue)value);
            if (object == null || (object = object.getMetaType()) == null || (object = PortsChecker.Companion.asPortScalarType((YamlMetaType)object)) == null) {
                return;
            }
            Object type2 = object;
            DockerPortSpec dockerPortSpec = ((PortScalarType)((Object)type2)).toDockerPortSpec(value);
            if (dockerPortSpec == null) {
                return;
            }
            DockerPortSpec portSpec = dockerPortSpec;
            if (PortsChecker.Companion.mayBeInterpretedAsBase60(portSpec)) {
                this.holder.registerProblem((PsiElement)value, DockerComposeBundle.message("ComposeUnquotedPortsInspection.error.message", new Object[0]), ProblemHighlightType.ERROR, new LocalQuickFix[]{(LocalQuickFix)new AddQuoteQuickFix(value)});
            } else {
                this.holder.registerProblem((PsiElement)value, DockerComposeBundle.message("ComposeUnquotedPortsInspection.warning.message", new Object[0]), ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[]{(LocalQuickFix)new AddQuoteQuickFix(value)});
            }
        }

        private final YamlMetaTypeProvider.MetaTypeProxy fieldAndType(YAMLValue $this$fieldAndType) {
            return this.metaTypeProvider.getValueMetaType($this$fieldAndType);
        }

        public PortsChecker(@NotNull ProblemsHolder holder, @NotNull YamlMetaTypeProvider metaTypeProvider) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)metaTypeProvider, (String)"metaTypeProvider");
            this.holder = holder;
            this.metaTypeProvider = metaTypeProvider;
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\bH\u0016J\u0012\u0010\t\u001a\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\bH\u0016J3\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0096\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/docker/composeFile/ComposeUnquotedPortsInspection$PortsChecker$AddQuoteQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "scalar", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "(Lorg/jetbrains/yaml/psi/YAMLScalar;)V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "intellij.clouds.docker.compose"})
        private static final class AddQuoteQuickFix
        extends LocalQuickFixAndIntentionActionOnPsiElement {
            @NotNull
            public String getText() {
                String string = DockerComposeBundle.message("ComposeUnquotedPortsInspection.quick.fix", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DockerComposeBundle.mess\u2026rtsInspection.quick.fix\")");
                return string;
            }

            @NotNull
            public String getFamilyName() {
                return this.getText();
            }

            public void invoke(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
                Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
                String text2 = StringsKt.trimIndent((String)("\n          key: \"" + startElement.getText() + "\"\n        "));
                YAMLFile yAMLFile = YAMLElementGenerator.getInstance((Project)project).createDummyYamlWithText(text2);
                Intrinsics.checkNotNullExpressionValue((Object)yAMLFile, (String)"YAMLElementGenerator.get\u2026teDummyYamlWithText(text)");
                YAMLFile tempFile = yAMLFile;
                Collection collection = PsiTreeUtil.collectElementsOfType((PsiElement)((PsiElement)tempFile), (Class[])new Class[]{YAMLQuotedTextImpl.class});
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"PsiTreeUtil.collectEleme\u2026otedTextImpl::class.java)");
                YAMLQuotedTextImpl yAMLQuotedTextImpl = (YAMLQuotedTextImpl)CollectionsKt.firstOrNull((Iterable)collection);
                if (yAMLQuotedTextImpl == null) {
                    return;
                }
                YAMLQuotedTextImpl quoted = yAMLQuotedTextImpl;
                startElement.replace((PsiElement)quoted);
            }

            public AddQuoteQuickFix(@NotNull YAMLScalar scalar) {
                Intrinsics.checkNotNullParameter((Object)scalar, (String)"scalar");
                super((PsiElement)scalar);
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u0005H\u0002J\u000e\u0010\u0006\u001a\u00020\u0007*\u0004\u0018\u00010\bH\u0002J\f\u0010\t\u001a\u00020\u0007*\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/docker/composeFile/ComposeUnquotedPortsInspection$PortsChecker$Companion;", "", "()V", "asPortScalarType", "Lcom/intellij/docker/composeFile/model/PortScalarType;", "Lorg/jetbrains/yaml/meta/model/YamlMetaType;", "base60Value", "", "Lkotlin/ranges/IntRange;", "mayBeInterpretedAsBase60", "Lcom/intellij/docker/agent/settings/DockerPortSpec;", "intellij.clouds.docker.compose"})
        public static final class Companion {
            private final boolean mayBeInterpretedAsBase60(DockerPortSpec $this$mayBeInterpretedAsBase60) {
                CharSequence charSequence = $this$mayBeInterpretedAsBase60.getLocalSpec().getHostIP();
                boolean bl = false;
                return charSequence.length() == 0 && this.base60Value($this$mayBeInterpretedAsBase60.getLocalSpec().getPortRange()) && this.base60Value($this$mayBeInterpretedAsBase60.getContainerSpec().getPortsRange());
            }

            private final boolean base60Value(IntRange $this$base60Value) {
                return $this$base60Value != null && $this$base60Value.getStart().intValue() == $this$base60Value.getEndInclusive().intValue() && $this$base60Value.getStart() < 60;
            }

            /*
             * WARNING - void declaration
             */
            private final PortScalarType asPortScalarType(YamlMetaType $this$asPortScalarType) {
                PortScalarType portScalarType;
                YamlMetaType yamlMetaType = $this$asPortScalarType;
                if (yamlMetaType instanceof PortScalarType) {
                    portScalarType = (PortScalarType)$this$asPortScalarType;
                } else if (yamlMetaType instanceof YamlComposedTypeBase) {
                    void $this$mapNotNullTo$iv$iv;
                    Iterable iterable = ((YamlComposedTypeBase)$this$asPortScalarType).getSubTypes();
                    Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"this.subTypes");
                    Iterable $this$mapNotNull$iv = iterable;
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable2 = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        PortScalarType portScalarType2;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        YamlMetaType it = (YamlMetaType)element$iv$iv;
                        boolean bl2 = false;
                        YamlMetaType yamlMetaType2 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)yamlMetaType2, (String)"it");
                        if (Companion.asPortScalarType(yamlMetaType2) == null) continue;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        PortScalarType it$iv$iv = portScalarType2;
                        boolean bl5 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    portScalarType = (PortScalarType)((Object)CollectionsKt.firstOrNull((List)((List)destination$iv$iv)));
                } else {
                    portScalarType = null;
                }
                return portScalarType;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

