/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.composeFile;

import com.intellij.docker.runtimes.ComposeDeploymentRuntime;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.PatternCondition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ProcessingContext;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0000\u001a\u0012\u0010\n\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000b\u001a\u00020\tH\u0000\u001a\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0015\u0010\r\u001a\u00020\u00042\u000b\u0010\u000e\u001a\u00070\u0001\u00a2\u0006\u0002\b\u000fH\u0000\u001a\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\tH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"TAG_SERVICES", "", "TAG_VERSION", "computeIsDockerComposeYamlFile", "", "yamlFile", "Lorg/jetbrains/yaml/psi/YAMLFile;", "fromComposeFile", "Lcom/intellij/patterns/PatternCondition;", "Lcom/intellij/psi/PsiElement;", "getComposeProjectName", "element", "isDockerComposeYamlFile", "isDockerComposeYamlFileName", "fileName", "Lorg/jetbrains/annotations/NonNls;", "isFromComposeFile", "intellij.clouds.docker.compose"})
@JvmName(name="ComposeFileUtil")
public final class ComposeFileUtil {
    @NotNull
    public static final String TAG_SERVICES = "services";
    @NotNull
    public static final String TAG_VERSION = "version";

    @NotNull
    public static final PatternCondition<PsiElement> fromComposeFile() {
        return (PatternCondition)new PatternCondition<PsiElement>("from-docker-compose-file"){

            public boolean accepts(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                return ComposeFileUtil.isFromComposeFile(element);
            }
        };
    }

    public static final boolean isFromComposeFile(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiFile psiFile = element.getContainingFile();
        boolean bl = false;
        boolean bl2 = false;
        PsiFile $this$with = psiFile;
        boolean bl3 = false;
        return $this$with instanceof YAMLFile && ComposeFileUtil.isDockerComposeYamlFile((YAMLFile)$this$with);
    }

    @Nullable
    public static final String getComposeProjectName(@NotNull PsiElement element) {
        String string;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!ComposeFileUtil.isFromComposeFile(element)) {
            return null;
        }
        PsiFile psiFile = element.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"element.containingFile");
        PsiFile psiFile2 = psiFile.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"element.containingFile.originalFile");
        Object object = psiFile2.getVirtualFile();
        if (object != null && (object = object.getParent()) != null && (object = object.getName()) != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object p1 = object2;
            boolean bl3 = false;
            string = ComposeDeploymentRuntime.computeErasedProjectName((String)p1);
        } else {
            string = null;
        }
        return string;
    }

    public static final boolean isDockerComposeYamlFile(@NotNull YAMLFile yamlFile) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)yamlFile, (String)"yamlFile");
        PsiFile psiFile = yamlFile.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"yamlFile.originalFile");
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile vFile = virtualFile;
        String string = vFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"vFile.name");
        if (ComposeFileUtil.isDockerComposeYamlFileName(string)) {
            bl = true;
        } else {
            Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)yamlFile), (CachedValueProvider)new CachedValueProvider(yamlFile){
                final /* synthetic */ YAMLFile $yamlFile;

                @Nullable
                public final CachedValueProvider.Result<Boolean> compute() {
                    return new CachedValueProvider.Result((Object)ComposeFileUtil.access$computeIsDockerComposeYamlFile(this.$yamlFile), new Object[]{this.$yamlFile});
                }
                {
                    this.$yamlFile = yAMLFile;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"CachedValuesManager.getC\u2026(yamlFile), yamlFile)\n  }");
            bl = (Boolean)object;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isDockerComposeYamlFileName(@NotNull String fileName) {
        String lowerCaseName;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        String string = lowerCaseName = StringUtil.toLowerCase((String)fileName);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lowerCaseName");
        if (!StringsKt.endsWith$default((String)string, (String)".yaml", (boolean)false, (int)2, null)) {
            if (!StringsKt.endsWith$default((String)lowerCaseName, (String)".yml", (boolean)false, (int)2, null)) return false;
        }
        String string2 = StringUtil.toLowerCase((String)fileName);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringUtil.toLowerCase(fileName)");
        if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)"docker-compose", (boolean)false, (int)2, null)) return false;
        return true;
    }

    private static final boolean computeIsDockerComposeYamlFile(YAMLFile yamlFile) {
        if (yamlFile.getDocuments().size() != 1) {
            return false;
        }
        Object e = yamlFile.getDocuments().get(0);
        Intrinsics.checkNotNullExpressionValue(e, (String)"yamlFile.documents[0]");
        YAMLValue yAMLValue = ((YAMLDocument)e).getTopLevelValue();
        if (!(yAMLValue instanceof YAMLMapping)) {
            yAMLValue = null;
        }
        YAMLMapping yAMLMapping = (YAMLMapping)yAMLValue;
        if (yAMLMapping == null) {
            return false;
        }
        YAMLMapping topValue = yAMLMapping;
        return topValue.getKeyValueByKey(TAG_VERSION) != null && topValue.getKeyValueByKey(TAG_SERVICES) != null;
    }

    public static final /* synthetic */ boolean access$computeIsDockerComposeYamlFile(YAMLFile yamlFile) {
        return ComposeFileUtil.computeIsDockerComposeYamlFile(yamlFile);
    }
}

