/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.composeFile;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.docker.DockerPluginDisposable;
import com.intellij.docker.DockerRunConfigurationCreator;
import com.intellij.docker.DockerRunLineMarkerProviderBase;
import com.intellij.docker.EditExistingRunConfig;
import com.intellij.docker.RunConfigActionBase;
import com.intellij.docker.compose.DockerComposeServiceActions;
import com.intellij.docker.composeFile.ComposeFileUtil;
import com.intellij.docker.composeFile.dsl.Markers;
import com.intellij.docker.composeFile.i18n.DockerComposeBundle;
import com.intellij.docker.composeFile.model.ComposeMetaTypeProvider;
import com.intellij.docker.debug.DockerBeforeRunTask;
import com.intellij.docker.debug.DockerBeforeRunTaskProvider;
import com.intellij.docker.deployment.DockerRunConfig;
import com.intellij.docker.deploymentSource.DockerComposeDeploymentSourceType;
import com.intellij.docker.remoteDebug.RemoteServerRequestAdapterFactory;
import com.intellij.docker.runtimes.DockerRuntimesManagerService;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Producer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.psi.YAMLKeyValue;

final class ComposeFileRunLineMarkerProvider
extends DockerRunLineMarkerProviderBase {
    private final Map<Project, Refresher> myRefreshers = new HashMap<Project, Refresher>();

    ComposeFileRunLineMarkerProvider() {
    }

    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement psi) {
        ASTNode node;
        if (psi == null) {
            ComposeFileRunLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if ((node = psi.getNode()) == null) {
            return null;
        }
        if (node.getElementType() != YAMLTokenTypes.SCALAR_KEY) {
            return null;
        }
        if (!(psi.getParent() instanceof YAMLKeyValue)) {
            return null;
        }
        if (!ComposeFileUtil.isFromComposeFile(psi)) {
            return null;
        }
        YAMLKeyValue keyValue = (YAMLKeyValue)psi.getParent();
        YamlMetaTypeProvider.MetaTypeProxy meta = ComposeMetaTypeProvider.getInstance().getKeyValueMetaType(keyValue);
        if (meta == null) {
            return null;
        }
        YamlMetaType type2 = meta.getMetaType();
        if (type2 instanceof Markers.TopLevelServicesGroup) {
            return new AllServicesLineMarkerInfo(psi);
        }
        if (type2 instanceof Markers.SingleComposeService) {
            this.setupRefresher(psi);
            return new ServiceLineMarkerInfo(psi, (Producer<String>)((Producer)() -> keyValue.getKeyText()), ComposeFileRunLineMarkerProvider.getServiceStatus(keyValue));
        }
        if (type2 instanceof Markers.RemoteCommand) {
            Markers.RemoteCommand typeImpl = (Markers.RemoteCommand)type2;
            String serviceName = typeImpl.getServiceName(keyValue);
            String command = typeImpl.buildCommandLine(keyValue);
            return command == null || serviceName == null ? null : DebugLineMarkerInfo.buildForCommandLine(psi, serviceName, command);
        }
        return null;
    }

    private void setupRefresher(@NotNull PsiElement psi) {
        Project project;
        if (psi == null) {
            ComposeFileRunLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (!this.myRefreshers.containsKey(project = psi.getProject())) {
            Disposer.register((Disposable)DockerPluginDisposable.getInstance(project), () -> this.myRefreshers.remove(project));
            this.myRefreshers.put(project, new Refresher(project));
        }
    }

    private static DockerComposeDeploymentSourceType COMPOSE() {
        return DockerComposeDeploymentSourceType.getInstance();
    }

    @Nullable
    private static DockerRuntimesManagerService.ComposeServiceStatus getServiceStatus(@NotNull YAMLKeyValue service2) {
        if (service2 == null) {
            ComposeFileRunLineMarkerProvider.$$$reportNull$$$0(2);
        }
        String serviceName = service2.getKeyText();
        String projectName = ComposeFileUtil.getComposeProjectName((PsiElement)service2);
        if (projectName == null) {
            return null;
        }
        return Optional.ofNullable(DockerRuntimesManagerService.getInstance().getActiveManager()).map(manager -> manager.findComposeServiceStatus(projectName, serviceName)).orElse(null);
    }

    @NotNull
    private static Icon getServiceActionIcon(@NotNull DockerRuntimesManagerService.ComposeServiceStatus status) {
        if (status == null) {
            ComposeFileRunLineMarkerProvider.$$$reportNull$$$0(3);
        }
        switch (status) {
            case DEPLOYED: {
                Icon icon = AllIcons.Actions.Restart;
                if (icon == null) {
                    ComposeFileRunLineMarkerProvider.$$$reportNull$$$0(4);
                }
                return icon;
            }
            case FAILED: {
                Icon icon = AllIcons.RunConfigurations.TestState.Yellow2;
                if (icon == null) {
                    ComposeFileRunLineMarkerProvider.$$$reportNull$$$0(5);
                }
                return icon;
            }
        }
        Icon icon = AllIcons.RunConfigurations.TestState.Run;
        if (icon == null) {
            ComposeFileRunLineMarkerProvider.$$$reportNull$$$0(6);
        }
        return icon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/composeFile/ComposeFileRunLineMarkerProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/composeFile/ComposeFileRunLineMarkerProvider";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getServiceActionIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setupRefresher";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getServiceStatus";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getServiceActionIcon";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Refresher
    implements DockerRuntimesManagerService.DockerRuntimesListener,
    Disposable {
        private final Project myProject;
        private MessageBusConnection myBusConnection;

        Refresher(@NotNull Project project) {
            if (project == null) {
                Refresher.$$$reportNull$$$0(0);
            }
            this.myProject = project;
            Disposer.register((Disposable)DockerPluginDisposable.getInstance(project), (Disposable)this);
            this.myBusConnection = ApplicationManager.getApplication().getMessageBus().connect();
            this.myBusConnection.subscribe(DockerRuntimesManagerService.DOCKER_RUNTIMES_MANAGER_TOPIC, (Object)this);
        }

        public void dispose() {
            if (this.myBusConnection != null) {
                this.myBusConnection.disconnect();
                this.myBusConnection = null;
            }
        }

        @Override
        public void connectionChanged(@NotNull DockerRuntimesManagerService.DockerRuntimesManager manager, boolean nowConnected) {
            if (manager == null) {
                Refresher.$$$reportNull$$$0(1);
            }
            this.restartDaemon();
        }

        @Override
        public void runtimesRefreshed(@NotNull DockerRuntimesManagerService.DockerRuntimesManager manager, @NotNull DockerRuntimesManagerService.DockerRuntimesListener.Delta delta) {
            if (manager == null) {
                Refresher.$$$reportNull$$$0(2);
            }
            if (delta == null) {
                Refresher.$$$reportNull$$$0(3);
            }
            this.restartDaemon();
        }

        private void restartDaemon() {
            if (!this.myProject.isDisposed()) {
                DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delta";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/docker/composeFile/ComposeFileRunLineMarkerProvider$Refresher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "connectionChanged";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runtimesRefreshed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DebugExistingRunConfigAction
    extends RunConfigActionBase {
        private final RunnerAndConfigurationSettings myRunConfig;

        DebugExistingRunConfigAction(@NotNull DockerRunConfigurationCreator helper, @NotNull RunnerAndConfigurationSettings runConfig) {
            if (helper == null) {
                DebugExistingRunConfigAction.$$$reportNull$$$0(0);
            }
            if (runConfig == null) {
                DebugExistingRunConfigAction.$$$reportNull$$$0(1);
            }
            super(helper);
            this.myRunConfig = runConfig;
            this.getTemplatePresentation().setText(DockerComposeBundle.messagePointer("ComposeFileRunLineMarkerProvider.DebugExistingRunConfigAction.text", this.myRunConfig.getName()));
            this.getTemplatePresentation().setIcon(AllIcons.Actions.StartDebugger);
        }

        @Override
        public void execute() {
            this.getHelper().executeConfiguration(this.myRunConfig);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "helper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "runConfig";
                    break;
                }
            }
            objectArray[1] = "com/intellij/docker/composeFile/ComposeFileRunLineMarkerProvider$DebugExistingRunConfigAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CreateNewDebugRunConfigAction
    extends RunConfigActionBase {
        private final RemoteServerRequestAdapterFactory myAdapterFactory;
        private final String myServiceName;
        private final RemoteServerRequestAdapterFactory.CommandLineAdjuster myAdjuster;
        private final String myBaseCommand;
        private final Supplier<DockerRunConfig.Wrapper> myDockerRunConfig;

        CreateNewDebugRunConfigAction(@NotNull DockerRunConfigurationCreator helper, @NotNull RemoteServerRequestAdapterFactory factory, @NotNull String serviceName, @NotNull RemoteServerRequestAdapterFactory.CommandLineAdjuster adjuster, @NotNull String baseCommand, @NotNull Supplier<DockerRunConfig.Wrapper> dockerRunConfig) {
            if (helper == null) {
                CreateNewDebugRunConfigAction.$$$reportNull$$$0(0);
            }
            if (factory == null) {
                CreateNewDebugRunConfigAction.$$$reportNull$$$0(1);
            }
            if (serviceName == null) {
                CreateNewDebugRunConfigAction.$$$reportNull$$$0(2);
            }
            if (adjuster == null) {
                CreateNewDebugRunConfigAction.$$$reportNull$$$0(3);
            }
            if (baseCommand == null) {
                CreateNewDebugRunConfigAction.$$$reportNull$$$0(4);
            }
            if (dockerRunConfig == null) {
                CreateNewDebugRunConfigAction.$$$reportNull$$$0(5);
            }
            super(helper);
            this.myAdapterFactory = factory;
            this.myServiceName = serviceName;
            this.myAdjuster = adjuster;
            this.myBaseCommand = baseCommand;
            this.myDockerRunConfig = dockerRunConfig;
            ConfigurationType type2 = this.myAdjuster.getConfigurationType();
            assert (type2 != null);
            this.getTemplatePresentation().setText(DockerComposeBundle.messagePointer("ComposeFileRunLineMarkerProvider.CreateNewDebugRunConfigAction.text", type2.getDisplayName()));
            this.getTemplatePresentation().setIcon(AllIcons.Actions.StartDebugger);
        }

        @Override
        public void execute() {
            RunManager runManager = RunManager.getInstance((Project)this.getProject());
            ConfigurationType type2 = this.myAdjuster.getConfigurationType();
            assert (type2 != null);
            String name = CreateNewDebugRunConfigAction.chooseName(runManager, type2);
            RunnerAndConfigurationSettings hostRunConfig = runManager.createConfiguration(name, type2.getClass());
            DockerBeforeRunTaskProvider provider = DockerBeforeRunTaskProvider.getInstance(this.getProject());
            DockerBeforeRunTask task2 = provider.createTask(hostRunConfig.getConfiguration());
            assert (task2 != null) : "For run configuration type: " + type2;
            this.myAdapterFactory.bind(task2.getRequest(), hostRunConfig.getConfiguration());
            task2.setTargetRunConfig(this.getTargetRunConfig());
            task2.setCustomCommand(null);
            task2.setWaitForHealthCheck(false);
            ArrayList<DockerBeforeRunTask> tasks = new ArrayList<DockerBeforeRunTask>(hostRunConfig.getConfiguration().getBeforeRunTasks());
            tasks.add(task2);
            hostRunConfig.getConfiguration().setBeforeRunTasks(tasks);
            this.getHelper().openForEditingAndExecute(hostRunConfig, DockerComposeBundle.message("ComposeFileRunLineMarkerProvider.CreateNewDebugRunConfigAction.dialogTitle", type2.getDisplayName()));
        }

        @Nullable
        private DockerBeforeRunTask.TargetRunConfig getTargetRunConfig() {
            DockerRunConfig.Wrapper wrapper = this.myDockerRunConfig.get();
            return wrapper == null ? null : new DockerBeforeRunTask.TargetComposeRunConfig(wrapper.getConfig(), this.myServiceName);
        }

        private static String chooseName(RunManager runManager, ConfigurationType type2) {
            Set existingNames = runManager.getConfigurationsList(type2).stream().map(RunProfile::getName).collect(Collectors.toSet());
            String baseName = type2.getDisplayName() + " with compose";
            return UniqueNameGenerator.generateUniqueName((String)baseName, (String)"", (String)"", next -> !existingNames.contains(next));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "helper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "factory";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "serviceName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "adjuster";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "baseCommand";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dockerRunConfig";
                    break;
                }
            }
            objectArray[1] = "com/intellij/docker/composeFile/ComposeFileRunLineMarkerProvider$CreateNewDebugRunConfigAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class DebugLineMarkerInfo
    extends MostlySingleActionLineMarkerInfo {
        private final RemoteServerRequestAdapterFactory myFactory;
        private final String myServiceName;
        private final RemoteServerRequestAdapterFactory.CommandLineAdjuster myAdjuster;
        private final String myBaseCommand;

        @Nullable
        static DebugLineMarkerInfo buildForCommandLine(@NotNull PsiElement psi, @NotNull String service2, @NotNull String command) {
            RemoteServerRequestAdapterFactory factory;
            if (psi == null) {
                DebugLineMarkerInfo.$$$reportNull$$$0(0);
            }
            if (service2 == null) {
                DebugLineMarkerInfo.$$$reportNull$$$0(1);
            }
            if (command == null) {
                DebugLineMarkerInfo.$$$reportNull$$$0(2);
            }
            if ((factory = RemoteServerRequestAdapterFactory.findAdapterFactory(command)) == null) {
                return null;
            }
            RemoteServerRequestAdapterFactory.CommandLineAdjuster adjuster = factory.recognizeCommandLine(command);
            if (adjuster == null || adjuster.getConfigurationType() == null) {
                return null;
            }
            if (ComposeFileRunLineMarkerProvider.listAllDockerAccounts().isEmpty()) {
                return null;
            }
            return new DebugLineMarkerInfo(psi, service2, factory, adjuster, command);
        }

        private DebugLineMarkerInfo(@NotNull PsiElement psi, @NotNull String serviceName, @NotNull RemoteServerRequestAdapterFactory factory, @NotNull RemoteServerRequestAdapterFactory.CommandLineAdjuster adjuster, @NotNull String baseCommand) {
            if (psi == null) {
                DebugLineMarkerInfo.$$$reportNull$$$0(3);
            }
            if (serviceName == null) {
                DebugLineMarkerInfo.$$$reportNull$$$0(4);
            }
            if (factory == null) {
                DebugLineMarkerInfo.$$$reportNull$$$0(5);
            }
            if (adjuster == null) {
                DebugLineMarkerInfo.$$$reportNull$$$0(6);
            }
            if (baseCommand == null) {
                DebugLineMarkerInfo.$$$reportNull$$$0(7);
            }
            super(psi, AllIcons.Actions.StartDebugger, DefaultDebugExecutor.getDebugExecutorInstance());
            this.myFactory = factory;
            this.myServiceName = serviceName;
            this.myAdjuster = adjuster;
            this.myBaseCommand = baseCommand;
        }

        @Override
        @NotNull
        protected ActionGroup computeAllActions(@NotNull DockerRunConfigurationCreator helper, @NotNull VirtualFile sourceFile) {
            if (helper == null) {
                DebugLineMarkerInfo.$$$reportNull$$$0(8);
            }
            if (sourceFile == null) {
                DebugLineMarkerInfo.$$$reportNull$$$0(9);
            }
            DefaultActionGroup result2 = new DefaultActionGroup();
            List<RunnerAndConfigurationSettings> existings = this.findExistingDebugRunConfigs(helper, sourceFile);
            for (RunnerAndConfigurationSettings next : existings) {
                result2.add((AnAction)new DebugExistingRunConfigAction(helper, next));
                result2.add((AnAction)new EditExistingRunConfig(helper, next));
            }
            RemoteServer firstDocker = (RemoteServer)ContainerUtil.getFirstItem((List)ComposeFileRunLineMarkerProvider.listAllDockerAccounts());
            if (firstDocker != null && existings.isEmpty()) {
                List<DockerRunConfig.Wrapper> dockerRunConfigWrappers = DockerRunConfig.Wrapper.dockerConfigs(helper.getProject(), sourceFile, ComposeFileRunLineMarkerProvider.COMPOSE());
                Supplier<DockerRunConfig.Wrapper> dockerRunConfig = dockerRunConfigWrappers.isEmpty() ? () -> {
                    RunnerAndConfigurationSettings config = helper.createConfiguration(ComposeFileRunLineMarkerProvider.COMPOSE(), sourceFile, firstDocker);
                    helper.rememberConfiguration(config);
                    return DockerRunConfig.Wrapper.wrapIfDocker(config);
                } : () -> (DockerRunConfig.Wrapper)ContainerUtil.getFirstItem((List)dockerRunConfigWrappers);
                result2.add((AnAction)new CreateNewDebugRunConfigAction(helper, this.myFactory, this.myServiceName, this.myAdjuster, this.myBaseCommand, dockerRunConfig));
            }
            DefaultActionGroup defaultActionGroup = result2;
            if (defaultActionGroup == null) {
                DebugLineMarkerInfo.$$$reportNull$$$0(10);
            }
            return defaultActionGroup;
        }

        private List<RunnerAndConfigurationSettings> findExistingDebugRunConfigs(@NotNull DockerRunConfigurationCreator helper, @NotNull VirtualFile sourceFile) {
            ConfigurationType type2;
            if (helper == null) {
                DebugLineMarkerInfo.$$$reportNull$$$0(11);
            }
            if (sourceFile == null) {
                DebugLineMarkerInfo.$$$reportNull$$$0(12);
            }
            if ((type2 = this.myAdjuster.getConfigurationType()) == null) {
                return Collections.emptyList();
            }
            RunManager runManager = RunManager.getInstance((Project)helper.getProject());
            LinkedList<RunnerAndConfigurationSettings> result2 = new LinkedList<RunnerAndConfigurationSettings>();
            for (RunnerAndConfigurationSettings next : runManager.getConfigurationSettingsList(type2)) {
                DockerBeforeRunTask task2 = DebugLineMarkerInfo.findDockerBeforeRunTask(next.getConfiguration());
                if (task2 == null || !task2.isForSourceFileAndType(sourceFile, ComposeFileRunLineMarkerProvider.COMPOSE()) || !task2.isForComposeService(this.myServiceName)) continue;
                result2.add(next);
            }
            return result2;
        }

        private static DockerBeforeRunTask findDockerBeforeRunTask(@NotNull RunConfiguration configuration) {
            List tasks;
            if (configuration == null) {
                DebugLineMarkerInfo.$$$reportNull$$$0(13);
            }
            return (tasks = configuration.getBeforeRunTasks().stream().map(task2 -> (DockerBeforeRunTask)((Object)((Object)ObjectUtils.tryCast((Object)task2, DockerBeforeRunTask.class)))).filter(Objects::nonNull).collect(Collectors.toList())).size() == 1 ? (DockerBeforeRunTask)((Object)tasks.get(0)) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psi";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "service";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serviceName";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "adjuster";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseCommand";
                    break;
                }
                case 8: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 9: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceFile";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/composeFile/ComposeFileRunLineMarkerProvider$DebugLineMarkerInfo";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/composeFile/ComposeFileRunLineMarkerProvider$DebugLineMarkerInfo";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeAllActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "buildForCommandLine";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "computeAllActions";
                    break;
                }
                case 10: {
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "findExistingDebugRunConfigs";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "findDockerBeforeRunTask";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class AllServicesLineMarkerInfo
    extends MostlySingleActionLineMarkerInfo {
        protected AllServicesLineMarkerInfo(@NotNull PsiElement psi) {
            if (psi == null) {
                AllServicesLineMarkerInfo.$$$reportNull$$$0(0);
            }
            super(psi, AllIcons.RunConfigurations.TestState.Run_run);
        }

        @Override
        @Nullable
        protected ActionGroup computeAllActions(@NotNull DockerRunConfigurationCreator helper, @NotNull VirtualFile sourceFile) {
            if (helper == null) {
                AllServicesLineMarkerInfo.$$$reportNull$$$0(1);
            }
            if (sourceFile == null) {
                AllServicesLineMarkerInfo.$$$reportNull$$$0(2);
            }
            return new DockerComposeServiceActions.ForAllServices(helper, helper.getProject(), sourceFile).asActionGroup();
        }

        @Override
        @Nullable
        public String getLineMarkerTooltip() {
            if (this.getActionIfTheOnly() != null) {
                return DockerComposeBundle.message("ComposeFileRunLineMarkerProvider.AllServicesLineMarkerInfo.tooltip", new Object[0]);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psi";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceFile";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/docker/composeFile/ComposeFileRunLineMarkerProvider$AllServicesLineMarkerInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "computeAllActions";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ServiceLineMarkerInfo
    extends MostlySingleActionLineMarkerInfo {
        private final Producer<String> myServiceNameProducer;
        @Nullable
        private final DockerRuntimesManagerService.ComposeServiceStatus myServiceStatus;

        ServiceLineMarkerInfo(@NotNull PsiElement psi, @NotNull Producer<String> serviceNameProducer, @Nullable DockerRuntimesManagerService.ComposeServiceStatus serviceStatus) {
            if (psi == null) {
                ServiceLineMarkerInfo.$$$reportNull$$$0(0);
            }
            if (serviceNameProducer == null) {
                ServiceLineMarkerInfo.$$$reportNull$$$0(1);
            }
            super(psi, serviceStatus == null ? AllIcons.RunConfigurations.TestState.Run : ComposeFileRunLineMarkerProvider.getServiceActionIcon(serviceStatus));
            this.myServiceNameProducer = serviceNameProducer;
            this.myServiceStatus = serviceStatus;
        }

        @Override
        @Nullable
        protected ActionGroup computeAllActions(@NotNull DockerRunConfigurationCreator helper, @NotNull VirtualFile sourceFile) {
            if (helper == null) {
                ServiceLineMarkerInfo.$$$reportNull$$$0(2);
            }
            if (sourceFile == null) {
                ServiceLineMarkerInfo.$$$reportNull$$$0(3);
            }
            String serviceName = (String)this.myServiceNameProducer.produce();
            return new DockerComposeServiceActions.ForSingleService(serviceName, helper, helper.getProject(), sourceFile).asActionGroup();
        }

        @Override
        @Nullable
        public String getLineMarkerTooltip() {
            if (this.getActionIfTheOnly() != null) {
                String serviceName = (String)this.myServiceNameProducer.produce();
                return this.myServiceStatus == DockerRuntimesManagerService.ComposeServiceStatus.DEPLOYED ? DockerComposeBundle.message("ComposeFileRunLineMarkerProvider.ServiceLineMarkerInfo.restart.tooltip", serviceName) : DockerComposeBundle.message("ComposeFileRunLineMarkerProvider.ServiceLineMarkerInfo.up.tooltip", serviceName);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psi";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serviceNameProducer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceFile";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/docker/composeFile/ComposeFileRunLineMarkerProvider$ServiceLineMarkerInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "computeAllActions";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class MostlySingleActionLineMarkerInfo
    extends LineMarkerInfo<PsiElement> {
        private final DockerRunConfigurationCreator myHelper;
        private final VirtualFile mySourceFile;

        MostlySingleActionLineMarkerInfo(@NotNull PsiElement psi, @NotNull Icon icon) {
            if (psi == null) {
                MostlySingleActionLineMarkerInfo.$$$reportNull$$$0(0);
            }
            if (icon == null) {
                MostlySingleActionLineMarkerInfo.$$$reportNull$$$0(1);
            }
            this(psi, icon, DefaultRunExecutor.getRunExecutorInstance());
        }

        MostlySingleActionLineMarkerInfo(@NotNull PsiElement psi, @NotNull Icon icon, @NotNull Executor executor) {
            if (psi == null) {
                MostlySingleActionLineMarkerInfo.$$$reportNull$$$0(2);
            }
            if (icon == null) {
                MostlySingleActionLineMarkerInfo.$$$reportNull$$$0(3);
            }
            if (executor == null) {
                MostlySingleActionLineMarkerInfo.$$$reportNull$$$0(4);
            }
            super(psi, psi.getTextRange(), icon, null, null, GutterIconRenderer.Alignment.CENTER);
            this.myHelper = new DockerRunConfigurationCreator(psi.getProject(), executor);
            this.mySourceFile = Optional.ofNullable(psi.getContainingFile()).map(PsiFile::getVirtualFile).orElse(null);
        }

        @Nullable
        public String getLineMarkerTooltip() {
            AnAction theOnly = this.getActionIfTheOnly();
            if (theOnly == null) {
                return null;
            }
            Presentation presentation = theOnly.getTemplatePresentation();
            return Optional.ofNullable(presentation.getDescription()).orElseGet(() -> ((Presentation)presentation).getText());
        }

        @NotNull
        public GutterIconRenderer createGutterRenderer() {
            return new LineMarkerInfo.LineMarkerGutterIconRenderer<PsiElement>((LineMarkerInfo)this){

                public AnAction getClickAction() {
                    return this.getActionIfTheOnly();
                }

                public boolean isNavigateAction() {
                    return true;
                }

                @Nullable
                public ActionGroup getPopupMenuActions() {
                    return this.computeAllActions(myHelper, mySourceFile);
                }
            };
        }

        @Nullable
        protected abstract ActionGroup computeAllActions(@NotNull DockerRunConfigurationCreator var1, @NotNull VirtualFile var2);

        @Nullable
        protected AnAction getActionIfTheOnly() {
            AnAction[] actions = Optional.ofNullable(this.computeAllActions(this.myHelper, this.mySourceFile)).map(ag -> ag.getChildren(null)).orElse(AnAction.EMPTY_ARRAY);
            return actions.length == 1 ? actions[0] : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "psi";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "icon";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "executor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/docker/composeFile/ComposeFileRunLineMarkerProvider$MostlySingleActionLineMarkerInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

