/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.service.commands;

import com.intellij.docker.compose.cli.DockerComposeCliUtil;
import com.intellij.docker.compose.cli.DockerComposeExecCliBuilder;
import com.intellij.docker.compose.configuration.util.DockerComposeConfigurationUtil;
import com.intellij.docker.compose.service.commands.AbstractServiceCmd;
import com.intellij.docker.compose.service.commands.ServiceCmdExecUtils;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ComposeServiceExecCmd
extends AbstractServiceCmd<ComposeServiceExecCmd> {
    private static final Logger LOG = Logger.getInstance(ComposeServiceExecCmd.class);
    private Boolean myNoPty;
    private boolean mySetupWorkingDirectory;

    public ComposeServiceExecCmd(@NotNull RemoteDockerRuntime dockerRuntime2) {
        if (dockerRuntime2 == null) {
            ComposeServiceExecCmd.$$$reportNull$$$0(0);
        }
        super(dockerRuntime2);
    }

    @Override
    @NotNull
    public KillableColoredProcessHandler execute() throws IOException, ExecutionException {
        return this.execute(false);
    }

    @Override
    @NotNull
    public GeneralCommandLine buildCommandLine() throws IOException {
        GeneralCommandLine generalCommandLine = ComposeServiceExecCmd.buildExecCommand(this, false).buildCommandLine();
        if (generalCommandLine == null) {
            ComposeServiceExecCmd.$$$reportNull$$$0(1);
        }
        return generalCommandLine;
    }

    @NotNull
    public String execDetached() throws IOException, ExecutionException {
        KillableColoredProcessHandler processHandler = this.execute(true);
        ProcessOutput processOutput = new CapturingProcessRunner((BaseProcessHandler)processHandler).runProcess();
        if (processOutput.checkSuccess(LOG)) {
            String string = processOutput.getStdout().trim();
            if (string == null) {
                ComposeServiceExecCmd.$$$reportNull$$$0(2);
            }
            return string;
        }
        throw new ExecutionException(processOutput.getStderr());
    }

    @Override
    @NotNull
    protected ComposeServiceExecCmd getThis() {
        ComposeServiceExecCmd composeServiceExecCmd = this;
        if (composeServiceExecCmd == null) {
            ComposeServiceExecCmd.$$$reportNull$$$0(3);
        }
        return composeServiceExecCmd;
    }

    public Boolean isNoPty() {
        return this.myNoPty;
    }

    @NotNull
    public ComposeServiceExecCmd withNoPty(Boolean value) {
        this.myNoPty = value;
        ComposeServiceExecCmd composeServiceExecCmd = this;
        if (composeServiceExecCmd == null) {
            ComposeServiceExecCmd.$$$reportNull$$$0(4);
        }
        return composeServiceExecCmd;
    }

    public boolean isSetupWorkingDirectory() {
        return this.mySetupWorkingDirectory;
    }

    @NotNull
    public ComposeServiceExecCmd withSetupWorkingDirectory(boolean setupWorkingDirectory) {
        this.mySetupWorkingDirectory = setupWorkingDirectory;
        ComposeServiceExecCmd composeServiceExecCmd = this;
        if (composeServiceExecCmd == null) {
            ComposeServiceExecCmd.$$$reportNull$$$0(5);
        }
        return composeServiceExecCmd;
    }

    @NotNull
    private KillableColoredProcessHandler execute(boolean detached) throws IOException, ExecutionException {
        KillableColoredProcessHandler killableColoredProcessHandler = ComposeServiceExecCmd.buildExecCommand(this, detached).run();
        if (killableColoredProcessHandler == null) {
            ComposeServiceExecCmd.$$$reportNull$$$0(6);
        }
        return killableColoredProcessHandler;
    }

    @NotNull
    private static DockerComposeExecCliBuilder buildExecCommand(@NotNull ComposeServiceExecCmd cmd, boolean detached) throws IOException {
        if (cmd == null) {
            ComposeServiceExecCmd.$$$reportNull$$$0(7);
        }
        if (ContainerUtil.isEmpty(cmd.getConfigurationPaths())) {
            throw new IllegalArgumentException(DockerBundle.message("ComposeServiceExecCmd.error.path.required", new Object[0]));
        }
        if (StringUtil.isEmpty((String)cmd.getServiceName())) {
            throw new IllegalArgumentException(DockerBundle.message("ComposeServiceExecCmd.error.service.name.required", new Object[0]));
        }
        if (cmd.getCommand() == null) {
            throw new IllegalArgumentException(DockerBundle.message("ComposeServiceExecCmd.error.command.required", new Object[0]));
        }
        ApplicationManager.getApplication().invokeAndWait(() -> ServiceCmdExecUtils.saveAllDocumentsAsIs());
        List<Path> configurationPaths = DockerComposeConfigurationUtil.findConfigurationFiles(cmd.getConfigurationPaths());
        DockerComposeExecCliBuilder result2 = ((DockerComposeExecCliBuilder)((DockerComposeExecCliBuilder)((DockerComposeExecCliBuilder)DockerComposeCliUtil.buildExecCommand(cmd.getDockerRuntime()).withRuntimeEnvironment(cmd.getEnvironment()).withEnvironment((Map<String, String>)cmd.getEnvs())).withFiles(configurationPaths)).withDetached(detached).withNoPty(cmd.isNoPty()).withSubcommandOptions(cmd.getSubcommandOptions())).withCmd(cmd.getCommand()).withService(cmd.getServiceName());
        if (cmd.isSetupWorkingDirectory()) {
            result2.withWorkingDir(cmd.getWorkingDir());
        }
        DockerComposeExecCliBuilder dockerComposeExecCliBuilder = result2;
        if (dockerComposeExecCliBuilder == null) {
            ComposeServiceExecCmd.$$$reportNull$$$0(8);
        }
        return dockerComposeExecCliBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerRuntime";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/compose/service/commands/ComposeServiceExecCmd";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/compose/service/commands/ComposeServiceExecCmd";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCommandLine";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "execDetached";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getThis";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "withNoPty";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "withSetupWorkingDirectory";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "buildExecCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildExecCommand";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

