/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.configuration.beans.v2;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.intellij.docker.compose.configuration.beans.common.DockerComposeConfiguration;
import com.intellij.docker.compose.configuration.beans.v2.DockerComposeServiceV2;
import com.intellij.docker.compose.configuration.beans.v2.DockerComposeVolumeV2;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"version", "services", "volumes"})
public class DockerComposeConfigurationV2
implements DockerComposeConfiguration {
    public static final String VERSION_TAG = "version";
    public static final String VERSION_2 = "2";
    @Nullable
    private String myVersion;
    private Map<String, DockerComposeServiceV2> myServices;
    private Map<String, DockerComposeVolumeV2> myVolumes;

    public DockerComposeConfigurationV2() {
    }

    public DockerComposeConfigurationV2(Map<String, DockerComposeServiceV2> services) {
        this(null, services);
    }

    public DockerComposeConfigurationV2(@Nullable String version, Map<String, DockerComposeServiceV2> services) {
        this.myVersion = version;
        this.myServices = services;
    }

    @JsonProperty
    @Nullable
    public String getVersion() {
        return this.myVersion;
    }

    @JsonProperty
    public void setVersion(@Nullable String version) {
        this.myVersion = version;
    }

    @JsonProperty
    public Map<String, DockerComposeServiceV2> getServices() {
        if (this.myServices == null) {
            this.myServices = new LinkedHashMap<String, DockerComposeServiceV2>();
        }
        return this.myServices;
    }

    @JsonProperty
    public void setServices(Map<String, DockerComposeServiceV2> services) {
        this.myServices = services;
    }

    @JsonProperty
    public Map<String, DockerComposeVolumeV2> getVolumes() {
        return this.myVolumes;
    }

    @JsonProperty
    public void setVolumes(Map<String, DockerComposeVolumeV2> volumes) {
        this.myVolumes = volumes;
    }

    @Override
    public <T> T accept(DockerComposeConfiguration.Visitor<T> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return "DockerComposeConfigurationV2{myVersion='" + this.myVersion + "', myServices=" + this.myServices + ", myVolumes=" + this.myVolumes + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DockerComposeConfigurationV2 v2 = (DockerComposeConfigurationV2)o;
        if (this.myVersion != null ? !this.myVersion.equals(v2.myVersion) : v2.myVersion != null) {
            return false;
        }
        if (this.myServices != null ? !this.myServices.equals(v2.myServices) : v2.myServices != null) {
            return false;
        }
        return !(this.myVolumes != null ? !this.myVolumes.equals(v2.myVolumes) : v2.myVolumes != null);
    }

    public int hashCode() {
        int result2 = this.myVersion != null ? this.myVersion.hashCode() : 0;
        result2 = 31 * result2 + (this.myServices != null ? this.myServices.hashCode() : 0);
        result2 = 31 * result2 + (this.myVolumes != null ? this.myVolumes.hashCode() : 0);
        return result2;
    }
}

