/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.configuration.beans.parse;

import com.intellij.docker.compose.configuration.beans.DockerComposeConfigurationParser;
import com.intellij.docker.compose.configuration.beans.parse.CachingDockerComposeConfigurationParser;
import com.intellij.docker.compose.configuration.beans.parse.CachingFilesSupplier;
import com.intellij.docker.compose.configuration.beans.parse.DockerComposeVersion;
import com.intellij.docker.compose.configuration.beans.parse.PureDockerComposeConfigurationParser;
import com.intellij.docker.compose.configuration.beans.parse.ToolBasedDockerComposeConfigurationParser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DockerComposeConfigurationParserUtil {
    private static final Logger LOG = Logger.getInstance(DockerComposeConfigurationParserUtil.class);
    public static final String VERSION_3 = "3";
    static final Pattern VERSION_PATTERN = Pattern.compile("(?<major>\\d+)(\\.\\d+)?");
    private static DockerComposeConfigurationParser ourInstance;
    private static final Object ourInstanceCreationMonitor;
    private static final CachingFilesSupplier<DockerComposeVersion> cachedComposeFileVersion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DockerComposeConfigurationParser defaultParserForUi() {
        Object object = ourInstanceCreationMonitor;
        synchronized (object) {
            if (ourInstance == null) {
                ourInstance = new CachingDockerComposeConfigurationParser(new ToolBasedDockerComposeConfigurationParser(PureDockerComposeConfigurationParser.getInstance()));
            }
            return ourInstance;
        }
    }

    @NotNull
    public static DockerComposeVersion parseVersion(@NotNull String path) throws IOException {
        if (path == null) {
            DockerComposeConfigurationParserUtil.$$$reportNull$$$0(0);
        }
        DockerComposeVersion dockerComposeVersion = cachedComposeFileVersion.fun(Collections.singletonList(path));
        if (dockerComposeVersion == null) {
            DockerComposeConfigurationParserUtil.$$$reportNull$$$0(1);
        }
        return dockerComposeVersion;
    }

    @Nullable
    public static String getMajorVersion(@NotNull String version) {
        Matcher matcher;
        if (version == null) {
            DockerComposeConfigurationParserUtil.$$$reportNull$$$0(2);
        }
        return (matcher = VERSION_PATTERN.matcher(version)).matches() ? matcher.group("major") : null;
    }

    public static void saveDockerComposeFiles(@NotNull List<String> dockerComposeFilePaths) {
        if (dockerComposeFilePaths == null) {
            DockerComposeConfigurationParserUtil.$$$reportNull$$$0(3);
        }
        DockerComposeConfigurationParserUtil.saveDockerComposeFiles(dockerComposeFilePaths, ModalityState.defaultModalityState());
    }

    public static void saveDockerComposeFiles(@NotNull List<String> dockerComposeFilePaths, @NotNull ModalityState modalityState) {
        if (dockerComposeFilePaths == null) {
            DockerComposeConfigurationParserUtil.$$$reportNull$$$0(4);
        }
        if (modalityState == null) {
            DockerComposeConfigurationParserUtil.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().invokeAndWait(() -> {
            FileDocumentManager documentManager = FileDocumentManager.getInstance();
            List documents = (List)ReadAction.compute(() -> {
                ArrayList<Document> list = new ArrayList<Document>();
                LocalFileSystem fs = LocalFileSystem.getInstance();
                for (String path : dockerComposeFilePaths) {
                    VirtualFile file2 = fs.findFileByPath(path);
                    if (file2 == null) continue;
                    list.add(documentManager.getDocument(file2));
                }
                return list;
            });
            if (!documents.isEmpty()) {
                WriteAction.runAndWait(() -> {
                    for (Document document : documents) {
                        if (!documentManager.isDocumentUnsaved(document)) continue;
                        documentManager.saveDocument(document);
                    }
                });
            }
        }, modalityState);
    }

    static {
        ourInstanceCreationMonitor = new Object();
        cachedComposeFileVersion = new CachingFilesSupplier(composeFiles2 -> {
            FileDocumentManager fileDocumentManager;
            Document document;
            Path path = Paths.get((String)composeFiles2.get(0), new String[0]);
            VirtualFile virtualFile = VfsUtil.findFile((Path)path, (boolean)true);
            if (virtualFile != null && (document = (fileDocumentManager = FileDocumentManager.getInstance()).getCachedDocument(virtualFile)) != null && fileDocumentManager.isDocumentUnsaved(document)) {
                LOG.error(String.format("The document for the file %s is unsaved. It must be saved in advance.", path));
            }
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(path.toFile()), StandardCharsets.UTF_8);){
                DockerComposeVersion dockerComposeVersion = PureDockerComposeConfigurationParser.getInstance().parseVersion(reader);
                return dockerComposeVersion;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/compose/configuration/beans/parse/DockerComposeConfigurationParserUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerComposeFilePaths";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/compose/configuration/beans/parse/DockerComposeConfigurationParserUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parseVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseVersion";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMajorVersion";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "saveDockerComposeFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

