/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.configuration.beans.parse;

import com.google.common.base.Preconditions;
import com.intellij.docker.compose.configuration.beans.parse.CachedException;
import com.intellij.docker.compose.configuration.beans.parse.CachedResult;
import com.intellij.docker.compose.configuration.beans.parse.CachedValue;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachingFilesSupplier<T>
implements ThrowableNotNullFunction<List<String>, T, IOException> {
    private final Object myObject;
    private final Map<List<String>, CachedResult<T>> myCache;
    @Nullable
    private Object myUnderlyingEssentialInfoForCaching;
    @NotNull
    private final ThrowableNotNullFunction<? super List<String>, ? extends T, ? extends IOException> myFunction;
    @NotNull
    private final Supplier<Object> myEssentialInfoForCachingSupplier;
    static final Logger LOG = Logger.getInstance(CachingFilesSupplier.class);

    public CachingFilesSupplier(@NotNull ThrowableNotNullFunction<? super List<String>, ? extends T, ? extends IOException> function) {
        if (function == null) {
            CachingFilesSupplier.$$$reportNull$$$0(0);
        }
        this(function, () -> true);
    }

    public CachingFilesSupplier(@NotNull ThrowableNotNullFunction<? super List<String>, ? extends T, ? extends IOException> function, @NotNull Supplier<Object> essentialInfoForCachingSupplier) {
        if (function == null) {
            CachingFilesSupplier.$$$reportNull$$$0(1);
        }
        if (essentialInfoForCachingSupplier == null) {
            CachingFilesSupplier.$$$reportNull$$$0(2);
        }
        this.myObject = new Object();
        this.myCache = new HashMap<List<String>, CachedResult<T>>();
        this.myFunction = function;
        this.myEssentialInfoForCachingSupplier = essentialInfoForCachingSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public T fun(@NotNull List<String> paths) throws IOException {
        Object object;
        if (paths == null) {
            CachingFilesSupplier.$$$reportNull$$$0(3);
        }
        Preconditions.checkArgument((!paths.isEmpty() ? 1 : 0) != 0, (Object)"Got empty paths");
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        long[] actualStamps = (long[])ReadAction.compute(() -> CachingFilesSupplier.getModificationStamps(localFileSystem, paths));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Present stamps for " + String.join((CharSequence)", ", paths) + " are " + LongStream.of(actualStamps).mapToObj(Long::toString).collect(Collectors.joining(", ")));
        }
        Object object2 = this.myObject;
        // MONITORENTER : object2
        Object newCacheKey = this.myEssentialInfoForCachingSupplier.get();
        if (newCacheKey == null) {
            Object object3 = this.myFunction.fun(paths);
            // MONITOREXIT : object2
            if (object3 != null) return (T)object3;
            CachingFilesSupplier.$$$reportNull$$$0(4);
            return (T)object3;
        }
        CachedResult<T> cachedResult = this.myCache.get(paths);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Cached stamps for " + String.join((CharSequence)", ", paths) + " are " + (cachedResult != null ? LongStream.of(cachedResult.getTimestamps()).mapToObj(Long::toString).collect(Collectors.joining(", ")) : "null"));
        }
        if (Objects.equals(this.myUnderlyingEssentialInfoForCaching, newCacheKey) && cachedResult != null && !CachingFilesSupplier.modificationStampsExpired(cachedResult.getTimestamps(), actualStamps)) {
            LOG.debug("Returning the value from the cache");
            T t = cachedResult.getCachedValue();
            // MONITOREXIT : object2
            if (t != null) return t;
            CachingFilesSupplier.$$$reportNull$$$0(6);
            return t;
        }
        LOG.debug("Generating a new value");
        this.myCache.remove(paths);
        try {
            Object configuration = this.myFunction.fun(paths);
            this.myCache.put(paths, new CachedValue<Object>(actualStamps, configuration));
            Object object4 = configuration;
            object = object4;
        }
        catch (IOException e) {
            this.myCache.put(paths, new CachedException(actualStamps, e));
            throw e;
        }
        finally {
            this.myUnderlyingEssentialInfoForCaching = newCacheKey;
        }
        if (object != null) return (T)object;
        CachingFilesSupplier.$$$reportNull$$$0(5);
        return (T)object;
    }

    private static long[] getModificationStamps(LocalFileSystem localFileSystem, @NotNull List<String> dockerComposeFilePaths) {
        if (dockerComposeFilePaths == null) {
            CachingFilesSupplier.$$$reportNull$$$0(7);
        }
        long[] result2 = new long[dockerComposeFilePaths.size()];
        int count = 0;
        for (String path : dockerComposeFilePaths) {
            VirtualFile virtualFile = localFileSystem.findFileByPath(path);
            LOG.debug(String.format("Getting modification stamp of %s (class %s)", virtualFile, virtualFile != null ? virtualFile.getClass().getName() : null));
            result2[count++] = virtualFile != null ? virtualFile.getModificationStamp() : Long.MAX_VALUE;
        }
        return result2;
    }

    private static boolean modificationStampsExpired(long[] cachedStamps, long[] actualStamps) {
        if (cachedStamps.length != actualStamps.length) {
            return true;
        }
        for (int i2 = 0; i2 < cachedStamps.length; ++i2) {
            if (cachedStamps[i2] >= actualStamps[i2]) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "essentialInfoForCachingSupplier";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/compose/configuration/beans/parse/CachingFilesSupplier";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerComposeFilePaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/compose/configuration/beans/parse/CachingFilesSupplier";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "fun";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fun";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getModificationStamps";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

