/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.cli;

import com.intellij.docker.i18n.DockerBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nJ\u001a\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u001a\u0010\u0011\u001a\u00020\u00122\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/docker/compose/cli/DockerComposeCli;", "", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "pattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "versionCommand", "", "extractDockerComposeVersion", "stdout", "getVersion", "dockerComposeExePath", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "runCommand", "Lcom/intellij/execution/process/ProcessOutput;", "cmd", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "intellij.clouds.docker"})
public final class DockerComposeCli {
    private static final Logger log;
    private static final String versionCommand = "--version";
    private static final Pattern pattern;
    @NotNull
    public static final DockerComposeCli INSTANCE;

    @NotNull
    public final String getVersion(@NotNull String dockerComposeExePath, @Nullable ProgressIndicator indicator) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)dockerComposeExePath, (String)"dockerComposeExePath");
        GeneralCommandLine generalCommandLine = new GeneralCommandLine().withExePath(dockerComposeExePath).withParameters(new String[]{versionCommand});
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"GeneralCommandLine().wit\u2026arameters(versionCommand)");
        GeneralCommandLine cmd = generalCommandLine;
        ProcessOutput processOutput = this.runCommand(indicator, cmd);
        if (processOutput.getExitCode() != 0 || processOutput.isTimeout()) {
            if (processOutput.isTimeout()) {
                log.debug(processOutput.getStderr() + "\nTimed out");
                throw (Throwable)new ExecutionException(DockerBundle.message("DockerComposeCli.error.version.command.time.out", new Object[0]));
            }
            log.debug(processOutput.getStderr() + "\nExit code " + processOutput.getExitCode());
            throw (Throwable)new ExecutionException(DockerBundle.message("DockerComposeCli.error.version.command.nonzero.exit.code", processOutput.getExitCode()));
        }
        String string = processOutput.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"processOutput.stdout");
        return this.extractDockerComposeVersion(string);
    }

    public static /* synthetic */ String getVersion$default(DockerComposeCli dockerComposeCli, String string, ProgressIndicator progressIndicator, int n, Object object) throws ExecutionException {
        if ((n & 2) != 0) {
            progressIndicator = null;
        }
        return dockerComposeCli.getVersion(string, progressIndicator);
    }

    @NotNull
    public final String extractDockerComposeVersion(@NotNull String stdout) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)stdout, (String)"stdout");
        Matcher matcher = pattern.matcher(stdout);
        if (matcher.find()) {
            String string = matcher.group("version");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"matcher.group(\"version\")");
            return string;
        }
        throw (Throwable)new ExecutionException(DockerBundle.message("DockerComposeCli.error.cant.find.version.in.output", stdout));
    }

    private final ProcessOutput runCommand(ProgressIndicator indicator, GeneralCommandLine cmd) throws ExecutionException {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command(cmd.getCommandLineList(null));
        Process process2 = null;
        try {
            Process process3 = processBuilder.start();
            Intrinsics.checkNotNullExpressionValue((Object)process3, (String)"processBuilder.start()");
            process2 = process3;
        }
        catch (IOException e) {
            throw (Throwable)new ExecutionException((Throwable)e);
        }
        CapturingProcessHandler processHandler = new CapturingProcessHandler(process2, cmd.getCharset(), cmd.getCommandLineString());
        if (indicator != null) {
            ProcessOutput processOutput = processHandler.runProcessWithProgressIndicator(indicator);
            Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"processHandler.runProces\u2026gressIndicator(indicator)");
            return processOutput;
        }
        ProcessOutput processOutput = processHandler.runProcess();
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"processHandler.runProcess()");
        return processOutput;
    }

    private DockerComposeCli() {
    }

    static {
        DockerComposeCli dockerComposeCli;
        INSTANCE = dockerComposeCli = new DockerComposeCli();
        Logger logger2 = Logger.getInstance(DockerComposeCli.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(DockerComposeCli::class.java)");
        log = logger2;
        pattern = Pattern.compile("docker-compose version (?<version>.+), build (?<build>.+)");
    }
}

