/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose;

import com.intellij.docker.ConfigureNewRunConfig;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerDeploymentConfigurationUtilsKt;
import com.intellij.docker.DockerIcons;
import com.intellij.docker.DockerRunConfigurationCreator;
import com.intellij.docker.FireAsTemporaryRunConfigAction;
import com.intellij.docker.RunConfigActionBase;
import com.intellij.docker.RunExistingRunConfig;
import com.intellij.docker.deployment.DockerRunConfig;
import com.intellij.docker.deploymentSource.DockerComposeDeploymentSourceType;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.utils.DockerUtils;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.configuration.deployment.DeploymentSourceType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0005\b&\u0018\u0000 \"2\u00020\u0001:\u0004\"#$%B3\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H$J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bJ\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190\u001bH\u0014J\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001c0!2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190\u001bH\u0014R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006&"}, d2={"Lcom/intellij/docker/compose/DockerComposeServiceActions;", "", "helper", "Lcom/intellij/docker/DockerRunConfigurationCreator;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "server", "Lcom/intellij/remoteServer/configuration/RemoteServer;", "Lcom/intellij/docker/DockerCloudConfiguration;", "(Lcom/intellij/docker/DockerRunConfigurationCreator;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/remoteServer/configuration/RemoteServer;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getHelper", "()Lcom/intellij/docker/DockerRunConfigurationCreator;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getServer", "()Lcom/intellij/remoteServer/configuration/RemoteServer;", "asActionGroup", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "configsFilter", "", "config", "Lcom/intellij/docker/deployment/DockerRunConfig$Wrapper;", "createActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "createFirstGroup", "Lcom/intellij/docker/RunExistingRunConfig;", "configs", "createSecondGroup", "", "Companion", "ForAllServices", "ForProject", "ForSingleService", "intellij.clouds.docker"})
public abstract class DockerComposeServiceActions {
    @NotNull
    private final DockerRunConfigurationCreator helper;
    @NotNull
    private final Project project;
    @Nullable
    private final VirtualFile file;
    @Nullable
    private final RemoteServer<DockerCloudConfiguration> server;
    private static final DockerComposeDeploymentSourceType COMPOSE;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected List<RunExistingRunConfig> createFirstGroup(@NotNull List<DockerRunConfig.Wrapper> configs) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(configs, (String)"configs");
        Iterable $this$map$iv = configs;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DockerRunConfig.Wrapper wrapper = (DockerRunConfig.Wrapper)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            RunExistingRunConfig runExistingRunConfig = new RunExistingRunConfig(this.helper, (DockerRunConfig.Wrapper)it);
            collection.add(runExistingRunConfig);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    protected List<AnAction> createSecondGroup(@NotNull List<DockerRunConfig.Wrapper> configs) {
        Intrinsics.checkNotNullParameter(configs, (String)"configs");
        boolean bl = false;
        List list = new ArrayList();
        boolean bl2 = false;
        boolean bl3 = false;
        List $this$apply = list;
        boolean bl4 = false;
        if (this.server == null) {
            List dockerAccounts = RemoteServersManager.getInstance().getServers((ServerType)DockerCloudType.getInstance());
            if (dockerAccounts.isEmpty()) {
                DockerComposeDeploymentSourceType dockerComposeDeploymentSourceType = COMPOSE;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)dockerComposeDeploymentSourceType), (String)"COMPOSE");
                $this$apply.add(DockerComposeServiceActions.Companion.withDockerIcon(new ConfigureNewRunConfig(this.helper, this.file, dockerComposeDeploymentSourceType, null)));
            } else {
                Iterable $this$forEach$iv = DockerUtils.allServersExceptKnowns(configs);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    RemoteServer it = (RemoteServer)element$iv;
                    boolean bl5 = false;
                    DockerComposeDeploymentSourceType dockerComposeDeploymentSourceType = COMPOSE;
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)dockerComposeDeploymentSourceType), (String)"COMPOSE");
                    $this$apply.add(new FireAsTemporaryRunConfigAction(this.helper, this.file, dockerComposeDeploymentSourceType, (RemoteServer<DockerCloudConfiguration>)it));
                }
            }
        } else if (configs.isEmpty()) {
            DockerComposeDeploymentSourceType dockerComposeDeploymentSourceType = COMPOSE;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)dockerComposeDeploymentSourceType), (String)"COMPOSE");
            $this$apply.add(new FireAsTemporaryRunConfigAction(this.helper, this.file, dockerComposeDeploymentSourceType, this.server));
        }
        return list;
    }

    protected abstract boolean configsFilter(@NotNull DockerRunConfig.Wrapper var1);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AnAction> createActions() {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        List<DockerRunConfig.Wrapper> list;
        VirtualFile virtualFile = this.file;
        if (virtualFile == null) {
            DockerComposeDeploymentSourceType dockerComposeDeploymentSourceType = COMPOSE;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)dockerComposeDeploymentSourceType), (String)"COMPOSE");
            list = DockerRunConfig.Wrapper.Companion.dockerConfigs(this.project, (DeploymentSourceType)dockerComposeDeploymentSourceType);
        } else {
            DockerComposeDeploymentSourceType dockerComposeDeploymentSourceType = COMPOSE;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)dockerComposeDeploymentSourceType), (String)"COMPOSE");
            list = DockerRunConfig.Wrapper.Companion.dockerConfigs(this.project, this.file, (DeploymentSourceType)dockerComposeDeploymentSourceType);
        }
        List<DockerRunConfig.Wrapper> allConfigs = list;
        Iterable $this$filter$iv = allConfigs;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            DockerRunConfig.Wrapper it = (DockerRunConfig.Wrapper)element$iv$iv;
            boolean bl = false;
            boolean bl2 = this.server != null ? Intrinsics.areEqual((Object)it.getConfig().getServerName(), (Object)this.server.getName()) : true;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        DockerComposeServiceActions dockerComposeServiceActions = this;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DockerRunConfig.Wrapper p1 = (DockerRunConfig.Wrapper)element$iv$iv;
            boolean bl = false;
            if (!dockerComposeServiceActions.configsFilter(p1)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List configs = (List)destination$iv$iv2;
        return DockerComposeServiceActions.Companion.combineGroups(this.createFirstGroup(configs), this.createSecondGroup(configs));
    }

    @NotNull
    public final DefaultActionGroup asActionGroup() {
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        boolean bl = false;
        boolean bl2 = false;
        DefaultActionGroup $this$apply = defaultActionGroup;
        boolean bl3 = false;
        $this$apply.addAll((Collection)this.createActions());
        return defaultActionGroup;
    }

    @NotNull
    protected final DockerRunConfigurationCreator getHelper() {
        return this.helper;
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @Nullable
    protected final VirtualFile getFile() {
        return this.file;
    }

    @Nullable
    protected final RemoteServer<DockerCloudConfiguration> getServer() {
        return this.server;
    }

    @JvmOverloads
    public DockerComposeServiceActions(@NotNull DockerRunConfigurationCreator helper, @NotNull Project project, @Nullable VirtualFile file2, @Nullable RemoteServer<DockerCloudConfiguration> server) {
        Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.helper = helper;
        this.project = project;
        this.file = file2;
        this.server = server;
    }

    public /* synthetic */ DockerComposeServiceActions(DockerRunConfigurationCreator dockerRunConfigurationCreator, Project project, VirtualFile virtualFile, RemoteServer remoteServer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            remoteServer = null;
        }
        this(dockerRunConfigurationCreator, project, virtualFile, (RemoteServer<DockerCloudConfiguration>)remoteServer);
    }

    @JvmOverloads
    public DockerComposeServiceActions(@NotNull DockerRunConfigurationCreator helper, @NotNull Project project, @Nullable VirtualFile file2) {
        this(helper, project, file2, null, 8, null);
    }

    static {
        Companion = new Companion(null);
        COMPOSE = DockerComposeDeploymentSourceType.getInstance();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00192\u00020\u0001:\u0003\u0019\u001a\u001bB9\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013H\u0014J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/docker/compose/DockerComposeServiceActions$ForSingleService;", "Lcom/intellij/docker/compose/DockerComposeServiceActions;", "service", "", "helper", "Lcom/intellij/docker/DockerRunConfigurationCreator;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "server", "Lcom/intellij/remoteServer/configuration/RemoteServer;", "Lcom/intellij/docker/DockerCloudConfiguration;", "(Ljava/lang/String;Lcom/intellij/docker/DockerRunConfigurationCreator;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/remoteServer/configuration/RemoteServer;)V", "configsFilter", "", "config", "Lcom/intellij/docker/deployment/DockerRunConfig$Wrapper;", "createFirstGroup", "", "Lcom/intellij/docker/RunExistingRunConfig;", "configs", "createSecondGroup", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "Companion", "ConfigureServiceRunConfig", "UpOneServiceAsTemporaryAction", "intellij.clouds.docker"})
    public static final class ForSingleService
    extends DockerComposeServiceActions {
        private final String service;
        @NotNull
        public static final Companion Companion = new Companion(null);

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        protected List<RunExistingRunConfig> createFirstGroup(@NotNull List<DockerRunConfig.Wrapper> configs) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(configs, (String)"configs");
            Iterable $this$map$iv = configs;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DockerRunConfig.Wrapper wrapper = (DockerRunConfig.Wrapper)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                DockerDeploymentConfiguration deploymentConfiguration = it.getDeploymentConfiguration();
                if (Intrinsics.areEqual((Object)((String)CollectionsKt.first(deploymentConfiguration.getServices())), (Object)this.service) ^ true) {
                    deploymentConfiguration.setServices(CollectionsKt.mutableListOf((Object[])new String[]{this.service}));
                }
                RunExistingRunConfig runExistingRunConfig = new RunExistingRunConfig(this.getHelper(), (DockerRunConfig.Wrapper)it);
                collection.add(runExistingRunConfig);
            }
            return (List)destination$iv$iv;
        }

        @Override
        @NotNull
        protected List<AnAction> createSecondGroup(@NotNull List<DockerRunConfig.Wrapper> configs) {
            Intrinsics.checkNotNullParameter(configs, (String)"configs");
            boolean bl = false;
            List list = new ArrayList();
            boolean bl2 = false;
            boolean bl3 = false;
            List $this$apply = list;
            boolean bl4 = false;
            if (this.getServer() == null) {
                List dockerAccounts = RemoteServersManager.getInstance().getServers((ServerType)DockerCloudType.getInstance());
                if (dockerAccounts.isEmpty()) {
                    $this$apply.add(Companion.withDockerIcon(new ConfigureServiceRunConfig(this.getHelper(), this.getFile(), this.service, null)));
                } else {
                    Iterable $this$forEach$iv = DockerUtils.allServersExceptKnowns(configs);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        RemoteServer it = (RemoteServer)element$iv;
                        boolean bl5 = false;
                        $this$apply.add(new UpOneServiceAsTemporaryAction(this.getHelper(), this.getFile(), this.service, (RemoteServer<DockerCloudConfiguration>)it));
                    }
                }
            } else if (configs.isEmpty()) {
                $this$apply.add(new UpOneServiceAsTemporaryAction(this.getHelper(), this.getFile(), this.service, this.getServer()));
            }
            return list;
        }

        @Override
        protected boolean configsFilter(@NotNull DockerRunConfig.Wrapper config) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            return DockerUtils.containsOnly(config.getDeploymentConfiguration().getServices(), this.service);
        }

        @JvmOverloads
        public ForSingleService(@NotNull String service2, @NotNull DockerRunConfigurationCreator helper, @NotNull Project project, @NotNull VirtualFile file2, @Nullable RemoteServer<DockerCloudConfiguration> server) {
            Intrinsics.checkNotNullParameter((Object)service2, (String)"service");
            Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            super(helper, project, file2, server);
            this.service = service2;
        }

        public /* synthetic */ ForSingleService(String string, DockerRunConfigurationCreator dockerRunConfigurationCreator, Project project, VirtualFile virtualFile, RemoteServer remoteServer, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                remoteServer = null;
            }
            this(string, dockerRunConfigurationCreator, project, virtualFile, (RemoteServer<DockerCloudConfiguration>)remoteServer);
        }

        @JvmOverloads
        public ForSingleService(@NotNull String service2, @NotNull DockerRunConfigurationCreator helper, @NotNull Project project, @NotNull VirtualFile file2) {
            this(service2, helper, project, file2, null, 16, null);
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/compose/DockerComposeServiceActions$ForSingleService$ConfigureServiceRunConfig;", "Lcom/intellij/docker/ConfigureNewRunConfig;", "helper", "Lcom/intellij/docker/DockerRunConfigurationCreator;", "sourceFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "service", "", "docker", "Lcom/intellij/remoteServer/configuration/RemoteServer;", "Lcom/intellij/docker/DockerCloudConfiguration;", "(Lcom/intellij/docker/DockerRunConfigurationCreator;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;Lcom/intellij/remoteServer/configuration/RemoteServer;)V", "customize", "", "runConfigWrapper", "Lcom/intellij/docker/deployment/DockerRunConfig$Wrapper;", "intellij.clouds.docker"})
        private static final class ConfigureServiceRunConfig
        extends ConfigureNewRunConfig {
            private final String service;

            @Override
            protected void customize(@NotNull DockerRunConfig.Wrapper runConfigWrapper) {
                Intrinsics.checkNotNullParameter((Object)runConfigWrapper, (String)"runConfigWrapper");
                super.customize(runConfigWrapper);
                Companion.setupOneComposeService(runConfigWrapper, this.service);
            }

            public ConfigureServiceRunConfig(@NotNull DockerRunConfigurationCreator helper, @Nullable VirtualFile sourceFile, @NotNull String service2, @Nullable RemoteServer<DockerCloudConfiguration> docker) {
                Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
                Intrinsics.checkNotNullParameter((Object)service2, (String)"service");
                DockerComposeDeploymentSourceType dockerComposeDeploymentSourceType = COMPOSE;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)dockerComposeDeploymentSourceType), (String)"COMPOSE");
                super(helper, sourceFile, dockerComposeDeploymentSourceType, docker);
                this.service = service2;
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/compose/DockerComposeServiceActions$ForSingleService$UpOneServiceAsTemporaryAction;", "Lcom/intellij/docker/FireAsTemporaryRunConfigAction;", "helper", "Lcom/intellij/docker/DockerRunConfigurationCreator;", "sourceFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "service", "", "docker", "Lcom/intellij/remoteServer/configuration/RemoteServer;", "Lcom/intellij/docker/DockerCloudConfiguration;", "(Lcom/intellij/docker/DockerRunConfigurationCreator;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;Lcom/intellij/remoteServer/configuration/RemoteServer;)V", "customize", "", "runConfigWrapper", "Lcom/intellij/docker/deployment/DockerRunConfig$Wrapper;", "intellij.clouds.docker"})
        private static final class UpOneServiceAsTemporaryAction
        extends FireAsTemporaryRunConfigAction {
            private final String service;

            @Override
            protected void customize(@Nullable DockerRunConfig.Wrapper runConfigWrapper) {
                block0: {
                    DockerRunConfig.Wrapper wrapper = runConfigWrapper;
                    if (wrapper == null) break block0;
                    Companion.setupOneComposeService(wrapper, this.service);
                }
            }

            public UpOneServiceAsTemporaryAction(@NotNull DockerRunConfigurationCreator helper, @Nullable VirtualFile sourceFile, @NotNull String service2, @NotNull RemoteServer<DockerCloudConfiguration> docker) {
                Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
                Intrinsics.checkNotNullParameter((Object)service2, (String)"service");
                Intrinsics.checkNotNullParameter(docker, (String)"docker");
                DockerComposeDeploymentSourceType dockerComposeDeploymentSourceType = COMPOSE;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)dockerComposeDeploymentSourceType), (String)"COMPOSE");
                super(helper, sourceFile, dockerComposeDeploymentSourceType, docker);
                this.service = service2;
                this.getTemplatePresentation().setText(DockerBundle.messagePointer("DockerComposeActions.UpOneServiceAsTemporaryAction.text", docker.getName()));
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"Lcom/intellij/docker/compose/DockerComposeServiceActions$ForSingleService$Companion;", "", "()V", "setupOneComposeService", "", "Lcom/intellij/docker/deployment/DockerRunConfig$Wrapper;", "service", "", "intellij.clouds.docker"})
        public static final class Companion {
            private final void setupOneComposeService(DockerRunConfig.Wrapper $this$setupOneComposeService, String service2) {
                DockerDeploymentConfiguration deployConfig2 = $this$setupOneComposeService.getDeploymentConfiguration();
                List<String> services = deployConfig2.getServices();
                services.clear();
                services.add(service2);
                $this$setupOneComposeService.getSettings().setName(COMPOSE.suggestConfigurationName(deployConfig2));
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B3\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/compose/DockerComposeServiceActions$ForAllServices;", "Lcom/intellij/docker/compose/DockerComposeServiceActions;", "helper", "Lcom/intellij/docker/DockerRunConfigurationCreator;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "server", "Lcom/intellij/remoteServer/configuration/RemoteServer;", "Lcom/intellij/docker/DockerCloudConfiguration;", "(Lcom/intellij/docker/DockerRunConfigurationCreator;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/remoteServer/configuration/RemoteServer;)V", "configsFilter", "", "config", "Lcom/intellij/docker/deployment/DockerRunConfig$Wrapper;", "intellij.clouds.docker"})
    public static final class ForAllServices
    extends DockerComposeServiceActions {
        @Override
        protected boolean configsFilter(@NotNull DockerRunConfig.Wrapper config) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            return config.getDeploymentConfiguration().getServices().isEmpty();
        }

        @JvmOverloads
        public ForAllServices(@NotNull DockerRunConfigurationCreator helper, @NotNull Project project, @Nullable VirtualFile file2, @Nullable RemoteServer<DockerCloudConfiguration> server) {
            Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super(helper, project, file2, server);
        }

        public /* synthetic */ ForAllServices(DockerRunConfigurationCreator dockerRunConfigurationCreator, Project project, VirtualFile virtualFile, RemoteServer remoteServer, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                remoteServer = null;
            }
            this(dockerRunConfigurationCreator, project, virtualFile, (RemoteServer<DockerCloudConfiguration>)remoteServer);
        }

        @JvmOverloads
        public ForAllServices(@NotNull DockerRunConfigurationCreator helper, @NotNull Project project, @Nullable VirtualFile file2) {
            this(helper, project, file2, null, 8, null);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u0005H\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/docker/compose/DockerComposeServiceActions$ForProject;", "Lcom/intellij/docker/compose/DockerComposeServiceActions;", "composeProjectName", "", "composeFiles", "", "Ljava/io/File;", "helper", "Lcom/intellij/docker/DockerRunConfigurationCreator;", "project", "Lcom/intellij/openapi/project/Project;", "server", "Lcom/intellij/remoteServer/configuration/RemoteServer;", "Lcom/intellij/docker/DockerCloudConfiguration;", "(Ljava/lang/String;Ljava/util/List;Lcom/intellij/docker/DockerRunConfigurationCreator;Lcom/intellij/openapi/project/Project;Lcom/intellij/remoteServer/configuration/RemoteServer;)V", "configsFilter", "", "config", "Lcom/intellij/docker/deployment/DockerRunConfig$Wrapper;", "createSecondGroup", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "configs", "intellij.clouds.docker"})
    public static final class ForProject
    extends DockerComposeServiceActions {
        private final String composeProjectName;
        private final List<File> composeFiles;

        @Override
        @NotNull
        protected List<AnAction> createSecondGroup(@NotNull List<DockerRunConfig.Wrapper> configs) {
            Intrinsics.checkNotNullParameter(configs, (String)"configs");
            boolean bl = false;
            List list = new ArrayList();
            boolean bl2 = false;
            boolean bl3 = false;
            List $this$apply = list;
            boolean bl4 = false;
            if (configs.isEmpty()) {
                if (this.composeFiles.size() == 1) {
                    DockerRunConfigurationCreator dockerRunConfigurationCreator = this.getHelper();
                    VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)((File)CollectionsKt.first(this.composeFiles)), (boolean)true);
                    DockerComposeDeploymentSourceType dockerComposeDeploymentSourceType = COMPOSE;
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)dockerComposeDeploymentSourceType), (String)"COMPOSE");
                    $this$apply.add(new FireAsTemporaryRunConfigAction(dockerRunConfigurationCreator, virtualFile, dockerComposeDeploymentSourceType, this.getServer()));
                } else {
                    DockerRunConfigurationCreator dockerRunConfigurationCreator = this.getHelper();
                    DockerComposeDeploymentSourceType dockerComposeDeploymentSourceType = COMPOSE;
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)dockerComposeDeploymentSourceType), (String)"COMPOSE");
                    $this$apply.add(new ConfigureNewRunConfig(dockerRunConfigurationCreator, null, dockerComposeDeploymentSourceType, this.getServer()));
                }
            }
            return list;
        }

        @Override
        protected boolean configsFilter(@NotNull DockerRunConfig.Wrapper config) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            String projectNameFromConfig = config.getDeploymentConfiguration().getComposeProjectName();
            CharSequence charSequence = projectNameFromConfig;
            boolean bl = false;
            if (!StringsKt.isBlank((CharSequence)charSequence) && Intrinsics.areEqual((Object)projectNameFromConfig, (Object)this.composeProjectName)) {
                return true;
            }
            File file2 = DockerDeploymentConfigurationUtilsKt.getSourceFile(this.getProject(), config.getDeploymentConfiguration().getSourceFilePath());
            return Intrinsics.areEqual((Object)(file2 != null && (file2 = file2.getParentFile()) != null ? file2.getName() : null), (Object)this.composeProjectName);
        }

        public ForProject(@NotNull String composeProjectName, @NotNull List<? extends File> composeFiles2, @NotNull DockerRunConfigurationCreator helper, @NotNull Project project, @NotNull RemoteServer<DockerCloudConfiguration> server) {
            Intrinsics.checkNotNullParameter((Object)composeProjectName, (String)"composeProjectName");
            Intrinsics.checkNotNullParameter(composeFiles2, (String)"composeFiles");
            Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(server, (String)"server");
            super(helper, project, null, server);
            this.composeProjectName = composeProjectName;
            this.composeFiles = composeFiles2;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\f\u0010\u000b\u001a\u00020\f*\u00020\fH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/docker/compose/DockerComposeServiceActions$Companion;", "", "()V", "COMPOSE", "Lcom/intellij/docker/deploymentSource/DockerComposeDeploymentSourceType;", "kotlin.jvm.PlatformType", "combineGroups", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "first", "second", "withDockerIcon", "Lcom/intellij/docker/RunConfigActionBase;", "intellij.clouds.docker"})
    public static final class Companion {
        private final RunConfigActionBase withDockerIcon(RunConfigActionBase $this$withDockerIcon) {
            RunConfigActionBase runConfigActionBase = $this$withDockerIcon;
            boolean bl = false;
            boolean bl2 = false;
            RunConfigActionBase $this$apply = runConfigActionBase;
            boolean bl3 = false;
            Presentation presentation = $this$apply.getTemplatePresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"templatePresentation");
            presentation.setIcon(DockerIcons.Docker);
            return runConfigActionBase;
        }

        private final List<AnAction> combineGroups(List<? extends AnAction> first, List<? extends AnAction> second) {
            boolean bl = false;
            List list = new ArrayList();
            boolean bl2 = false;
            boolean bl3 = false;
            List $this$apply = list;
            boolean bl4 = false;
            $this$apply.addAll((Collection)first);
            Collection collection = first;
            boolean bl5 = false;
            if (!collection.isEmpty()) {
                collection = second;
                bl5 = false;
                if (!collection.isEmpty()) {
                    $this$apply.add(new Separator());
                }
            }
            $this$apply.addAll((Collection)second);
            return list;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

