/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.cli.executor;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerDeploymentConfigurationUtilsKt;
import com.intellij.docker.agent.ApiTaskException;
import com.intellij.docker.agent.cli.communicator.AsyncCliProcess;
import com.intellij.docker.agent.cli.communicator.ProcessResult;
import com.intellij.docker.agent.progress.DockerImageBuilder;
import com.intellij.docker.agent.progress.DockerImageBuilderResult;
import com.intellij.docker.agent.progress.TtySink;
import com.intellij.docker.agent.settings.DockerEnvVarImpl;
import com.intellij.docker.agent.terminal.pipe.DockerTerminalPipe;
import com.intellij.docker.cli.DockerBuildCliBuilder;
import com.intellij.docker.cli.DockerBuildCliValidator;
import com.intellij.docker.cli.NormalizedCommandLine;
import com.intellij.docker.cli.executor.DockerCliCommunicator;
import com.intellij.docker.cli.executor.DockerCliExecutor;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.openapi.project.Project;
import com.intellij.util.text.StringKt;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\u0018\u0000 &2\u00020\u0001:\u0001&B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\b\u0010 \u001a\u00020!H\u0016J\u0012\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001b0#*\u00020\u0007H\u0002J\u0014\u0010$\u001a\u0004\u0018\u00010\u001b*\b\u0012\u0004\u0012\u00020\u001b0#H\u0002J\u0014\u0010%\u001a\u0004\u0018\u00010\u001b*\b\u0012\u0004\u0012\u00020\u001b0#H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\f\u0012\u0004\u0012\u00020\u000f0\u000ej\u0002`\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001f\u0010\u001a\u001a\u0013\u0018\u00010\u001b\u00a2\u0006\u0002\b\u001c\u00a2\u0006\u0002\b\u001d\u00a2\u0006\u0002\b\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/docker/cli/executor/DockerCliImageBuilder;", "Lcom/intellij/docker/agent/progress/DockerImageBuilder;", "project", "Lcom/intellij/openapi/project/Project;", "buildPipe", "Lcom/intellij/docker/agent/terminal/pipe/DockerTerminalPipe$WithTty;", "configuration", "Lcom/intellij/docker/DockerDeploymentConfiguration;", "serverConfiguration", "Lcom/intellij/docker/DockerCloudConfiguration;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/docker/agent/terminal/pipe/DockerTerminalPipe$WithTty;Lcom/intellij/docker/DockerDeploymentConfiguration;Lcom/intellij/docker/DockerCloudConfiguration;)V", "cliCommunicator", "Lcom/intellij/docker/cli/executor/DockerCliExecutor$WithBuildKit;", "myDockerAsyncCliProcess", "Lcom/intellij/docker/agent/cli/communicator/AsyncCliProcess;", "Lcom/intellij/docker/agent/cli/communicator/ProcessResult;", "Lcom/intellij/docker/agent/cli/communicator/AsyncCliProcessWithResult;", "promise", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/docker/agent/progress/DockerImageBuilderResult;", "getPromise", "()Ljava/util/concurrent/CompletableFuture;", "ttySink", "Lcom/intellij/docker/agent/progress/TtySink;", "getTtySink", "()Lcom/intellij/docker/agent/progress/TtySink;", "workingDirectory", "", "Lorg/jetbrains/annotations/Nullable;", "Lorg/jetbrains/annotations/SystemIndependent;", "Lorg/jetbrains/annotations/NonNls;", "build", "terminate", "", "buildArgs", "", "extractImageIdFromStdOut", "extractImageTageFromStdOut", "Companion", "intellij.clouds.docker"})
public final class DockerCliImageBuilder
implements DockerImageBuilder {
    private final String workingDirectory;
    private final DockerCliExecutor.WithBuildKit cliCommunicator;
    @NotNull
    private final CompletableFuture<DockerImageBuilderResult> promise;
    private AsyncCliProcess<ProcessResult> myDockerAsyncCliProcess;
    private final Project project;
    private final DockerTerminalPipe.WithTty buildPipe;
    private final DockerDeploymentConfiguration configuration;
    private static final String SHA256 = "sha256:";
    private static final int SHORT_ID_LENGTH = 12;
    private static final String TAG_PREFIX = "docker.io/library/";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final CompletableFuture<DockerImageBuilderResult> getPromise() {
        return this.promise;
    }

    @Override
    @NotNull
    public TtySink getTtySink() {
        return this.buildPipe.asTtySink();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompletableFuture<DockerImageBuilderResult> build() {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Iterable iterable = this.configuration.getEnvVars();
        List<String> list = this.buildArgs(this.configuration);
        DockerCliCommunicator dockerCliCommunicator = this.cliCommunicator;
        DockerCliImageBuilder dockerCliImageBuilder = this;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Function1 function1 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            DockerEnvVarImpl it = (DockerEnvVarImpl)element$iv$iv;
            boolean bl = false;
            Pair pair = new Pair((Object)it.getName(), (Object)it.getValue());
            boolean bl2 = false;
            map2.put(pair.getFirst(), pair.getSecond());
        }
        Map map3 = destination$iv$iv;
        boolean bl = true;
        Path path = null;
        String string = this.workingDirectory;
        function1 = (Function1)new Function1<Integer, Unit>(this){
            final /* synthetic */ DockerCliImageBuilder this$0;

            public final void invoke(int it) {
                DockerCliImageBuilder.access$getBuildPipe$p(this.this$0).setShowCursor(false);
            }
            {
                this.this$0 = dockerCliImageBuilder;
                super(1);
            }
        };
        Function1 function12 = (Function1)new Function1<String, Unit>(this){
            final /* synthetic */ DockerCliImageBuilder this$0;

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                DockerCliImageBuilder.access$getBuildPipe$p(this.this$0).printlnError(it);
            }
            {
                this.this$0 = dockerCliImageBuilder;
                super(1);
            }
        };
        Function1 function13 = (Function1)new Function1<String, Unit>(this){
            final /* synthetic */ DockerCliImageBuilder this$0;

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                DockerCliImageBuilder.access$getBuildPipe$p(this.this$0).print(it);
            }
            {
                this.this$0 = dockerCliImageBuilder;
                super(1);
            }
        };
        dockerCliImageBuilder.myDockerAsyncCliProcess = DockerCliCommunicator.DefaultImpls.build$default(dockerCliCommunicator, list, map3, function12, function13, function1, string, path, bl, 64, null);
        AsyncCliProcess<ProcessResult> asyncCliProcess = this.myDockerAsyncCliProcess;
        if (asyncCliProcess == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myDockerAsyncCliProcess");
        }
        this.buildPipe.transferTerminalInputTo(asyncCliProcess.getProcessInput());
        StringBuilder stringBuilder = new StringBuilder().append(DockerBundle.message("DockerCliImageBuilder.output.command", new Object[0])).append(' ');
        AsyncCliProcess<ProcessResult> asyncCliProcess2 = this.myDockerAsyncCliProcess;
        if (asyncCliProcess2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myDockerAsyncCliProcess");
        }
        this.buildPipe.printlnSystem(stringBuilder.append(asyncCliProcess2).toString());
        ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ DockerCliImageBuilder this$0;

            public final void invoke() {
                ProcessResult result2 = (ProcessResult)DockerCliImageBuilder.access$getMyDockerAsyncCliProcess$p(this.this$0).await();
                if (result2 != null && result2.getExitCode() != 0) {
                    this.this$0.getPromise().completeExceptionally(new ApiTaskException(DockerBundle.message("DockerCliImageBuilder.image.build.failed.message", result2.getExitCode())));
                } else {
                    Object object = result2;
                    String id = object != null && (object = ((ProcessResult)object).getStdOut()) != null ? DockerCliImageBuilder.access$extractImageIdFromStdOut(this.this$0, (List)object) : null;
                    Object object2 = result2;
                    String tag2 = object2 != null && (object2 = ((ProcessResult)object2).getStdOut()) != null ? DockerCliImageBuilder.access$extractImageTageFromStdOut(this.this$0, (List)object2) : null;
                    this.this$0.getPromise().complete(new DockerImageBuilderResult(id, tag2));
                }
            }
            {
                this.this$0 = dockerCliImageBuilder;
                super(0);
            }
        }), (int)31, null);
        return this.promise;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String extractImageTageFromStdOut(List<String> $this$extractImageTageFromStdOut) {
        String tag2;
        Object v4;
        Object object;
        block4: {
            Object v0;
            String it;
            block3: {
                List $this$lastOrNull$iv = StringsKt.split$default((CharSequence)CollectionsKt.joinToString$default((Iterable)$this$extractImageTageFromStdOut, (CharSequence)"", null, null, (int)0, null, null, (int)62, null), (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$lastOrNull = false;
                ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                while (iterator$iv.hasPrevious()) {
                    Object e = iterator$iv.previous();
                    it = (String)e;
                    boolean bl = false;
                    if (!StringsKt.contains$default((CharSequence)it, (CharSequence)"naming to", (boolean)false, (int)2, null)) continue;
                    v0 = e;
                    break block3;
                }
                v0 = null;
            }
            String string = v0;
            object = string;
            if (string == null) return null;
            List list = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])new String[]{" "}, (boolean)false, (int)0, (int)6, null);
            object = list;
            if (list == null) return null;
            Iterable $this$firstOrNull$iv = (Iterable)object;
            boolean $i$f$firstOrNull = false;
            for (Object t : $this$firstOrNull$iv) {
                it = (String)t;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)it, (String)TAG_PREFIX, (boolean)false, (int)2, null)) continue;
                v4 = t;
                break block4;
            }
            v4 = null;
        }
        String string = v4;
        object = string;
        if (string == null) return null;
        String string2 = object;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String string4 = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        object = string4;
        if (string4 == null) return null;
        String string5 = StringsKt.removePrefix((String)object, (CharSequence)TAG_PREFIX);
        String string6 = tag2 = string5;
        if (string6 == null) return null;
        string2 = string6;
        bl = false;
        boolean bl2 = false;
        String string7 = string2;
        boolean bl3 = false;
        String string8 = StringsKt.contains$default((CharSequence)tag2, (CharSequence)":", (boolean)false, (int)2, null) ? tag2 : (String)tag2 + ":latest";
        return string8;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String extractImageIdFromStdOut(List<String> $this$extractImageIdFromStdOut) {
        String fullId;
        Object v4;
        Object object;
        block5: {
            Object v0;
            String it;
            block4: {
                List $this$lastOrNull$iv = StringsKt.split$default((CharSequence)CollectionsKt.joinToString$default((Iterable)$this$extractImageIdFromStdOut, (CharSequence)"", null, null, (int)0, null, null, (int)62, null), (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$lastOrNull = false;
                ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                while (iterator$iv.hasPrevious()) {
                    Object e = iterator$iv.previous();
                    it = (String)e;
                    boolean bl = false;
                    if (!StringsKt.contains$default((CharSequence)it, (CharSequence)"writing image", (boolean)false, (int)2, null)) continue;
                    v0 = e;
                    break block4;
                }
                v0 = null;
            }
            String string = v0;
            object = string;
            if (string == null) return null;
            List list = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])new String[]{" "}, (boolean)false, (int)0, (int)6, null);
            object = list;
            if (list == null) return null;
            Iterable $this$firstOrNull$iv = (Iterable)object;
            boolean $i$f$firstOrNull = false;
            for (Object t : $this$firstOrNull$iv) {
                it = (String)t;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)it, (String)SHA256, (boolean)false, (int)2, null)) continue;
                v4 = t;
                break block5;
            }
            v4 = null;
        }
        String string = v4;
        object = string;
        if (string == null) return null;
        Object object2 = object;
        int n = 0;
        Object object3 = object2;
        if (object3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String string2 = ((Object)StringsKt.trim((CharSequence)((CharSequence)object3))).toString();
        String string3 = fullId = string2;
        String string4 = string3;
        if (string3 == null) return null;
        String string5 = StringsKt.removePrefix(string4, (CharSequence)SHA256);
        string4 = string5;
        if (string5 == null) return null;
        object2 = string4;
        n = 0;
        int n2 = 12;
        boolean bl = false;
        String string6 = object2;
        if (string6 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string7 = string6.substring(n, n2);
        String string8 = string7;
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string8;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> buildArgs(DockerDeploymentConfiguration $this$buildArgs) {
        Collection<Pair> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String string;
        String string2;
        boolean bl;
        NormalizedCommandLine normalizedCommandLine;
        boolean bl2 = StringsKt.isBlank((CharSequence)$this$buildArgs.getBuildCliOptions());
        if (bl2) {
            normalizedCommandLine = null;
        } else {
            Object object;
            boolean bl3 = false;
            try {
                object = Result.Companion;
                boolean $i$a$-runCatching-DockerCliImageBuilder$buildArgs$buildOptions$22 = false;
                NormalizedCommandLine $i$a$-runCatching-DockerCliImageBuilder$buildArgs$buildOptions$22 = new DockerBuildCliValidator().tryValidateCliOptions($this$buildArgs.getBuildCliOptions());
                bl = false;
                object = Result.constructor-impl((Object)$i$a$-runCatching-DockerCliImageBuilder$buildArgs$buildOptions$22);
            }
            catch (Throwable $i$a$-runCatching-DockerCliImageBuilder$buildArgs$buildOptions$22) {
                Result.Companion companion = Result.Companion;
                boolean bl4 = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-DockerCliImageBuilder$buildArgs$buildOptions$22));
            }
            string2 = object;
            boolean bl5 = false;
            normalizedCommandLine = (NormalizedCommandLine)((Object)(Result.isFailure-impl((Object)string2) ? null : string2));
        }
        NormalizedCommandLine buildOptions = normalizedCommandLine;
        string2 = $this$buildArgs.getContextFolderPath();
        if (string2 == null) {
            File file2 = DockerDeploymentConfigurationUtilsKt.getSourceFile(this.project, this.configuration);
            if (file2 != null && (file2 = file2.getParentFile()) != null) {
                File file3 = file2;
                boolean $i$a$-runCatching-DockerCliImageBuilder$buildArgs$buildOptions$22 = false;
                bl = false;
                File it = file3;
                boolean bl6 = false;
                string = DockerDeploymentConfigurationUtilsKt.getPathToStore(this.project, it);
            } else {
                string = null;
            }
        } else {
            string = $this$buildArgs.getContextFolderPath();
        }
        String contextFolder = StringKt.nullize((String)string, (boolean)true);
        Iterable iterable = $this$buildArgs.getBuildArgs();
        DockerBuildCliBuilder dockerBuildCliBuilder = new DockerBuildCliBuilder().setDockerFile($this$buildArgs.getSourceFilePath()).setContextDirectory(contextFolder).setCustomBuildOptions(buildOptions).addImageTags($this$buildArgs.getSeparateImageTags());
        boolean $i$f$map = false;
        void var7_17 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DockerEnvVarImpl dockerEnvVarImpl = (DockerEnvVarImpl)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl7 = false;
            Pair pair = new Pair((Object)it.getName(), (Object)it.getValue());
            collection.add(pair);
        }
        collection = (List)destination$iv$iv;
        DockerBuildCliBuilder builder = dockerBuildCliBuilder.addBuildArgs((List<Pair<String, String>>)collection);
        return builder.build();
    }

    @Override
    public void terminate() {
        if (this.myDockerAsyncCliProcess != null) {
            AsyncCliProcess<ProcessResult> asyncCliProcess = this.myDockerAsyncCliProcess;
            if (asyncCliProcess == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myDockerAsyncCliProcess");
            }
            asyncCliProcess.cancel();
            Unit unit = Unit.INSTANCE;
            boolean bl = false;
            boolean bl2 = false;
            Unit it = unit;
            boolean bl3 = false;
            this.promise.cancel(true);
        }
    }

    public DockerCliImageBuilder(@NotNull Project project, @NotNull DockerTerminalPipe.WithTty buildPipe, @NotNull DockerDeploymentConfiguration configuration, @NotNull DockerCloudConfiguration serverConfiguration) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)buildPipe, (String)"buildPipe");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)((Object)serverConfiguration), (String)"serverConfiguration");
        this.project = project;
        this.buildPipe = buildPipe;
        this.configuration = configuration;
        this.workingDirectory = this.project.getBasePath();
        this.cliCommunicator = new DockerCliExecutor.WithBuildKit(serverConfiguration, false, null, 6, null);
        this.promise = new CompletableFuture();
    }

    public static final /* synthetic */ DockerTerminalPipe.WithTty access$getBuildPipe$p(DockerCliImageBuilder $this) {
        return $this.buildPipe;
    }

    public static final /* synthetic */ AsyncCliProcess access$getMyDockerAsyncCliProcess$p(DockerCliImageBuilder $this) {
        AsyncCliProcess<ProcessResult> asyncCliProcess = $this.myDockerAsyncCliProcess;
        if (asyncCliProcess == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myDockerAsyncCliProcess");
        }
        return asyncCliProcess;
    }

    public static final /* synthetic */ void access$setMyDockerAsyncCliProcess$p(DockerCliImageBuilder $this, AsyncCliProcess asyncCliProcess) {
        $this.myDockerAsyncCliProcess = asyncCliProcess;
    }

    public static final /* synthetic */ String access$extractImageIdFromStdOut(DockerCliImageBuilder $this, List $this$access_u24extractImageIdFromStdOut) {
        return $this.extractImageIdFromStdOut($this$access_u24extractImageIdFromStdOut);
    }

    public static final /* synthetic */ String access$extractImageTageFromStdOut(DockerCliImageBuilder $this, List $this$access_u24extractImageTageFromStdOut) {
        return $this.extractImageTageFromStdOut($this$access_u24extractImageTageFromStdOut);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/docker/cli/executor/DockerCliImageBuilder$Companion;", "", "()V", "SHA256", "", "SHORT_ID_LENGTH", "", "TAG_PREFIX", "intellij.clouds.docker"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

