/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.cli.executor;

import com.intellij.docker.agent.cli.communicator.AsyncCliProcess;
import com.intellij.execution.process.OSProcessHandler;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\bJ\u000f\u0010\r\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/docker/cli/executor/AsyncCliProcessImpl;", "T", "Lcom/intellij/docker/agent/cli/communicator/AsyncCliProcess;", "handler", "Lcom/intellij/execution/process/OSProcessHandler;", "resultProducer", "Lkotlin/Function1;", "", "(Lcom/intellij/execution/process/OSProcessHandler;Lkotlin/jvm/functions/Function1;)V", "processInput", "Ljava/io/OutputStream;", "getProcessInput", "()Ljava/io/OutputStream;", "await", "()Ljava/lang/Object;", "cancel", "", "toString", "", "intellij.clouds.docker"})
public final class AsyncCliProcessImpl<T>
implements AsyncCliProcess<T> {
    @NotNull
    private final OutputStream processInput;
    private final OSProcessHandler handler;
    private final Function1<Integer, T> resultProducer;

    @Override
    public void cancel() {
        this.handler.destroyProcess();
    }

    @Override
    @NotNull
    public OutputStream getProcessInput() {
        return this.processInput;
    }

    @Override
    @Nullable
    public T await() {
        if (this.handler.waitFor()) {
            return (T)this.resultProducer.invoke((Object)this.handler.getProcess().exitValue());
        }
        this.cancel();
        return null;
    }

    @NotNull
    public String toString() {
        String string = this.handler.getCommandLine();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"handler.commandLine");
        return string;
    }

    public AsyncCliProcessImpl(@NotNull OSProcessHandler handler2, @NotNull Function1<? super Integer, ? extends T> resultProducer) {
        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
        Intrinsics.checkNotNullParameter(resultProducer, (String)"resultProducer");
        this.handler = handler2;
        this.resultProducer = resultProducer;
        OutputStream outputStream = this.handler.getProcessInput();
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"handler.processInput");
        this.processInput = outputStream;
    }
}

