/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.cli;

import com.intellij.docker.agent.cli.CliParserBase;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.execution.ParametersListUtil;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;
import org.jetbrains.annotations.NotNull;

public class NormalizedCommandLine {
    private final MultiMap<Option, String> myGrouped = MultiMap.createLinked();
    private final Set<Option> myOneValuePerLineOptions = new HashSet<Option>();
    private final Set<Option> myOptionsWithEqualsSeparator = new HashSet<Option>();

    public void forceNameEqualsValueFormat(Option option) {
        this.myOptionsWithEqualsSeparator.add(option);
    }

    public void registerOneValue(Option option, String value) {
        this.myGrouped.putValue((Object)option, (Object)NormalizedCommandLine.encodeSpaces(value));
    }

    public void registerOneValue(Option option, int value) {
        this.myGrouped.putValue((Object)option, (Object)String.valueOf(value));
    }

    public void registerOneValue(Option option, long value) {
        this.myGrouped.putValue((Object)option, (Object)String.valueOf(value));
    }

    public void registerOneValue(Option option, boolean value) {
        if (option.hasOptionalArg() && value) {
            this.myGrouped.putValue((Object)option, (Object)"");
        } else {
            this.myGrouped.putValue((Object)option, (Object)String.valueOf(value));
        }
    }

    public void registerMany(Option option, String[] value) {
        for (String next : value) {
            this.myGrouped.putValue((Object)option, (Object)NormalizedCommandLine.encodeSpaces(next));
        }
    }

    protected void preferOneValuePerLine(Option option) {
        this.myOneValuePerLineOptions.add(option);
    }

    public List<String> groupByOptions() {
        LinkedList<String> result2 = new LinkedList<String>();
        for (Map.Entry entry : this.myGrouped.entrySet()) {
            Option nextOption = (Option)entry.getKey();
            String optionKey = nextOption.getOpt() == null ? "--" + nextOption.getLongOpt() : "-" + nextOption.getOpt();
            String keyValueSeparator = this.myOptionsWithEqualsSeparator.contains(nextOption) ? "=" : " ";
            List pieces = ((Collection)entry.getValue()).stream().map(val -> optionKey + keyValueSeparator + val).map(String::trim).collect(Collectors.toList());
            if (this.myOneValuePerLineOptions.contains(nextOption)) {
                result2.addAll(pieces);
                continue;
            }
            result2.add(String.join((CharSequence)" ", pieces));
        }
        return result2;
    }

    @NotNull
    private static String encodeSpaces(String value) {
        if (value == null) {
            String string = String.valueOf(null);
            if (string == null) {
                NormalizedCommandLine.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (value.contains(" ")) {
            String string = ParametersListUtil.join((String[])new String[]{value});
            if (string == null) {
                NormalizedCommandLine.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = value;
        if (string == null) {
            NormalizedCommandLine.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/cli/NormalizedCommandLine", "encodeSpaces"));
    }

    public static class LabelListPrinter
    extends CliParserBase.LabelListHandler<NormalizedCommandLine> {
        public LabelListPrinter(Option option) {
            super(option);
        }

        @Override
        protected void handleLabelsMap(Map<String, String> parsedMap) {
            parsedMap.forEach((key, value) -> {
                String text2 = value == null || value.length() == 0 ? key : key + "=" + value;
                ((NormalizedCommandLine)this.getCmd()).registerOneValue(this.getOption(), text2);
            });
        }
    }

    public static class MemoryOptionPrinter
    extends CliParserBase.MemoryOptionHandler<NormalizedCommandLine> {
        public MemoryOptionPrinter(Option option) {
            super(option, null);
        }

        @Override
        protected void handleEachValue(String value) {
            this.parseMemory(value);
            ((NormalizedCommandLine)this.getCmd()).registerOneValue(this.getOption(), value);
        }
    }

    public static class MappedListPrinter
    extends CliParserBase.MappedListHandler<NormalizedCommandLine, String> {
        public MappedListPrinter(Option option) {
            super(option, String.class, Function.identity(), (cmd, strings) -> cmd.registerMany(option, (String[])strings));
        }
    }

    public static class StringListPrinter
    extends CliParserBase.StringListHandler<NormalizedCommandLine> {
        public StringListPrinter(Option option) {
            this(option, false);
        }

        public StringListPrinter(Option option, boolean preferSeparateLine) {
            super(option, (cmd, strings) -> {
                cmd.registerMany(option, (String[])strings);
                if (preferSeparateLine) {
                    cmd.preferOneValuePerLine(option);
                }
            });
        }
    }

    public static class BooleanValuePrinter
    extends CliParserBase.BooleanOptionHandler<NormalizedCommandLine> {
        public BooleanValuePrinter(Option option) {
            super(option);
        }

        @Override
        protected void handleBooleanValue(boolean value) {
            ((NormalizedCommandLine)this.getCmd()).registerOneValue(this.getOption(), value);
        }
    }

    public static class DoubleValuePrinter
    extends CliParserBase.DoubleOptionHandler<NormalizedCommandLine> {
        private static final DecimalFormat FORMAT = new DecimalFormat("#.######");

        public DoubleValuePrinter(Option option) {
            super(option, (cmd, value) -> cmd.registerOneValue(option, FORMAT.format(value)));
        }
    }

    public static class LongValuePrinter
    extends CliParserBase.LongOptionHandler<NormalizedCommandLine> {
        public LongValuePrinter(Option option) {
            super(option, (? super CMD cmd, ? super Long value) -> cmd.registerOneValue(option, (long)value));
        }
    }

    public static class IntegerValuePrinter
    extends CliParserBase.IntegerOptionHandler<NormalizedCommandLine> {
        public IntegerValuePrinter(Option option) {
            super(option, (? super CMD cmd, ? super Integer value) -> cmd.registerOneValue(option, (int)value));
        }
    }

    public static class SingleValuePrinter
    extends CliParserBase.SingleValueHandler<NormalizedCommandLine> {
        public SingleValuePrinter(Option option) {
            super(option);
        }

        @Override
        protected void handleEachValue(String value) {
            ((NormalizedCommandLine)this.getCmd()).registerOneValue(this.getOption(), value);
        }
    }

    public static interface CliValidator {
        public List<CliParserBase.OptionHandler<NormalizedCommandLine>> getHandlers();

        @NotNull
        public NormalizedCommandLine tryValidateCliOptions(@NotNull String var1) throws ParseException;

        default public List<String> validateCliOptions(@NotNull String optionsLine) {
            if (optionsLine == null) {
                CliValidator.$$$reportNull$$$0(0);
            }
            try {
                return this.tryValidateCliOptions(optionsLine).groupByOptions();
            }
            catch (CliParserBase.IllegalOptionException | ParseException e) {
                return Collections.singletonList(optionsLine);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionsLine", "com/intellij/docker/cli/NormalizedCommandLine$CliValidator", "validateCliOptions"));
        }
    }
}

