/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.cli;

import com.intellij.docker.DockerSettings;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerExecCommandCliBuilder {
    private String myName;
    private String[] myCommand;
    private String myWorkingDir;
    private Map<String, String> myEnvironment;

    public DockerExecCommandCliBuilder withName(@NotNull String name) {
        if (name == null) {
            DockerExecCommandCliBuilder.$$$reportNull$$$0(0);
        }
        this.myName = name;
        return this;
    }

    public DockerExecCommandCliBuilder withCommand(String ... command) {
        if (command == null) {
            DockerExecCommandCliBuilder.$$$reportNull$$$0(1);
        }
        this.myCommand = command;
        return this;
    }

    public DockerExecCommandCliBuilder withWorkingDir(@Nullable String workingDir) {
        this.myWorkingDir = workingDir;
        return this;
    }

    public DockerExecCommandCliBuilder withEnvironment(@NotNull Map<String, String> environment) {
        if (environment == null) {
            DockerExecCommandCliBuilder.$$$reportNull$$$0(2);
        }
        this.myEnvironment = environment;
        return this;
    }

    public GeneralCommandLine buildCommandLine() {
        String dockerPath = DockerSettings.getInstance().getDockerPath();
        PtyCommandLine result2 = new PtyCommandLine(Collections.singletonList(dockerPath));
        result2.addParameter("exec");
        result2.addParameter(this.myName);
        if (this.myWorkingDir != null) {
            result2.addParameter("-w");
            result2.addParameter(this.myWorkingDir);
        }
        if (this.myEnvironment != null) {
            for (Map.Entry entry : this.myEnvironment.entrySet()) {
                result2.addParameter("env");
                result2.addParameter((String)entry.getKey() + "=" + (String)entry.getValue());
            }
        }
        for (String command : this.myCommand) {
            result2.addParameter(command);
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/cli/DockerExecCommandCliBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "withName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "withCommand";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "withEnvironment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

