/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.applications;

import com.github.dockerjava.api.command.InspectVolumeResponse;
import com.intellij.docker.agent.ApiTasksKt;
import com.intellij.docker.agent.DockerAgentContext;
import com.intellij.docker.agent.DockerAgentVolume;
import com.intellij.docker.agent.applications.DockerAgentApplicationBase;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lcom/intellij/docker/agent/applications/DockerAgentVolumeImpl;", "Lcom/intellij/docker/agent/applications/DockerAgentApplicationBase;", "Lcom/intellij/docker/agent/DockerAgentVolume;", "agentContext", "Lcom/intellij/docker/agent/DockerAgentContext;", "volume", "Lcom/github/dockerjava/api/command/InspectVolumeResponse;", "(Lcom/intellij/docker/agent/DockerAgentContext;Lcom/github/dockerjava/api/command/InspectVolumeResponse;)V", "getVolume", "()Lcom/github/dockerjava/api/command/InspectVolumeResponse;", "callDockerJavaInspection", "", "deleteVolume", "", "getPresentableName", "", "getUniqueName", "intellij.clouds.docker.agent.impl"})
public final class DockerAgentVolumeImpl
extends DockerAgentApplicationBase
implements DockerAgentVolume {
    @NotNull
    private final InspectVolumeResponse volume;

    @Override
    @NotNull
    public String getUniqueName() {
        return "volume:" + this.getVolume().getName();
    }

    @Override
    @NotNull
    protected Object callDockerJavaInspection() {
        Object object = this.getClient().inspectVolumeCmd(this.getVolume().getName()).exec();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"client.inspectVolumeCmd(volume.name).exec()");
        return object;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = this.getVolume().getName();
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    public void deleteVolume() {
        ApiTasksKt.launchApiTask(this.getErrorHandler(), (Function0)new Function0<Void>(this){
            final /* synthetic */ DockerAgentVolumeImpl this$0;

            public final Void invoke() {
                return this.this$0.getClient().removeVolumeCmd(this.this$0.getVolume().getName()).exec();
            }
            {
                this.this$0 = dockerAgentVolumeImpl;
                super(0);
            }
        });
    }

    @Override
    @NotNull
    public InspectVolumeResponse getVolume() {
        return this.volume;
    }

    public DockerAgentVolumeImpl(@NotNull DockerAgentContext agentContext, @NotNull InspectVolumeResponse volume) {
        Intrinsics.checkNotNullParameter((Object)agentContext, (String)"agentContext");
        Intrinsics.checkNotNullParameter((Object)volume, (String)"volume");
        super(agentContext);
        this.volume = volume;
    }
}

