/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.applications;

import com.github.dockerjava.api.command.ConnectToNetworkCmd;
import com.github.dockerjava.api.model.ContainerNetwork;
import com.github.dockerjava.api.model.Network;
import com.intellij.docker.agent.ApiTasksKt;
import com.intellij.docker.agent.DockerAgentContext;
import com.intellij.docker.agent.DockerAgentNetwork;
import com.intellij.docker.agent.applications.DockerAgentApplicationBase;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u0006H\u0014J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u0014\u001a\u00020\u000eH\u0016J\b\u0010\u0015\u001a\u00020\u000eH\u0016J\b\u0010\u0016\u001a\u00020\u0006H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"Lcom/intellij/docker/agent/applications/DockerAgentNetworkImpl;", "Lcom/intellij/docker/agent/applications/DockerAgentApplicationBase;", "Lcom/intellij/docker/agent/DockerAgentNetwork;", "agentContext", "Lcom/intellij/docker/agent/DockerAgentContext;", "network", "Lcom/github/dockerjava/api/model/Network;", "(Lcom/intellij/docker/agent/DockerAgentContext;Lcom/github/dockerjava/api/model/Network;)V", "getNetwork", "()Lcom/github/dockerjava/api/model/Network;", "callDockerJavaInspection", "connectContainer", "", "containerId", "", "config", "Lcom/github/dockerjava/api/model/ContainerNetwork;", "deleteNetwork", "", "disconnectContainer", "getPresentableName", "getUniqueName", "reinspect", "intellij.clouds.docker.agent.impl"})
public final class DockerAgentNetworkImpl
extends DockerAgentApplicationBase
implements DockerAgentNetwork {
    @NotNull
    private final Network network;

    @Override
    @NotNull
    public String getUniqueName() {
        return "network:" + this.getNetwork().getId();
    }

    @NotNull
    protected Network callDockerJavaInspection() {
        Network network = this.getClient().inspectNetworkCmd().withNetworkId(this.getNetwork().getId()).exec();
        Intrinsics.checkNotNullExpressionValue((Object)network, (String)"client.inspectNetworkCmd\u2026workId(network.id).exec()");
        return network;
    }

    @Override
    public void deleteNetwork() {
        ApiTasksKt.launchApiTask(this.getErrorHandler(), (Function0)new Function0<Void>(this){
            final /* synthetic */ DockerAgentNetworkImpl this$0;

            public final Void invoke() {
                return this.this$0.getClient().removeNetworkCmd(this.this$0.getNetwork().getId()).exec();
            }
            {
                this.this$0 = dockerAgentNetworkImpl;
                super(0);
            }
        });
    }

    @Override
    @NotNull
    public Network reinspect() {
        return this.callDockerJavaInspection();
    }

    @Override
    public boolean disconnectContainer(@NotNull String containerId) {
        Intrinsics.checkNotNullParameter((Object)containerId, (String)"containerId");
        Boolean bl = (Boolean)ApiTasksKt.launchApiTask(this.getErrorHandler(), (Function0)new Function0<Boolean>(this, containerId){
            final /* synthetic */ DockerAgentNetworkImpl this$0;
            final /* synthetic */ String $containerId;

            public final boolean invoke() {
                this.this$0.getClient().disconnectFromNetworkCmd().withContainerId(this.$containerId).withNetworkId(this.this$0.getNetwork().getId()).withForce(Boolean.valueOf(true)).exec();
                return true;
            }
            {
                this.this$0 = dockerAgentNetworkImpl;
                this.$containerId = string;
                super(0);
            }
        });
        return bl != null ? bl : false;
    }

    @Override
    public boolean connectContainer(@NotNull String containerId, @Nullable ContainerNetwork config) {
        Intrinsics.checkNotNullParameter((Object)containerId, (String)"containerId");
        Boolean bl = (Boolean)ApiTasksKt.launchApiTask(this.getErrorHandler(), (Function0)new Function0<Boolean>(this, containerId, config){
            final /* synthetic */ DockerAgentNetworkImpl this$0;
            final /* synthetic */ String $containerId;
            final /* synthetic */ ContainerNetwork $config;

            public final boolean invoke() {
                ConnectToNetworkCmd command = this.this$0.getClient().connectToNetworkCmd().withNetworkId(this.this$0.getNetwork().getId()).withContainerId(this.$containerId);
                ContainerNetwork containerNetwork = this.$config;
                if (containerNetwork != null) {
                    ContainerNetwork containerNetwork2 = containerNetwork;
                    boolean bl = false;
                    boolean bl2 = false;
                    ContainerNetwork it = containerNetwork2;
                    boolean bl3 = false;
                    command.withContainerNetwork(this.$config);
                }
                command.exec();
                return true;
            }
            {
                this.this$0 = dockerAgentNetworkImpl;
                this.$containerId = string;
                this.$config = containerNetwork;
                super(0);
            }
        });
        return bl != null ? bl : false;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = this.getNetwork().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"network.name");
        return string;
    }

    @Override
    @NotNull
    public Network getNetwork() {
        return this.network;
    }

    public DockerAgentNetworkImpl(@NotNull DockerAgentContext agentContext, @NotNull Network network) {
        Intrinsics.checkNotNullParameter((Object)agentContext, (String)"agentContext");
        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
        super(agentContext);
        this.network = network;
    }
}

